/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import sanproject.sn2.base.SJbaseConst;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.env.exception.SJcEnvUtyException;
import sanproject.sn2.com.utility.env.exception.SJcEnvUtyParameterException;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileInterface;

public class SJcEnvUty {
    private static final int INT_ZERO = 0;
    private static final boolean FALSE = false;
    static final String LOG_FUNCTION = "EnvironmentUtility";
    static final String LOG_TITLE = "SJcEnvUty";
    private static String SN_BASE_PATH_DEFAULT = "C:\\DKC200\\";
    private static String SN_DATA_PATH_DEFAULT = "san\\SN2\\SN2Files\\";
    private static String CMN_BASE_PATH_DEFAULT = SN_BASE_PATH_DEFAULT;
    private static String CMN_DATA_PATH_DEFAULT = SN_DATA_PATH_DEFAULT;
    private static String SN_DKC200_DIR = "dkc200\\";
    private static String GUM_IP_FILE_PATH = "svp_send\\cnf\\GumIPaddress.dat";
    private static final int GUM_IP_FILE_DATA_SIZE = 128;
    private static final int GUM1_ENABLE_POS = 19;
    private static final int GUM1_V4_FLG_POS = 23;
    private static final int GUM1_ADDR_POS = 32;
    private static final int GUM2_ENABLE_POS = 67;
    private static final int GUM2_V4_FLG_POS = 71;
    private static final int GUM2_ADDR_POS = 80;
    private static final int V4_BYTE_LENGTH = 4;
    private static final int V6_BYTE_LENGTH = 16;
    private static final byte GUM1_ENABLE_FLG = -128;
    private static final byte GUM2_ENABLE_FLG = -128;
    private static final byte GUM1_V4_FLG = -128;
    private static final byte GUM2_V4_FLG = -128;
    private static final String GUM_AUTH_FILE_PATH = "svp_send\\cnf\\GumAuthentication.dat";
    private static final int GUM_AUTH_FILE_DATA_SIZE = 672;
    private static final int USER_LENGTH_POS = 656;
    private static final int PASSWORD_LENGTH_POS = 660;
    private static final int USER_POS = 16;
    private static final int PASSWORD_POS = 336;
    private static final int BYTE_SIZE_OF_INT = 4;
    private static String SN_MPC_FILE = "mpc.ini";

    public static String getProperty(String key) {
        return SJcEnvUty.getProperty(key, null);
    }

    public static String getProperty(String key, String def) {
        if (key == null || key.equals("")) {
            return def;
        }
        return System.getProperty(key, def);
    }

    public static int getProperty2int(String key) {
        return SJcEnvUty.getProperty2int(key, 0);
    }

    public static int getProperty2int(String key, int def) {
        String result_str = SJcEnvUty.getProperty(key);
        int result = def;
        try {
            if (result_str != null) {
                result = Integer.parseInt(result_str);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }

    public static boolean getProperty2boolean(String key) {
        return SJcEnvUty.getProperty2boolean(key, false);
    }

    public static boolean getProperty2boolean(String key, boolean def) {
        String result_str = SJcEnvUty.getProperty(key);
        boolean result = def;
        if (result_str != null) {
            result = Boolean.parseBoolean(result_str);
        }
        return result;
    }

    private static String getRelativePath() {
        String path = SJcEnvUty.getProperty("SN_EnvFileV", "");
        if (path.equals("")) {
            path = SJbaseConst.SN_DIRECTORY_BASE_SETTING + SJcFileInterface.separator + "properties" + SJcFileInterface.separator + "SN2_StartupV.properties";
        } else {
            String SN_DataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            if (path.length() >= SN_DataPath.length() && path.toLowerCase().contains(SN_DataPath.toLowerCase())) {
                path = String.copyValueOf(path.toCharArray(), SN_DataPath.length(), path.length() - SN_DataPath.length());
            }
        }
        return path;
    }

    public static void saveProperty(String key, String value) throws SJcException {
        Properties prop;
        String LOG_SUBTITLE = "saveProperty";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveProperty", "Start.");
        if (key == null || key.equals("")) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "saveProperty", "Parameter is invalid.");
            throw new SJcEnvUtyParameterException("107011");
        }
        String path = SJcEnvUty.getRelativePath();
        try {
            prop = SJcFileUty.loadProperties("", path);
        }
        catch (SJcException e) {
            prop = new Properties();
        }
        if (value == null) {
            prop.remove(key);
        } else {
            prop.setProperty(key, value);
        }
        SJcFileUty.saveProperties("", path, prop);
        try {
            if (value == null) {
                String oldValue = System.clearProperty(key);
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "saveProperty", "Clear property : " + key + " = " + oldValue);
            } else {
                String oldValue = System.setProperty(key, value);
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "saveProperty", "Set property : " + key + " : " + oldValue + " -> " + value);
            }
        }
        catch (Exception e) {
            throw new SJcEnvUtyException(e, "107012");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveProperty", "End.");
    }

    public static void saveint2Property(String key, int value) throws SJcException {
        String LOG_SUBTITLE = "saveint2Property";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveint2Property", "Start.");
        SJcEnvUty.saveProperty(key, String.valueOf(value));
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveint2Property", "End.");
    }

    public static void saveboolean2Property(String key, boolean value) throws SJcException {
        String LOG_SUBTITLE = "saveboolean2Property";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveboolean2Property", "Start.");
        SJcEnvUty.saveProperty(key, String.valueOf(value));
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "saveboolean2Property", "End.");
    }

    public static String getSnBasePath() {
        String ret = System.getProperty("SN_BasePath", SN_BASE_PATH_DEFAULT);
        ret = SJcEnvUty.appendSeparator(ret);
        return ret;
    }

    public static String getSnDataPath() {
        String ret = System.getProperty("SN_DataPath");
        if (null == ret) {
            ret = SJcEnvUty.getSnBasePath() + SN_DATA_PATH_DEFAULT;
        }
        ret = SJcEnvUty.appendSeparator(ret);
        return ret;
    }

    public static String getCmnBasePath() {
        String ret = System.getProperty("Cmn_BasePath", CMN_BASE_PATH_DEFAULT);
        ret = SJcEnvUty.appendSeparator(ret);
        return ret;
    }

    public static String getCmnDataPath() {
        String ret = System.getProperty("Cmn_DataPath");
        if (null == ret) {
            ret = SJcEnvUty.getCmnBasePath() + CMN_DATA_PATH_DEFAULT;
        }
        ret = SJcEnvUty.appendSeparator(ret);
        return ret;
    }

    private static String appendSeparator(String directoryName) {
        if (null == directoryName) {
            directoryName = SJcConst.sjc_PathSeparator;
        }
        if (!directoryName.endsWith(SJcConst.sjc_PathSeparator)) {
            directoryName = directoryName + SJcConst.sjc_PathSeparator;
        }
        return directoryName;
    }

    public static String getDkcRootName() {
        int DKC_ROOT_INDEX = 2;
        String basePath = SJcEnvUty.getSnBasePath();
        File file = new File(basePath);
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        path = path.replace("\\", "/");
        String[] pathArr = path.split("/");
        String dkcRootName = "";
        if (pathArr.length >= DKC_ROOT_INDEX) {
            dkcRootName = pathArr[pathArr.length - DKC_ROOT_INDEX];
            dkcRootName = dkcRootName.replace(":", "");
        }
        return dkcRootName;
    }

    public static List<String> getGumAddressList() {
        ArrayList<String> gumAddresList = new ArrayList<String>(2);
        byte[] gumIpFileData = SJcEnvUty.readGumIpFile();
        String gum1Addr = "";
        if (gumIpFileData[19] == -128) {
            gum1Addr = gumIpFileData[23] == -128 ? SJcEnvUty.getGum1v4Address(gumIpFileData) : SJcEnvUty.getGum1v6Address(gumIpFileData);
        }
        String gum2Addr = "";
        if (gumIpFileData[67] == -128) {
            gum2Addr = gumIpFileData[71] == -128 ? SJcEnvUty.getGum2v4Address(gumIpFileData) : SJcEnvUty.getGum2v6Address(gumIpFileData);
        }
        gumAddresList.add(gum1Addr);
        gumAddresList.add(gum2Addr);
        return gumAddresList;
    }

    public static String getGum1v4Address() {
        String ret = "";
        byte[] gumIpFileData = SJcEnvUty.readGumIpFile();
        if (gumIpFileData[19] == -128) {
            ret = SJcEnvUty.getGum1v4Address(gumIpFileData);
        }
        return ret;
    }

    public static String getGum1v6Address() {
        String ret = "";
        byte[] gumIpFileData = SJcEnvUty.readGumIpFile();
        if (gumIpFileData[19] == -128) {
            ret = SJcEnvUty.getGum1v6Address(gumIpFileData);
        }
        return ret;
    }

    public static String getGum2v4Address() {
        String ret = "";
        byte[] gumIpFileData = SJcEnvUty.readGumIpFile();
        if (gumIpFileData[67] == -128) {
            ret = SJcEnvUty.getGum2v4Address(gumIpFileData);
        }
        return ret;
    }

    public static String getGum2v6Address() {
        String ret = "";
        byte[] gumIpFileData = SJcEnvUty.readGumIpFile();
        if (gumIpFileData[67] == -128) {
            ret = SJcEnvUty.getGum2v6Address(gumIpFileData);
        }
        return ret;
    }

    private static String getGum1v4Address(byte[] gumIpFileData) {
        String ret = "";
        if (gumIpFileData[23] == -128) {
            ret = SJcEnvUty.getAddressBytes(gumIpFileData, 32, 4);
        }
        return ret;
    }

    private static String getGum1v6Address(byte[] gumIpFileData) {
        String ret = "";
        if (gumIpFileData[23] != -128) {
            ret = SJcEnvUty.getAddressBytes(gumIpFileData, 32, 16);
        }
        return ret;
    }

    private static String getGum2v4Address(byte[] gumIpFileData) {
        String ret = "";
        if (gumIpFileData[71] == -128) {
            ret = SJcEnvUty.getAddressBytes(gumIpFileData, 80, 4);
        }
        return ret;
    }

    private static String getGum2v6Address(byte[] gumIpFileData) {
        String ret = "";
        if (gumIpFileData[71] != -128) {
            ret = SJcEnvUty.getAddressBytes(gumIpFileData, 80, 16);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readGumIpFile() {
        byte[] buff = new byte[128];
        String basePath = SJcEnvUty.getSnBasePath().toLowerCase();
        String rootPath = basePath.replace(SN_DKC200_DIR, "");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(rootPath + GUM_IP_FILE_PATH);
            fis.read(buff);
        }
        catch (Throwable th) {
            SJcLogUty.error(LOG_FUNCTION, LOG_TITLE, "readGumIpFile", "Failed to read file.", th);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (Throwable th) {
                    SJcLogUty.error(LOG_FUNCTION, LOG_TITLE, "readGumIpFile", "Failed to close file.", th);
                }
            }
        }
        return buff;
    }

    private static String getAddressBytes(byte[] gumIpFileData, int startPos, int length) {
        byte[] addressBytes = new byte[length];
        System.arraycopy(gumIpFileData, startPos, addressBytes, 0, length);
        String ret = "";
        try {
            InetAddress address = InetAddress.getByAddress(addressBytes);
            ret = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            SJcLogUty.error(LOG_FUNCTION, LOG_TITLE, "getAddressBytes", "Exception occurred.", e);
        }
        return ret;
    }

    public static String getManageUserName() {
        String manageUserName = "";
        byte[] authInfo = SJcEnvUty.readGumAuthFile();
        int size = SJcEnvUty.byteArrayToInt(authInfo, 656);
        byte[] userIdArea = new byte[size];
        System.arraycopy(authInfo, 16, userIdArea, 0, size);
        try {
            manageUserName = SJcSecureUty.decryptString(userIdArea);
        }
        catch (SJcException e) {
            SJcLogUty.error(LOG_FUNCTION, LOG_TITLE, "getManageUserName", "Failed to decript file.", e);
        }
        return manageUserName;
    }

    public static String getManagePassword() {
        String managePassword = "";
        byte[] authInfo = SJcEnvUty.readGumAuthFile();
        int size = SJcEnvUty.byteArrayToInt(authInfo, 660);
        byte[] passwordArea = new byte[size];
        System.arraycopy(authInfo, 336, passwordArea, 0, size);
        try {
            managePassword = SJcSecureUty.decryptString(passwordArea);
        }
        catch (SJcException e) {
            SJcLogUty.error(LOG_FUNCTION, LOG_TITLE, "getManagePassword", "Failed to decript file.", e);
        }
        return managePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readGumAuthFile() {
        byte[] buff = new byte[672];
        String basePath = SJcEnvUty.getSnBasePath().toLowerCase();
        String rootPath = basePath.replace(SN_DKC200_DIR, "");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(rootPath + GUM_AUTH_FILE_PATH);
            fis.read(buff);
        }
        catch (Throwable th) {
            SJcLogUty.error(LOG_FUNCTION, LOG_TITLE, "readGumIpFile", "Failed to read file.", th);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (Throwable th) {
                    SJcLogUty.error(LOG_FUNCTION, LOG_TITLE, "readGumIpFile", "Failed to close file.", th);
                }
            }
        }
        return buff;
    }

    private static int byteArrayToInt(byte[] src, int start) {
        int ret = 0;
        if (src.length - start >= 4) {
            ByteBuffer buff = ByteBuffer.wrap(src, start, 4);
            buff.order(ByteOrder.LITTLE_ENDIAN);
            ret = buff.getInt();
        }
        return ret;
    }

    public static boolean isMPC() {
        boolean ret = false;
        String path = SJcEnvUty.getCmnBasePath() + SN_MPC_FILE;
        File file = new File(path);
        if (file.isFile()) {
            ret = true;
        }
        return ret;
    }
}

