/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.BitSet;

public class SJctrAccessControlData {
    static final int SN_SUBROLL_PERMISSION_DISABLE = 0;
    static final int SN_SUBROLL_PERMISSION_READ = 1;
    static final int SN_SUBROLL_PERMISSION_WRITE = 2;
    static final int SN_SUBROLL_INDEX_xxxx0 = 0;
    static final int SN_SUBROLL_INDEX_xxxx1 = 1;
    static final int SN_SUBROLL_INDEX_xxxx2 = 2;
    static final int SN_SUBROLL_INDEX_xxxx3 = 3;
    byte[][] mPermissionInfo = new byte[][]{{0, 0}, {1, 1}, {2, 2}, {3, 3}};
    BitSet mReadPermission = new BitSet(64);
    BitSet mWritePermission = new BitSet(64);
    BitSet mPpInstalled = new BitSet(64);
    BitSet mIndexListBitSet = new BitSet(64);
    byte[][] mPermissionData = new byte[64][2];

    public SJctrAccessControlData() {
    }

    public SJctrAccessControlData(boolean debug) {
        this.mReadPermission.set(0);
        this.mReadPermission.set(1);
        this.mReadPermission.set(2);
        this.mReadPermission.set(3);
        this.mWritePermission.set(0);
        this.mWritePermission.set(1);
        this.mWritePermission.set(2);
        this.mWritePermission.set(3);
        this.mPpInstalled.set(0);
        this.mPpInstalled.set(1);
        this.mPpInstalled.set(2);
        this.mPpInstalled.set(3);
        this.mPermissionData[0][0] = 0;
        this.mPermissionData[1][0] = 1;
        this.mPermissionData[2][0] = 1;
        this.mPermissionData[3][0] = 2;
    }

    private void setIndexListBitSet(byte[] subRollIndexList) {
        this.mIndexListBitSet.clear();
        for (int index = 0; index < subRollIndexList.length; ++index) {
            this.mIndexListBitSet.set((int)subRollIndexList[index], true);
        }
    }

    private boolean checkBitSet(BitSet bitset) {
        BitSet tmpBitSet = (BitSet)bitset.clone();
        tmpBitSet.and(this.mIndexListBitSet);
        boolean result = tmpBitSet.equals(this.mIndexListBitSet);
        tmpBitSet = null;
        return result;
    }

    public boolean isReadPermission(byte[] subRollIndexList) {
        this.setIndexListBitSet(subRollIndexList);
        return this.checkBitSet(this.mReadPermission);
    }

    public boolean isWritePermission(byte[] subRollIndexList) {
        this.setIndexListBitSet(subRollIndexList);
        return this.checkBitSet(this.mWritePermission);
    }

    public boolean isPpInstalled(byte[] subRollIndexList) {
        this.setIndexListBitSet(subRollIndexList);
        return this.checkBitSet(this.mPpInstalled);
    }

    public int getPermission(byte[] subRollIndexList) {
        int permission = 0;
        int disable = 0;
        int read = 0;
        int write = 0;
        for (int index = 0; index < subRollIndexList.length; ++index) {
            if (this.mPermissionData[index][0] == 0) {
                ++disable;
                continue;
            }
            if (this.mPermissionData[index][0] == 1) {
                ++read;
                continue;
            }
            if (this.mPermissionData[index][0] != 2) continue;
            ++write;
        }
        return permission;
    }
}

