/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.HUVM_VDKC_Operation_IN;
import sanproject.serverux.dataimpl.HUVMsetVDKC;
import sanproject.serverux.dataimpl.HUVMvboxIndex;
import sanproject.serverux.dataimpl.RSGIndex;
import sanproject.serverux.dataimpl.RSGsetHostGroup;
import sanproject.serverux.dataimpl.RSGsetLdev;
import sanproject.serverux.dataimpl.RSGsetMigrateRsc_IN;
import sanproject.serverux.dataimpl.RSGsetMigrate_1Rsg;
import sanproject.serverux.dataimpl.RSGsetPg;
import sanproject.serverux.dataimpl.RSGsetPort;
import sanproject.serverux.dataimpl.RSGsetRSG;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountInfoUty;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrAccountRsgDataMacro;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupIscsiTargetInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgUserInfo;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevJnlGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgEncryptionInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotVvolRelation;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevJnlGroupInfo;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;
import sanproject.sn2.model.data.vsm.SJmoRSGVirtualDkc;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrRsgUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public static final String GUID_BRACKET_LEFT = "BRACKET_LEFT";
    public static final String GUID_BRACKET_RIGHT = "BRACKET_RIGHT";
    public static final String GUID_BAR = "BAR";
    private static final int DEF_INTERNAL_PG_NO_START = 1;
    public static int DEF_INTERNAL_PG_NO_END = SJmoDataMacro_IF.PGKIND_INTERNAL_MAX;
    private static final int DEF_EXTERNAL_PG_NO_START = 101;
    private static final int DEF_EXTERNAL_PG_NO_END = 16484;
    private static final int DEF_FICON_DM_PG_NO_START = 16641;
    private static final int DEF_FICON_DM_PG_NO_END = 17152;
    private String[][] strVssEmu = new String[][]{{"0271", "OPEN-V"}, {"0293", "OPEN-3"}, {"0298", "OPEN-8"}, {"0299", "OPEN-9"}, {"0297", "OPEN-E"}, {"0283", "OPEN-K"}, {"0240", "OPEN-L"}};

    public SJctrRsgUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public static List<?> getCache(SJctrDataController dc, Class<?> key) {
        if (dc instanceof SJctrWizardDataController) {
            return ((SJctrWizardDataController)dc).getCache(key);
        }
        return dc.getProxy().getCache(key);
    }

    public static List<SJmoRSGgetAllRsgs> SJmoRSGgetAllRsgs(SJctrDataController dc) {
        List<SJmoRSGgetAllRsgs> allRsgs = SJctrRsgUtility.getCache(dc, SJmoGetRSGgetAllRsgs.class);
        if (null == allRsgs) {
            dc.getLogUty().putlog("getRsgInfo", "Information of all resource groups is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return allRsgs;
    }

    public static List<SJmoRSGgetRsg> getRsgListInfo(SJctrDataController dc) {
        List<SJmoRSGgetAllRsgs> allRsgs = SJctrRsgUtility.SJmoRSGgetAllRsgs(dc);
        if (0 == allRsgs.size()) {
            dc.getLogUty().putlog("getRsgInfo", "Size of resource groups data list is zero.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoRSGgetAllRsgs allRsg = allRsgs.get(0);
        if (null == allRsg) {
            dc.getLogUty().putlog("getRsgInfo", "Information of resource groups is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return allRsgs.get(0).getRsgs();
    }

    public static List<SJmoPgDetail> getSJmoPgDetail(SJctrDataController dc) {
        List<SJmoPgDetail> info = SJctrRsgUtility.getCache(dc, SJmoGetPgDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPgDetail", "Information of parity groups is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoVdevDetail> getSJmoVdevDetail(SJctrDataController dc) {
        List<SJmoVdevDetail> info = SJctrRsgUtility.getCache(dc, SJmoGetVdevDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoVdevDetail", "Information of SJmoVdevDetail is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPdevDetail> getSJmoPdevDetail(SJctrDataController dc) {
        List<SJmoPdevDetail> info = SJctrRsgUtility.getCache(dc, SJmoGetPdevDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPdevDetail", "Information of SJmoPdevDetail is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPgScatteredInfo> getSJmoPgScatteredInfo(SJctrDataController dc) {
        List<SJmoPgScatteredInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetPgScatteredInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPgScatteredInfo", "Information of SJmoPgScatteredInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPgEncryptionInfo> getSJmoPgEncryptionInfo(SJctrDataController dc) {
        List<SJmoPgEncryptionInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetPgEncryptionInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPgEncryptionInfo", "Information of SJmoPgEncryptionInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevDetail> getSJmoLdevDetail(SJctrDataController dc) {
        List<SJmoLdevDetail> info = SJctrRsgUtility.getCache(dc, SJmoGetLdevDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevDetail", "Information of LDEVs is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevStatusInfo> getSJmoLdevStatusInfo(SJctrDataController dc) {
        List<SJmoLdevStatusInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetLdevStatusInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevStatusInfo", "Information of SJmoLdevStatusInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevLuseInfo> getSJmoLdevLuseInfo(SJctrDataController dc) {
        List<SJmoLdevLuseInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetLdevLuseInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevLuseInfo", "Information of SJmoLdevLuseInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPortDetail> getSJmoPortDetail(SJctrDataController dc) {
        List<SJmoPortDetail> info = SJctrRsgUtility.getCache(dc, SJmoGetPortDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortDetail", "Information of port detail is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPortHostGroupInfo> getSJmoPortHostGroupInfo(SJctrDataController dc) {
        List<SJmoPortHostGroupInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetPortHostGroupInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortHostGroupInfo", "Information of host groups is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevNicknameInfo> getSJmoLdevNicknameInfo(SJctrDataController dc) {
        List<SJmoLdevNicknameInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetLdevNicknameInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevNicknameInfo", "Information of LDEV nickname is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoHDPRelation> getSJmoHDPRelation(SJctrDataController dc) {
        List<SJmoHDPRelation> info = SJctrRsgUtility.getCache(dc, SJmoGetHDPRelation.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoHDPRelation", "Information of HDP relation info is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPoolDetail> getSJmoPoolDetail(SJctrDataController dc) {
        List<SJmoPoolDetail> info = SJctrRsgUtility.getCache(dc, SJmoGetPoolDetail.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPoolDetail", "Information of pool detail info is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPoolNameInfo> getSJmoPoolNameInfo(SJctrDataController dc) {
        List<SJmoPoolNameInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetPoolNameInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPoolNameInfo", "Information of pool name info is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPortAttributeInfo> getSJmoPortAttributeInfo(SJctrDataController dc) {
        List<SJmoPortAttributeInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetPortAttributeInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortAttributeInfo", "Information of port attribute info is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLdevJnlGroupInfo> getSJmoLdevJnlGroupInfo(SJctrDataController dc) {
        List<SJmoLdevJnlGroupInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetLdevJnlGroupInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoLdevJnlGroupInfo", "Information of journal group info is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getSJmoSnapshotVvolRelationInfo(SJctrDataController dc) {
        List<SJmoLocalReplicationPairVolInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetSnapshotVvolRelation.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoSnapshotVvolRelationInfo", "Information of snapshot vvol relation by pool info is null.");
            info = new ArrayList<SJmoLocalReplicationPairVolInfo>(0);
        }
        return info;
    }

    public static List<SJmoPortIscsiTargetInfo> getSJmoPortIscsiTargetInfo(SJctrDataController dc) {
        List<SJmoPortIscsiTargetInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetPortIscsiTargetInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortIscsiTargetInfo", "Information of iSCSI Targets is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoHUVMVirtualDkc> getSJmoHUVMVirtualDkc(SJctrDataController dc) {
        List<SJmoHUVMVirtualDkc> info = SJctrRsgUtility.getCache(dc, SJmoGetHUVMVirtualDkc.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoHUVMVirtualDkc", "Information of SJmoHUVMVirtualDkc is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoHUVMVirtualDkc> getSJmoHUVMVirtualDkcForRsgProp(SJctrDataController dc) {
        List<SJmoHUVMVirtualDkc> info = SJctrRsgUtility.getCache(dc, SJmoGetHUVMVirtualDkc.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoHUVMVirtualDkcForRsgProp", "Information of SJmoHUVMVirtualDkc is null.");
            info = new ArrayList<SJmoHUVMVirtualDkc>(0);
        }
        return info;
    }

    public static List<SJmoHUVMVirtualLdev> getSJmoHUVMVirtualLdev(SJctrDataController dc) {
        List<SJmoHUVMVirtualLdev> info = SJctrRsgUtility.getCache(dc, SJmoGetHUVMVirtualLdev.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoHUVMVirtualLdev", "Information of SJmoHUVMVirtualLdev is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static List<SJmoPortLunInfo> getSJmoPortLunDetail(SJctrDataController dc) {
        List<SJmoPortLunInfo> info = SJctrRsgUtility.getCache(dc, SJmoGetPortLunInfo.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoPortLunDetail", "Information of SJmoPortLunInfo list is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return info;
    }

    public static void setCacheRscDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetPgDetail.class.getName(), SJctrRsgUtility.getSJmoPgDetail(dc));
        needDataMap.put(SJmoGetVdevDetail.class.getName(), SJctrRsgUtility.getSJmoVdevDetail(dc));
        needDataMap.put(SJmoGetPdevDetail.class.getName(), SJctrRsgUtility.getSJmoPdevDetail(dc));
        needDataMap.put(SJmoGetPgScatteredInfo.class.getName(), SJctrRsgUtility.getSJmoPgScatteredInfo(dc));
        needDataMap.put(SJmoGetPgEncryptionInfo.class.getName(), SJctrRsgUtility.getSJmoPgEncryptionInfo(dc));
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrRsgUtility.getSJmoLdevDetail(dc));
        needDataMap.put(SJmoGetLdevStatusInfo.class.getName(), SJctrRsgUtility.getSJmoLdevStatusInfo(dc));
        needDataMap.put(SJmoGetLdevLuseInfo.class.getName(), SJctrRsgUtility.getSJmoLdevLuseInfo(dc));
        needDataMap.put(SJmoGetPortDetail.class.getName(), SJctrRsgUtility.getSJmoPortDetail(dc));
        needDataMap.put(SJmoGetPortHostGroupInfo.class.getName(), SJctrRsgUtility.getSJmoPortHostGroupInfo(dc));
        needDataMap.put(SJmoGetLdevNicknameInfo.class.getName(), SJctrRsgUtility.getSJmoLdevNicknameInfo(dc));
        needDataMap.put(SJmoGetHDPRelation.class.getName(), SJctrRsgUtility.getSJmoHDPRelation(dc));
        needDataMap.put(SJmoGetPoolDetail.class.getName(), SJctrRsgUtility.getSJmoPoolDetail(dc));
        needDataMap.put(SJmoGetPoolNameInfo.class.getName(), SJctrRsgUtility.getSJmoPoolNameInfo(dc));
        needDataMap.put(SJmoGetPortAttributeInfo.class.getName(), SJctrRsgUtility.getSJmoPortAttributeInfo(dc));
        needDataMap.put(SJmoGetLdevJnlGroupInfo.class.getName(), SJctrRsgUtility.getSJmoLdevJnlGroupInfo(dc));
        needDataMap.put(SJmoGetSnapshotVvolRelation.class.getName(), SJctrRsgUtility.getSJmoSnapshotVvolRelationInfo(dc));
        needDataMap.put(SJmoGetPortIscsiTargetInfo.class.getName(), SJctrRsgUtility.getSJmoPortIscsiTargetInfo(dc));
    }

    public static void setCacheCreateEditRscDetailData(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        SJctrRsgUtility.setCacheRscDetailData(needDataMap, dc);
        needDataMap.put(SJmoGetHUVMVirtualDkc.class.getName(), SJctrRsgUtility.getSJmoHUVMVirtualDkcForRsgProp(dc));
    }

    public static void setCacheGADReserves(Map<String, List<?>> needDataMap, SJctrDataController dc) {
        needDataMap.put(SJmoGetLdevDetail.class.getName(), SJctrRsgUtility.getSJmoLdevDetail(dc));
        needDataMap.put(SJmoGetHUVMVirtualLdev.class.getName(), SJctrRsgUtility.getSJmoHUVMVirtualLdev(dc));
        needDataMap.put(SJmoGetRSGgetAllRsgs.class.getName(), SJctrRsgUtility.SJmoRSGgetAllRsgs(dc));
        needDataMap.put(SJmoGetHUVMVirtualDkc.class.getName(), SJctrRsgUtility.getSJmoHUVMVirtualDkc(dc));
    }

    public static void setOldTaskNothingData(SJctrDataController dc) {
        List<?> info = SJctrRsgUtility.getCache(dc, SJmoGetSnapshotVvolRelation.class);
        if (null == info) {
            dc.getLogUty().putlog("getSJmoSnapshotVvolRelationInfo", "Information of snapshot vvol relation by pool info is null.");
            dc.getProxy().putCache(SJmoGetSnapshotVvolRelation.class, new ArrayList(0));
        }
    }

    public static void setOldCreateEditTaskNothingData(SJctrDataController dc) {
        SJctrRsgUtility.setOldTaskNothingData(dc);
        List<?> vdkcInfo = SJctrRsgUtility.getCache(dc, SJmoGetHUVMVirtualDkc.class);
        if (null == vdkcInfo) {
            dc.getLogUty().putlog("setOldCreateEditTaskNothingData", "Information of SJmoHUVMVirtualDkc is null.");
            dc.getProxy().putCache(SJmoGetHUVMVirtualDkc.class, new ArrayList(0));
        }
    }

    public static SJcException convRsgLogicalErr(SJcException err, int msgID) {
        SJcMessage msgObj = err.getMsg();
        if (msgObj.getModuleID().equals(Integer.toString(22)) && msgObj.getFunctionID().equals(Integer.toString(207)) && msgObj.getMsgID().equals(Integer.toString(107001))) {
            SJctrError errObj = new SJctrError(207, 22, msgID);
            err = errObj.createException();
        }
        return err;
    }

    public String getRsgNameId(SJmoRSGgetRsg rsgInfo) {
        String rsgNameId = "? (?)";
        if (null != rsgInfo) {
            SJmoRSGInfo rsgNameIdInfo = rsgInfo.getRsgInfo();
            rsgNameId = rsgNameIdInfo.getRsgName();
            int rsgId = rsgNameIdInfo.getRsgId();
            rsgNameId = 0 <= rsgId ? rsgNameId + " " + this.guidanceHandle.getGuidance(GUID_BRACKET_LEFT) + rsgId + this.guidanceHandle.getGuidance(GUID_BRACKET_RIGHT) : rsgNameId + " " + this.guidanceHandle.getGuidance(GUID_BRACKET_LEFT) + this.guidanceHandle.getGuidance(GUID_BAR) + this.guidanceHandle.getGuidance(GUID_BRACKET_RIGHT);
        }
        return rsgNameId;
    }

    public static String toRsgIdDisplay(SJctrComUtility util, SJmoRSGInfo rsgInfo) {
        String strDispString = "?";
        if (rsgInfo != null) {
            strDispString = rsgInfo.getRsgName() + " " + util.getGuidance(GUID_BRACKET_LEFT) + rsgInfo.getRsgId() + util.getGuidance(GUID_BRACKET_RIGHT);
        }
        return strDispString;
    }

    public static String getRsgName(SJmoRSGInfo rsgInfo) {
        String ret = "?";
        if (rsgInfo != null) {
            ret = rsgInfo.getRsgName();
        }
        return ret;
    }

    public static String getRsgId(SJmoRSGInfo rsgInfo) {
        String ret = "?";
        if (rsgInfo != null) {
            ret = Integer.toString(rsgInfo.getRsgId());
        }
        return ret;
    }

    public String getNumOfRsgs(List<SJmoRSGgetRsg> rsgsInfo) {
        String resourceGroupCount = "?";
        if (null != rsgsInfo) {
            resourceGroupCount = Integer.toString(rsgsInfo.size());
        }
        return resourceGroupCount;
    }

    public String getNumOfRsgsWithMaxAllowed(List<SJmoRSGgetRsg> rsgsInfo) {
        String numOfRsg = this.getNumOfRsgs(rsgsInfo);
        numOfRsg = numOfRsg + " " + this.guidanceHandle.getGuidance(GUID_BRACKET_LEFT) + this.guidanceHandle.getGuidance("MAX_ALLOWED") + " " + 1024 + this.guidanceHandle.getGuidance(GUID_BRACKET_RIGHT);
        return numOfRsg;
    }

    public String getNumOfUsgs(SJctrRsgUserInfo rsgUsgInfo) {
        String userGroupCount = "?";
        if (null != rsgUsgInfo) {
            userGroupCount = Integer.toString(rsgUsgInfo.getNumOfUserGroups());
        }
        return userGroupCount;
    }

    public String getNumOfPgs(SJmoRSGgetRsg rsgInfo, List<SJmoPgScatteredInfo> pgScList) {
        String resourceCount = "?";
        if (null != rsgInfo) {
            ArrayList<SJmoPgIndex> pgIndexList = rsgInfo.getVdevs();
            int pgCount = 0;
            ArrayList scPgsIndex = new ArrayList();
            for (SJmoPgScatteredInfo scPgInfo : pgScList) {
                scPgsIndex.addAll(scPgInfo.getAlPgIndex());
            }
            Collections.sort(scPgsIndex);
            for (SJmoPgIndex pgIndex : pgIndexList) {
                int index = Collections.binarySearch(scPgsIndex, pgIndex);
                if (0 <= index) continue;
                ++pgCount;
            }
            resourceCount = Integer.toString(pgCount);
        }
        return resourceCount;
    }

    public String getNumOfLdevs(SJmoRSGgetRsg rsgInfo, List<SJmoLdevLuseInfo> luseList) {
        String resourceCount = "?";
        if (null != rsgInfo) {
            ArrayList<SJmoLdevIndex> ldevIndexList = rsgInfo.getLdevs();
            int ldevCount = 0;
            ArrayList lusesIndex = new ArrayList();
            for (SJmoLdevLuseInfo luseInfo : luseList) {
                lusesIndex.addAll(luseInfo.getAlLUSELdevIndex());
            }
            Collections.sort(lusesIndex);
            for (SJmoLdevIndex ldevIndex : ldevIndexList) {
                int index = Collections.binarySearch(lusesIndex, ldevIndex);
                if (0 <= index) continue;
                ++ldevCount;
            }
            resourceCount = Integer.toString(ldevCount);
        }
        return resourceCount;
    }

    public String getNumOfPorts(SJmoRSGgetRsg rsgInfo) {
        String resourceCount = "?";
        if (null != rsgInfo) {
            resourceCount = Integer.toString(rsgInfo.getPorts().size());
        }
        return resourceCount;
    }

    public String getNumOfHostGroups(SJmoRSGgetRsg rsgInfo, List<SJmoPortDetail> portDetailList) {
        String resourceCount = "?";
        if (null != rsgInfo && null != portDetailList) {
            ArrayList<SJmoHostGroupIndex> hgIndexList = rsgInfo.getHostGrps();
            resourceCount = Integer.toString(this.getNumOfHostGroupsNumber(hgIndexList, portDetailList));
        }
        return resourceCount;
    }

    public int getNumOfHostGroupsNumber(List<SJmoHostGroupIndex> hgIndexList, List<SJmoPortDetail> portDetailList) {
        int count = 0;
        if (null != hgIndexList && null != portDetailList) {
            for (SJmoHostGroupIndex hgIndex : hgIndexList) {
                if (!SJctrRsgUtility.isFibrePort(portDetailList, hgIndex)) continue;
                ++count;
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "getNumOfHostGroupsNumber", "hgIndexList or portDetailList is null.");
        }
        return count;
    }

    public String getNumOfIscsiTargets(SJmoRSGgetRsg rsgInfo, List<SJmoPortDetail> portDetailList) {
        String resourceCount = "?";
        if (null != rsgInfo && null != portDetailList) {
            ArrayList<SJmoHostGroupIndex> iscsiIndexList = rsgInfo.getHostGrps();
            resourceCount = Integer.toString(this.getNumOfIscsiTargetsNumber(iscsiIndexList, portDetailList));
        }
        return resourceCount;
    }

    public int getNumOfIscsiTargetsNumber(List<SJmoHostGroupIndex> iscsiIndexList, List<SJmoPortDetail> portDetailList) {
        int count = 0;
        if (null != iscsiIndexList && null != portDetailList) {
            for (SJmoHostGroupIndex iscsiIndex : iscsiIndexList) {
                if (!SJctrRsgUtility.isIscsiPort(portDetailList, iscsiIndex)) continue;
                ++count;
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "getNumOfIscsiTargetsNumber", "iscsiIndexList or portDetailList is null.");
        }
        return count;
    }

    public String getUndefHostGroupString(SJmoHostGroupIndex hgIndex) {
        String hgStr = this.guidanceHandle.getGuidance(GUID_BRACKET_LEFT) + this.getHostGroupNumString(hgIndex) + this.guidanceHandle.getGuidance(GUID_BRACKET_RIGHT);
        return hgStr;
    }

    public String getHostGroupNumString(SJmoHostGroupIndex hgIndex) {
        String hgNumString = "?";
        if (null != hgIndex) {
            hgNumString = String.format("%02X", hgIndex.getSHostGroup());
        }
        return hgNumString;
    }

    public static SJmoRSGgetRsg getRsgInfoByRsgId(int rsgId, List<SJmoRSGgetRsg> rsgInfoList) {
        SJmoRSGgetRsg rtnInfo = null;
        for (SJmoRSGgetRsg rsgInfo : rsgInfoList) {
            if (rsgInfo.getRsgInfo().getRsgId() != rsgId) continue;
            rtnInfo = rsgInfo;
            break;
        }
        return rtnInfo;
    }

    public static boolean isMaxCountOfRsgs(List<?> ... rsgInfoLists) {
        boolean ret = false;
        int rsgCount = 0;
        for (List<?> rsgInfoList : rsgInfoLists) {
            rsgCount += rsgInfoList.size();
        }
        if (1024 <= rsgCount) {
            ret = true;
        }
        return ret;
    }

    public static boolean isInvalidRsgName(String rsgName) {
        boolean ret = false;
        for (String disabledName : SJctrAccountRsgDataMacro.BUILTIN_RSG_NAMES) {
            if (!disabledName.equals(rsgName)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean isDuplicateRsgName(String rsgName, List<SJmoRSGgetRsg> rsgInfoList) {
        boolean ret = false;
        for (SJmoRSGgetRsg rsgInfo : rsgInfoList) {
            if (!rsgInfo.getRsgInfo().getRsgName().equals(rsgName)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean isDuplicateRsgName(String rsgName, List<SJmoRSGgetRsg> rsgInfoList, List<? extends SJctrRsgInfo> selRsgInfoList) {
        boolean ret = false;
        for (SJctrRsgInfo sJctrRsgInfo : selRsgInfoList) {
            if (!sJctrRsgInfo.getRsgInfo().getRsgInfo().getRsgName().equals(rsgName)) continue;
            ret = true;
            break;
        }
        if (!ret) {
            ret = SJctrRsgUtility.isDuplicateRsgName(rsgName, rsgInfoList);
        }
        return ret;
    }

    public static boolean isDuplicateLdevId(SJmoLdevIndex ldevIndex, int vdkcno, List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean ret = false;
        if (null == ldevIndex) {
            SJctrLogUty.error("SJctrRsgUtility", "isDuplicateLdevId", "ldevIndex is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isDuplicateLdevId", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo ldev : ldevInfoList) {
            if (ldev.getVLDEV().getIndex() != ldevIndex.getIndex() || vdkcno != ldev.getVLDEV().getVBoxIndex().getIVboxId()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean isDuplicateListLdevId(List<SJctrRsgLdevInfo> ldevInfoList, List<SJctrRsgLdevInfo> AllldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isDuplicateListLdevId", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (null == AllldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isDuplicateListLdevId", "AllldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            int vdkc;
            SJmoLdevIndex checkLdevIndex = checkLdev.getVLDEV().getVirtualLdev();
            boolean isDuplicate = SJctrRsgUtility.isDuplicateLdevId(checkLdevIndex, vdkc = checkLdev.getVLDEV().getVBoxIndex().getIVboxId(), AllldevInfoList);
            if (!isDuplicate) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isExistResource(SJmoRSGgetRsg rsgInfo) {
        boolean ret = false;
        if (0 < rsgInfo.getVdevs().size()) {
            ret = true;
        } else if (0 < rsgInfo.getLdevs().size()) {
            ret = true;
        } else if (0 < rsgInfo.getPorts().size()) {
            ret = true;
        } else if (0 < rsgInfo.getHostGrps().size()) {
            ret = true;
        }
        return ret;
    }

    public static boolean isIncludeRsg0(List<SJctrRsgInfo> rsgInfoList) {
        boolean ret = false;
        for (SJctrRsgInfo rsgInfo : rsgInfoList) {
            if (0 != rsgInfo.getRsgInfo().getRsgInfo().getRsgId()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean isIncludeDifferentVdkc(List<SJctrRsgInfo> rsgInfoList) {
        boolean ret = false;
        if (null == rsgInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isIncludeDifferentVdkc", "rsgInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int checkVboxId = rsgInfoList.get(0).getRsgInfo().getRsgInfo().getVboxIndex().getIVboxId();
        for (SJctrRsgInfo rsgInfo : rsgInfoList) {
            int vboxId = rsgInfo.getRsgInfo().getRsgInfo().getVboxIndex().getIVboxId();
            if (vboxId == checkVboxId) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static HUVM_VDKC_Operation_IN createCreateRsgsApplyData(List<SJctrRsgInfo> rsgInfoList) {
        HUVM_VDKC_Operation_IN applyParam = new HUVM_VDKC_Operation_IN();
        applyParam.setOperation(2);
        HUVMsetVDKC vdkcParam = new HUVMsetVDKC();
        ArrayList<RSGsetRSG> rsgsList = new ArrayList<RSGsetRSG>();
        for (SJctrRsgInfo createRsgInfo : rsgInfoList) {
            RSGsetRSG rsgs = new RSGsetRSG();
            HUVMvboxIndex huvmIndex = new HUVMvboxIndex();
            huvmIndex.setVboxId(0);
            rsgs.setVboxIndex(huvmIndex);
            rsgs.setNickname(createRsgInfo.getRsgInfo().getRsgInfo().getRsgName());
            rsgs.setRsgId(-1);
            rsgsList.add(rsgs);
        }
        vdkcParam.setRsgs(rsgsList);
        applyParam.setVDKC(vdkcParam);
        return applyParam;
    }

    public static HUVM_VDKC_Operation_IN createEditRsgsApplyData(List<SJctrRsgInfo> rsgInfoList) {
        HUVM_VDKC_Operation_IN applyParam = new HUVM_VDKC_Operation_IN();
        applyParam.setOperation(4);
        HUVMsetVDKC vdkcParam = new HUVMsetVDKC();
        ArrayList<RSGsetRSG> rsgsList = new ArrayList<RSGsetRSG>();
        for (SJctrRsgInfo editRsgInfo : rsgInfoList) {
            RSGsetRSG rsgs = new RSGsetRSG();
            HUVMvboxIndex huvmIndex = new HUVMvboxIndex();
            huvmIndex.setVboxId(editRsgInfo.getRsgInfo().getRsgInfo().getVboxIndex().getIVboxId());
            rsgs.setVboxIndex(huvmIndex);
            rsgs.setRsgId(editRsgInfo.getRsgInfo().getRsgInfo().getRsgId());
            rsgs.setNickname(editRsgInfo.getRsgInfo().getRsgInfo().getRsgName());
            rsgsList.add(rsgs);
        }
        vdkcParam.setRsgs(rsgsList);
        applyParam.setVDKC(vdkcParam);
        return applyParam;
    }

    public static HUVM_VDKC_Operation_IN createDeleteRsgsApplyData(List<SJctrRsgInfo> rsgInfoList) {
        HUVM_VDKC_Operation_IN applyParam = new HUVM_VDKC_Operation_IN();
        applyParam.setOperation(3);
        HUVMsetVDKC vdkcParam = new HUVMsetVDKC();
        ArrayList<RSGsetRSG> rsgsList = new ArrayList<RSGsetRSG>();
        for (SJctrRsgInfo editRsgInfo : rsgInfoList) {
            RSGsetRSG rsgs = new RSGsetRSG();
            HUVMvboxIndex huvmIndex = new HUVMvboxIndex();
            huvmIndex.setVboxId(editRsgInfo.getRsgInfo().getRsgInfo().getVboxIndex().getIVboxId());
            rsgs.setVboxIndex(huvmIndex);
            rsgs.setRsgId(editRsgInfo.getRsgInfo().getRsgInfo().getRsgId());
            rsgsList.add(rsgs);
        }
        vdkcParam.setRsgs(rsgsList);
        applyParam.setVDKC(vdkcParam);
        return applyParam;
    }

    public static RSGsetMigrateRsc_IN createAddRscApplyData(List<SJctrRsgInfo> rsgInfoList, List<SJmoPgScatteredInfo> pgScList, List<SJmoLdevLuseInfo> luseList) {
        RSGsetMigrateRsc_IN applyParam = new RSGsetMigrateRsc_IN();
        ArrayList<RSGsetMigrate_1Rsg> migrateDataList = new ArrayList<RSGsetMigrate_1Rsg>();
        for (SJctrRsgInfo rsgInfo : rsgInfoList) {
            SJmoRSGgetRsg rsgData = rsgInfo.getRsgInfo();
            if (!SJctrRsgUtility.isExistResource(rsgData)) continue;
            RSGIndex toIndex = new RSGIndex();
            toIndex.setRsgId(rsgData.getRsgInfo().getRsgId());
            migrateDataList.add(SJctrRsgUtility.createMigrateRscData(toIndex, rsgInfo, pgScList, luseList));
        }
        applyParam.setRsgs(migrateDataList);
        return applyParam;
    }

    public static RSGsetMigrateRsc_IN createRemoveRscApplyData(List<SJctrRsgInfo> rsgInfoList, List<SJmoPgScatteredInfo> pgScList, List<SJmoLdevLuseInfo> luseList) {
        RSGsetMigrateRsc_IN applyParam = new RSGsetMigrateRsc_IN();
        RSGIndex toIndex = new RSGIndex();
        toIndex.setRsgId(0);
        ArrayList<RSGsetMigrate_1Rsg> migrateDataList = new ArrayList<RSGsetMigrate_1Rsg>();
        for (SJctrRsgInfo rsgInfo : rsgInfoList) {
            if (!SJctrRsgUtility.isExistResource(rsgInfo.getRsgInfo())) continue;
            migrateDataList.add(SJctrRsgUtility.createMigrateRscData(toIndex, rsgInfo, pgScList, luseList));
        }
        applyParam.setRsgs(migrateDataList);
        return applyParam;
    }

    public static RSGsetMigrate_1Rsg createMigrateRscData(RSGIndex toIndex, SJctrRsgInfo rsgInfo, List<SJmoPgScatteredInfo> pgScList, List<SJmoLdevLuseInfo> luseList) {
        RSGsetMigrate_1Rsg setRscInfo = new RSGsetMigrate_1Rsg();
        setRscInfo.setRsgTo(toIndex);
        SJmoRSGgetRsg target = rsgInfo.getRsgInfo();
        ArrayList<SJmoPgIndex> pgsList = target.getVdevs();
        ArrayList<SJmoLdevIndex> ldevsList = target.getLdevs();
        ArrayList<SJmoPortIndex> portsList = target.getPorts();
        ArrayList<SJmoHostGroupIndex> hgsList = target.getHostGrps();
        ArrayList<RSGsetPg> setPgsList = new ArrayList<RSGsetPg>();
        for (SJmoPgIndex pgIndex : pgsList) {
            RSGsetPg setPg = new RSGsetPg();
            setPg.setPGIndex(pgIndex.getFB4(), pgIndex.getPG());
            setPgsList.add(setPg);
            int index = Collections.binarySearch(pgScList, pgIndex);
            if (0 > index) continue;
            ArrayList pgScIndexList = pgScList.get(index).getAlPgIndex();
            for (SJmoPgIndex pgScIndex : pgScIndexList) {
                RSGsetPg setPgSc = new RSGsetPg();
                setPgSc.setPGIndex(pgScIndex.getFB4(), pgScIndex.getPG());
                setPgsList.add(setPgSc);
            }
        }
        setRscInfo.setVdevs(setPgsList);
        ArrayList<RSGsetLdev> setLdevsList = new ArrayList<RSGsetLdev>();
        for (SJmoLdevIndex ldevIndex : ldevsList) {
            RSGsetLdev setLdev = new RSGsetLdev();
            setLdev.setLDEVIndex(ldevIndex.getSLdkc(), ldevIndex.getSCu(), ldevIndex.getSLdev());
            setLdevsList.add(setLdev);
            int index = Collections.binarySearch(luseList, ldevIndex);
            if (0 > index) continue;
            ArrayList luseIndexList = luseList.get(index).getAlLUSELdevIndex();
            for (SJmoLdevIndex luseIndex : luseIndexList) {
                RSGsetLdev setLuse = new RSGsetLdev();
                setLuse.setLDEVIndex(luseIndex.getSLdkc(), luseIndex.getSCu(), luseIndex.getSLdev());
                setLdevsList.add(setLuse);
            }
        }
        setRscInfo.setLdevs(setLdevsList);
        ArrayList<RSGsetPort> setPortsList = new ArrayList<RSGsetPort>();
        for (SJmoPortIndex portIndex : portsList) {
            RSGsetPort setPort = new RSGsetPort();
            setPort.setSPort(portIndex.getSPort());
            setPortsList.add(setPort);
        }
        setRscInfo.setPorts(setPortsList);
        ArrayList<RSGsetHostGroup> setHgsList = new ArrayList<RSGsetHostGroup>();
        for (SJmoHostGroupIndex hgIndex : hgsList) {
            RSGsetHostGroup setHg = new RSGsetHostGroup();
            setHg.setSPort(hgIndex.getSPort());
            setHg.setSHostGroupId(hgIndex.getSHostGroup());
            setHgsList.add(setHg);
        }
        setRscInfo.setHostGrps(setHgsList);
        return setRscInfo;
    }

    public static List<SJctrRsgPgInfo> createRsgPgInfoList(List<SJmoPgIndex> pgIndexList, List<SJmoPgDetail> pgDetailList, List<SJmoVdevDetail> VdevList, List<SJmoPdevDetail> PdevList, List<SJmoPgScatteredInfo> PgScList, List<SJmoPgEncryptionInfo> encList, List<SJmoLdevDetail> ldevList, List<SJmoLdevStatusInfo> stsList, List<SJmoLdevLuseInfo> luseList) {
        ArrayList<SJctrRsgPgInfo> pgTableList = new ArrayList<SJctrRsgPgInfo>();
        if (null != pgIndexList && null != pgDetailList && null != VdevList && null != PdevList && null != PgScList && null != encList && null != ldevList && null != stsList && null != luseList) {
            for (SJmoPgIndex pgIndex : pgIndexList) {
                SJmoPgDetail pgDetail;
                int index = Collections.binarySearch(pgDetailList, pgIndex);
                if (index < 0 || !SJctrRsgUtility.isViewRscPg(pgDetail = pgDetailList.get(index))) continue;
                SJctrRsgPgInfo pgTableInfo = new SJctrRsgPgInfo(pgIndex);
                pgTableInfo.setPGDetail(pgDetail);
                pgTableInfo.setExist(true);
                pgTableInfo.setPGScatteredList(PgScList);
                pgTableInfo.setBasicDataList(pgDetailList, VdevList, ldevList, null);
                pgTableInfo.setPDEVList(PdevList);
                pgTableInfo.setEncriptionList(encList);
                pgTableInfo.setLDEVStauts(stsList);
                pgTableInfo.setLuseList(luseList);
                if (!pgTableInfo.isScTopPG()) continue;
                pgTableList.add(pgTableInfo);
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "createRsgPgInfoList", "pgIndexList or pgDetailList or VdevList or PdevList or PgScList or encList or ldevList or stsList or luseList is null.");
        }
        return pgTableList;
    }

    public static boolean isViewRscPg(SJmoPgIndex pgIndex) {
        boolean ret = false;
        int pgFB4No = pgIndex.getFB4();
        if (1 <= pgFB4No && pgFB4No <= DEF_INTERNAL_PG_NO_END) {
            ret = true;
        } else if (101 <= pgFB4No && pgFB4No <= 16484) {
            ret = true;
        } else if (16641 <= pgFB4No && pgFB4No <= 17152) {
            ret = true;
        }
        return ret;
    }

    public static List<SJctrRsgLdevInfo> createRsgLdevInfoList(List<SJmoLdevIndex> ldevIndexList, List<SJmoLdevDetail> ldevDetailList) {
        ArrayList<SJctrRsgLdevInfo> ldevTableList = new ArrayList<SJctrRsgLdevInfo>();
        if (null != ldevIndexList && null != ldevDetailList) {
            for (SJmoLdevIndex ldevIndex : ldevIndexList) {
                SJctrRsgLdevInfo ldevTableInfo = new SJctrRsgLdevInfo(ldevIndex);
                int index = Collections.binarySearch(ldevDetailList, ldevIndex);
                if (index >= 0) {
                    SJmoLdevDetail ldevDetail = ldevDetailList.get(index);
                    if (0 == ldevDetailList.get(index).getSLUSEEmlCount()) continue;
                    ldevTableInfo.setDetailData(ldevDetail);
                    ldevTableInfo.setExist(true);
                }
                ldevTableList.add(ldevTableInfo);
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "createRsgLdevInfoList", "ldevIndexList or ldevDetailList is null.");
        }
        return ldevTableList;
    }

    public static List<SJctrRsgLdevInfo> createRsgLdevInfoList(List<SJmoLdevIndex> ldevIndexList, List<SJmoLdevDetail> ldevDetailList, List<SJmoHUVMVirtualLdev> virtualLdevList) {
        ArrayList<SJctrRsgLdevInfo> ldevTableList = new ArrayList<SJctrRsgLdevInfo>();
        if (null == ldevIndexList || null == ldevDetailList || null == virtualLdevList) {
            return ldevTableList;
        }
        for (SJmoLdevIndex ldevIndex : ldevIndexList) {
            int vindex;
            SJctrRsgLdevInfo ldevTableInfo = new SJctrRsgLdevInfo(ldevIndex);
            int index = Collections.binarySearch(ldevDetailList, ldevIndex);
            if (index >= 0) {
                SJmoLdevDetail ldevDetail = ldevDetailList.get(index);
                if (0 == ldevDetailList.get(index).getSLUSEEmlCount()) continue;
                ldevTableInfo.setDetailData(ldevDetail);
                ldevTableInfo.setExist(true);
            }
            if ((vindex = Collections.binarySearch(virtualLdevList, ldevIndex)) >= 0) {
                ldevTableInfo.setVLDEV(virtualLdevList.get(vindex));
            }
            ldevTableList.add(ldevTableInfo);
        }
        return ldevTableList;
    }

    public static List<SJctrRsgPortInfo> createRsgPortInfoList(List<SJmoPortIndex> portIndexList, List<SJmoPortDetail> portDetailList) {
        ArrayList<SJctrRsgPortInfo> portTableList = new ArrayList<SJctrRsgPortInfo>();
        if (null != portIndexList && null != portDetailList) {
            for (SJmoPortIndex portIndex : portIndexList) {
                int index = Collections.binarySearch(portDetailList, portIndex);
                if (index < 0) continue;
                SJctrRsgPortInfo portTableInfo = new SJctrRsgPortInfo(portIndex);
                portTableInfo.setDetailData(portDetailList.get(index));
                portTableInfo.setExist(true);
                portTableList.add(portTableInfo);
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "createRsgPortInfoList", "portIndexList or portDetailList is null.");
        }
        return portTableList;
    }

    public static List<SJctrRsgHostGroupInfo> createRsgHgInfoList(List<SJmoHostGroupIndex> hgIndexList, List<SJmoPortDetail> portDetailList, List<SJmoPortHostGroupInfo> hgInfoList) {
        ArrayList<SJctrRsgHostGroupInfo> hgTableList = new ArrayList<SJctrRsgHostGroupInfo>();
        if (null != hgIndexList && null != portDetailList && null != hgInfoList) {
            for (SJmoHostGroupIndex hgIndex : hgIndexList) {
                SJctrRsgHostGroupInfo hgTableData;
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort(hgIndex.getSPort());
                SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(portDetailList, portIndex);
                if (portDetail == null || !SJctrRsgUtility.isFibrePort(portDetail) || (hgTableData = SJctrRsgUtility.createHgTableData(hgInfoList, portIndex, hgIndex, portDetail)) == null) continue;
                hgTableList.add(hgTableData);
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "createRsgHgInfoList", "hgIndexList or portDetailList or hgInfoList is null.");
        }
        return hgTableList;
    }

    public static List<SJctrRsgIscsiTargetInfo> createRsgIscsiInfoList(List<SJmoHostGroupIndex> iscsiIndexList, List<SJmoPortDetail> portDetailList, List<SJmoPortIscsiTargetInfo> iscsiInfoList) {
        ArrayList<SJctrRsgIscsiTargetInfo> iscsiTableList = new ArrayList<SJctrRsgIscsiTargetInfo>();
        if (null != iscsiIndexList && null != portDetailList && null != iscsiInfoList) {
            for (SJmoHostGroupIndex iscsiIndex : iscsiIndexList) {
                SJctrRsgIscsiTargetInfo iscsiTableData;
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort(iscsiIndex.getSPort());
                SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(portDetailList, portIndex);
                if (portDetail == null || !SJctrIscsiUtility.isIscsiPort(portDetail) || (iscsiTableData = SJctrRsgUtility.createIscsiTableData(iscsiInfoList, portIndex, iscsiIndex, portDetail)) == null) continue;
                iscsiTableList.add(iscsiTableData);
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "createRsgIscsiInfoList", "iscsiIndexList or portDetailList or iscsiInfoList is null.");
        }
        return iscsiTableList;
    }

    public static List<SJctrRsgHostGroupIscsiTargetInfo> createRsgHgIscsiInfoList(List<SJmoHostGroupIndex> hgIscsiList, List<SJmoPortDetail> portDetailList, List<SJmoPortHostGroupInfo> hgInfoList, List<SJmoPortIscsiTargetInfo> iscsiInfoList) {
        ArrayList<SJctrRsgHostGroupIscsiTargetInfo> hgiscsiTableList = new ArrayList<SJctrRsgHostGroupIscsiTargetInfo>();
        if (null != hgIscsiList && null != portDetailList && null != hgInfoList && null != iscsiInfoList) {
            for (SJmoHostGroupIndex hgiscsiIndex : hgIscsiList) {
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort(hgiscsiIndex.getSPort());
                SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(portDetailList, portIndex);
                if (portDetail == null) continue;
                if (SJctrRsgUtility.isFibrePort(portDetail)) {
                    SJctrRsgHostGroupInfo hgTableData = SJctrRsgUtility.createHgTableData(hgInfoList, portIndex, hgiscsiIndex, portDetail);
                    if (hgTableData == null) continue;
                    hgiscsiTableList.add(hgTableData);
                    continue;
                }
                if (SJctrIscsiUtility.isIscsiPort(portDetail)) {
                    SJctrRsgIscsiTargetInfo iscsiTableData = SJctrRsgUtility.createIscsiTableData(iscsiInfoList, portIndex, hgiscsiIndex, portDetail);
                    if (iscsiTableData == null) continue;
                    hgiscsiTableList.add(iscsiTableData);
                    continue;
                }
                SJctrLogUty.info("SJctrRsgUtility", "createRsgHgIscsiInfoList", "portDetail is failled.");
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "createRsgHgIscsiInfoList", "hgIscsiList or portDetailList or hgInfoList or iscsiInfoList is null.");
        }
        return hgiscsiTableList;
    }

    public static Map<String, SJctrUserGrpInfoDetail> getUserGroupsInfo(SJctrLogUty logUtil) {
        Map<String, SJctrUserGrpInfoDetail> userGrpInfoDetailMap = null;
        String[] userGrpNames = null;
        try {
            userGrpNames = SJcUserGroupInfoUty.getUserGroupList();
        }
        catch (SJcException e) {
            logUtil.putlog("getUserGroupsInfo", "[Logic Error]getUserGroupList() is failed (" + e.getClass().getSimpleName() + ")", null, 30000);
        }
        if (userGrpNames != null) {
            try {
                userGrpInfoDetailMap = SJctrAccountInfoUty.getUserGrpInfoDetailList(userGrpNames);
            }
            catch (SJcException e) {
                logUtil.putlog("getUserGroupsInfo", "[Logic Error]getUserGrpInfoDetailList() is failed (" + e.getClass().getSimpleName() + ")", null, 30000);
            }
        }
        return userGrpInfoDetailMap;
    }

    public String getVirtualStorageMode(List<?> dataList) {
        String strRtn = "?";
        if (null != dataList) {
            SJmoRSGVirtualDkc vDkc;
            boolean vsmFlg;
            Object obj;
            strRtn = this.guidanceHandle.getGuidance("VSM_FOR_RSG_DISABLED");
            if (0 != dataList.size() && null != (obj = dataList.get(0)) && obj instanceof SJmoRSGVirtualDkc && (vsmFlg = (vDkc = (SJmoRSGVirtualDkc)obj).getVValidity())) {
                strRtn = this.guidanceHandle.getGuidance("VSM_FOR_RSG_ENABLED");
            }
        }
        return strRtn;
    }

    public static void makePgCapacityUnit(SJctrTableDataModel table, List<? extends SJmoPgDetail> basicDataList) {
        table.setCapacityFlg(true);
        table.setDpVolumeFlg(false);
        table.setOpenVolumeFlg(false);
        table.setMainframeVolumeFlg(false);
        SJctrComCVSUtility uty = table.getComUtility().getCVSUtility();
        for (SJmoPgDetail sJmoPgDetail : basicDataList) {
            String strEmu = uty.getEmulationTypeName(sJmoPgDetail.getBaseEmulationType());
            if (uty.isOpen(strEmu)) {
                table.setOpenVolumeFlg(true);
            } else if (uty.isMainframe(strEmu)) {
                table.setMainframeVolumeFlg(true);
            }
            if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
            break;
        }
    }

    public static void makeLdevCapacityUnit(SJctrTableDataModel table, List<? extends SJmoLdevDetail> basicDataList) {
        table.setCapacityFlg(true);
        table.setDpVolumeFlg(false);
        table.setOpenVolumeFlg(false);
        table.setMainframeVolumeFlg(false);
        for (SJmoLdevDetail sJmoLdevDetail : basicDataList) {
            if (SJctrLdevUtility.isOpenVolume(sJmoLdevDetail)) {
                table.setOpenVolumeFlg(true);
            } else if (SJctrLdevUtility.isMFVolume(sJmoLdevDetail)) {
                table.setMainframeVolumeFlg(true);
            }
            if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
            break;
        }
    }

    public static boolean isFibrePort(SJmoPortDetail portDetail) {
        boolean ret = false;
        if (portDetail != null) {
            switch (portDetail.getByPortKindNo()) {
                case 2: {
                    ret = true;
                    break;
                }
                case 4: {
                    ret = true;
                    break;
                }
                case 6: {
                    ret = true;
                    break;
                }
                case 7: {
                    ret = true;
                    break;
                }
                case 8: {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static boolean isIscsiPort(SJmoPortDetail portDetail) {
        boolean ret = false;
        if (portDetail != null && portDetail.getByPortKindNo() == 5) {
            ret = true;
        }
        return ret;
    }

    public static Object getPortInfoByPortIndex(List<? extends SJmoPortIndex> portList, SJmoPortIndex portIndex) {
        int index;
        SJmoPortIndex data = null;
        if (portList != null && portIndex != null && (index = Collections.binarySearch(portList, portIndex)) >= 0) {
            data = portList.get(index);
        }
        return data;
    }

    public static boolean isFibrePort(List<SJmoPortDetail> portDetailList, SJmoHostGroupIndex hgIscsiIndex) {
        boolean result = false;
        if (null != portDetailList && null != hgIscsiIndex) {
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(hgIscsiIndex.getSPort());
            SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(portDetailList, portIndex);
            if (portDetail != null && SJctrRsgUtility.isFibrePort(portDetail)) {
                result = true;
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "isFibrePort", "portDetailList or hgIscsiIndex is null.");
        }
        return result;
    }

    public static boolean isIscsiPort(List<SJmoPortDetail> portDetailList, SJmoHostGroupIndex hgIscsiIndex) {
        boolean result = false;
        if (null != portDetailList && null != hgIscsiIndex) {
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(hgIscsiIndex.getSPort());
            SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortIndex(portDetailList, portIndex);
            if (portDetail != null && SJctrRsgUtility.isIscsiPort(portDetail)) {
                result = true;
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "isIscsiPort", "portDetailList or hgIscsiIndex is null.");
        }
        return result;
    }

    public static boolean isVirtualLdevIdListReserve(List<SJctrRsgLdevInfo> ldevInfoList) {
        SJctrRsgLdevInfo checkLdev;
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevIdListReserve", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Iterator<SJctrRsgLdevInfo> i$ = ldevInfoList.iterator();
        while (i$.hasNext() && !(result = SJctrRsgUtility.isVirtualLdevIdReserve((checkLdev = i$.next()).getVLDEV()))) {
        }
        return result;
    }

    public static boolean isVirtualLdevIdReserve(SJmoHUVMVirtualLdev ldevInfo) {
        boolean result = false;
        if (null == ldevInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevIdReserve", "ldevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoLdevIndex virtualLdev = ldevInfo.getVirtualLdev();
        if (virtualLdev.getSCu() != 255) {
            result = true;
        }
        return result;
    }

    public static boolean isVirtualLdevListHuvmOn(List<SJctrRsgLdevInfo> ldevInfoList) {
        SJctrRsgLdevInfo checkLdev;
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevHuvmOff", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Iterator<SJctrRsgLdevInfo> i$ = ldevInfoList.iterator();
        while (i$.hasNext() && !(result = SJctrRsgUtility.isVirtualLdevHuvmOn((checkLdev = i$.next()).getVLDEV()))) {
        }
        return result;
    }

    public static boolean isVirtualLdevHuvmOn(SJmoHUVMVirtualLdev ldevInfo) {
        boolean result = false;
        if (null == ldevInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevListHuvmOn", "ldevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        short vAttrHuvm = ldevInfo.getSVAttrHuvm();
        if ((vAttrHuvm & Short.MIN_VALUE) == Short.MIN_VALUE) {
            result = true;
        }
        return result;
    }

    public static boolean isVirtualLdevListHuvmOff(List<SJctrRsgLdevInfo> ldevInfoList) {
        SJctrRsgLdevInfo checkLdev;
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevListHuvmOff", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Iterator<SJctrRsgLdevInfo> i$ = ldevInfoList.iterator();
        while (i$.hasNext() && !(result = SJctrRsgUtility.isVirtualLdevHuvmOff((checkLdev = i$.next()).getVLDEV()))) {
        }
        return result;
    }

    public static boolean isVirtualLdevHuvmOff(SJmoHUVMVirtualLdev ldevInfo) {
        boolean result = false;
        if (null == ldevInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevHuvmOff", "ldevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        short vAttrHuvm = ldevInfo.getSVAttrHuvm();
        if ((vAttrHuvm & Short.MIN_VALUE) != Short.MIN_VALUE) {
            result = true;
        }
        return result;
    }

    public static boolean isVirtualLdevIdListNotNormal(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevIdListNotNormal", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean isNormal = SJctrRsgUtility.isVirtualLdevIdNormal(checkLdev.getVLDEV());
            if (isNormal) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isVirtualLdevIdNormal(SJmoHUVMVirtualLdev ldevInfo) {
        boolean result = false;
        if (null == ldevInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevIdNotNormal", "ldevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        short vAttrHuvm = ldevInfo.getSVAttrHuvm();
        if ((vAttrHuvm & Short.MIN_VALUE) == Short.MIN_VALUE && (vAttrHuvm & 0x4000) == 0 && (vAttrHuvm & 0x2000) == 0) {
            result = true;
        }
        return result;
    }

    public static boolean isVirtualLdevListNotReserve(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevListNotReserve", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean isReserve = SJctrRsgUtility.isVirtualLdevReserve(checkLdev.getVLDEV());
            if (isReserve) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isVirtualLdevReserve(SJmoHUVMVirtualLdev ldevInfo) {
        boolean result = false;
        if (null == ldevInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevNotReserve", "ldevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        short vAttrHuvm = ldevInfo.getSVAttrHuvm();
        if ((vAttrHuvm & Short.MIN_VALUE) == Short.MIN_VALUE && (vAttrHuvm & 0x4000) == 0 && (vAttrHuvm & 0x2000) == 8192) {
            result = true;
        }
        return result;
    }

    public static boolean isMappingLuPath(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isMappingLuPath", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            int luPathNum = checkLdev.getILUPathNumber();
            if (luPathNum <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isMappingHGLuPath(List<SJctrRsgHostGroupInfo> HostGroupInfoList, List<SJmoPortLunInfo> PortLuPathList) {
        boolean result = false;
        if (null == HostGroupInfoList || null == PortLuPathList) {
            SJctrLogUty.error("SJctrRsgUtility", "isMappingHGLuPath", "HostGroupInfoList or PortLuPathList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgHostGroupInfo checkHg : HostGroupInfoList) {
            ArrayList portLunDetailList;
            if (!checkHg.isExist()) continue;
            SJmoPortLunInfo portLunInfo = new SJmoPortLunInfo();
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(checkHg.getSPort());
            int index = Collections.binarySearch(PortLuPathList, portIndex);
            if (index < 0 || !(result = SJctrRsgUtility.checkPortLunDetailUsedSpecifiedHg(portLunDetailList = (portLunInfo = PortLuPathList.get(index)).getAlPortLun(), checkHg.getSHostGroup()))) continue;
            break;
        }
        return result;
    }

    public static boolean isMappingIscsiLuPath(List<SJctrRsgIscsiTargetInfo> iscsiTargetInfoList, List<SJmoPortLunInfo> portLuPathList) {
        if (null == iscsiTargetInfoList || null == portLuPathList) {
            SJctrLogUty.error("SJctrRsgUtility", "isMappingIscsiLuPath", "iSCSITargetInfo or PortLunInfo is null.");
            throw SJctrRsgUtility.createRsgException(107001);
        }
        boolean luPathResultIscsi = false;
        for (SJctrRsgIscsiTargetInfo checkIscsi : iscsiTargetInfoList) {
            ArrayList portLunDetailList;
            if (!checkIscsi.isExist()) continue;
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(checkIscsi.getSPort());
            SJmoPortLunInfo portLunInfo = new SJmoPortLunInfo();
            int index = Collections.binarySearch(portLuPathList, portIndex);
            if (index < 0 || !SJctrRsgUtility.checkPortLunDetailUsedSpecifiedHg(portLunDetailList = (portLunInfo = portLuPathList.get(index)).getAlPortLun(), checkIscsi.getSHostGroup())) continue;
            luPathResultIscsi = true;
            break;
        }
        return luPathResultIscsi;
    }

    public static boolean checkPortLunDetailUsedSpecifiedHg(List<SJmoPortLunDetail> portLunDetailList, short hgId) {
        boolean result = false;
        if (null == portLunDetailList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkPortLunDetailUsedSpecifiedHg", "portLunDetailList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJmoPortLunDetail portLunDetail : portLunDetailList) {
            if (portLunDetail.getSHostGroup() != hgId) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isDefaultVdkcNumber(SJmoRSGInfo targetRsgInfo) {
        boolean result = false;
        if (null == targetRsgInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isDefaultVdkcNumber", "targetRsgInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int checkVdkc = targetRsgInfo.getVboxIndex().getIVboxId();
        if (checkVdkc == 0) {
            result = true;
        }
        return result;
    }

    private static SJctrRsgHostGroupInfo createHgTableData(List<SJmoPortHostGroupInfo> hgInfoList, SJmoPortIndex portIndex, SJmoHostGroupIndex hgiscsiIndex, SJmoPortDetail portDetail) {
        SJctrRsgHostGroupInfo hgTableInfo = null;
        if (null != hgInfoList && null != portIndex && null != hgiscsiIndex && null != portDetail) {
            SJmoPortHostGroupInfo portHgInfo = (SJmoPortHostGroupInfo)SJctrIscsiUtility.getPortInfoByPortIndex(hgInfoList, portIndex);
            if (portHgInfo != null) {
                ArrayList hgInfos = portHgInfo.getAlPortHostGroup();
                SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)SJctrIscsiUtility.getPortInfoByPortIndex(hgInfos, hgiscsiIndex);
                if (hgInfo != null) {
                    hgTableInfo = new SJctrRsgHostGroupInfo(hgiscsiIndex, portDetail, hgInfo);
                    hgTableInfo.setExist(true);
                } else {
                    hgTableInfo = new SJctrRsgHostGroupInfo(hgiscsiIndex, portDetail, null);
                    hgTableInfo.setExist(false);
                }
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "createHgTableData", "hgInfoList or portIndex or hgiscsiIndex or portDetail is null.");
        }
        return hgTableInfo;
    }

    private static SJctrRsgIscsiTargetInfo createIscsiTableData(List<SJmoPortIscsiTargetInfo> iscsiInfoList, SJmoPortIndex portIndex, SJmoHostGroupIndex hgiscsiIndex, SJmoPortDetail portDetail) {
        SJctrRsgIscsiTargetInfo iscsiTableInfo = null;
        if (null != iscsiInfoList && null != portIndex && null != hgiscsiIndex && null != portDetail) {
            SJmoPortIscsiTargetInfo portIscsiInfo = (SJmoPortIscsiTargetInfo)SJctrIscsiUtility.getPortInfoByPortIndex(iscsiInfoList, portIndex);
            if (portIscsiInfo != null) {
                ArrayList<SJmoIscsiTargetInfo> iscsiInfos = portIscsiInfo.getAlPortIscsiTarget();
                SJmoIscsiTargetInfo iscsiInfo = (SJmoIscsiTargetInfo)SJctrIscsiUtility.getPortInfoByPortIndex(iscsiInfos, hgiscsiIndex);
                if (null != iscsiInfo) {
                    iscsiTableInfo = new SJctrRsgIscsiTargetInfo(hgiscsiIndex, portDetail, iscsiInfo);
                    iscsiTableInfo.setExist(true);
                } else {
                    iscsiTableInfo = new SJctrRsgIscsiTargetInfo(hgiscsiIndex, portDetail, null);
                    iscsiTableInfo.setExist(false);
                }
            }
        } else {
            SJctrLogUty.info("SJctrRsgUtility", "createIscsiTableData", "iscsiInfoList or portIndex or hgiscsiIndex or portDetail is null.");
        }
        return iscsiTableInfo;
    }

    public String toDispStringVssModelSerialNo(SJmoHUVMVirtualDkc dkc) {
        String strProduct = "?";
        String strSerialNo = "?";
        if (dkc != null) {
            strProduct = dkc.getStrVProductName();
            strSerialNo = dkc.getStrVSerialNo();
        }
        return strProduct + " / " + strSerialNo;
    }

    public String getModelSerialNumberStringFromRsgInfo(SJmoRSGInfo rsgInfo, List<SJmoHUVMVirtualDkc> vDkcList) {
        SJmoHUVMvboxIndex vIndex;
        int vBoxIndex;
        String strProduct = "?";
        String strSerialNo = "?";
        if (null != rsgInfo && null != vDkcList && (vBoxIndex = Collections.binarySearch(vDkcList, vIndex = rsgInfo.getVboxIndex())) >= 0) {
            SJmoHUVMVirtualDkc vDkcInfo = vDkcList.get(vBoxIndex);
            strProduct = vDkcInfo.getStrVProductName();
            strSerialNo = vDkcInfo.getStrVSerialNo();
        }
        return strProduct + " / " + strSerialNo;
    }

    public static SJcException createRsgException(int err) {
        return new SJctrError(207, 22, err).createException();
    }

    public String toDispStringVssLdevID(SJmoHUVMVirtualLdev ldev, SJctrLdevUtility ldevUtl) {
        String rtn = "?:?:?";
        if (ldev != null) {
            rtn = ldev.isValidIndexVirtualLdev() ? ldevUtl.toLdevDisplay(ldev.getVirtualLdev()) : "";
        }
        return rtn;
    }

    public String toDispStringVssDeviceName(SJmoHUVMVirtualLdev ldev, SJctrLdevUtility ldevUtl) {
        String rtn = "?";
        if (ldev != null) {
            if ((ldev.getSVAttrHuvm() & Short.MIN_VALUE) == 0) {
                return "";
            }
            if (ldev.getSVInfflag() == 1) {
                String strEmu;
                rtn = strEmu = this.getVssEmuType(ldevUtl, ldev.getIVEmulation());
                byte iLun = ldev.getByVLuse();
                if (iLun > 0) {
                    rtn = rtn + "*" + iLun;
                }
                if (ldev.isVCvs()) {
                    rtn = rtn + "-CVS";
                }
            } else {
                rtn = "";
            }
        }
        return rtn;
    }

    private String getVssEmuType(SJctrLdevUtility ldevUtl, int iEmu) {
        String rtn = ldevUtl.toEmuDisplay(iEmu);
        if (rtn.equals("?")) {
            for (int i = 0; i < this.strVssEmu.length; ++i) {
                int iData = Integer.parseInt(this.strVssEmu[i][0], 16);
                if (iEmu != iData) continue;
                rtn = this.strVssEmu[i][1];
            }
        }
        return rtn;
    }

    public String toDispStringVssSsid(SJmoHUVMVirtualLdev ldev) {
        String rtn = "?";
        if (ldev != null) {
            if ((ldev.getSVAttrHuvm() & Short.MIN_VALUE) == 0) {
                return "";
            }
            rtn = ldev.getSVInfflag() == 1 ? SJctrComUtility.toHexString(ldev.getIVSsid(), 4, true) : "";
        }
        return rtn;
    }

    public String toDispStringVssAttribute(SJmoHUVMVirtualLdev ldev) {
        String rtn = "?";
        if (ldev != null) {
            rtn = "";
            if ((ldev.getSVAttrHuvm() & Short.MIN_VALUE) == 0) {
                return rtn;
            }
            if ((ldev.getSVAttrHuvm() & 0x2000) > 0) {
                rtn = this.guidanceHandle.getGuidance("HA_RESERVED");
            }
        }
        return rtn;
    }

    public String toDispStringVssHUVMMode(SJmoHUVMVirtualLdev ldev) {
        String rtn = "?";
        if (ldev != null) {
            rtn = (ldev.getSVAttrHuvm() & Short.MIN_VALUE) != 0 ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return rtn;
    }

    public static List getTargetVssLdevList(Object index, Map<Class<?>, List<?>> basicData) {
        int vssLdevIndex;
        ArrayList<SJmoHUVMVirtualLdev> rtn = new ArrayList<SJmoHUVMVirtualLdev>();
        List<?> vssLdevList = basicData.get(SJmoGetHUVMVirtualLdev.class);
        if (vssLdevList != null && (vssLdevIndex = Collections.binarySearch(vssLdevList, index)) >= 0) {
            SJmoHUVMVirtualLdev VssLdev = (SJmoHUVMVirtualLdev)vssLdevList.get(vssLdevIndex);
            rtn.add(VssLdev);
        }
        return rtn;
    }

    public static boolean isVirtualLdevIdListNotReserve(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevIdListNotReserve", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean isReserve = SJctrRsgUtility.isVirtualLdevIdReserve(checkLdev.getVLDEV());
            if (isReserve) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isVirtualLdevInfoListSet(List<SJctrRsgLdevInfo> ldevInfoList) {
        SJctrRsgLdevInfo checkLdev;
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevInfoListSet", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Iterator<SJctrRsgLdevInfo> i$ = ldevInfoList.iterator();
        while (i$.hasNext() && !(result = SJctrRsgUtility.isVirtualLdevInfoSet((checkLdev = i$.next()).getVLDEV()))) {
        }
        return result;
    }

    public static boolean isVirtualLdevInfoSet(SJmoHUVMVirtualLdev ldevInfo) {
        boolean result = false;
        if (null == ldevInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevInfoSet", "ldevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        short vInfflag = ldevInfo.getSVInfflag();
        if (vInfflag == 1) {
            result = true;
        }
        return result;
    }

    public static boolean isVirtualLdevInfoListNotSet(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevInfoListNotSet", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean isSet = SJctrRsgUtility.isVirtualLdevInfoSet(checkLdev.getVLDEV());
            if (isSet) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isVirtualLdevIdListNotSameLdevId(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevIdListNotSameLdevId", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean sameLdevId = SJctrRsgUtility.isVirtualLdevIdSameLdevId(checkLdev.getVLDEV());
            if (sameLdevId) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isVirtualLdevIdListSameLdevId(List<SJctrRsgLdevInfo> ldevInfoList) {
        SJctrRsgLdevInfo checkLdev;
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevIdListSameLdevId", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Iterator<SJctrRsgLdevInfo> i$ = ldevInfoList.iterator();
        while (i$.hasNext() && !(result = SJctrRsgUtility.isVirtualLdevIdSameLdevId((checkLdev = i$.next()).getVLDEV()))) {
        }
        return result;
    }

    public static boolean isVirtualLdevIdSameLdevId(SJmoHUVMVirtualLdev ldevInfo) {
        boolean result = false;
        if (null == ldevInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isVirtualLdevIdSameLdevId", "ldevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoLdevIndex virtualLdev = ldevInfo.getVirtualLdev();
        if (virtualLdev.getIndex() == ldevInfo.getIndex()) {
            result = true;
        }
        return result;
    }

    public static boolean isIncludeQuorumDisk(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isIncludeQuorumDisk", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean quorum;
            if (!checkLdev.isExist() || !(quorum = checkLdev.getBLockVolume())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isIncludeJournalVolume(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isIncludeJournalVolume", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean jnl;
            if (!checkLdev.isExist() || !(jnl = checkLdev.getbJNLVolume())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isIncludeMigrationVolume(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isIncludeMigrationVolume", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean migration;
            if (!checkLdev.isExist() || !(migration = checkLdev.getbOdmVol())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isIncludeMFVolume(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isIncludeMFVolume", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean mf;
            if (!checkLdev.isExist() || !(mf = checkLdev.getbMfVolume())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isIncludeMiddleVolume(List<SJctrRsgLdevInfo> ldevInfoList) {
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isIncludeMiddleVolume", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJctrRsgLdevInfo checkLdev : ldevInfoList) {
            boolean middle;
            if (!checkLdev.isExist() || !(middle = checkLdev.getbMiddleVolume())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isVdkcNumberListNotZero(List<SJctrRsgLdevInfo> ldevInfoList) {
        SJctrRsgLdevInfo checkLdev;
        boolean result = false;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "isVdkcNumberListNotZero", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        Iterator<SJctrRsgLdevInfo> i$ = ldevInfoList.iterator();
        while (i$.hasNext() && !(result = SJctrRsgUtility.isVdkcNumberNotZero((checkLdev = i$.next()).getVLDEV()))) {
        }
        return result;
    }

    public static boolean isVdkcNumberNotZero(SJmoHUVMVirtualLdev ldevInfo) {
        boolean result = false;
        if (null == ldevInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isVdkcNumberNotZero", "ldevInfo is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        int vbox = ldevInfo.getVBoxIndex().getIVboxId();
        if (vbox != 0) {
            result = true;
        }
        return result;
    }

    public static int checkOperationHuvmOn(List<SJctrRsgLdevInfo> ldevInfoList, SJctrLicenseContainer lc) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationHuvmOn", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (null == lc) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationHuvmOn", "lc is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isLicense = lc.checkPP(SJctrLicenseContainer.PPID_RSG);
        if (!isLicense) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationHuvmOn", "license is not enable.");
            result = 65536;
            return result;
        }
        boolean isMf = SJctrRsgUtility.isIncludeMFVolume(ldevInfoList);
        if (isMf) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationHuvmOn", "ldevInfoList include mf Volume.");
            result = 16384;
            return result;
        }
        boolean isMiddle = SJctrRsgUtility.isIncludeMiddleVolume(ldevInfoList);
        if (isMiddle) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationHuvmOn", "ldevInfoList include middle Volume.");
            result = 32768;
            return result;
        }
        boolean isMapLunPath = SJctrRsgUtility.isMappingLuPath(ldevInfoList);
        if (isMapLunPath) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationHuvmOn", "ldevInfoList include lun path mapping.");
            result = 32;
            return result;
        }
        boolean isMigration = SJctrRsgUtility.isIncludeMigrationVolume(ldevInfoList);
        if (isMigration) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationHuvmOn", "ldevInfoList include migration volume.");
            result = 16;
            return result;
        }
        boolean isJournal = SJctrRsgUtility.isIncludeJournalVolume(ldevInfoList);
        if (isJournal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationHuvmOn", "ldevInfoList include journal volume.");
            result = 8;
            return result;
        }
        boolean isQuorum = SJctrRsgUtility.isIncludeQuorumDisk(ldevInfoList);
        if (isQuorum) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationHuvmOn", "ldevInfoList include quorum disk.");
            result = 4;
            return result;
        }
        return result;
    }

    public static int checkOperationHuvmOff(List<SJctrRsgLdevInfo> ldevInfoList) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationHuvmOff", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isNotNormal = SJctrRsgUtility.isVirtualLdevIdListNotNormal(ldevInfoList);
        if (isNotNormal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationHuvmOff", "ldevInfoList include attr is not normal.");
            result = 64;
            return result;
        }
        return result;
    }

    public static int checkOperationVirtualLdevIdReserveHuvmOff(List<SJctrRsgLdevInfo> ldevInfoList) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationVirtualLdevIdReserveHuvmOff", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isNotNormal = SJctrRsgUtility.isVirtualLdevIdListNotNormal(ldevInfoList);
        if (isNotNormal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdReserveHuvmOff", "ldevInfoList include attr is not normal.");
            result = 64;
            return result;
        }
        return result;
    }

    public static int checkOperationVirtualLdevIdReserveVirtualLdevInfoSet(List<SJctrRsgLdevInfo> ldevInfoList) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationVirtualLdevIdReserveVirtualLdevInfoSet", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isNotNormal = SJctrRsgUtility.isVirtualLdevIdListNotNormal(ldevInfoList);
        if (isNotNormal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdReserveVirtualLdevInfoSet", "ldevInfoList include attr is not normal.");
            result = 64;
            return result;
        }
        return result;
    }

    public static int checkOperationVirtualLdevIdReleaseVirtualLdevInfoRemove(List<SJctrRsgLdevInfo> ldevInfoList) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationVirtualLdevIdReleaseVirtualLdevInfoRemove", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isMapLunPath = SJctrRsgUtility.isMappingLuPath(ldevInfoList);
        if (isMapLunPath) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdReleaseVirtualLdevInfoRemove", "ldevInfoList include lun path mapping.");
            result = 32;
            return result;
        }
        boolean isMigration = SJctrRsgUtility.isIncludeMigrationVolume(ldevInfoList);
        if (isMigration) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdReleaseVirtualLdevInfoRemove", "ldevInfoList include migration volume.");
            result = 16;
            return result;
        }
        boolean isJournal = SJctrRsgUtility.isIncludeJournalVolume(ldevInfoList);
        if (isJournal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdReleaseVirtualLdevInfoRemove", "ldevInfoList include journal volume.");
            result = 8;
            return result;
        }
        boolean isQuorum = SJctrRsgUtility.isIncludeQuorumDisk(ldevInfoList);
        if (isQuorum) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdReleaseVirtualLdevInfoRemove", "ldevInfoList include quorum disk.");
            result = 4;
            return result;
        }
        return result;
    }

    public static int checkOperationVirtualLdevIdReserve(List<SJctrRsgLdevInfo> ldevInfoList) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationVirtualLdevIdReserve", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isNotNormal = SJctrRsgUtility.isVirtualLdevIdListNotNormal(ldevInfoList);
        if (isNotNormal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdReserve", "ldevInfoList include attr is not normal.");
            result = 64;
            return result;
        }
        return result;
    }

    public static int checkOperationVirtualLdevIdRelease(List<SJctrRsgLdevInfo> ldevInfoList) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationVirtualLdevIdRelease", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isMapLunPath = SJctrRsgUtility.isMappingLuPath(ldevInfoList);
        if (isMapLunPath) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdRelease", "ldevInfoList include lun path mapping.");
            result = 32;
            return result;
        }
        boolean isMigration = SJctrRsgUtility.isIncludeMigrationVolume(ldevInfoList);
        if (isMigration) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdRelease", "ldevInfoList include migration volume.");
            result = 16;
            return result;
        }
        boolean isJournal = SJctrRsgUtility.isIncludeJournalVolume(ldevInfoList);
        if (isJournal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdRelease", "ldevInfoList include journal volume.");
            result = 8;
            return result;
        }
        boolean isQuorum = SJctrRsgUtility.isIncludeQuorumDisk(ldevInfoList);
        if (isQuorum) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevIdRelease", "ldevInfoList include quorum disk.");
            result = 4;
            return result;
        }
        return result;
    }

    public static int checkOperationVirtualLdevInfoSet(List<SJctrRsgLdevInfo> ldevInfoList) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationVirtualLdevInfoSet", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isNotNormal = SJctrRsgUtility.isVirtualLdevIdListNotNormal(ldevInfoList);
        if (isNotNormal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevInfoSet", "ldevInfoList include attr is not normal.");
            result = 64;
            return result;
        }
        boolean isMapLunPath = SJctrRsgUtility.isMappingLuPath(ldevInfoList);
        if (isMapLunPath) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevInfoSet", "ldevInfoList include lun path mapping.");
            result = 32;
            return result;
        }
        return result;
    }

    public static int checkOperationVirtualLdevInfoRemove(List<SJctrRsgLdevInfo> ldevInfoList) {
        int result = 0;
        if (null == ldevInfoList) {
            SJctrLogUty.error("SJctrRsgUtility", "checkOperationVirtualLdevInfoRemove", "ldevInfoList is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean isMapLunPath = SJctrRsgUtility.isMappingLuPath(ldevInfoList);
        if (isMapLunPath) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevInfoRemove", "ldevInfoList include lun path mapping.");
            result = 32;
            return result;
        }
        boolean isMigration = SJctrRsgUtility.isIncludeMigrationVolume(ldevInfoList);
        if (isMigration) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevInfoRemove", "ldevInfoList include migration volume.");
            result = 16;
            return result;
        }
        boolean isJournal = SJctrRsgUtility.isIncludeJournalVolume(ldevInfoList);
        if (isJournal) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevInfoRemove", "ldevInfoList include journal volume.");
            result = 8;
            return result;
        }
        boolean isQuorum = SJctrRsgUtility.isIncludeQuorumDisk(ldevInfoList);
        if (isQuorum) {
            SJctrLogUty.info("SJctrRsgUtility", "checkOperationVirtualLdevInfoRemove", "ldevInfoList include quorum disk.");
            result = 4;
            return result;
        }
        return result;
    }

    public static Set<Integer> createUseVLdevIndexListVdkc(SJctrDataController dc, SJmoHUVMvboxIndex vBoxIndex) {
        if (dc == null || vBoxIndex == null) {
            SJctrLogUty.error("SJctrRsgUtility", "createUseVLdevIndexList", "Argument is null.");
            SJctrError err = new SJctrError(207, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        HashSet<Integer> LdevIndexList = new HashSet<Integer>();
        List<SJmoHUVMVirtualLdev> vLdevList = SJctrRsgUtility.getSJmoHUVMVirtualLdev(dc);
        for (SJmoHUVMVirtualLdev vLdev : vLdevList) {
            if (vBoxIndex.getIVboxId() != vLdev.getVBoxIndex().getIVboxId() || !SJctrRsgUtility.isVirtualLdevIdReserve(vLdev)) continue;
            LdevIndexList.add(vLdev.getVirtualLdev().getIndex());
        }
        return LdevIndexList;
    }

    public static void setFinishChangeCheck(SJctrDataController dc, boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer;
        if (null != dc && null != (footer = (SJctrFooterDataModel)dc.getDataObjectModel("COM_FOOTER")) && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    public String toDispStringVssLdevIdTransient(SJmoHUVMVirtualLdev vLdev, SJctrLdevUtility ldevUtl, SJmoHAPairVolInfoMgr haPairMgr) {
        String rtn = "?:?:?";
        if (vLdev != null && ldevUtl != null && haPairMgr != null) {
            if (vLdev.isValidIndexVirtualLdev()) {
                rtn = ldevUtl.toLdevDisplay(vLdev.getVirtualLdev());
                if (SJctrRsgUtility.isVirtualLdevHuvmOn(vLdev) && !SJctrRsgUtility.isVdkcNumberNotZero(vLdev) && SJctrRsgUtility.isVirtualLdevIdSameLdevId(vLdev) && haPairMgr.getHAPairVolInfo(vLdev.getIndex()) == null) {
                    rtn = rtn + "(" + this.guidanceHandle.getGuidance("TRANSIENT") + ")";
                }
            } else {
                rtn = "";
            }
        }
        return rtn;
    }

    public static int getLeadTime(int applySize, double progressUnit, double progressTime) {
        int ret = 1;
        if (progressTime <= 0.0) {
            return ret;
        }
        if (progressUnit <= 0.0 || applySize <= 0) {
            ret = (int)Math.ceil(progressTime / 1000.0);
            return ret;
        }
        double unitNum = Math.ceil((double)applySize / progressUnit);
        ret = (int)Math.ceil(unitNum * progressTime / 1000.0);
        return ret;
    }

    public static boolean isSysRsg(SJmoRSGInfo rsgInfo) {
        if (null == rsgInfo) {
            SJctrLogUty.error("SJctrRsgUtility", "isSysRsg", "rsgInfo is null.");
            throw SJctrRsgUtility.makeException(107001);
        }
        boolean ret = false;
        String rsgName = rsgInfo.getRsgName();
        int rsgId = rsgInfo.getRsgId();
        if (rsgId == 1023 && rsgName.equals("NAS_Platform_System_RSG")) {
            ret = true;
        }
        return ret;
    }

    public static SJcException makeException(int errCode) {
        return SJctrRsgUtility.makeError(errCode).createException();
    }

    public static SJctrError makeError(int errCode) {
        SJctrError err = new SJctrError(207, 22, errCode);
        return err;
    }
}

