/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.common.Robj_interface_HIHsmManualPlanProgress2;
import sanproject.common.Robj_interface_HIHsmManualPlanProgress2_OUT;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.arg.monitor.HIHsmManualPlanProgressArgInfoEx;
import sanproject.serverux.arg.monitor.HIHsmMigrationHistoryArgInfoEx;
import sanproject.serverux.data.HIHsmMigrationHistoryEx;
import sanproject.serverux.dataimpl.HIHsmManualPlanProgress2_IN;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrCapacityColumnFromLdevDetail;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.comparator.SJctrScatteredComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.topwindow.port.hostgroup.lun.SJctrLUNsTableModel;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrGetMigrationHistoryInfo;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrGetMigrationPlanInfo;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrGetMigrationPlanInfoHUVM;
import sanproject.sn2.controller.wizard.volumemigration.com.SJctrVMPlanBasicData;
import sanproject.sn2.controller.wizard.volumemigration.histories.SJctrVMHistoryInfo;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrAvailableSourceVolsData;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrAvailableTargetVolsData;
import sanproject.sn2.controller.wizard.volumemigration.migratevolumes.SJctrVMProvTypeStringWrapper;
import sanproject.sn2.controller.wizard.volumemigration.migrationplans.SJctrMigrationPlanInfo;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;

public class SJctrVolumeMigrationUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public SJctrVolumeMigrationUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public static Robj_interface_HIHsmManualPlanProgress2_OUT getMigPlanInfoNotUsedCache(SJctrDataController dc) throws SJcException {
        SJctrLogUty.info("SJctrVolumeMigrationUtility", "getMigPlanInfoNotUsedCache", "MigrationPlan Get Start.");
        HashSet<SJctrGetDirectWrapper> wrapperSet = new HashSet<SJctrGetDirectWrapper>();
        SJctrGetDirectWrapper dirWrapper = SJctrVolumeMigrationUtility.createMigPlanGetInputHUVM();
        dirWrapper.setCacheMode(false);
        wrapperSet.add(dirWrapper);
        Map<SJctrGetDirectWrapper, List<?>> dataMap = dc.getProxy().getDataInf(wrapperSet);
        List<?> rmiDataList = dataMap.get(dirWrapper);
        if (rmiDataList == null) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", "getMigPlanInfoNotUsedCache", "Plan Data List null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (rmiDataList.isEmpty()) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", "getMigPlanInfoNotUsedCache", "PlanData List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)rmiDataList.get(0);
        if (rmiData == null) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", "getMigPlanInfoNotUsedCache", "Model ThroughData null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        Robj_interface_HIHsmManualPlanProgress2_OUT rmiOut = (Robj_interface_HIHsmManualPlanProgress2_OUT)rmiData.getObjRmi();
        if (rmiOut == null) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", "getMigPlanInfoNotUsedCache", "rmi Output Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJctrLogUty.info("SJctrVolumeMigrationUtility", "getMigPlanInfoNotUsedCache", "MigrationPlan Get End.");
        return rmiOut;
    }

    public static HIHsmMigrationHistoryEx getHistoryInfoNotUsedCache(SJctrDataController dc, int iFrom, int iTo) throws SJcException {
        SJctrLogUty.info("SJctrVolumeMigrationUtility", "getHistoryInfoNotUsedCache", "HistoryInfo Get Start.");
        HashSet<SJctrGetDirectWrapper> wrapperSet = new HashSet<SJctrGetDirectWrapper>();
        SJctrGetDirectWrapper dirWrapper = SJctrVolumeMigrationUtility.createHistGetInput(iFrom, iTo);
        dirWrapper.setCacheMode(false);
        wrapperSet.add(dirWrapper);
        Map<SJctrGetDirectWrapper, List<?>> dataMap = dc.getProxy().getDataInf(wrapperSet);
        List<?> rmiDataList = dataMap.get(dirWrapper);
        if (rmiDataList == null) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", "getHistoryInfoNotUsedCache", "HistData List null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (rmiDataList.isEmpty()) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", "getHistoryInfoNotUsedCache", "HistData List size 0");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)rmiDataList.get(0);
        if (rmiData == null) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", "getHistoryInfoNotUsedCache", "Model ThroughData null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        HIHsmMigrationHistoryEx rmiOut = (HIHsmMigrationHistoryEx)rmiData.getObjRmi();
        if (rmiOut == null) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", "getHistoryInfoNotUsedCache", "rmi Output Data null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        SJctrLogUty.info("SJctrVolumeMigrationUtility", "getMigPlanInfoNotUsedCache", "MigrationPlan Get End.");
        return rmiOut;
    }

    public static SJctrGetDirectWrapper createMigPlanGetInput() {
        HIHsmManualPlanProgressArgInfoEx rmiInput = new HIHsmManualPlanProgressArgInfoEx(-1);
        SJctrGetMigrationPlanInfo getKind = new SJctrGetMigrationPlanInfo(rmiInput);
        SJmoGetDirect getDirect = new SJmoGetDirect(getKind, null, null);
        SJctrGetDirectWrapper dirWrapper = new SJctrGetDirectWrapper(getDirect);
        return dirWrapper;
    }

    public static SJctrGetDirectWrapper createMigPlanGetInputHUVM() {
        HIHsmManualPlanProgress2_IN rmiInput = new HIHsmManualPlanProgress2_IN();
        rmiInput.setOwnerID(-1);
        SJctrGetMigrationPlanInfoHUVM getKind = new SJctrGetMigrationPlanInfoHUVM(rmiInput);
        SJmoGetDirect getDirect = new SJmoGetDirect(getKind, null, null);
        SJctrGetDirectWrapper dirWrapper = new SJctrGetDirectWrapper(getDirect);
        return dirWrapper;
    }

    public static SJctrGetDirectWrapper createHistGetInput(int iFrom, int iTo) {
        int iMaxIndex = 16384;
        if (iTo > iFrom + --iMaxIndex) {
            SJctrLogUty.info("SJctrVolumeMigrationUtility", " createHistGetInput", "From = " + iFrom + "To = " + iTo + " iTo correct");
            iTo = iFrom + iMaxIndex;
        }
        HIHsmMigrationHistoryArgInfoEx rmiInput = new HIHsmMigrationHistoryArgInfoEx();
        rmiInput.setFrom(iFrom);
        rmiInput.setTo(iTo);
        SJctrGetMigrationHistoryInfo getKind = new SJctrGetMigrationHistoryInfo(rmiInput);
        SJmoGetDirect getDirect = new SJmoGetDirect(getKind, null, null);
        SJctrGetDirectWrapper dirWrapper = new SJctrGetDirectWrapper(getDirect);
        return dirWrapper;
    }

    public static Map<SJctrGetDirectWrapper, List<?>> getModelInfoNotUsedCache(SJctrDataController dc, SJmoGetKind_IF[] getKindList) {
        SJctrLogUty.info("SJctrVolumeMigrationUtility", "getModelInfoNotUsedCache", "ModelData Get Start.");
        HashSet<SJctrGetDirectWrapper> wrapperSet = new HashSet<SJctrGetDirectWrapper>();
        for (SJmoGetKind_IF getKind : getKindList) {
            SJmoGetDirect getDirect = new SJmoGetDirect(getKind, null, null);
            SJctrGetDirectWrapper dirWrapper = new SJctrGetDirectWrapper(getDirect);
            dirWrapper.setCacheMode(false);
            wrapperSet.add(dirWrapper);
        }
        Map<SJctrGetDirectWrapper, List<?>> dataMap = dc.getProxy().getDataInf(wrapperSet);
        SJctrLogUty.info("SJctrVolumeMigrationUtility", "getModelInfoNotUsedCache", "MigrationPlan Get End.");
        return dataMap;
    }

    public static SJcException makeVMCtrlErrInfo(int iError) {
        return new SJctrError(52, 22, iError).createException();
    }

    public static SJctrResourceGroupUtility makeRsgUtil(SJctrDataController dc, SJmoRSGgetAllRsgs rsgInfo) {
        return new SJctrResourceGroupUtility(dc.getOwner(), rsgInfo);
    }

    public static List<SJmoLdevIndex> getAvailableRsgLdevList(SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoLdevIndex> availableLdevList = new ArrayList<SJmoLdevIndex>();
        if (rsgUtil != null) {
            List<SJmoRSGgetRsg> availableRsgList = rsgUtil.extractRsg();
            for (SJmoRSGgetRsg rsgInfo : availableRsgList) {
                availableLdevList.addAll(rsgInfo.getLdevs());
            }
            Collections.sort(availableLdevList);
        } else {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", "getAvailableRsgLdevList", "RsgUtil = null");
        }
        return availableLdevList;
    }

    public static boolean chkLdevRsgGrp(SJmoLdevIndex sourceLdev, SJmoLdevIndex targetLdev, List<SJmoLdevIndex> availableLdevList) {
        return SJctrVolumeMigrationUtility.chkLdevRsgGrp(sourceLdev, availableLdevList) & SJctrVolumeMigrationUtility.chkLdevRsgGrp(targetLdev, availableLdevList);
    }

    public static boolean chkLdevRsgGrp(SJmoLdevIndex chkLdev, List<SJmoLdevIndex> availableLdevList) {
        boolean bRet = false;
        int iPoint = Collections.binarySearch(availableLdevList, chkLdev);
        if (iPoint >= 0) {
            bRet = true;
        }
        return bRet;
    }

    public static SJcException makeErrInfTable(SJctrRelatedDispDataObject relObj, SJctrUserController userDC, SJctrTableDataModel tblModel, List<SJctrErrorColumnData> errList) {
        SJctrErrorDataController errDC = (SJctrErrorDataController)userDC.getDataController(relObj);
        SJctrLdevIndexComparator comp = null;
        if (tblModel instanceof SJctrLUNsTableModel) {
            comp = new SJctrLdevIndexComparator();
        }
        if (comp == null) {
            errDC.setParameter(tblModel, errList);
        } else {
            errDC.setParameter(tblModel, errList, comp);
        }
        SJctrError topErr = errDC.getRepresentativeError(errList, 5);
        SJcException tblErr = topErr.createException();
        tblErr.setErrDisp(relObj);
        return tblErr;
    }

    public static boolean chkMigrationSetNum(int iSetNum) {
        boolean bRet = true;
        if (iSetNum > 8) {
            bRet = false;
        }
        return bRet;
    }

    public static SJctrErrorColumnData makeVMCtrlErrColumnData(int iErrorCode, Object keyObj) {
        SJctrError errInfo = new SJctrError(52, 22, iErrorCode);
        return new SJctrErrorColumnData((Comparable)keyObj, errInfo);
    }

    public static int getHistFromIndex(int iPageNum) {
        int iMaxIndex = 16384;
        return SJctrVolumeMigrationUtility.getHistToIndex(iPageNum) - --iMaxIndex;
    }

    public static int getHistToIndex(int iPageNum) {
        return iPageNum * 16384;
    }

    public static SJcMessage getMsgObject(int iError) {
        return new SJcMessage(Integer.toString(52), Integer.toString(22), Integer.toString(iError));
    }

    public String toHistoryActionDisplay(SJctrVMHistoryInfo histInfo) {
        String strRet = "?";
        if (histInfo == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toHistoryActionDisplay", "History Data = null");
            return strRet;
        }
        switch (histInfo.getIAction()) {
            case 1: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_STARTED");
                break;
            }
            case 2: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_COMPLETED");
                break;
            }
            case 3: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_CANCEL_USER");
                break;
            }
            case 4: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_FAILED");
                break;
            }
            case 5: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_CANCEL_CONTROLLER");
                break;
            }
            case 6: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_CANCEL_SI");
                break;
            }
            case 7: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_CANCEL_TC");
                break;
            }
            case 9: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_CANCEL_UR");
                break;
            }
            case 10: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_CANCEL_XRC");
                break;
            }
            case 11: {
                strRet = this.guidanceHandle.getGuidance("ACTION_MIG_CANCEL_CC");
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toHistoryActionDisplay", "Action value invalid: " + histInfo.getIAction());
            }
        }
        return strRet;
    }

    public String toOwnerDisplay(SJctrVMPlanBasicData planData) {
        StringBuffer strRet = new StringBuffer();
        if (planData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toOwnerDisplay", "Plan Data = null");
            return strRet.append("?").toString();
        }
        switch (planData.getIOwner()) {
            case 0: {
                strRet.append(this.guidanceHandle.getGuidance("OWNER_OWN"));
                break;
            }
            case 1: {
                strRet.append(this.guidanceHandle.getGuidance("OWNER_RM"));
                break;
            }
            case 255: {
                strRet.append(this.guidanceHandle.getGuidance("OWNER_HCS"));
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toOwnerDisplay", "OwnerID invalid:" + planData.getIOwner());
                strRet.append("?");
            }
        }
        return strRet.toString();
    }

    public String toMigrationTypeDisplay(SJctrVMPlanBasicData planData) {
        StringBuffer strRet = new StringBuffer();
        if (planData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toMigrationTypeDisplay", "Plan Data = null");
            return strRet.append("?").toString();
        }
        if (planData.isHUVM()) {
            strRet.append(this.guidanceHandle.getGuidance("MIGTYPE_HUVM"));
        } else {
            strRet.append(this.guidanceHandle.getGuidance("MIGTYPE_NORMAL"));
        }
        return strRet.toString();
    }

    public String toMigrationStatusDisplay(SJctrMigrationPlanInfo planData) {
        String strRet = "?";
        if (planData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toMigrationStatusDisplay", "Plan Data = null");
            return strRet;
        }
        switch (planData.getIStatus()) {
            case 1: {
                strRet = this.guidanceHandle.getGuidance("MIGRATION_STAT_SIMPLEX");
                break;
            }
            case 2: {
                strRet = this.guidanceHandle.getGuidance("MIGRATION_STAT_SUSPEND");
                break;
            }
            case 3: {
                strRet = this.guidanceHandle.getGuidance("MIGRATION_STAT_RUN");
                break;
            }
            case 4: {
                strRet = this.guidanceHandle.getGuidance("MIGRATION_STAT_SPLIT");
                break;
            }
            default: {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toMigrationStatusDisplay", "Status value invalid: " + planData.getIStatus());
            }
        }
        return strRet;
    }

    public String toMigrationProgressDisplay(SJctrMigrationPlanInfo planData) {
        String strRet = "?";
        if (planData == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toMigrationProgressDisplay", "Plan Data = null");
            return strRet;
        }
        if (0 <= planData.getIProgress() && 100 >= planData.getIProgress()) {
            strRet = Integer.toString(planData.getIProgress());
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toMigrationProgressDisplay", "Progress invalid:" + planData.getIProgress());
        }
        return strRet;
    }

    public static List<SJctrMigrationPlanInfo> makePlanDataList(Robj_interface_HIHsmManualPlanProgress2_OUT rmiPlanData) {
        ArrayList<SJctrMigrationPlanInfo> migPlanDataList = new ArrayList<SJctrMigrationPlanInfo>();
        Robj_interface_HIHsmManualPlanProgress2[] rmiPlan = rmiPlanData.getPlans();
        for (int iCnt = 0; iCnt < rmiPlan.length; ++iCnt) {
            SJmoLdevIndex srcLdev = new SJmoLdevIndex();
            SJmoLdevIndex targetLdev = new SJmoLdevIndex();
            Robj_interface_RJiLDEVIndex srcTmp = rmiPlan[iCnt].getSourceRJiLDEVIndex();
            Robj_interface_RJiLDEVIndex targetTmp = rmiPlan[iCnt].getTargetRJiLDEVIndex();
            srcLdev.setLdevIndex(srcTmp.getSLDKC(), srcTmp.getSCU(), srcTmp.getSLDEV());
            targetLdev.setLdevIndex(targetTmp.getSLDKC(), targetTmp.getSCU(), targetTmp.getSLDEV());
            SJctrMigrationPlanInfo planInfo = new SJctrMigrationPlanInfo(srcLdev, targetLdev, rmiPlan[iCnt].getOwnerID(), rmiPlan[iCnt].isHUVM(), rmiPlan[iCnt].getProgress(), rmiPlan[iCnt].getStatus());
            migPlanDataList.add(planInfo);
        }
        Collections.sort(migPlanDataList);
        return migPlanDataList;
    }

    public static String getStrEmuCapaKey(SJmoLdevDetail keyData, SJctrComUtility comUtil) {
        StringBuffer strKey = new StringBuffer();
        strKey.append(comUtil.getCVSUtility().getEmulationTypeName(keyData.getIEmulationType()));
        strKey.append(Long.toString(keyData.getLLDEVLBASize()));
        strKey.append(Boolean.toString(keyData.getBT10pi()));
        return strKey.toString();
    }

    public static String getProvisoningTypeDispString(SJmoLdevDetail ldev, SJctrComUtility comUtil) {
        StringBuffer strRet = new StringBuffer();
        if (ldev == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", "getProvisoningTypeDispString", "LDEV Detail = null");
            return strRet.append("?").toString();
        }
        if (comUtil == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", "getProvisoningTypeDispString", "comUtil = null");
            return strRet.append("?").toString();
        }
        switch (ldev.getByVolumeType()) {
            case 0: {
                strRet.append(comUtil.getGuidance("BASIC"));
                strRet.append(":");
                strRet.append(" ");
                strRet.append(comUtil.getLdevUtility().toArrayGroupDisplay(ldev));
                break;
            }
            case 1: {
                strRet.append(comUtil.getGuidance("EXTERNAL"));
                strRet.append(":");
                strRet.append(" ");
                strRet.append(comUtil.getLdevUtility().toArrayGroupDisplay(ldev));
                break;
            }
            case 3: {
                strRet.append(comUtil.getGuidance("THP"));
                break;
            }
            case 4: {
                strRet.append(comUtil.getGuidance("EXTERNAL_MF_VOL"));
                strRet.append(":");
                strRet.append(" ");
                strRet.append(comUtil.getLdevUtility().toArrayGroupDisplay(ldev));
                break;
            }
            default: {
                SJctrLogUty.warn("SJctrVolumeMigrationUtility", "getProvisoningTypeDispString", "VolType invalid:" + ldev.getByVolumeType());
                strRet.append("?").toString();
            }
        }
        return strRet.toString();
    }

    public static List<SJmoLdevDetail> getAvailableDpVolList(Map<String, Object> ldevMap) {
        ArrayList<SJmoLdevDetail> ldevList = new ArrayList<SJmoLdevDetail>();
        if (ldevMap == null) {
            return ldevList;
        }
        if (ldevMap.isEmpty()) {
            return ldevList;
        }
        Set<String> keySet = ldevMap.keySet();
        for (String strKey : keySet) {
            List tmpLdevList = (List)ldevMap.get(strKey);
            for (SJmoLdevDetail ldev : tmpLdevList) {
                int iPoint = Collections.binarySearch(ldevList, ldev);
                if (iPoint >= 0) continue;
                iPoint = -iPoint - 1;
                ldevList.add(iPoint, ldev);
            }
        }
        return ldevList;
    }

    public long getAddSrcVolLdevPages(SJmoLdevDetail srcVolLdev, SJmoLdevDetail targetVolLdev, SJmoPoolDetail targetPoolDetail, List<SJmoHDPRelation> allDpVolList, SJctrComUtility comUtil) {
        if (srcVolLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddSrcVolLdevPages", " srcVolLdev null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (targetVolLdev == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddSrcVolLdevPages", " targetVolLdev null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (targetPoolDetail == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddSrcVolLdevPages", "targetPoolDetail null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (allDpVolList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddSrcVolLdevPages", "allDpVolList null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (comUtil == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddSrcVolLdevPages", "comUtil null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        long lPageSize = targetPoolDetail.getPageSize();
        long lSrcLdevPage = 0L;
        if (srcVolLdev.getByVolumeType() == 3) {
            int iPoint = Collections.binarySearch(allDpVolList, srcVolLdev);
            if (iPoint < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddLdevPages", "relation Noting");
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            }
            SJmoHDPRelation dpVol = allDpVolList.get(iPoint);
            lSrcLdevPage = dpVol.getLUsedpage();
        } else {
            lSrcLdevPage = SJctrComCVSUtility.getAddLdevPages(srcVolLdev, lPageSize, comUtil, true);
        }
        if (targetVolLdev.getByVolumeType() == 3) {
            int iTrgPoint = Collections.binarySearch(allDpVolList, targetVolLdev);
            if (iTrgPoint < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddLdevPages", "relation TargetLdev Noting");
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            }
            SJmoHDPRelation targetDpVol = allDpVolList.get(iTrgPoint);
            if ((targetDpVol.getLSwapControlFlg() & 0x10000000L) != 0L) {
                lSrcLdevPage = 0L;
            } else {
                long offsetCapa = SJctrVolumeMigrationUtility.getOffsetCapa(targetDpVol, lSrcLdevPage, comUtil);
                lSrcLdevPage -= offsetCapa;
            }
        }
        return lSrcLdevPage;
    }

    public static double getDPoolUsedPercent(SJmoPoolDetail poolDtl) {
        double dPoolUsedPercent = 0.0;
        if ((double)poolDtl.getPoolPages() != 0.0) {
            dPoolUsedPercent = ((double)poolDtl.getPoolUsedPages() + (double)poolDtl.getLPoolReservedPages()) / (double)poolDtl.getPoolPages();
        }
        return dPoolUsedPercent *= 100.0;
    }

    public static SJmoPoolDetail findHDPRelationData(List<SJmoHDPRelation> dpvolList, List<SJmoPoolDetail> poolDetaillList, SJmoLdevDetail ldevDetail) {
        int poolDetailIndex;
        SJmoPoolDetail poolDetailData = null;
        int dpVolDetailIndex = Collections.binarySearch(dpvolList, ldevDetail);
        if (0 <= dpVolDetailIndex) {
            SJmoHDPRelation hdpRelData = dpvolList.get(dpVolDetailIndex);
            int iPoolID = hdpRelData.getIPoolId();
            SJmoPoolIndex compPoolIdx = new SJmoPoolIndex();
            compPoolIdx.setPoolId(iPoolID);
            poolDetailIndex = Collections.binarySearch(poolDetaillList, compPoolIdx);
            if (poolDetailIndex < 0) {
                SJctrLogUty.warn("SJctrVolumeMigrationUtility", " findHDPRelationData ", "poolDetailIndex relation Noting");
                throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
            }
        } else {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", " findHDPRelationData ", "dpVolDetailIndex relation Noting");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        poolDetailData = poolDetaillList.get(poolDetailIndex);
        return poolDetailData;
    }

    public static int createLdevIndex(int iLDKC, int iCU, int iLDEV) {
        int iLdevIndex = -1;
        iLdevIndex = iLDKC << 16 | iCU << 8 | iLDEV;
        return iLdevIndex;
    }

    public static ArrayList createComboBoxData(SJmoLdevDetail selectSourceVolume, SJctrAvailableTargetVolsData targetVolData, List<SJctrVMProvTypeStringWrapper> comboDispList) {
        HashMap<String, Object> targetMap;
        ArrayList<String> dispList = new ArrayList<String>();
        if (selectSourceVolume != null && !(targetMap = targetVolData.getAvailableLdevMap(selectSourceVolume)).isEmpty()) {
            for (SJctrVMProvTypeStringWrapper KeyWrapper : comboDispList) {
                List<SJmoLdevDetail> availableLdevList = targetVolData.getAvailableLdevList(selectSourceVolume, KeyWrapper.getStrKey());
                if (availableLdevList.isEmpty()) continue;
                dispList.add(KeyWrapper.getStrKey());
            }
        }
        return dispList;
    }

    public static ArrayList<String> createComboBoxData(SJctrAvailableSourceVolsData sourceVolData, List<SJctrVMProvTypeStringWrapper> comboDispList) {
        ArrayList<String> dispList = new ArrayList<String>();
        if (sourceVolData.isBExist()) {
            for (SJctrVMProvTypeStringWrapper KeyWrapper : comboDispList) {
                List<SJmoLdevDetail> availableLdevList = sourceVolData.getAvailableLdevList(KeyWrapper.getStrKey());
                if (availableLdevList.isEmpty()) continue;
                dispList.add(KeyWrapper.getStrKey());
            }
        }
        return dispList;
    }

    public static String toPoolRemainCapacityDisplay(SJmoPoolDetail poolDetail, String strCapaUnit, SJctrComUtility comUtil) {
        String stRtn = "";
        SJctrCapacityUtility.UNIT selCapaUnit = SJctrCapacityUtility.UNIT.BLOCK;
        int iEmulation = 0;
        if (null != poolDetail && null != strCapaUnit && null != comUtil) {
            iEmulation = poolDetail.getEmulationType();
            selCapaUnit = SJctrCapacityUtility.UNIT.valueOf(strCapaUnit);
            iEmulation = comUtil.getPoolUtility().changeEmulationType(iEmulation);
            if (iEmulation == -1) {
                return "?";
            }
            if (SJctrPoolUtility.isOpenPool(poolDetail) && selCapaUnit.equals((Object)SJctrCapacityUtility.UNIT.CYL)) {
                return "-";
            }
            if (selCapaUnit.equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
                long lPage = SJctrVolumeMigrationUtility.toPoolRemainCapa(poolDetail, SJctrCapacityUtility.UNIT.PAGE, comUtil);
                stRtn = Long.toString(lPage);
            } else {
                long lPoolBlock = SJctrVolumeMigrationUtility.toPoolRemainCapa(poolDetail, SJctrCapacityUtility.UNIT.BLOCK, comUtil);
                stRtn = comUtil.getCapacityUtility().toString(lPoolBlock, selCapaUnit, iEmulation);
            }
            strCapaUnit = comUtil.getCapacityUtility().getUnitString(selCapaUnit);
            stRtn = stRtn + " " + strCapaUnit;
        } else {
            stRtn = "?";
        }
        return stRtn;
    }

    public static long toPoolRemainCapa(SJmoPoolDetail poolDetail, SJctrCapacityUtility.UNIT unit, SJctrComUtility comUtil) {
        long lPoolRemainCapa = 0L;
        long lPoolTotalPages = 0L;
        long lPoolUsedPages = 0L;
        long lPoolReservedPages = 0L;
        long lPoolRemainPages = 0L;
        long lPoolPageSize = 0L;
        if (poolDetail != null && unit != null && comUtil != null) {
            lPoolTotalPages = poolDetail.getPoolPages();
            lPoolUsedPages = poolDetail.getPoolUsedPages();
            lPoolReservedPages = poolDetail.getLPoolReservedPages();
            if (lPoolTotalPages < 0L) {
                return 0L;
            }
            lPoolRemainPages = lPoolTotalPages - lPoolUsedPages - lPoolReservedPages;
            if (lPoolRemainPages < 0L) {
                lPoolRemainPages = 0L;
            }
            switch (unit) {
                case PAGE: {
                    lPoolRemainCapa = lPoolRemainPages;
                    break;
                }
                case BLOCK: {
                    lPoolPageSize = poolDetail.getPageSize();
                    long lPoolRemainSize = lPoolRemainPages * lPoolPageSize;
                    lPoolRemainCapa = comUtil.getCapacityUtility().valueOf(lPoolRemainSize, SJctrCapacityUtility.UNIT.KB);
                    break;
                }
            }
        } else {
            lPoolRemainCapa = -1L;
        }
        return lPoolRemainCapa;
    }

    public static String toPoolBasicRemainCapacityDisplay(SJmoPoolDetail poolDetail, String strCapaUnit, SJctrComUtility comUtil) {
        String stRtn = "";
        SJctrCapacityUtility.UNIT selCapaUnit = SJctrCapacityUtility.UNIT.BLOCK;
        int iEmulation = 0;
        if (null != poolDetail && null != strCapaUnit && null != comUtil) {
            if (0L == poolDetail.getLPoolFmcActualPages()) {
                return "-";
            }
            iEmulation = poolDetail.getEmulationType();
            selCapaUnit = SJctrCapacityUtility.UNIT.valueOf(strCapaUnit);
            iEmulation = comUtil.getPoolUtility().changeEmulationType(iEmulation);
            if (iEmulation == -1) {
                return "?";
            }
            if (SJctrPoolUtility.isOpenPool(poolDetail) && selCapaUnit.equals((Object)SJctrCapacityUtility.UNIT.CYL)) {
                return "-";
            }
            if (selCapaUnit.equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
                long lPage = SJctrVolumeMigrationUtility.toPoolBasicRemainCapa(poolDetail, SJctrCapacityUtility.UNIT.PAGE, comUtil);
                stRtn = Long.toString(lPage);
            } else {
                long lPoolBlock = SJctrVolumeMigrationUtility.toPoolBasicRemainCapa(poolDetail, SJctrCapacityUtility.UNIT.BLOCK, comUtil);
                stRtn = comUtil.getCapacityUtility().toString(lPoolBlock, selCapaUnit, iEmulation);
            }
            strCapaUnit = comUtil.getCapacityUtility().getUnitString(selCapaUnit);
            stRtn = stRtn + " " + strCapaUnit;
        } else {
            stRtn = "?";
        }
        return stRtn;
    }

    public static long toPoolBasicRemainCapa(SJmoPoolDetail poolDetail, SJctrCapacityUtility.UNIT unit, SJctrComUtility comUtil) {
        long lPoolRemainCapa = 0L;
        long lPoolTotalPages = 0L;
        long lPoolUsedPages = 0L;
        long lPoolReservedPages = 0L;
        long lPoolRemainPages = 0L;
        long lPoolPageSize = 0L;
        if (poolDetail != null && unit != null && comUtil != null) {
            lPoolTotalPages = poolDetail.getLPoolActualPages();
            lPoolUsedPages = poolDetail.getLPoolActualUsedPages();
            lPoolReservedPages = poolDetail.getLPoolReservedPages();
            if (lPoolTotalPages < 0L) {
                return 0L;
            }
            lPoolRemainPages = lPoolTotalPages - lPoolUsedPages - lPoolReservedPages;
            if (lPoolRemainPages < 0L) {
                lPoolRemainPages = 0L;
            }
            switch (unit) {
                case PAGE: {
                    lPoolRemainCapa = lPoolRemainPages;
                    break;
                }
                case BLOCK: {
                    lPoolPageSize = poolDetail.getPageSize();
                    long lPoolRemainSize = lPoolRemainPages * lPoolPageSize;
                    lPoolRemainCapa = comUtil.getCapacityUtility().valueOf(lPoolRemainSize, SJctrCapacityUtility.UNIT.KB);
                    break;
                }
            }
        } else {
            lPoolRemainCapa = -1L;
        }
        return lPoolRemainCapa;
    }

    public static void makeMigrationPlanCapacityUnit(SJctrTableDataModel table, List<? extends SJctrMigrationPlanInfo> basicDataList, List<SJmoLdevDetail> ldevDetailList) {
        if (basicDataList == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", "makeMigrationPlanCapacityUnit", "basicDataList = null");
            return;
        }
        if (ldevDetailList == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", "makeMigrationPlanCapacityUnit", "ldevDetailList = null");
            return;
        }
        boolean isOpenMfCheck = false;
        Set<String> keySet = table.getAllColumnKeySet();
        for (String string : keySet) {
            SJctrColumn column = table.getColumnInfo(string);
            if (!(column instanceof SJctrCapacityColumnFromLdevDetail)) continue;
            isOpenMfCheck = true;
            break;
        }
        if (isOpenMfCheck) {
            table.setCapacityFlg(true);
            table.setDpVolumeFlg(false);
            table.setOpenVolumeFlg(false);
            table.setMainframeVolumeFlg(false);
            if (basicDataList.isEmpty()) {
                return;
            }
            for (SJctrMigrationPlanInfo sJctrMigrationPlanInfo : basicDataList) {
                SJmoLdevIndex sourceLdevIndex = sJctrMigrationPlanInfo.getSourceLdevIndex();
                SJmoLdevIndex targetLdevIndex = sJctrMigrationPlanInfo.getTargetLdevIndex();
                int source = Collections.binarySearch(ldevDetailList, sourceLdevIndex);
                int target = Collections.binarySearch(ldevDetailList, targetLdevIndex);
                if (source < 0 || target < 0) {
                    SJctrLogUty.warn("SJctrVolumeMigrationUtility", " makeMigrationPlanCapacityUnit ", "ldevDetailData nothing ");
                    SJcException ctrExp = SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
                    throw ctrExp;
                }
                SJmoLdevDetail sourceLdevDetail = ldevDetailList.get(source);
                SJmoLdevDetail targetLdevDetail = ldevDetailList.get(target);
                if (SJctrLdevUtility.isOpenVolume(sourceLdevDetail) || SJctrLdevUtility.isOpenVolume(targetLdevDetail)) {
                    table.setOpenVolumeFlg(true);
                }
                if (SJctrLdevUtility.isMFVolume(sourceLdevDetail) || SJctrLdevUtility.isMFVolume(targetLdevDetail)) {
                    table.setMainframeVolumeFlg(true);
                }
                if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
                break;
            }
        }
    }

    public static ArrayList<String> getPGScatteredKeyList(SJmoPgIndex pgIndex, List<SJmoPgScatteredInfo> pgScatList, SJctrComUtility comUtil) {
        ArrayList<String> pgScatKeyList = new ArrayList<String>();
        if (pgIndex == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", " getPGScatteredKeyList ", " pgIndex null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (pgScatList == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", " getPGScatteredKeyList ", " pgScatList null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (comUtil == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", " getPGScatteredKeyList ", " comUtil null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (pgScatList.isEmpty()) {
            return pgScatKeyList;
        }
        SJctrArrayGroupIndexComparator COMPARATOR = new SJctrArrayGroupIndexComparator();
        Collections.sort(pgScatList, COMPARATOR);
        int iPoint = Collections.binarySearch(pgScatList, pgIndex, new SJctrScatteredComparator());
        if (iPoint >= 0) {
            SJmoPgScatteredInfo pgScatInfo = pgScatList.get(iPoint);
            String strPgData = SJctrVolumeMigrationUtility.getStrPGScatKey(pgScatInfo, comUtil);
            pgScatKeyList.add(strPgData);
            ArrayList alPgIndex = pgScatInfo.getAlPgIndex();
            for (SJmoPgIndex alPgIndexdata : alPgIndex) {
                strPgData = SJctrVolumeMigrationUtility.getStrPGScatKey(alPgIndexdata, comUtil);
                pgScatKeyList.add(strPgData);
            }
        }
        return pgScatKeyList;
    }

    public static String getStrPGScatKey(SJmoPgIndex pgIndex, SJctrComUtility comUtil) {
        StringBuffer strRet = new StringBuffer();
        if (pgIndex == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", " getStrPGScatKey ", " pgIndex null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (comUtil == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", " getStrPGScatKey ", " comUtil null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        strRet.append(comUtil.guidanceHandle.getGuidance("BASIC"));
        strRet.append(":");
        strRet.append(" ");
        strRet.append(comUtil.getLdevUtility().toArrayGroupDisplay(pgIndex.getFB4(), pgIndex.getPG()));
        return strRet.toString();
    }

    public static long getOffsetCapa(SJmoHDPRelation targetDpVol, long lSrcLdevPage, SJctrComUtility comUtil) {
        long offsetCapa = 0L;
        if (targetDpVol == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", " getOffsetCapa ", " targetDpVol null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        if (comUtil == null) {
            SJctrLogUty.warn("SJctrVolumeMigrationUtility", " getOffsetCapa ", " comUtil null");
            throw SJctrVolumeMigrationUtility.makeVMCtrlErrInfo(207006);
        }
        int iEmu = comUtil.getPoolUtility().changeEmulationType(targetDpVol.getIEmulationType());
        long totalPages = comUtil.getPoolUtility().getPages(iEmu, targetDpVol.getLTotalCapaLBA(), comUtil);
        if (totalPages < targetDpVol.getLUsedpage()) {
            totalPages = targetDpVol.getLUsedpage();
        }
        if ((offsetCapa = lSrcLdevPage + targetDpVol.getLUsedpage() - totalPages) < 0L) {
            offsetCapa = 0L;
        }
        return offsetCapa;
    }

    public static boolean chkPoolVirtMode(int iPoolID, List<SJmoLdevDetail> ldevlist) {
        boolean bRet = false;
        for (SJmoLdevDetail ldevDetail : ldevlist) {
            if (!ldevDetail.getbPoolVol() || iPoolID != ldevDetail.getSPoolID() || !ldevDetail.getBVirtMode()) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static double getDPoolBasicUsedPercent(SJmoPoolDetail poolDtl) {
        double dPoolUsedPercent = 0.0;
        if ((double)poolDtl.getLPoolActualPages() != 0.0) {
            dPoolUsedPercent = (double)poolDtl.getLPoolActualUsedPages() / (double)poolDtl.getLPoolActualPages();
        }
        return dPoolUsedPercent *= 100.0;
    }
}

