/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrFilter;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.SJctrColumnCellObject;
import sanproject.sn2.controller.com.column.SJctrColumnLinkAction;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public abstract class SJctrColumn
implements Cloneable {
    public static final int LOGIC_CONTAINS = 0;
    public static final int LOGIC_IS = 1;
    public static final int LOGIC_START_WITH = 2;
    public static final int LOGIC_END_WITH = 3;
    public static final int LOGIC_EQUAL = 128;
    public static final int LOGIC_GRATER = 129;
    public static final int LOGIC_LESS = 130;
    public static final int LOGIC_GRATER_EQUAL = 131;
    public static final int LOGIC_LESS_EQUAL = 132;
    private static final int FILTER_BIT_NUM = 0;
    private static final int FILTER_BIT_STR = 1;
    private static final int FILTER_BIT_SELECT = 2;
    protected static final int FILTER_NUM_DIRECT = 0;
    protected static final int FILTER_STR_DIRECT = 1;
    protected static final int FILTER_NUM_SELECT = 2;
    protected static final int FILTER_STR_SELECT = 3;
    protected static final int FILTER_NUM_UNIT = 4;
    protected static final int FILTER_DATE = 8;
    protected static final int FILTER_LDEV = 16;
    protected static final int FILTER_TIME = 32;
    protected static final int FILTER_NOTHING = Integer.MIN_VALUE;
    protected static final int SORT_STR = 0;
    protected static final int SORT_NUM = 1;
    protected static final int SORT_MIX = 2;
    protected static final int SORT_ID = 3;
    public static final int ITEM_NOTHING = 0;
    public static final int ITEM_ICON = 1;
    public static final int ITEM_LINK = 2;
    public static final int ITEM_ICON_LINK = 3;
    public static final int ITEM_ERR_LINK = 4;
    public static final int ITEM_CHECK = 8;
    public static final String DELIMITER = "\t";
    public static final String COM_LABEL = "label";
    public static final String KEY_ICON = "COM_ICON";
    private static final String COM_NAME = "name";
    private static final String COM_CHILDREN = "children";
    private static final String KEY_ITEMINFO = "COM_ITEMATTRI";
    public static final String KEY_TOOLTIP = "COM_TOOLTIP";
    public static final String KEY_VISIBLE = "COM_VISIBLE";
    private static final int intVisible = 0;
    private static final int intInvisible = 2;
    private static final String COM_FILTER_STD = "COM_FILTER_STD";
    private static final String COM_FILTER_SEL = "COM_FILTER_SEL";
    private static final String COM_FILTER_NUM_SEL = "COM_FILTER_NUM_SEL";
    private static final String COM_FILTER_DATE = "COM_FILTER_DATE";
    private static final String COM_FILTER_LDEV = "COM_FILTER_LDEV";
    private static final String COM_FILTER_TIME = "COM_FILTER_TIME";
    private static final String COM_FILTER_NAME = "COM_FILTER_NAME";
    private static final String COM_FILTER_LOGIC_TYPE = "COM_FILTER_LOGIC_TYPE";
    private static final String COM_FILTER_FORMAT = "COM_FILTER_FORMAT";
    private static final String COM_FILTER_FORMAT_EQUAL = "COM_FILTER_FORMAT_EQUAL";
    private static final String COM_FILTER_SEL_VALUE = "COM_FILTER_SEL_VALUE";
    private static final String COM_FILTER_VALUE_MAX = "COM_FILTER_VALUE_MAX";
    private static final String COM_FILTER_VALUE_SEP = "COM_FILTER_VALUE_SEP";
    protected static final String FORMAT_NOTHING = "";
    protected static final String FORMAT_DEC = "^\\d{1,19}$";
    protected static final String FORMAT_UNKNOWN = "-?";
    protected static final String FORMAT_SPACE = "^$|^[ \u3000]{1,}$";
    protected static final String FORMAT_DEC_UNKNOWN = "^[-?]{1}$|^$|^[ \u3000]{1,}$";
    protected static final String FORMAT_HEX1_8 = "^([0-9A-Fa-f]{1,8})$";
    protected static final String FORMAT_HEX1_6 = "^([0-9A-Fa-f]{1,6})$";
    protected static final String FORMAT_HEX1_4 = "^([0-9A-Fa-f]{1,4})$";
    protected static final String FORMAT_HEX1_3 = "^([0-9A-Fa-f]{1,3})$";
    protected static final String FORMAT_HEX1_2 = "^([0-9A-Fa-f]{1,2})$";
    protected static final String FORMAT_HEX8 = "^([0-9A-Fa-f]{8})$";
    protected static final String FORMAT_HEX6 = "^([0-9A-Fa-f]{6})$";
    protected static final String FORMAT_HEX4 = "^([0-9A-Fa-f]{4})$";
    protected static final String FORMAT_HEX3 = "^([0-9A-Fa-f]{3})$";
    protected static final String FORMAT_HEX2 = "^([0-9A-Fa-f]{2})$";
    protected static final String FORMAT_HEX1 = "^([0-9A-Fa-f]{1})$";
    protected static final String FORMAT_HEX = "^([0-9A-Fa-f]{4})$";
    private static final Set<String> formatHexSet;
    protected static final String FORMAT_DATE = "^(\\d{4})\\/(\\d{2})\\/(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2})$";
    protected static final String FORMAT_LDEV = "^(00):([0-9A-Fa-f]{2}):([0-9A-Fa-f]{2})$";
    protected static final String FORMAT_NUM_UNIT = "^\\d{1,19}(\\.\\d{1,2})?$";
    private static final String REGEX_MIX_STR = "\\d+";
    private static final int FILTER_TIME_HOUR_MAX = 23;
    private static final int FILTER_TIME_MINUTE_MAX = 59;
    private static final int FILTER_TIME_SECOND_MAX = 59;
    protected static final String REP_HOUR_MAX = "HOUR_MAX";
    protected static final String FORMAT_TIME = "^(\\d{1,HOUR_MAX}):(\\d{1,2}):(\\d{1,2})$";
    private static final String FILTER_TIME_DEFAULT_SEP = ":";
    private static final int FILTER_TIME_DEFAULT_SEP_LIST_SIZE = 3;
    private static final List<String> FILTER_TIME_DEFAULT_SEP_LIST;
    private static final String UNMAP_STR = "";
    private String label;
    private Map<String, SJctrColumn> childColumn;
    private int itemInfo;
    private Comparator<HashMap<String, Object>> myComparator;
    private final String myKey;
    private String myFullpathKey;
    private final Set<String> selectFilterData;
    private String regexFilterAvailableString = null;
    private SJctrTableDataModel tableModel;
    private String unitSelect;
    private String screenId = "COMMON";
    private String partsId = null;
    private SJctrColumnCellObject cellObj = null;
    private SJctrColumnLinkAction linkAction = null;
    private boolean showColumn = true;
    private boolean showColumnDefault = true;
    private boolean gettingColumnData = true;
    private boolean gettingHiddenColumnData = true;
    private boolean showColumnAlways = false;
    protected boolean supportColumn = true;
    private List<Integer> filterTimeMaxList = null;
    private List<String> filterTimeSepList = null;
    private String regexFilterTime = null;

    public SJctrColumn(String key) {
        this.myKey = key;
        this.myFullpathKey = key;
        this.label = "";
        this.unitSelect = "";
        this.itemInfo = 0;
        this.selectFilterData = (this.getFilterType() & 2) == 2 ? new HashSet<String>() : null;
    }

    public void addColumn(SJctrColumn column) {
        if (column != null) {
            if (this.childColumn == null) {
                this.childColumn = new LinkedHashMap<String, SJctrColumn>();
            }
            column.setTable(this.tableModel);
            String childKey = column.getMyKey();
            String fullPath = this.getMyFullPathKey() + DELIMITER + childKey;
            column.setFullPathKey(fullPath);
            this.childColumn.put(childKey, column);
        }
    }

    public Object createCellObject(List<?> dataList) {
        SJctrColumnCellObject cellObj = this.getCellObj();
        if (this.getItemInfo() != 0 && cellObj != null) {
            return cellObj.createCellObject(dataList);
        }
        return this.toDispString(dataList);
    }

    public List<Object> doLinkAction(Map<String, Object> rowData) {
        SJctrColumnLinkAction linkAction = this.getLinkAction();
        if (linkAction != null) {
            return linkAction.doLinkAction(rowData);
        }
        return null;
    }

    public SJctrColumn getColumnInfo(String key) {
        SJctrColumn column = null;
        if (this.childColumn != null) {
            String searchKey = key;
            String childKey = null;
            int delimiterIndex = key.indexOf(DELIMITER);
            if (delimiterIndex > 0) {
                searchKey = key.substring(0, delimiterIndex);
                childKey = key.substring(delimiterIndex + 1);
            }
            if ((column = this.childColumn.get(searchKey)) != null && childKey != null) {
                column = column.getColumnInfo(childKey);
            }
        }
        return column;
    }

    public Comparator<HashMap<String, Object>> getComparator() {
        if (this.myComparator == null) {
            this.myComparator = this.createComparator();
        }
        return this.myComparator;
    }

    public Set<String> getAllKeySet() {
        LinkedHashSet<String> retSet = new LinkedHashSet<String>();
        String parentKey = this.getMyKey();
        retSet.add(parentKey);
        if (this.childColumn != null) {
            for (SJctrColumn column : this.childColumn.values()) {
                for (String childKey : column.getAllKeySet()) {
                    retSet.add(parentKey + DELIMITER + childKey);
                }
            }
        }
        return retSet;
    }

    public SJctrFilter getFilter(SJctrDataObject data) {
        SJctrFilter retFilter;
        int logic = (Integer)data.getData("COM_FILTER_LOGIC");
        List list = (List)data.getData("COM_FILTER_VALUE");
        if (list.size() == 0) {
            return null;
        }
        String value = (String)list.get(0);
        String regex = this.getInputFormat();
        switch (this.getFilterType()) {
            case 0: 
            case 2: 
            case 4: 
            case 16: {
                if (logic == 128 && (FORMAT_UNKNOWN.contains(value) || Pattern.matches(FORMAT_SPACE, value))) {
                    regex = "^[-?]{1}$|^$|^[ \u3000]{1,}$|" + regex;
                }
                if (this.regexFilterAvailableString == null) {
                    this.regexFilterAvailableString = this.makeRegexFilterAvailableString();
                }
                if (this.regexFilterAvailableString == "" || logic != 128 || !Pattern.matches(this.regexFilterAvailableString, value)) break;
                regex = regex + "|" + this.regexFilterAvailableString;
                break;
            }
        }
        if (!this.checkInputFormat(value, regex)) {
            return null;
        }
        if (!this.checkFilterValueMax(value, regex)) {
            return null;
        }
        if (!this.isFilterValueData(value)) {
            return null;
        }
        if (!this.isFilterUnitData(list)) {
            return null;
        }
        switch (this.getFilterType()) {
            case 1: 
            case 3: {
                String str = this.getInputValueString(list, this.getInputFormat());
                retFilter = this.createStringFilter(logic, str);
                break;
            }
            case 0: 
            case 2: 
            case 32: {
                if (this.isUseStringFilter(logic, value)) {
                    String str = this.getInputValueStringForNUM(list, FORMAT_DEC_UNKNOWN);
                    retFilter = this.createStringFilter(1, str);
                    break;
                }
                long num = this.getInputValueNumber(list, this.getInputFormat());
                retFilter = this.createNumberFilter(logic, num);
                break;
            }
            case 4: {
                if (this.isUseStringFilter(logic, value)) {
                    String str = this.getInputValueStringForNUM(list, FORMAT_DEC_UNKNOWN);
                    retFilter = this.createStringFilter(1, str);
                    break;
                }
                long num = this.getInputValueDecimal(list, this.getInputFormat(), logic);
                retFilter = this.createUnitNumberFilter(logic, num, list);
                break;
            }
            case 8: {
                long date = this.getInputDate(value, this.getInputFormat());
                retFilter = this.createNumberFilter(logic, date);
                break;
            }
            case 16: {
                if (this.isUseStringFilter(logic, value)) {
                    String str = this.getInputValueStringForNUM(list, FORMAT_DEC_UNKNOWN);
                    retFilter = this.createStringFilter(1, str);
                    break;
                }
                Object obj = this.getInputLdev(value, this.getInputFormat());
                retFilter = this.createObjectFilter(logic, obj);
                break;
            }
            default: {
                retFilter = null;
            }
        }
        return retFilter;
    }

    private boolean isUseStringFilter(int logic, String value) {
        boolean ret = false;
        if (logic == 128) {
            if (this.regexFilterAvailableString == null) {
                this.regexFilterAvailableString = this.makeRegexFilterAvailableString();
            }
            if (FORMAT_UNKNOWN.contains(value)) {
                ret = true;
            } else if (this.regexFilterAvailableString != "" && Pattern.matches(this.regexFilterAvailableString, value)) {
                ret = true;
            } else if (Pattern.matches(FORMAT_SPACE, value)) {
                ret = true;
            }
        }
        return ret;
    }

    public String getFilterValueString(SJctrDataObject data) {
        StringBuilder result = new StringBuilder();
        int logic = (Integer)data.getData("COM_FILTER_LOGIC");
        List list = (List)data.getData("COM_FILTER_VALUE");
        if (list.size() == 0) {
            return "";
        }
        String value = (String)list.get(0);
        if (this.getFilterType() == 32) {
            value = this.getFilterValueStringTime(value);
        }
        result.append(value);
        switch (this.getFilterType()) {
            case 4: {
                if (logic == 128 && FORMAT_UNKNOWN.contains(value)) break;
                String unitString = (String)list.get(1);
                result.append(unitString);
                break;
            }
        }
        return result.toString();
    }

    private String getFilterValueStringTime(String time) {
        StringBuilder result = new StringBuilder();
        String regex = this.getInputFormat();
        Matcher matcher = Pattern.compile(regex).matcher(time);
        List<String> sepList = this.getFilterValueSepList();
        if (matcher.matches()) {
            result.append(matcher.group(1));
            result.append(sepList.get(0));
            result.append(matcher.group(2));
            result.append(sepList.get(1));
            result.append(matcher.group(3));
            result.append(sepList.get(2));
        }
        return result.toString();
    }

    public String getFilterLogicString(SJctrDataObject data) {
        String result = "";
        SJctrComUtility util = this.getTable().getComUtility();
        int logic = (Integer)data.getData("COM_FILTER_LOGIC");
        switch (logic) {
            case 0: {
                result = util.getGuidance("LOGIC_CONTAINS");
                break;
            }
            case 1: {
                result = util.getGuidance("LOGIC_IS");
                break;
            }
            case 2: {
                result = util.getGuidance("LOGIC_START_WITH");
                break;
            }
            case 3: {
                result = util.getGuidance("LOGIC_END_WITH");
                break;
            }
            case 128: {
                result = util.getGuidance("LOGIC_EQUAL");
                break;
            }
            case 129: {
                result = util.getGuidance("LOGIC_GRATER");
                break;
            }
            case 130: {
                result = util.getGuidance("LOGIC_LESS");
                break;
            }
            case 131: {
                result = util.getGuidance("LOGIC_GRATER_EQUAL");
                break;
            }
            case 132: {
                result = util.getGuidance("LOGIC_LESS_EQUAL");
                break;
            }
        }
        return result;
    }

    public int getFilterType() {
        return 1;
    }

    public HashMap<String, Object> getHeaderInfo(Set<String> targetColumn) {
        return this.getHeaderInfo(null, targetColumn);
    }

    public HashMap<String, Object> getHeaderInfo(Map<String, Object> parent, Set<String> targetColumn) {
        String tooltip;
        String name = parent == null ? this.getMyKey() : parent.get(COM_NAME) + DELIMITER + this.getMyKey();
        if (!targetColumn.contains(name)) {
            return null;
        }
        HashMap<String, Object> headerInfo = new HashMap<String, Object>();
        headerInfo.put(COM_NAME, name);
        headerInfo.put(COM_LABEL, this.getLabel());
        if (this.itemInfo != 0) {
            headerInfo.put(KEY_ITEMINFO, this.itemInfo);
        }
        int visible = 0;
        if (!this.getShowColumn()) {
            visible = 2;
        }
        headerInfo.put(KEY_VISIBLE, visible);
        List<SJctrColumn> childColumnList = this.getChildColumn();
        int childNum = childColumnList.size();
        if (childNum > 0) {
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(childNum);
            for (SJctrColumn column : childColumnList) {
                HashMap<String, Object> childInfo = column.getHeaderInfo(headerInfo, targetColumn);
                if (childInfo == null) continue;
                list.add(childInfo);
            }
            headerInfo.put(COM_CHILDREN, list);
        }
        if ((tooltip = this.getHeaderTooltip()) != null) {
            headerInfo.put(KEY_TOOLTIP, tooltip);
        }
        switch (this.getFilterType()) {
            case 0: {
                headerInfo.put(COM_FILTER_STD, this.getFilterInfoStandardEqual());
                break;
            }
            case 1: {
                headerInfo.put(COM_FILTER_STD, this.getFilterInfoStandard());
                break;
            }
            case 2: 
            case 3: {
                headerInfo.put(COM_FILTER_SEL, this.getFilterInfoSelect());
                break;
            }
            case 4: {
                headerInfo.put(COM_FILTER_NUM_SEL, this.getFilterInfoNumUnit());
                break;
            }
            case 8: {
                headerInfo.put(COM_FILTER_DATE, this.getFilterInfoStandard());
                break;
            }
            case 16: {
                headerInfo.put(COM_FILTER_LDEV, this.getFilterInfoStandardEqual());
                break;
            }
            case 32: {
                headerInfo.put(COM_FILTER_TIME, this.getFilterInfoTime());
                break;
            }
        }
        return headerInfo;
    }

    protected String getHeaderTooltip() {
        return null;
    }

    public String getInputFormat() {
        String inputFormat;
        switch (this.getFilterType()) {
            case 0: 
            case 2: {
                inputFormat = FORMAT_DEC;
                break;
            }
            case 4: {
                inputFormat = FORMAT_NUM_UNIT;
                break;
            }
            case 1: 
            case 3: {
                inputFormat = "";
                break;
            }
            case 8: {
                inputFormat = FORMAT_DATE;
                break;
            }
            case 16: {
                inputFormat = FORMAT_LDEV;
                break;
            }
            case 32: {
                inputFormat = this.makeRegexFilterTime();
                break;
            }
            default: {
                inputFormat = "";
            }
        }
        return inputFormat;
    }

    private String makeRegexFilterTime() {
        if (this.regexFilterTime != null) {
            return this.regexFilterTime;
        }
        int max = this.getFilterValueHourMax();
        if (max < 0) {
            max = 23;
        }
        String strMax = Integer.valueOf(max).toString();
        int dig = strMax.length();
        this.regexFilterTime = FORMAT_TIME.replace(REP_HOUR_MAX, Integer.valueOf(dig).toString());
        return this.regexFilterTime;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMyFullPathKey() {
        return this.myFullpathKey;
    }

    public String getMyKey() {
        return this.myKey;
    }

    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(index);
        return list;
    }

    public abstract List<Class<? extends SJmoGetKind_IF>> getNeedModelKind();

    public Collection<SJctrGetDirectWrapper> getNeedModelDirect() {
        Collection<SJctrGetDirectWrapper> list = null;
        return list;
    }

    public final Object getPrimaryKeyObject(Map<String, Object> dat) {
        return dat.get("CTRL_MODEL_KEY");
    }

    public int getSortType() {
        return 0;
    }

    public String getString(Map<String, Object> dat) {
        SJctrColumnCellObject cellObj = this.getCellObj();
        if (this.getItemInfo() != 0 && cellObj != null) {
            return cellObj.getString(dat);
        }
        String retValue = (String)dat.get(this.getMyFullPathKey());
        if (retValue == null) {
            retValue = "";
        }
        return retValue;
    }

    public void initGuidance(SJctrComUtility util) {
        if (this.childColumn != null) {
            for (SJctrColumn column : this.childColumn.values()) {
                column.initGuidance(util);
            }
        }
        String screenId = this.getScreenId();
        String partsId = this.getPartsId();
        if (partsId != null) {
            this.setLabel(util.getGuidance(screenId, partsId));
        }
    }

    public void makeSelectFilterData(String str) {
        if (this.selectFilterData != null) {
            this.selectFilterData.add(str);
        }
    }

    private boolean checkFilterValueMax(String value, String regex) {
        boolean ret = true;
        switch (this.getFilterType()) {
            case 32: {
                Matcher matcher = Pattern.compile(regex).matcher(value);
                if (matcher.matches()) {
                    int hh = Integer.parseInt(matcher.group(1));
                    int mm = Integer.parseInt(matcher.group(2));
                    int ss = Integer.parseInt(matcher.group(3));
                    int hhMax = this.getFilterValueHourMax();
                    if (hhMax < 0) {
                        hhMax = 23;
                    }
                    if (hh > hhMax) {
                        ret = false;
                        break;
                    }
                    if (mm > 59) {
                        ret = false;
                        break;
                    }
                    if (ss <= 59) break;
                    ret = false;
                    break;
                }
                ret = false;
                break;
            }
        }
        return ret;
    }

    private boolean isFilterValueData(String value) {
        boolean result = true;
        result = this.selectFilterData != null ? this.selectFilterData.contains(value) : value != null;
        return result;
    }

    private boolean isFilterUnitData(List<String> list) {
        boolean result = true;
        if (this.getFilterType() == 4 && list.size() >= 2) {
            String unitStr = list.get(1);
            SJctrCapacityUtility.UNIT unit = SJctrCapacityUtility.UNIT.valueOf(unitStr);
            SJctrTableDataModel table = this.getTable();
            List<SJctrCapacityUtility.UNIT> unitList = table.getUnitList();
            result = unitList.contains((Object)unit);
        }
        return result;
    }

    public final void setLabel(String label) {
        if (label != null) {
            this.label = label;
        }
    }

    public final void setItemInfo(int info) {
        this.itemInfo = info;
    }

    public int getItemInfo() {
        return this.itemInfo;
    }

    public final void setTable(SJctrTableDataModel table) {
        if (table != null) {
            this.tableModel = table;
            if (this.childColumn != null) {
                for (SJctrColumn column : this.childColumn.values()) {
                    column.setTable(table);
                }
            }
        }
    }

    public abstract String toDispString(List<?> var1);

    protected long convertUnitToOrigin(long inputNum, String unit) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    protected Comparator<HashMap<String, Object>> createComparator() {
        Comparator<HashMap<String, Object>> retComparator;
        switch (this.getSortType()) {
            case 1: {
                retComparator = new Comparator<HashMap<String, Object>>(){

                    @Override
                    public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                        long result = SJctrColumn.this.getNumber(o1) - SJctrColumn.this.getNumber(o2);
                        if (result > 0L) {
                            result = 1L;
                        } else if (result < 0L) {
                            result = -1L;
                        }
                        return (int)result;
                    }
                };
                break;
            }
            case 3: {
                retComparator = new Comparator<HashMap<String, Object>>(){

                    @Override
                    public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                        Object obj1 = SJctrColumn.this.getObject(o1);
                        Object obj2 = SJctrColumn.this.getObject(o2);
                        Comparator<Object> comparator = SJctrColumn.this.createObjectComparator();
                        return comparator.compare(obj1, obj2);
                    }
                };
                break;
            }
            case 2: {
                retComparator = new Comparator<HashMap<String, Object>>(){

                    @Override
                    public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                        return SJctrColumn.this.getMixString(o1).compareTo(SJctrColumn.this.getMixString(o2));
                    }
                };
                break;
            }
            default: {
                retComparator = new Comparator<HashMap<String, Object>>(){

                    @Override
                    public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                        return SJctrColumn.this.getString(o1).compareTo(SJctrColumn.this.getString(o2));
                    }
                };
            }
        }
        return retComparator;
    }

    protected Comparator<Object> createObjectComparator() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    protected long getInputValueNumber(List<String> list, String regex) {
        long inputNum;
        switch (this.getFilterType()) {
            case 0: 
            case 2: {
                inputNum = this.getInputNumber(list.get(0), regex);
                break;
            }
            case 32: {
                inputNum = this.getInputTime(list.get(0), regex);
                break;
            }
            default: {
                inputNum = 0L;
            }
        }
        return inputNum;
    }

    protected long getInputValueDecimal(List<String> list, String regex, int logic) {
        long resultValue = 0L;
        if (list == null || list.size() < 2) {
            this.getTable().getLogUty().putlog("getInputValueDecimal", "Filter data: " + list, 40000);
            return resultValue;
        }
        String decimalStr = list.get(0);
        String unitStr = list.get(1);
        Matcher matcher = Pattern.compile(regex).matcher(decimalStr);
        if (matcher.matches()) {
            long baseValue = this.convertUnitToOrigin(1L, unitStr);
            BigDecimal baseDecimal = new BigDecimal(baseValue);
            BigDecimal decimal = new BigDecimal(decimalStr);
            if (baseValue != 1L) {
                if (logic == 130) {
                    decimal = decimal.subtract(new BigDecimal("0.01"));
                } else if (logic == 129) {
                    decimal = decimal.add(new BigDecimal("0.01"));
                }
            }
            decimal = decimal.multiply(baseDecimal);
            BigDecimal max = new BigDecimal(Long.MAX_VALUE);
            BigDecimal value = max.min(decimal);
            RoundingMode roundingMode = logic == 130 || logic == 131 ? RoundingMode.UP : RoundingMode.DOWN;
            value = value.setScale(0, roundingMode);
            resultValue = value.longValue();
        } else {
            this.getTable().getLogUty().putlog("getInputValueDecimal", "Filter data: " + decimalStr, 30000);
        }
        return resultValue;
    }

    protected String getInputValueString(List<String> list, String regex) {
        return list.get(0);
    }

    protected String getInputValueStringForNUM(List<String> list, String regex) {
        String ret = list.get(0);
        if (Pattern.matches(FORMAT_SPACE, ret)) {
            ret = "";
        }
        return ret;
    }

    protected String getMixString(Map<String, Object> dat) {
        StringBuffer buf = new StringBuffer();
        String str = this.getString(dat);
        Matcher matcher = Pattern.compile(REGEX_MIX_STR).matcher(str);
        int length = this.getZeroPaddingLength();
        StringBuilder pad = new StringBuilder(length);
        while (matcher.find()) {
            pad.delete(0, pad.length());
            String group = matcher.group();
            int padNum = length - group.length();
            for (int i = 0; i < padNum; ++i) {
                pad.append('0');
            }
            pad.append(group);
            matcher.appendReplacement(buf, pad.toString());
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    protected long getNumber(Map<String, Object> dat) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    protected long getFilterUnitNumber(Map<String, Object> dat, SJctrCapacityUtility.UNIT unit) {
        long retValue;
        switch (unit) {
            case CYL: {
                retValue = this.getCylinderNumber(dat);
                break;
            }
            case PAGE: {
                retValue = this.getPageNumber(dat);
                break;
            }
            default: {
                retValue = this.getNumber(dat);
            }
        }
        return retValue;
    }

    protected long getCylinderNumber(Map<String, Object> dat) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    protected long getPageNumber(Map<String, Object> dat) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    protected Object getObject(Map<String, Object> dat) {
        return this.getPrimaryKeyObject(dat);
    }

    protected final SJctrTableDataModel getTable() {
        return this.tableModel;
    }

    protected LinkedHashMap<String, String> getUnitList() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    protected String getUnitSelect() {
        return this.unitSelect;
    }

    protected int getZeroPaddingLength() {
        return 10;
    }

    public void setUnitSelect(String unit) {
        if (this.getFilterType() == 4) {
            this.unitSelect = unit;
        }
    }

    private boolean checkInputFormat(String str, String regex) {
        boolean result = true;
        if (!regex.equals("")) {
            Matcher matcher = Pattern.compile(regex).matcher(str);
            result = matcher.matches();
        }
        return result;
    }

    private SJctrFilter createNumberFilter(int logic, long num) {
        SJctrFilterNumber retFilter;
        switch (logic) {
            case 128: {
                retFilter = new SJctrFilterNumberEqual(num);
                break;
            }
            case 129: {
                retFilter = new SJctrFilterNumberGrater(num);
                break;
            }
            case 130: {
                retFilter = new SJctrFilterNumberLess(num);
                break;
            }
            case 131: {
                retFilter = new SJctrFilterNumberGraterEqual(num);
                break;
            }
            case 132: {
                retFilter = new SJctrFilterNumberLessEqual(num);
                break;
            }
            default: {
                retFilter = null;
            }
        }
        return retFilter;
    }

    private SJctrFilter createUnitNumberFilter(int logic, long num, List<String> list) {
        SJctrFilterUnitEqual retFilter = null;
        if (list == null || list.size() < 2) {
            this.getTable().getLogUty().putlog("createUnitNumberFilter", "Filter data: " + list, 40000);
            return retFilter;
        }
        String filterInput = list.get(0);
        String filterUnit = list.get(1);
        switch (logic) {
            case 128: {
                retFilter = new SJctrFilterUnitEqual(num, filterInput, filterUnit);
                break;
            }
            case 129: {
                retFilter = new SJctrFilterUnitGrater(num, filterInput, filterUnit);
                break;
            }
            case 130: {
                retFilter = new SJctrFilterUnitLess(num, filterInput, filterUnit);
                break;
            }
            case 131: {
                retFilter = new SJctrFilterUnitGraterEqual(num, filterInput, filterUnit);
                break;
            }
            case 132: {
                retFilter = new SJctrFilterUnitLessEqual(num, filterInput, filterUnit);
            }
        }
        return retFilter;
    }

    private SJctrFilter createObjectFilter(int logic, Object obj) {
        SJctrFilterObject retFilter;
        switch (logic) {
            case 128: {
                retFilter = new SJctrFilterObjectEqual(obj, this.createObjectComparator());
                break;
            }
            case 129: {
                retFilter = new SJctrFilterObjectGrater(obj, this.createObjectComparator());
                break;
            }
            case 130: {
                retFilter = new SJctrFilterObjectLess(obj, this.createObjectComparator());
                break;
            }
            case 131: {
                retFilter = new SJctrFilterObjectGraterEqual(obj, this.createObjectComparator());
                break;
            }
            case 132: {
                retFilter = new SJctrFilterObjectLessEqual(obj, this.createObjectComparator());
                break;
            }
            default: {
                retFilter = null;
            }
        }
        return retFilter;
    }

    private SJctrFilter createStringFilter(int logic, String str) {
        SJctrFilterString retFilter = null;
        switch (logic) {
            case 0: {
                retFilter = new SJctrFilterStringContains(str);
                break;
            }
            case 1: {
                retFilter = new SJctrFilterStringIs(str);
                break;
            }
            case 2: {
                retFilter = new SJctrFilterStringStartWith(str);
                break;
            }
            case 3: {
                retFilter = new SJctrFilterStringEndWith(str);
                break;
            }
            default: {
                retFilter = null;
            }
        }
        return retFilter;
    }

    private SJctrComboBoxDataModel createUnitComboBox() {
        SJctrComboBoxDataModel combo = new SJctrComboBoxDataModel();
        SJctrTableDataModel table = this.getTable();
        SJctrCapacityUtility util = table.getComUtility().getCapacityUtility();
        for (SJctrCapacityUtility.UNIT unit : table.getUnitList()) {
            combo.addItem(unit.toString(), util.getUnitString(unit));
        }
        return combo;
    }

    public List<SJctrColumn> getChildColumn() {
        ArrayList<SJctrColumn> list = new ArrayList<SJctrColumn>();
        if (this.childColumn != null) {
            for (SJctrColumn column : this.childColumn.values()) {
                list.add(column);
            }
        }
        return list;
    }

    private long getInputDate(String str, String regex) {
        long date = 0L;
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (matcher.lookingAt()) {
            int YYYY = Integer.parseInt(matcher.group(1));
            int MM = Integer.parseInt(matcher.group(2));
            int DD = Integer.parseInt(matcher.group(3));
            int hh = Integer.parseInt(matcher.group(4));
            int mm = Integer.parseInt(matcher.group(5));
            int ss = Integer.parseInt(matcher.group(6));
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(YYYY, MM - 1, DD, hh, mm, ss);
            date = calendar.getTimeInMillis();
        }
        return date;
    }

    private Object getInputLdev(String str, String regex) {
        SJmoLdevIndex ldevId = new SJmoLdevIndex();
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (matcher.lookingAt()) {
            short node = Short.parseShort(matcher.group(1), 16);
            short cu = Short.parseShort(matcher.group(2), 16);
            short ldev = Short.parseShort(matcher.group(3), 16);
            ldevId.setLdevIndex(node, cu, ldev);
        }
        return ldevId;
    }

    private long getInputNumber(String str, String regex) {
        long num = 0L;
        if (regex.equals(FORMAT_DEC) || regex.contains(FORMAT_DEC)) {
            BigInteger max = new BigInteger(Long.toString(Long.MAX_VALUE));
            BigInteger value = max.min(new BigInteger(str));
            num = value.longValue();
        } else if (formatHexSet.contains(regex)) {
            num = Long.parseLong(str, 16);
        }
        return num;
    }

    private long getInputTime(String str, String regex) {
        long sec = 0L;
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (matcher.matches()) {
            int hh = Integer.parseInt(matcher.group(1));
            int mm = Integer.parseInt(matcher.group(2));
            int ss = Integer.parseInt(matcher.group(3));
            sec = hh * 3600 + mm * 60 + ss;
        }
        return sec;
    }

    private SJctrDataObject getFilterInfoCom() {
        SJctrDataObject filterInfo = new SJctrDataObject();
        filterInfo.setData(COM_FILTER_NAME, this.getMyFullPathKey());
        filterInfo.setData(COM_FILTER_LOGIC_TYPE, this.getFilterType() & 1);
        return filterInfo;
    }

    private SJctrDataObject getFilterInfoNumUnit() {
        SJctrDataObject filterInfo = this.getFilterInfoStandardEqual();
        SJctrComboBoxDataModel combo = this.createUnitComboBox();
        Object nestedList = combo.getDataObject(null);
        filterInfo.setData(COM_FILTER_SEL_VALUE, nestedList);
        return filterInfo;
    }

    private SJctrDataObject getFilterInfoTime() {
        SJctrDataObject filterInfo = this.getFilterInfoStandard();
        filterInfo.setData(COM_FILTER_VALUE_MAX, this.getFilterValueMaxList());
        filterInfo.setData(COM_FILTER_VALUE_SEP, this.getFilterValueSepList());
        return filterInfo;
    }

    private List<Integer> getFilterValueMaxList() {
        if (this.filterTimeMaxList != null) {
            return this.filterTimeMaxList;
        }
        int hhMax = this.getFilterValueHourMax();
        if (hhMax < 0) {
            hhMax = 23;
        }
        this.filterTimeMaxList = new ArrayList<Integer>();
        this.filterTimeMaxList.add(hhMax);
        this.filterTimeMaxList.add(59);
        this.filterTimeMaxList.add(59);
        return this.filterTimeMaxList;
    }

    public int getFilterValueHourMax() {
        return 23;
    }

    private List<String> getFilterValueSepList() {
        if (this.filterTimeSepList != null) {
            return this.filterTimeSepList;
        }
        this.filterTimeSepList = this.getFilterValueSep();
        if (this.filterTimeSepList == null || this.filterTimeSepList.size() != 3) {
            this.filterTimeSepList = FILTER_TIME_DEFAULT_SEP_LIST;
        }
        return this.filterTimeSepList;
    }

    public List<String> getFilterValueSep() {
        return FILTER_TIME_DEFAULT_SEP_LIST;
    }

    private SJctrDataObject getFilterInfoSelect() {
        SJctrDataObject filterInfo = this.getFilterInfoCom();
        if (this.selectFilterData != null) {
            Object[] filterData = new String[this.selectFilterData.size()];
            filterData = this.selectFilterData.toArray(filterData);
            Pattern pattern = Pattern.compile(REGEX_MIX_STR);
            int length = this.getZeroPaddingLength();
            StringBuilder pad = new StringBuilder(length);
            HashMap<Object, Object> hmap = new HashMap<Object, Object>();
            block3: for (int iCnt = 0; iCnt < filterData.length; ++iCnt) {
                Object name = filterData[iCnt];
                Matcher matcher = pattern.matcher((CharSequence)name);
                Object key = name;
                switch (this.getSortType()) {
                    case 2: {
                        int i;
                        int padNum;
                        StringBuffer buf = new StringBuffer();
                        buf.delete(0, buf.length());
                        while (matcher.find()) {
                            pad.delete(0, pad.length());
                            String group = matcher.group();
                            padNum = length - group.length();
                            for (i = 0; i < padNum; ++i) {
                                pad.append('0');
                            }
                            pad.append(group);
                            matcher.appendReplacement(buf, pad.toString());
                        }
                        matcher.appendTail(buf);
                        filterData[iCnt] = key = new String(buf);
                        hmap.put(key, name);
                        continue block3;
                    }
                    default: {
                        int i;
                        int padNum;
                        boolean bMatch = matcher.matches();
                        if (bMatch) {
                            pad.delete(0, pad.length());
                            padNum = length - ((String)name).length();
                            for (i = 0; i < padNum; ++i) {
                                pad.append('0');
                            }
                            pad.append((String)name);
                            filterData[iCnt] = key = new String(pad);
                        }
                        hmap.put(key, name);
                    }
                }
            }
            Arrays.sort(filterData);
            SJctrComboBoxDataModel combo = new SJctrComboBoxDataModel(this.selectFilterData.size());
            for (Object name : filterData) {
                combo.addItem((String)hmap.get(name));
            }
            Object nestedList = combo.getDataObject(null);
            filterInfo.setData(COM_FILTER_SEL_VALUE, nestedList);
        }
        return filterInfo;
    }

    private SJctrDataObject getFilterInfoStandard() {
        SJctrDataObject filterInfo = this.getFilterInfoCom();
        filterInfo.setData(COM_FILTER_FORMAT, this.getInputFormat());
        return filterInfo;
    }

    private SJctrDataObject getFilterInfoStandardEqual() {
        SJctrDataObject filterInfo = this.getFilterInfoCom();
        filterInfo.setData(COM_FILTER_FORMAT, this.getInputFormat());
        StringBuilder formatEqual = new StringBuilder("^[-?]{1}$|^$|^[ \u3000]{1,}$|" + this.getInputFormat());
        if (this.regexFilterAvailableString == null) {
            this.regexFilterAvailableString = this.makeRegexFilterAvailableString();
        }
        if (this.regexFilterAvailableString != "") {
            formatEqual.append("|");
            formatEqual.append(this.regexFilterAvailableString);
        }
        filterInfo.setData(COM_FILTER_FORMAT_EQUAL, formatEqual.toString());
        return filterInfo;
    }

    protected List<String> getFilterAvailableStrings() {
        return Collections.emptyList();
    }

    private String makeRegexFilterAvailableString() {
        List<String> lstString = this.getFilterAvailableStrings();
        if (lstString == null || lstString.isEmpty()) {
            return "";
        }
        StringBuilder sbRegex = new StringBuilder();
        sbRegex.append("^(?i)(");
        for (int i = 0; i < lstString.size(); ++i) {
            if (i > 0) {
                sbRegex.append("|");
            }
            sbRegex.append(lstString.get(i));
        }
        sbRegex.append(")$");
        return sbRegex.toString();
    }

    private void setFullPathKey(String key) {
        this.myFullpathKey = key;
    }

    public Object clone() throws CloneNotSupportedException {
        SJctrColumnLinkAction linkAction;
        SJctrColumnCellObject cellObj;
        SJctrColumn cloneColumn = (SJctrColumn)super.clone();
        cloneColumn.clear();
        if (this.childColumn != null) {
            for (SJctrColumn child : this.childColumn.values()) {
                SJctrColumn cloneChild = (SJctrColumn)child.clone();
                cloneColumn.addColumn(cloneChild);
            }
        }
        if ((cellObj = this.getCellObj()) != null) {
            cloneColumn.setCellObj((SJctrColumnCellObject)cellObj.clone());
        }
        if ((linkAction = this.getLinkAction()) != null) {
            cloneColumn.setLinkAction((SJctrColumnLinkAction)linkAction.clone());
        }
        return cloneColumn;
    }

    protected void clear() {
        this.childColumn = null;
        this.cellObj = null;
        this.linkAction = null;
        this.myComparator = null;
    }

    public String getScreenId() {
        return this.screenId;
    }

    public void setScreenId(String id) {
        this.screenId = id;
    }

    public String getPartsId() {
        return this.partsId;
    }

    public void setPartsId(String id) {
        this.partsId = id;
    }

    public SJctrColumnCellObject getCellObj() {
        return this.cellObj;
    }

    public void setCellObj(SJctrColumnCellObject cellObj) {
        this.cellObj = cellObj;
        if (this.cellObj != null) {
            this.cellObj.setColumn(this);
        }
    }

    public SJctrColumnLinkAction getLinkAction() {
        return this.linkAction;
    }

    public void setLinkAction(SJctrColumnLinkAction linkAction) {
        this.linkAction = linkAction;
        if (this.linkAction != null) {
            this.linkAction.setColumn(this);
        }
    }

    public boolean getShowColumn() {
        return this.showColumn;
    }

    public boolean getShowColumnDefault() {
        boolean ret = this.showColumnDefault;
        if (!this.supportColumn) {
            ret = false;
        }
        return ret;
    }

    public void setShowColumn(boolean showColumn) {
        this.showColumn = showColumn;
    }

    public void setShowColumnDefault(boolean showColumn) {
        this.showColumnDefault = showColumn;
    }

    public void setShowColumnDefault(boolean showColumn, boolean gettingColumnData) {
        this.showColumnDefault = showColumn;
        this.gettingHiddenColumnData = gettingColumnData;
    }

    public boolean getGettingColumnData() {
        return this.gettingColumnData;
    }

    public boolean getGettingHiddenColumnData() {
        return this.gettingHiddenColumnData;
    }

    public void setGettingColumnData(boolean gettingColumnData) {
        this.gettingColumnData = gettingColumnData;
    }

    public void setGettingHiddenColumnData(boolean gettingHiddenColumnData) {
        this.gettingHiddenColumnData = gettingHiddenColumnData;
    }

    public boolean getShowColumnAlways() {
        return this.showColumnAlways;
    }

    public void setShowColumnAlways(boolean showColumn) {
        this.showColumnAlways = showColumn;
    }

    public boolean getSupportColumn() {
        return this.supportColumn;
    }

    public void setSupportColumn(boolean supportColumn) {
        this.supportColumn = supportColumn;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(FORMAT_HEX1_8);
        set.add(FORMAT_HEX1_6);
        set.add(FORMAT_HEX1_4);
        set.add(FORMAT_HEX1_3);
        set.add(FORMAT_HEX1_2);
        set.add(FORMAT_HEX8);
        set.add(FORMAT_HEX6);
        set.add("^([0-9A-Fa-f]{4})$");
        set.add(FORMAT_HEX3);
        set.add(FORMAT_HEX2);
        set.add(FORMAT_HEX1);
        set.add("^([0-9A-Fa-f]{4})$");
        formatHexSet = Collections.unmodifiableSet(set);
        FILTER_TIME_DEFAULT_SEP_LIST = new ArrayList<String>(3);
        FILTER_TIME_DEFAULT_SEP_LIST.add(FILTER_TIME_DEFAULT_SEP);
        FILTER_TIME_DEFAULT_SEP_LIST.add(FILTER_TIME_DEFAULT_SEP);
        FILTER_TIME_DEFAULT_SEP_LIST.add("");
    }

    private class SJctrFilterUnitLessEqual
    extends SJctrFilterUnitEqual {
        public SJctrFilterUnitLessEqual(long num, String str, String unitStr) {
            super(num, str, unitStr);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getFilterUnitNumber(rowData, this.unit);
            if (targetNum < 0L) {
                return false;
            }
            if (targetNum <= this.numValue) {
                return true;
            }
            return this.equalsString(targetNum);
        }
    }

    private class SJctrFilterUnitGraterEqual
    extends SJctrFilterUnitEqual {
        public SJctrFilterUnitGraterEqual(long num, String str, String unitStr) {
            super(num, str, unitStr);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getFilterUnitNumber(rowData, this.unit);
            if (targetNum < 0L) {
                return false;
            }
            if (targetNum >= this.numValue) {
                return true;
            }
            return this.equalsString(targetNum);
        }
    }

    private class SJctrFilterUnitLess
    extends SJctrFilterUnitEqual {
        public SJctrFilterUnitLess(long num, String str, String unitStr) {
            super(num, str, unitStr);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getFilterUnitNumber(rowData, this.unit);
            return targetNum >= 0L && targetNum < this.numValue;
        }
    }

    private class SJctrFilterUnitGrater
    extends SJctrFilterUnitEqual {
        public SJctrFilterUnitGrater(long num, String str, String unitStr) {
            super(num, str, unitStr);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getFilterUnitNumber(rowData, this.unit);
            return targetNum >= 0L && targetNum > this.numValue;
        }
    }

    private class SJctrFilterUnitEqual
    implements SJctrFilter {
        protected final long numValue;
        protected final String strValue;
        protected final SJctrCapacityUtility.UNIT unit;
        private final SJctrCapacityUtility util;

        public SJctrFilterUnitEqual(long num, String str, String unitStr) {
            this.numValue = num;
            this.unit = SJctrCapacityUtility.UNIT.valueOf(unitStr);
            this.util = SJctrColumn.this.getTable().getComUtility().getCapacityUtility();
            BigDecimal bd = new BigDecimal(str);
            str = bd.toString();
            this.strValue = this.isIntegralUnit(this.unit) ? this.removeDecimalPoint(str) : this.addDecimalPoint(str);
        }

        private boolean isIntegralUnit(SJctrCapacityUtility.UNIT checkUnit) {
            long baseValue = 1L;
            return 1L == this.util.valueOf(1L, checkUnit);
        }

        private String removeDecimalPoint(String str) {
            String retStr = str;
            int index = str.indexOf(46);
            if (index >= 0) {
                retStr = str.substring(0, index);
            }
            return retStr;
        }

        private String addDecimalPoint(String str) {
            StringBuilder buf = new StringBuilder(str);
            int index = str.indexOf(46);
            if (index < 0) {
                buf.append('.');
            }
            buf.append("00");
            index = buf.indexOf(".");
            return buf.substring(0, index + 3);
        }

        protected boolean equalsString(long num) {
            String targetString = this.util.toString(num, this.unit);
            return targetString.equals(this.strValue);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getFilterUnitNumber(rowData, this.unit);
            return targetNum >= 0L && this.equalsString(targetNum);
        }
    }

    private class SJctrFilterObjectLessEqual
    extends SJctrFilterObject {
        public SJctrFilterObjectLessEqual(Object obj, Comparator<Object> comp) {
            super(obj, comp);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            Object targetObj = SJctrColumn.this.getObject(rowData);
            return this.comparator.compare(targetObj, this.value) <= 0;
        }
    }

    private class SJctrFilterObjectGraterEqual
    extends SJctrFilterObject {
        public SJctrFilterObjectGraterEqual(Object obj, Comparator<Object> comp) {
            super(obj, comp);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            Object targetObj = SJctrColumn.this.getObject(rowData);
            return this.comparator.compare(targetObj, this.value) >= 0;
        }
    }

    private class SJctrFilterObjectLess
    extends SJctrFilterObject {
        public SJctrFilterObjectLess(Object obj, Comparator<Object> comp) {
            super(obj, comp);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            Object targetObj = SJctrColumn.this.getObject(rowData);
            return this.comparator.compare(targetObj, this.value) < 0;
        }
    }

    private class SJctrFilterObjectGrater
    extends SJctrFilterObject {
        public SJctrFilterObjectGrater(Object obj, Comparator<Object> comp) {
            super(obj, comp);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            Object targetObj = SJctrColumn.this.getObject(rowData);
            return this.comparator.compare(targetObj, this.value) > 0;
        }
    }

    private class SJctrFilterObjectEqual
    extends SJctrFilterObject {
        public SJctrFilterObjectEqual(Object obj, Comparator<Object> comp) {
            super(obj, comp);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            Object targetObj = SJctrColumn.this.getObject(rowData);
            return this.comparator.compare(targetObj, this.value) == 0;
        }
    }

    private abstract class SJctrFilterObject
    implements SJctrFilter {
        protected final Object value;
        protected final Comparator<Object> comparator;

        public SJctrFilterObject(Object obj, Comparator<Object> comp) {
            this.value = obj;
            this.comparator = comp;
        }
    }

    private class SJctrFilterNumberLessEqual
    extends SJctrFilterNumber {
        public SJctrFilterNumberLessEqual(long num) {
            super(num);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getNumber(rowData);
            return targetNum <= this.value;
        }
    }

    private class SJctrFilterNumberGraterEqual
    extends SJctrFilterNumber {
        public SJctrFilterNumberGraterEqual(long num) {
            super(num);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getNumber(rowData);
            return targetNum >= this.value;
        }
    }

    private class SJctrFilterNumberLess
    extends SJctrFilterNumber {
        public SJctrFilterNumberLess(long num) {
            super(num);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getNumber(rowData);
            return targetNum < this.value;
        }
    }

    private class SJctrFilterNumberGrater
    extends SJctrFilterNumber {
        public SJctrFilterNumberGrater(long num) {
            super(num);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getNumber(rowData);
            return targetNum > this.value;
        }
    }

    private class SJctrFilterNumberEqual
    extends SJctrFilterNumber {
        public SJctrFilterNumberEqual(long num) {
            super(num);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            long targetNum = SJctrColumn.this.getNumber(rowData);
            return targetNum == this.value;
        }
    }

    private abstract class SJctrFilterNumber
    implements SJctrFilter {
        protected final long value;

        public SJctrFilterNumber(long num) {
            this.value = num;
        }
    }

    private class SJctrFilterStringEndWith
    extends SJctrFilterString {
        private final int length;

        public SJctrFilterStringEndWith(String str) {
            super(str);
            this.length = str.length();
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            String targetString = SJctrColumn.this.getString(rowData);
            return targetString.regionMatches(true, targetString.length() - this.length, this.value, 0, this.length);
        }
    }

    private class SJctrFilterStringStartWith
    extends SJctrFilterString {
        private final int length;

        public SJctrFilterStringStartWith(String str) {
            super(str);
            this.length = str.length();
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            String targetString = SJctrColumn.this.getString(rowData);
            return targetString.regionMatches(true, 0, this.value, 0, this.length);
        }
    }

    private class SJctrFilterStringIs
    extends SJctrFilterString {
        public SJctrFilterStringIs(String str) {
            super(str);
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            String targetString = SJctrColumn.this.getString(rowData);
            return targetString.equalsIgnoreCase(this.value);
        }
    }

    private class SJctrFilterStringContains
    extends SJctrFilterString {
        public SJctrFilterStringContains(String str) {
            super(str.toUpperCase());
        }

        @Override
        public boolean include(Map<String, Object> rowData) {
            String targetString = SJctrColumn.this.getString(rowData).toUpperCase();
            return targetString.contains(this.value);
        }
    }

    private abstract class SJctrFilterString
    implements SJctrFilter {
        protected final String value;

        public SJctrFilterString(String str) {
            this.value = str;
        }
    }
}

