/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.column.SJctrGetColumnIconCellObject;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgScatteredInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolVolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrPoolEnlargementFactorFMCColumnFromPoolDetail
extends SJctrColumn
implements SJctrGetColumnIconCellObject.SJctrColumnGetIconIdIF {
    private int iconId = 12295;

    public SJctrPoolEnlargementFactorFMCColumnFromPoolDetail(String key) {
        super(key);
        this.setPartsId("ENLARGE_FACT");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJmoGetPoolDetail.class);
        alList.add(SJmoGetLdevDetail.class);
        alList.add(SJmoGetPoolVolDetail.class);
        alList.add(SJmoGetPgDetail.class);
        alList.add(SJmoGetVdevDetail.class);
        alList.add(SJmoGetPgScatteredInfo.class);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)index;
        List<SJmoPoolVolDetail> poolVolDtlList = basicData.get(SJmoGetPoolVolDetail.class);
        List<SJmoLdevDetail> ldevDtlList = basicData.get(SJmoGetLdevDetail.class);
        List<SJmoPgDetail> pgDtlList = basicData.get(SJmoGetPgDetail.class);
        List<SJmoVdevDetail> vdevDtlLst = basicData.get(SJmoGetVdevDetail.class);
        List<SJmoPgScatteredInfo> scPgInfoList = basicData.get(SJmoGetPgScatteredInfo.class);
        SJctrPoolUtility poolUtil = this.getTable().getComUtility().getPoolUtility();
        int iconId = poolUtil.getPoolCapExpantionRateIconId(poolDtl, poolVolDtlList, ldevDtlList, pgDtlList, vdevDtlLst, scPgInfoList);
        this.setIconId(iconId);
        return super.getNeedModelData(index, basicData);
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList != null && !dataList.isEmpty()) {
            Object obj = dataList.get(0);
            if (obj != null && obj instanceof SJmoPoolDetail) {
                SJmoPoolDetail poolDtl = (SJmoPoolDetail)obj;
                SJctrComUtility comUtl = this.getTable().getComUtility();
                SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
                String strClmUnit = this.getTable().getUnitMenu();
                strRtn = poolUtl.toPoolFMCEnlargementFactor(poolDtl, comUtl, strClmUnit);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "obj = " + obj);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList = " + dataList);
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        String strClmUnit;
        long lCrntEnlargeFact = 0L;
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
        String strCrntPoolCapa = poolUtl.toPoolFMCEnlargementFactor(poolDtl, comUtl, strClmUnit = this.getTable().getUnitMenu());
        if (strCrntPoolCapa.equals("?")) {
            lCrntEnlargeFact = -2L;
        } else if (strCrntPoolCapa.equals(SJctrPoolUtility.HAIFUN_STR)) {
            lCrntEnlargeFact = SJctrPoolUtility.HAIFUN_NUM;
        } else {
            try {
                lCrntEnlargeFact = Long.parseLong(strCrntPoolCapa);
            }
            catch (NumberFormatException e) {
                lCrntEnlargeFact = -2L;
            }
        }
        return lCrntEnlargeFact;
    }

    @Override
    public void setIconId(int iconId) {
        this.iconId = iconId;
    }

    @Override
    public int getIconId() {
        return this.iconId;
    }
}

