/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumnLinkAction;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public abstract class SJctrPoolLinkActionFromLdevDetail
extends SJctrColumnLinkAction {
    @Override
    public List<Object> doLinkAction(Map<String, Object> lineMap) {
        ArrayList<Object> linkActionList = new ArrayList<Object>();
        int poolID = this.getPoolID(lineMap);
        Map<Class<?>, List<?>> basicDataMap = this.getColumn().getTable().getBasicDataMap();
        this.checkSelectedPoolRs(basicDataMap, poolID);
        linkActionList.add(SJctrDataController.NOTIFY_STATE.MOVE_LISTVIEW);
        linkActionList.add(this.getNextDC());
        linkActionList.add(poolID);
        return linkActionList;
    }

    protected SJmoRSGgetAllRsgs getRsgInfo(Map<Class<?>, List<?>> basicDataMap) {
        List<?> rsgInfoList = basicDataMap.get(SJmoGetRSGgetAllRsgs.class);
        if (null == rsgInfoList || rsgInfoList.isEmpty()) {
            SJctrError err = new SJctrError(this.getFunc(), this.getModule(), 107001);
            throw err.createException();
        }
        SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)rsgInfoList.get(0);
        if (null == rsgInfo) {
            SJctrError err = new SJctrError(this.getFunc(), this.getModule(), 107001);
            throw err.createException();
        }
        return rsgInfo;
    }

    protected List<SJmoPoolDetail> getSelectedPoolDtlList(Map<Class<?>, List<?>> basicDataMap, int poolId) {
        List<?> poolDtlList = basicDataMap.get(SJmoGetPoolDetail.class);
        if (null == poolDtlList) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getPoolDtlList", "Pool detail list is null.");
            SJctrError err = new SJctrError(this.getFunc(), this.getModule(), 107001);
            throw err.createException();
        }
        SJmoPoolIndex poolIndex = new SJmoPoolIndex();
        poolIndex.setPoolId(poolId);
        int index = Collections.binarySearch(poolDtlList, poolIndex);
        if (index < 0) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getPoolDtlList", "Selected pool is not found.");
            throw new SJctrError(this.getFunc(), this.getModule(), this.getNotExistError()).createException();
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDtlList.get(index);
        ArrayList<SJmoPoolDetail> retList = new ArrayList<SJmoPoolDetail>(1);
        retList.add(poolDtl);
        return retList;
    }

    protected List<SJmoLdevDetail> getLdevDtlList(Map<Class<?>, List<?>> basicDataMap) {
        List<SJmoLdevDetail> ldevDtlList = basicDataMap.get(SJmoGetLdevDetail.class);
        if (null == ldevDtlList) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSJmoLdevDetail", "LDEV detail list is null.");
            SJctrError err = new SJctrError(this.getFunc(), this.getModule(), 107001);
            throw err.createException();
        }
        return ldevDtlList;
    }

    protected void checkSelectedPoolRs(Map<Class<?>, List<?>> basicDataMap, int poolId) {
        SJmoRSGgetAllRsgs rsgInfo;
        SJctrUserController user;
        List<SJmoPoolDetail> poolDtlList = this.getSelectedPoolDtlList(basicDataMap, poolId);
        List<SJmoLdevDetail> ldevDtlList = this.getLdevDtlList(basicDataMap);
        if ((poolDtlList = SJctrPoolUtility.extractAvailablePoolList(poolDtlList, ldevDtlList, user = this.getColumn().getTable().getDataController().getOwner(), rsgInfo = this.getRsgInfo(basicDataMap))).isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkSelectedPoolRs", "Selected pool is not authorized.");
            throw new SJctrError(this.getFunc(), this.getModule(), this.getResourceError()).createException();
        }
    }

    protected abstract int getFunc();

    protected abstract int getModule();

    protected abstract int getNotExistError();

    protected abstract int getResourceError();

    protected abstract Class<? extends SJctrDataController> getNextDC();

    protected abstract int getPoolID(Map<String, Object> var1);
}

