/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrVVolReservedCapacityColumnFromLdevDetailColumn
extends SJctrCapacityColumn {
    public SJctrVVolReservedCapacityColumnFromLdevDetailColumn(String key) {
        super(key);
        this.setPartsId("RESERVED_CAP");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJmoGetHDPRelation.class);
        return alList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoHDPRelation> dataList = new ArrayList<SJmoHDPRelation>();
        ArrayList hdpRelList = new ArrayList(modelData.get(SJmoGetHDPRelation.class));
        int iIndex = Collections.binarySearch(hdpRelList, index);
        if (iIndex >= 0) {
            SJmoHDPRelation hdpRelData = (SJmoHDPRelation)hdpRelList.get(iIndex);
            dataList.add(hdpRelData);
        }
        return dataList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        if (dataList.size() != 0) {
            SJmoHDPRelation hdpRelData = (SJmoHDPRelation)dataList.get(0);
            String strCapaUnit = this.getUnitSelect();
            SJctrComUtility comUtil = this.getTable().getComUtility();
            strRtn = this.getTable().getComUtility().getPoolUtility().toVVollReservedCapacityDisplay(hdpRelData, strCapaUnit, comUtil);
        }
        return strRtn;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long ret = this.getPageNumber(dat);
        if (ret >= 0L) {
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
            Map<Class<?>, List<?>> basicMap = this.getTable().getBasicDataMap();
            List<?> dpVolList = this.getNeedModelData(ldevDetail, basicMap);
            SJmoHDPRelation dpVolDetail = (SJmoHDPRelation)dpVolList.get(0);
            int emuType = dpVolDetail.getIEmulationType();
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
            SJctrCapacityUtility capaUtil = comUtl.getCapacityUtility();
            emuType = poolUtl.changeEmulationType(emuType);
            long dpVolPageSize = dpVolDetail.getLPageCapa();
            long lDpVolCapa = ret * dpVolPageSize;
            ret = capaUtil.valueOf(lDpVolCapa, SJctrCapacityUtility.UNIT.KB, emuType);
        }
        return ret;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        long retValue = -2L;
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        if (ldevDetail == null) {
            return retValue;
        }
        Map<Class<?>, List<?>> basicMap = this.getTable().getBasicDataMap();
        List<?> dpVolList = this.getNeedModelData(ldevDetail, basicMap);
        if (!dpVolList.isEmpty()) {
            SJmoHDPRelation dpVolDetail = (SJmoHDPRelation)dpVolList.get(0);
            if (dpVolDetail == null) {
                return retValue;
            }
            retValue = dpVolDetail.getLReservedPage();
        }
        return retValue;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long ret = this.getNumber(dat);
        if (ret >= 0L) {
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
            SJctrCapacityUtility capaUtil = comUtl.getCapacityUtility();
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
            Map<Class<?>, List<?>> basicMap = this.getTable().getBasicDataMap();
            List<?> dpVolList = this.getNeedModelData(ldevDetail, basicMap);
            SJmoHDPRelation dpVolDetail = (SJmoHDPRelation)dpVolList.get(0);
            int emuType = dpVolDetail.getIEmulationType();
            emuType = poolUtl.changeEmulationType(emuType);
            ret = capaUtil.toCylValue(ret, emuType);
        }
        return ret;
    }
}

