/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrVssModelSNoPgColumnFromVirtualDKC
extends SJctrColumn {
    public SJctrVssModelSNoPgColumnFromVirtualDKC(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("VDKC"));
    }

    @Override
    public int getFilterType() {
        return 1;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<SJmoHUVMVirtualDkc> rtn = new ArrayList<SJmoHUVMVirtualDkc>();
        SJmoPgIndex pgIndex = (SJmoPgIndex)index;
        List<?> allRsgsList = basicData.get(SJmoGetRSGgetAllRsgs.class);
        if (allRsgsList != null && allRsgsList.size() > 0) {
            int vBoxIndex;
            SJmoRSGgetRsg rsg = SJctrArrayGroupUtility.getBelongToRsg(pgIndex, ((SJmoRSGgetAllRsgs)allRsgsList.get(0)).getRsgs());
            SJmoHUVMvboxIndex targetIndex = rsg.getRsgInfo().getVboxIndex();
            List<?> VboxList = basicData.get(SJmoGetHUVMVirtualDkc.class);
            if (VboxList != null && (vBoxIndex = Collections.binarySearch(VboxList, targetIndex)) >= 0) {
                SJmoHUVMVirtualDkc VssDkc = (SJmoHUVMVirtualDkc)VboxList.get(vBoxIndex);
                rtn.add(VssDkc);
            }
        }
        return rtn;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetRSGgetAllRsgs.class);
        list.add(SJmoGetHUVMVirtualDkc.class);
        return list;
    }

    @Override
    public int getSortType() {
        return 0;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String rtn = "? / ?";
        if (dataList != null && dataList.size() > 0) {
            SJmoHUVMVirtualDkc wkDkc = (SJmoHUVMVirtualDkc)dataList.get(0);
            rtn = this.getTable().getComUtility().getRsgUtility().toDispStringVssModelSerialNo(wkDkc);
        }
        return rtn;
    }
}

