/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.iscsi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;

public class SJctrUsageColumnFromIscsiTargetPathInfo
extends SJctrColumn {
    private int LIST_ISCSI_PATH = 0;
    private int LIST_EXD_PATH_GROUP_MGR = 1;

    public SJctrUsageColumnFromIscsiTargetPathInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("ISCSI_TARGET_PATH_USED"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdTargetPortInfoMgr.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> retList = new ArrayList<Object>(2);
        SJmoIscsiTargetPathInfo iscsiPathInfo = (SJmoIscsiTargetPathInfo)index;
        retList.add(iscsiPathInfo);
        List<?> exdPathGrouMgr = modelData.get(SJmoGetExdTargetPortInfoMgr.class);
        retList.add(exdPathGrouMgr);
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (null != dataList && dataList.size() != 0) {
            SJmoIscsiTargetPathInfo iscsiPathInfo = (SJmoIscsiTargetPathInfo)dataList.get(this.LIST_ISCSI_PATH);
            List exdPathGroupMgr = (List)dataList.get(this.LIST_EXD_PATH_GROUP_MGR);
            if (null != exdPathGroupMgr && exdPathGroupMgr.size() != 0) {
                ArrayList pathGrpList = ((SJmoExdTargetPortInfoMgr)exdPathGroupMgr.get(0)).getAlExdTargetPortInfo();
                boolean usePathGrp = SJctrIscsiUtility.isUsedUvmIscsiPath(iscsiPathInfo, pathGrpList);
                SJctrIscsiUtility iscsiUty = this.getTable().getComUtility().getIscsiUtility();
                ret = iscsiUty.getIscsiPathUsageString(usePathGrp);
            }
        }
        return ret;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

