/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrQSPoolUsedCapacityColumnFromPairVolInfo
extends SJctrCapacityColumn {
    Map<SJmoLocalReplicationPairVolInfo, Long> blockSizeMap = null;
    Map<SJmoLocalReplicationPairVolInfo, SJmoLdevDetail> ldevDtlMap = null;
    Map<SJmoLocalReplicationPairVolInfo, Long> pageSizeMap = null;

    public SJctrQSPoolUsedCapacityColumnFromPairVolInfo(String key) {
        super(key);
        this.setPartsId("POOLCAP_USED");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetLdevDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<SJmoModelData_Base> list = new ArrayList<SJmoModelData_Base>(2);
        SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)index;
        List<?> ldevDtlList = basicData.get(SJmoGetLdevDetail.class);
        List<?> poolDtlList = basicData.get(SJmoGetPoolDetail.class);
        list.add(pairInfo);
        int target = Collections.binarySearch(ldevDtlList, pairInfo);
        if (target >= 0) {
            list.add((SJmoModelData_Base)ldevDtlList.get(target));
        }
        SJmoLocalReplicationPairVolInfoMgr pairVolMgr = (SJmoLocalReplicationPairVolInfoMgr)basicData.get(SJmoGetLocalReplicationPairVolInfoMgr.class).get(0);
        ArrayList<? extends SJmoLdevIndex> sVolList = pairInfo.getAlSVolIndex();
        for (SJmoLdevIndex sJmoLdevIndex : sVolList) {
            SJmoLocalReplicationPairVolInfo sVolPairInfo = pairVolMgr.getLocalReplicationPairVolInfo(sJmoLdevIndex);
            if (sVolPairInfo == null || !sVolPairInfo.isVolPos(0x800000)) continue;
            SJmoPoolIndex poolIndex = new SJmoPoolIndex();
            poolIndex.setPoolId(sVolPairInfo.getISVolPoolId());
            int searchIndex = Collections.binarySearch(poolDtlList, poolIndex);
            if (searchIndex < 0) break;
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDtlList.get(searchIndex);
            list.add(poolDtl);
            break;
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        String strCapaUnit = "";
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrCapacityUtility capaUtil = comUtl.getCapacityUtility();
        SJmoDataChange dataChange = comUtl.getDataChangeTable();
        if (this.blockSizeMap == null) {
            this.blockSizeMap = new HashMap<SJmoLocalReplicationPairVolInfo, Long>(this.getTable().getRowCount());
        }
        if (this.ldevDtlMap == null) {
            this.ldevDtlMap = new HashMap<SJmoLocalReplicationPairVolInfo, SJmoLdevDetail>(this.getTable().getRowCount());
        }
        if (this.pageSizeMap == null) {
            this.pageSizeMap = new HashMap<SJmoLocalReplicationPairVolInfo, Long>(this.getTable().getRowCount());
        }
        strCapaUnit = this.getUnitSelect();
        if (dataList != null && dataList.size() == 3) {
            SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)dataList.get(0);
            SJmoLdevDetail ldevDtl = (SJmoLdevDetail)dataList.get(1);
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)dataList.get(2);
            Long blocCap = this.blockSizeMap.get(pairInfo);
            if (blocCap == null) {
                int emuType = ldevDtl.getIEmulationType();
                String emuName = dataChange.getEmulationTypeName(emuType);
                int slotSize = dataChange.getEmuSlotSize(emuName);
                long poolUsedCapSlot = pairInfo.getLPVolUsedPool();
                long usedCap_KB = poolUsedCapSlot * (long)slotSize;
                blocCap = capaUtil.valueOf(usedCap_KB, SJctrCapacityUtility.UNIT.KB, emuType);
                this.blockSizeMap.put(pairInfo, blocCap);
                this.ldevDtlMap.put(pairInfo, ldevDtl);
                long usedSlot = pairInfo.getLPVolUsedPool();
                short poolGrainSize = poolDtl.getPoolGrainSize();
                long pageSize = usedSlot / (long)poolGrainSize;
                this.pageSizeMap.put(pairInfo, pageSize);
            }
            strCapaUnit = this.getUnitSelect();
            SJctrCapacityUtility.UNIT clmUnit = SJctrCapacityUtility.UNIT.valueOf(strCapaUnit);
            StringBuilder buf = new StringBuilder();
            if (clmUnit.equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
                Long pageSize = this.pageSizeMap.get(pairInfo);
                if (pageSize != null) {
                    buf.append(pageSize);
                }
            } else {
                buf.append(capaUtil.toString(blocCap, clmUnit));
            }
            buf.append(" ");
            buf.append(capaUtil.getUnitString(clmUnit));
            strRtn = buf.toString();
        }
        return strRtn;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lPoolBlock = -1L;
        SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)this.getPrimaryKeyObject(dat);
        Long getValue = this.blockSizeMap.get(pairInfo);
        if (getValue != null) {
            lPoolBlock = getValue;
        }
        return lPoolBlock;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        long cylinderSize = -1L;
        SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
        SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)this.getPrimaryKeyObject(dat);
        Long getValue = this.blockSizeMap.get(pairInfo);
        SJmoLdevDetail ldevDtl = this.ldevDtlMap.get(pairInfo);
        if (getValue != null && ldevDtl != null) {
            cylinderSize = capaUtil.toCylValue((long)getValue, ldevDtl.getIEmulationType());
        }
        return cylinderSize;
    }

    @Override
    protected long getPageNumber(Map<String, Object> dat) {
        SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)this.getPrimaryKeyObject(dat);
        long retValue = this.pageSizeMap.get(pairInfo);
        return retValue;
    }

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    public int getSortType() {
        return 1;
    }
}

