/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdTargetPortInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdTargetPortInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdTargetPortInfoMgr;

public class SJctrVirtualPortIDColumnFromExdPhysicalPathInfo
extends SJctrColumn {
    protected Map<String, Integer> stVPortIDMap = null;

    public SJctrVirtualPortIDColumnFromExdPhysicalPathInfo(String key) {
        super(key);
        this.setPartsId("VIRTUAL_PORT_ID");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdTargetPortInfoMgr.class);
        list.add(SJmoGetPortDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        if (this.stVPortIDMap == null) {
            this.stVPortIDMap = new HashMap<String, Integer>();
        }
        ArrayList<SJmoExdTargetPortInfo> list = new ArrayList<SJmoExdTargetPortInfo>();
        SJmoExdPhysicalPathInfo physicalPath = (SJmoExdPhysicalPathInfo)index;
        List<SJmoPortDetail> portDtlList = modelData.get(SJmoGetPortDetail.class);
        SJmoPortDetail portDtl = SJctrExtUtility.getPortDtlFromPhysicalPathInfo(physicalPath, portDtlList);
        if (portDtl == null) {
            list.add(null);
        } else {
            int targetPortID = physicalPath.getRmiExdPhysicalPathInfo().referTargetPortId();
            SJmoExdTargetPortInfoMgr targetPortMgr = (SJmoExdTargetPortInfoMgr)modelData.get(SJmoGetExdTargetPortInfoMgr.class).get(0);
            SJmoExdTargetPortInfo targetPortInfo = targetPortMgr.getExdTargetPortInfo(targetPortID);
            if (1 == portDtl.getIVPortMode()) {
                list.add(targetPortInfo);
            }
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        int iVPortID = -2;
        if (dataList.isEmpty()) {
            ret = SJctrPortUtility.STR_HYPHEN;
            iVPortID = -1;
        } else {
            SJmoExdTargetPortInfo targetPort = (SJmoExdTargetPortInfo)dataList.get(0);
            if (targetPort != null) {
                String strWWN = targetPort.getRmiExdTargetPortInfo().getDispTargetPortAddress();
                iVPortID = SJctrExtUtility.getIscsiVirtualPortId(strWWN);
                ret = String.valueOf(iVPortID);
            }
        }
        this.stVPortIDMap.put(ret, iVPortID);
        return ret;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int vPortID = -1;
        String strNum = this.getString(dat);
        if (this.stVPortIDMap.containsKey(strNum)) {
            vPortID = this.stVPortIDMap.get(strNum);
        }
        return vPortID;
    }
}

