/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.arraygroup;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility;
import sanproject.sn2.controller.topwindow.ldev.SJctrLdevSummaryModel;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrFreeDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPgVerifyStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetVdevDetail;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.sn2com.execapp.SJappDefConst;

public class SJctrPgSummaryModel
extends SJctrSimpleDataModel
implements SJctrCVSMacro {
    @Override
    public void makeDataObject() {
        ArrayList<SJctrPGDetail> pgList = new ArrayList<SJctrPGDetail>();
        List<Object> pgDetailList = this.getBasicDataList(SJmoGetPgDetail.class);
        List<SJmoGetVdevDetail> VdevDetailList = this.getBasicDataList(SJmoGetVdevDetail.class);
        List<SJmoGetPdevDetail> pdevDetailList = this.getBasicDataList(SJmoGetPdevDetail.class);
        List<SJmoGetRSGgetAllRsgs> allRsgsList = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
        if (allRsgsList.size() > 0) {
            pgDetailList = SJctrArrayGroupUtility.extractAvailablePgList(pgDetailList, (SJmoRSGgetAllRsgs)((Object)allRsgsList.get(0)), this.getDataController().getOwner());
        }
        for (int i = 0; i < pgDetailList.size(); ++i) {
            SJmoPgDetail wkpg = (SJmoPgDetail)((Object)pgDetailList.get(i));
            SJctrPGDetail pg = new SJctrPGDetail(wkpg.getFB4(), wkpg.getPG());
            pg.setBasicDataList(pgDetailList, VdevDetailList, null, null);
            pg.setPDEVList(pdevDetailList);
            pgList.add(pg);
        }
        long lFreeSize_Internal = 0L;
        long lTotalSize_Internal = 0L;
        long lFreeSize_External = 0L;
        long lTotalSize_External = 0L;
        for (int i = 0; i < pgList.size(); ++i) {
            SJctrPGDetail pg = (SJctrPGDetail)pgList.get(i);
            String selFolder = SJctrArrayGroupUtility.createFolderName(pg.getFB4());
            if (selFolder.equals("INTERNAL")) {
                lTotalSize_Internal += pg.getAllTotalLBA();
            } else if (selFolder.equals("EXTERNAL")) {
                lTotalSize_External += pg.getAllTotalLBA();
            }
            ArrayList freeList = pg.getAllFreeData();
            for (int j = 0; j < freeList.size(); ++j) {
                SJctrFreeDetail free = (SJctrFreeDetail)freeList.get(j);
                long l = free.getRemainingTotalLBA() / 2L;
                if (selFolder.equals("INTERNAL")) {
                    lFreeSize_Internal += l * 2L;
                    continue;
                }
                if (!selFolder.equals("EXTERNAL")) continue;
                lFreeSize_External += l * 2L;
            }
        }
        int SSD_Total = 0;
        int SAS_Total = 0;
        int SSD_SAS_Total = 0;
        for (SJmoPdevDetail sJmoPdevDetail : pdevDetailList) {
            for (SJmoPgDetail sJmoPgDetail : pgDetailList) {
                if (sJmoPdevDetail.getFB4() != sJmoPgDetail.getFB4() || sJmoPdevDetail.getPG() != sJmoPgDetail.getPG()) continue;
                if (sJmoPdevDetail.getDriveType() == 5 || sJmoPdevDetail.getDriveType() == 9) {
                    ++SSD_Total;
                    break;
                }
                if (sJmoPdevDetail.getDriveType() != 0) break;
                ++SAS_Total;
                break;
            }
            if (sJmoPdevDetail.getFB4() == -1 && sJmoPdevDetail.getPG() == -1) {
                if (sJmoPdevDetail.getDriveType() == 5 || sJmoPdevDetail.getDriveType() == 9) {
                    ++SSD_Total;
                } else if (sJmoPdevDetail.getDriveType() == 0) {
                    ++SAS_Total;
                }
            }
            SSD_SAS_Total = SSD_Total + SAS_Total;
        }
        ((SJctrDataObject)this.getManageData()).setData("COM_INT_FREE_CAP", this.getCapacity(lFreeSize_Internal));
        ((SJctrDataObject)this.getManageData()).setData("COM_INT_TOTAL_CAP", this.getCapacity(lTotalSize_Internal));
        ((SJctrDataObject)this.getManageData()).setData("COM_EXT_FREE_CAP", this.getCapacity(lFreeSize_External));
        ((SJctrDataObject)this.getManageData()).setData("COM_EXT_TOTAL_CAP", this.getCapacity(lTotalSize_External));
        ((SJctrDataObject)this.getManageData()).setData("COM_SSD", Integer.toString(SSD_Total));
        ((SJctrDataObject)this.getManageData()).setData("COM_SAS", Integer.toString(SAS_Total));
        ((SJctrDataObject)this.getManageData()).setData("COM_SASSSD_NUM", Integer.toString(SSD_SAS_Total));
        ((SJctrDataObject)this.getManageData()).setData("COM_PROGRESS", SJctrLdevSummaryModel.getDispStringProg(this));
        String[] verifyResultFileInfo = SJctrLdevSummaryModel.getVerifyResultFileInfo(this.getDataController());
        ((SJctrDataObject)this.getManageData()).setData("COM_VERIFY_FILE", verifyResultFileInfo[0].equals("") ? "" : SJappDefConst.URL_BASEHEAD + SJcEnvUty.getDkcRootName() + "/" + "verify" + "/" + verifyResultFileInfo[0]);
        ((SJctrDataObject)this.getManageData()).setData("COM_VERIFY_MODTIME", verifyResultFileInfo[1]);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetPgDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetVdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgVerifyStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    private String getCapacity(long lCap) {
        SJctrCapacityUtility.UNIT unit = this.getComUtility().getCapacityUtility().getUnit(lCap);
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        StringBuilder buf = new StringBuilder(util.toString(lCap, unit, 0));
        buf.append(" ");
        buf.append(util.getUnitString(unit));
        return buf.toString();
    }
}

