/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.comdialog.colsetting.data;

import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;

public class SJctrColumnSettingsData {
    private SJctrColumn _col;
    private String columnLabel;
    private String columnKey;
    private String fullPathKey;
    private boolean showColumn;
    private boolean showColumnDefault;
    private boolean showColumnAlways;
    private String columnDisplayName;
    private int checkSelect;
    private int checkVisible;
    private static final Integer valOff = SJctrSelectableDataObject.SEL_OFF;
    private static final Integer valOn = SJctrSelectableDataObject.SEL_ON;
    private static final int valEnable = SJctrSelectableDataObject.VISIBLE_ACTIVE;
    private static final int valDisable = SJctrSelectableDataObject.VISIBLE_INACTIVE;
    public static final String DELIMITER = "\t";

    public SJctrColumnSettingsData(SJctrTableDataModel table, SJctrColumn column, boolean initColumnSettings) {
        this._col = column;
        boolean init = initColumnSettings;
        this.columnLabel = this._col.getLabel();
        this.columnKey = this._col.getMyKey();
        this.fullPathKey = this._col.getMyFullPathKey();
        String fullLabel = this.makeLabel(table, this.fullPathKey);
        this.columnDisplayName = fullLabel.replace(DELIMITER, " | ");
        this.showColumn = this._col.getShowColumn();
        this.showColumnDefault = this._col.getShowColumnDefault();
        this.showColumnAlways = this._col.getShowColumnAlways();
        boolean initShowColumn = this.showColumn;
        if (init) {
            initShowColumn = this.showColumnDefault;
        }
        String myKey = this._col.getMyKey();
        String primaryKey = table.getPrimaryColumn();
        boolean isPrimaryKey = false;
        if (myKey.equals(primaryKey) || this.showColumnAlways) {
            isPrimaryKey = true;
        }
        this.checkVisible = valEnable;
        if (isPrimaryKey) {
            this.checkVisible = valDisable;
        }
        this.checkSelect = isPrimaryKey ? valOn : (initShowColumn ? valOn.intValue() : valOff.intValue());
    }

    private String makeLabel(SJctrTableDataModel table, String fullKey) {
        String label = "";
        int delimiterIndex = fullKey.indexOf(DELIMITER);
        if (delimiterIndex > 0) {
            int nextIndex = 0;
            while (delimiterIndex > 0) {
                String parentKey = fullKey.substring(0, delimiterIndex);
                SJctrColumn column = table.getColumnInfo(parentKey);
                label = label + column.getLabel() + DELIMITER;
                nextIndex = delimiterIndex + 1;
                if (nextIndex >= fullKey.length()) {
                    delimiterIndex = -1;
                    continue;
                }
                delimiterIndex = fullKey.indexOf(DELIMITER, nextIndex);
            }
        }
        label = label + this.columnLabel;
        return label;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public String getFullPathKey() {
        return this.fullPathKey;
    }

    public boolean getShowColumnDefault() {
        return this.showColumnDefault;
    }

    public String getColumnDisplayName() {
        return this.columnDisplayName;
    }

    public int getSelect() {
        return this.checkSelect;
    }

    public int getVisible() {
        return this.checkVisible;
    }

    public void setColumnDisplayName(String name) {
        this.columnDisplayName = name;
    }

    public void setSelect(int select) {
        this.checkSelect = select;
    }

    public void setVisible(int visible) {
        this.checkVisible = visible;
    }
}

