/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.comdialog.encryption.kmip.viewbackserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.comdialog.encryption.kmip.viewbackserver.SJctrKmipBackupKeyServerButtonModel;
import sanproject.sn2.controller.topwindow.comdialog.encryption.kmip.viewbackserver.SJctrKmipDelBackupkeyServerButtonModel;
import sanproject.sn2.controller.topwindow.comdialog.encryption.kmip.viewbackserver.SJctrKmipRestoreKeyServerButtonModel;
import sanproject.sn2.controller.topwindow.comdialog.encryption.kmip.viewbackserver.SJctrKmipViewBackupKeyServerTableModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.backupkeys.SJctrBackupKeysToServerSubWizard;
import sanproject.sn2.controller.wizard.encryption.kmip.delbackserver.SJctrDeleteBackupServerSubWizard;
import sanproject.sn2.controller.wizard.encryption.kmip.restorekeys.msg.SJctrRestoreKeysFromServerMsgSubWizard;
import sanproject.sn2.kms.common.SJkmsConfiguration;
import sanproject.sn2.kms.common.SJkmsKmipConfiguration;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;
import sanproject.sn2.kms.util.SJkmsConfigUty;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrKmipViewBackupKeyServerDC
extends SJctrDialogDataController
implements SJctrEncryptionKeyDef {
    public SJctrKmipViewBackupKeyServerDC() throws SJcException {
        super(34664518);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_TABLE", new SJctrKmipViewBackupKeyServerTableModel());
        this.addDataObjectModel("COM_DELBACKEYSRV_BTN", new SJctrKmipDelBackupkeyServerButtonModel());
        this.addDataObjectModel("COM_BACKEYSRV_BTN", new SJctrKmipBackupKeyServerButtonModel());
        this.addDataObjectModel("COM_RSTKEYSRV_BTN", new SJctrKmipRestoreKeyServerButtonModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_VIEWKEYSERVER.PUSH_DELKEY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrKmipViewBackupKeyServerDC.this.pushDelKeyAction();
            }
        });
        this.addMessageEventListener(NOTIFY_VIEWKEYSERVER.PUSH_BACKUPEY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrKmipViewBackupKeyServerDC.this.pushBackupKeyAction();
            }
        });
        this.addMessageEventListener(NOTIFY_VIEWKEYSERVER.PUSH_RESTOREKEY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrKmipViewBackupKeyServerDC.this.pushRestoreKeyAction();
            }
        });
    }

    private void pushDelKeyAction() {
        if (!this.isEnableRoleSrvDel()) {
            SJctrEncryptionKeysUtility.createErrorDialog(105204);
        }
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel("COM_TABLE");
        List<Object> selectedRowList = table.getSelectedRowDataOrder();
        HashMap param = new HashMap();
        param.put("KEY_SELECT_UUID", selectedRowList);
        SJctrRelatedDispDataObject newRelated = this.createWizard(SJctrDeleteBackupServerSubWizard.class, param);
        SJctrRelatedDispDataObject removeRelated = this.getOwner().removeRelatedDispData(this.getuId());
        this.addUpdateDisp(removeRelated);
        this.addUpdateDisp(newRelated);
    }

    private void pushBackupKeyAction() {
        if (!this.isEnableRoleBackup()) {
            SJctrEncryptionKeysUtility.createErrorDialog(105204);
        }
        if (!this.isEnablePP()) {
            SJctrEncryptionKeysUtility.createErrorDialog(105204);
        }
        SJctrRelatedDispDataObject newRelated = this.createWizard(SJctrBackupKeysToServerSubWizard.class, null);
        SJctrRelatedDispDataObject removeRelated = this.getOwner().removeRelatedDispData(this.getuId());
        this.addUpdateDisp(removeRelated);
        this.addUpdateDisp(newRelated);
    }

    private void pushRestoreKeyAction() {
        if (!this.isEnableRoleRestore()) {
            SJctrEncryptionKeysUtility.createErrorDialog(105204);
        }
        if (!this.isEnablePP()) {
            SJctrEncryptionKeysUtility.createErrorDialog(105204);
        }
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel("COM_TABLE");
        List<Object> selectedRowList = table.getSelectedRowDataOrder();
        HashMap param = new HashMap();
        param.put("COM_RESTOREINFO", selectedRowList);
        SJctrRelatedDispDataObject newRelated = this.createWizard(SJctrRestoreKeysFromServerMsgSubWizard.class, param);
        SJctrRelatedDispDataObject removeRelated = this.getOwner().removeRelatedDispData(this.getuId());
        this.addUpdateDisp(removeRelated);
        this.addUpdateDisp(newRelated);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(new SJmoGetSubsystemInfo()));
        return set;
    }

    private SJctrGetDirectWrapper createModelDirect(SJmoGetKind_IF kind) {
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper retDirect = new SJctrGetDirectWrapper(direct);
        return retDirect;
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJkmsKmipConfiguration conf;
        List<SJkmsConfiguration> list;
        String strType = SJkmsConfigUty.getType();
        if (!strType.equals("kmip")) {
            SJctrEncryptionKeysUtility.createErrorDialog(105462);
        }
        if ((list = SJkmsConfigUty.getConfiguration(strType)) != null && list.size() > 0 && !(conf = (SJkmsKmipConfiguration)list.get(0)).getEnabled()) {
            SJctrEncryptionKeysUtility.createErrorDialog(105462);
        }
        List<?> subList = this.getCache(SJmoGetSubsystemInfo.class);
        SJmoSubsystemInfo info = (SJmoSubsystemInfo)subList.get(0);
        List<Object> refList = new ArrayList();
        refList = SJkmsCommunicationUty.refer(info.getDKCSNAddString());
        this.putCache("KEY_KMS_REFERLIST", refList);
        return true;
    }

    protected boolean isEnablePP() {
        boolean bResult = true;
        SJctrLicenseContainer license = this.getOwner().getAuthorizeContainer().getLisenceContainer();
        SJctrSystemParamContainer sysCtnr = this.getOwner().getAuthorizeContainer().getSystemParamContainer();
        if (!sysCtnr.isLocalHost()) {
            bResult &= license.checkPP(SJctrLicenseContainer.PPID_SN);
        }
        return bResult &= license.checkPP(SJctrLicenseContainer.PPID_ENCRYPTION);
    }

    protected boolean isEnableRoleSrvDel() {
        return this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(27);
    }

    protected boolean isEnableRoleBackup() {
        return this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(23);
    }

    protected boolean isEnableRoleRestore() {
        return this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(24);
    }

    public static enum NOTIFY_VIEWKEYSERVER implements SJctrNotifyState
    {
        PUSH_DELKEY,
        PUSH_BACKUPEY,
        PUSH_RESTOREKEY;

    }
}

