/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.encryption;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyInfoDEK;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrEncryptionKeysSummaryModel
extends SJctrSimpleDataModel {
    private static final String KEY_INT_ENCRYPT_KEYS_NUM = "COM_INTERNAL_KEY";
    private static final int ENCKEY_INTERNAL_MAX = SJmoDataMacro_IF.NUM_MAX_ENCKEY_INTERNAL - 0 + 1;

    @Override
    protected void makeModelDirect() {
        SJctrGetDirectWrapper direct = SJctrEncryptionKeysUtility.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR);
        if (direct != null) {
            this.directList.add(direct);
        }
    }

    @Override
    public void makeDataObject() {
        List<? extends SJmoGetKind_IF> encMgrList = this.getBasicDataList(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR);
        this.makeSummary(encMgrList);
    }

    protected void makeSummary(List<?> encMgrList) {
        Object summaryData = this.getManageData();
        String strDEK = new String();
        String strCEK = new String();
        String strFree = new String();
        String strDC = new String();
        if (encMgrList == null || encMgrList.isEmpty() || !SJctrEncryptionKeysUtility.isKekKey(encMgrList)) {
            this.getLogUty().putlog("makeSummary", "List is invalid.", 30000);
            strDC = this.getNumOfEncryptionKeys(null, 1);
            strFree = this.getNumOfEncryptionKeys(null, 0);
            ((SJctrDataObject)summaryData).setData("COM_DEK", strDC);
            ((SJctrDataObject)summaryData).setData("COM_CEK", strDC);
            ((SJctrDataObject)summaryData).setData("COM_FREE", strFree);
            return;
        }
        SJmoEncryptionKeyInfoMgr data = encMgrList.get(0);
        ArrayList data_DF = data.getAlEncryptionKeyInfoDEK();
        ArrayList data_C = data.getAlEncryptionKeyInfoCEK();
        ArrayList list_FD = this.getDEKFreeList(data_DF);
        ArrayList data_D = new ArrayList();
        ArrayList data_F = new ArrayList();
        data_D = (ArrayList)list_FD.get(0);
        data_F = (ArrayList)list_FD.get(1);
        strDEK = this.getNumOfEncryptionKeys(data_D, 1);
        strCEK = this.getNumOfEncryptionKeys(data_C, 2);
        strFree = this.getNumOfEncryptionKeys(data_F, 0);
        ((SJctrDataObject)summaryData).setData("COM_DEK", strDEK);
        ((SJctrDataObject)summaryData).setData("COM_CEK", strCEK);
        ((SJctrDataObject)summaryData).setData("COM_FREE", strFree);
    }

    private ArrayList getDEKFreeList(ArrayList<?> encryptionList) {
        ArrayList<SJmoEncryptionKeyInfoDEK> FreeList = new ArrayList<SJmoEncryptionKeyInfoDEK>();
        ArrayList<SJmoEncryptionKeyInfoDEK> DEKList = new ArrayList<SJmoEncryptionKeyInfoDEK>();
        for (int i = 0; i < encryptionList.size(); ++i) {
            SJmoEncryptionKeyInfoDEK encKey = (SJmoEncryptionKeyInfoDEK)encryptionList.get(i);
            int encKind = encKey.getIKeyKind();
            if (encKind == 0) {
                FreeList.add(encKey);
                continue;
            }
            if (encKind != 1) continue;
            DEKList.add(encKey);
        }
        ArrayList<ArrayList<SJmoEncryptionKeyInfoDEK>> rtnList = new ArrayList<ArrayList<SJmoEncryptionKeyInfoDEK>>();
        rtnList.add(DEKList);
        rtnList.add(FreeList);
        return rtnList;
    }

    private String getNumOfEncryptionKeys(ArrayList<?> encryptionList, int encFlg) {
        String rtnValue = "?";
        if (encryptionList != null) {
            switch (encFlg) {
                case 0: {
                    int num_f = encryptionList.size();
                    rtnValue = num_f + this.getComUtility().getStrMaxAllowed(SJctrEncryptionKeysUtility.INT_ENCKEY_CREATE_NUM);
                    break;
                }
                case 1: {
                    int num_d = encryptionList.size();
                    rtnValue = Integer.toString(num_d);
                    break;
                }
                case 2: {
                    int num_c = encryptionList.size();
                    rtnValue = Integer.toString(num_c);
                    break;
                }
            }
        } else if (encFlg == 0) {
            rtnValue = rtnValue + this.getComUtility().getStrMaxAllowed(ENCKEY_INTERNAL_MAX);
        }
        return rtnValue;
    }
}

