/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.exstorage.system.pathgroup;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.column.uvm.SJctrStatusIcon;
import sanproject.sn2.controller.com.column.uvm.SJctrVolumeStatus;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.exstorage.system.SJctrExsSystemSelectDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdPhysicalPathInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdProfileInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdStatusInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdStatusInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfoOnPathGroup;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPhysicalPathInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdStatusInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdVolumeInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrExsSystemPathGrpSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_EXT_STATUS = "COM_EXT_STATUS";
    public static final String KEY_EXT_SUBSYSTEMNAME = "COM_EXT_VMS";
    public static final String KEY_EXT_PATHGP_NUM = "COM_EXT_PATHGP_NUM";
    public static final String KEY_EXT_VOL_NUM = "COM_EXT_VOL_NUM";
    public static final String KEY_EXT_VOL_CAP = "COM_EXT_VOL_CAP";
    private SJmoExdSubsystemInfo subsystem = null;
    private SJmoExdProfileInfo profile = null;
    private List<SJmoExdPathGroupInfo> pathGrpInfoList = null;
    private SJmoExdVolumeInfoMgr exdVolInfoMgr = null;
    private SJmoExdStatusInfoMgr exdStatusMgr = null;
    private SJmoExdPhysicalPathInfoMgr physicalPathInfoMgr = null;
    private List<SJmoExdPathGroupInfo> usablePathGrpList = null;
    private List<SJmoExdVolumeInfo> usableExdVolList = null;
    private SJctrResourceGroupUtility rsgUtil = null;

    @Override
    public void makeDataObject() {
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrExsSystemSelectDC) {
            SJmoModelData_Base mgr;
            SJctrExsSystemSelectDC selectDC = (SJctrExsSystemSelectDC)dc;
            int subsystemID = selectDC.getSelectSystem();
            List<SJmoGetKind_IF> list = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
            if (list != null && list.size() != 0) {
                SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)((Object)list.get(0));
                this.rsgUtil = new SJctrResourceGroupUtility(this.getDataController().getOwner(), rsgInfo);
            }
            if ((list = this.getBasicDataList(SJmoGetExdSubsystemInfoMgr.class)) != null && list.size() != 0) {
                mgr = (SJmoExdSubsystemInfoMgr)((Object)list.get(0));
                this.subsystem = ((SJmoExdSubsystemInfoMgr)mgr).getExdSubsystemInfo(subsystemID);
            }
            if ((list = this.getBasicDataList(SJmoGetExdProfileInfoMgr.class)) != null && list.size() != 0) {
                mgr = (SJmoExdProfileInfoMgr)((Object)list.get(0));
                if (this.subsystem != null) {
                    this.profile = ((SJmoExdProfileInfoMgr)mgr).getExdProfileInfo(this.subsystem.getRmiExdSubsystemInfo().referProfileId());
                }
            }
            if ((list = this.getBasicDataList(SJmoGetExdPathGroupInfoMgr.class)) != null && list.size() != 0) {
                mgr = (SJmoExdPathGroupInfoMgr)((Object)list.get(0));
                this.pathGrpInfoList = ((SJmoExdPathGroupInfoMgr)mgr).getAlPathGroupInfoOfSubsystemId(subsystemID);
            }
            if ((list = this.getBasicDataList(SJmoGetExdVolumeInfoMgr.class)) != null && list.size() != 0) {
                this.exdVolInfoMgr = (SJmoExdVolumeInfoMgr)((Object)list.get(0));
            }
            list = this.getBasicDataList(SJmoGetExdStatusInfoMgr.class);
            this.exdStatusMgr = (SJmoExdStatusInfoMgr)((Object)list.get(0));
            list = this.getBasicDataList(SJmoGetExdPhysicalPathInfoMgr.class);
            if (list != null && list.size() != 0) {
                this.physicalPathInfoMgr = (SJmoExdPhysicalPathInfoMgr)((Object)list.get(0));
            }
        }
        this.makeSummary();
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetExdSubsystemInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdProfileInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPathGroupInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdVolumeInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdStatusInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPhysicalPathInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    protected void makeSummary() {
        SJctrDataController dc = this.getDataController();
        SJctrComUtility comUtil = dc.getOwner().getComUtility();
        SJctrExtUtility extUtil = comUtil.getExtUtility();
        this.usablePathGrpList = extUtil.getUsableExdPathGrpInfo(this.rsgUtil, this.pathGrpInfoList, this.physicalPathInfoMgr, this.exdVolInfoMgr);
        this.usableExdVolList = extUtil.getUsableExdVolInfoonPathGrp(this.rsgUtil, this.usablePathGrpList, this.exdVolInfoMgr);
        int numOfExtPathGrp = this.usablePathGrpList.size();
        int numOfExtVol = this.usableExdVolList.size();
        String extVolCap = this.getExternalVolCapacity();
        SJctrDataObject status = this.getStatus();
        String subsystemName = this.getSubsystemName();
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_EXT_STATUS, status);
        ((SJctrDataObject)summaryData).setData(KEY_EXT_SUBSYSTEMNAME, subsystemName);
        ((SJctrDataObject)summaryData).setData(KEY_EXT_PATHGP_NUM, SJctrComUtility.toDecString(numOfExtPathGrp));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_VOL_NUM, SJctrComUtility.toDecString(numOfExtVol));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_VOL_CAP, extVolCap);
    }

    private SJctrDataObject getStatus() {
        String label = "?";
        int principalStatus = 0;
        int icon = 12292;
        SJctrVolumeStatus volumeStatus = new SJctrVolumeStatus();
        ArrayList<SJmoExdStatusInfo> statusList = new ArrayList<SJmoExdStatusInfo>();
        if (this.pathGrpInfoList != null) {
            for (SJmoExdPathGroupInfo pathGrp : this.pathGrpInfoList) {
                int pathGrpId = pathGrp.getRmiExdPathGroupInfo().getPathGroupID();
                SJmoExdVolumeInfoOnPathGroup exdVolInfoOnPathGrp = this.exdVolInfoMgr.getExdVolumeInfoOnPathGroup(pathGrpId);
                ArrayList volList = exdVolInfoOnPathGrp.getAlExdVolumeInfo();
                for (SJmoExdVolumeInfo volInfo : volList) {
                    int vpgId = volInfo.getRmiExdVolumeInfo().getExternalVolumeID();
                    SJmoExdStatusInfo statusInfo = this.exdStatusMgr.getExdStatusInfo(vpgId);
                    statusList.add(statusInfo);
                }
            }
            if (statusList.size() != 0) {
                principalStatus = volumeStatus.getPrincipalStatus(statusList);
                icon = SJctrStatusIcon.getVolumeStatusIconId(principalStatus);
            }
        }
        SJctrExtUtility util = this.getComUtility().getExtUtility();
        label = util.getStatusDisplay(principalStatus);
        SJctrDataObject status = new SJctrDataObject();
        status.setData("label", label);
        if (!label.equals("?")) {
            status.setData("COM_ICON", icon);
        }
        return status;
    }

    private String getSubsystemName() {
        String name = "";
        SJctrExtUtility util = this.getComUtility().getExtUtility();
        return util.toSubSystemName(this.subsystem, this.profile);
    }

    private String getExternalVolCapacity() {
        long capa = 0L;
        for (SJmoExdVolumeInfo exdVol : this.usableExdVolList) {
            capa += exdVol.getRmiExdVolumeInfo().getExternalDeviceInfo().getVolumeSize();
        }
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        return util.toUnitString(capa);
    }
}

