/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.information.allocation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.information.allocation.SJctrInformationChartModel;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPoolUsedCapacity;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolUsedCapacity;
import sanproject.sn2.model.data.system.SJmoSubsystemCapacity;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrInformationSummaryModel
extends SJctrSimpleDataModel {
    public long lAllocCapa = 0L;
    public long lUnAllocCapa = 0L;
    public long lUsedPoolCapa = 0L;
    public long lUnUsedPoolCapa = 0L;
    public long lReservedCapa = 0L;
    public long lFreeCapa = 0L;
    public long lTotalCapa = 0L;
    public int iAllocCnt = 0;
    public int iUnAllocCnt = 0;
    public int iReservedCnt = 0;
    public int iVvolCnt = 0;
    public int iTotalCnt = 0;
    public int iAllocatedParc = 0;
    public int iUnAllocatedParc = 0;
    public int iUsedPoolParc = 0;
    public int iUnUsedPoolParc = 0;
    public int iReservedParc = 0;
    public int iFreeSpaceParc = 0;
    public int iUsedPoolCnt = 0;
    public int iFreeCnt = 0;
    public long lVvolAllocCapa = 0L;
    public long lVvolUnAllocCapa = 0L;
    public long lVvolOtherCapa = 0L;
    public long lVvolTotalCapa = 0L;
    public long lDpTotalPer = 0L;
    public int iVvolAllocCnt = 0;
    public int iVvolUnAllocCnt = 0;
    public int iVvolOtherCnt = 0;
    public int iVvolTotalCnt = 0;
    public int iTotalLdevCnt = 0;
    public int iQsPoolCnt = 0;
    private long[] savingCapArray = null;
    public static final double lMaxCapa = 1024.0;
    public static final long lUnitCapa = 1024L;
    public String sMB = "MB";
    public String sGB = "GB";
    public String sTB = "TB";
    public String sHai = "-";
    public String sPar = "%";
    public static String sQue = "?";
    public static String sParH = "[-%]";
    private String strSavingEffect_Format = "Total Saving: %s%% (%s) (Deduplication: %s%% Compression: %s%%)";
    private String appropriate = "Appropriate";
    private static final int IAPPROPRIATE = 1;
    private static final int ITB = 2;
    private static final int IGB = 3;
    private static final int IMB = 4;
    private int iCapUnit = 0;
    public static final int VOL_TYPE_INTERNAL = 1;
    public static final int VOL_TYPE_EXTERNAL = 2;
    public static final int VOL_TYPE_TOTAL = 3;
    public static final int VOL_EMU_OPEN = 16;
    public static final int VOL_EMU_MF = 32;
    public static final int VOL_EMU_TOTAL = 48;
    public static final int ITOTAL_TOTAL_PAT = 51;
    public static final int ITOTAL_INTERNAL_PAT = 49;
    public static final int ITOTAL_EXTERNAL_PAT = 50;
    public static final int IOPEN_TOTAL_PAT = 19;
    public static final int IOPEN_INTERNAL_PAT = 17;
    public static final int IOPEN_EXTERNAL_PAT = 18;
    public static final int IMF_TOTAL_PAT = 35;
    public static final int IMF_INTERNAL_PAT = 33;
    public static final int IMF_EXTERNAL_PAT = 34;
    public String COM_TOTAL = "Total";
    public String COM_INTERNAL = "Internal";
    public String COM_EXTERNAL = "External";
    public String COM_OPEN = "Open";
    public String COM_MF = "MainFrame";
    private int giSelComboMode = 0;
    public static final String KEY_ALLOCATED_CAP = "COM_ALLOCATED_CAP";
    public static final String KEY_UNALLOCATED_CAP = "COM_UNALLOCATED_CAP";
    public static final String KEY_USEDPOOL_CAP = "COM_USEDPOOL_CAP";
    public static final String KEY_UNUSEDPOOL_CAP = "COM_UNUSEDPOOL_CAP";
    public static final String KEY_OTHER_CAP = "COM_OTHER_CAP";
    public static final String KEY_FREE_CAP = "COM_FREE_CAP";
    public static final String KEY_TOTAL_CAP = "COM_TOTAL_CAP";
    public static final String KEY_ALLOCATED_PER = "COM_ALLOCATED_PER";
    public static final String KEY_UNALLOCATED_PER = "COM_UNALLOCATED_PER";
    public static final String KEY_USEDPOOL_PER = "COM_USEDPOOL_PER";
    public static final String KEY_UNUSEDPOOL_PER = "COM_UNUSEDPOOL_PER";
    public static final String KEY_OTHER_PER = "COM_OTHER_PER";
    public static final String KEY_FREE_PER = "COM_FREE_PER";
    public static final String KEY_ALLOCATED_NUM = "COM_ALLOCATED_NUM";
    public static final String KEY_UNALLOCATED_NUM = "COM_UNALLOCATED_NUM";
    public static final String KEY_RESERVED_NUM = "COM_RESERVED_NUM";
    public static final String KEY_VVOL_NUM = "COM_VVOL_NUM";
    public static final String KEY_TOTAL_NUM = "COM_TOTAL_NUM";
    public static final String KEY_CHART = "COM_CHART";
    public static final String KEY_CHART_ALLOCATED = "COM_CHART_ALLOCATED";
    public static final String KEY_CHART_UNALLOCATED = "COM_CHART_UNALLOCATED";
    public static final String KEY_CHART_USEDPOOL = "COM_CHART_USEDPOOL";
    public static final String KEY_CHART_UNUSEDPOOL = "COM_CHART_UNUSEDPOOL";
    public static final String KEY_CHART_OTHER = "COM_CHART_OTHER";
    public static final String KEY_CHART_FREE = "COM_CHART_FREE";
    public static final String KEY_OP_MF = "COM_OP_MF";
    public static final String KEY_INTE_EXT = "COM_INTE_EXT";
    public static final String KEY_LABEL = "COM_LABEL";
    public static final String KEY_USEDPOOL_NUM = "COM_USEDPOOL_NUM";
    public static final String KEY_UNUSEDPOOL_NUM = "COM_UNUSEDPOOL_NUM";
    public static final String KEY_OTHER_NUM = "COM_OTHER_NUM";
    public static final String KEY_POOL_ALLOCATED_CAP = "COM_POOL_ALLOCATED_CAP";
    public static final String KEY_POOL_UNALLOCATED_CAP = "COM_POOL_UNALLOCATED_CAP";
    public static final String KEY_VVOL_OTHER_CAP = "COM_VVOL_OTHER_CAP";
    public static final String KEY_VVOL_TOTAL_CAP = "COM_VVOL_TOTAL_CAP";
    public static final String KEY_VVOL_ALLOCATED_NUM = "COM_VVOL_ALLOCATED_NUM";
    public static final String KEY_VVOL_UNALLOCATED_NUM = "COM_VVOL_UNALLOCATED_NUM";
    public static final String KEY_VVOL_OTHER_NUM = "COM_VVOL_OTHER_NUM";
    public static final String KEY_VVOL_TOTAL_NUM = "COM_VVOL_TOTAL_NUM";
    public static final String KEY_TOTAL_POOL_PER = "COM_TOTALPOOL_PER";
    public static final String KEY_TOTAL_LDEV_NUM = "COM_TOTAL_LDEV_NUM";
    public static final String KEY_SAVING_EFFECT = "COM_SAVING_EFFECT";
    private SJctrInformationChartModel chart;
    private SJctrCapacityUtility capaUtil;
    private static final int CALC_FAILED = -1;
    private static final int CALC_PERCENTAGE = 100;
    private static final int ONE_DECIMAL = 0;
    private static final int POOL_PER_ONE = 1;
    private static final double POOL_PER_TH1 = 100.0;
    private static final double POOL_PER_TH2 = 101.0;
    private String ldevMax = "(Max Allowed: 65280)";
    private static final int OPEN_VOLUME = 3;
    private static final int INTERNAL_VOLUME = 0;
    private static final int EXTERNAL_VOLUME = 1;
    static final Comparator<SJmoPoolDetail> PoolDetailComparator = new SJmoPoolDetailComparator();

    public SJctrInformationSummaryModel() {
        this.initChart();
    }

    private long callSum(long lPara1, long lPara2, long lPara3, long lPara4) {
        long lReturn = lPara1 < 0L || lPara2 < 0L || lPara3 < 0L || lPara4 < 0L ? -1L : lPara1 + lPara2 + lPara3 + lPara4;
        return lReturn;
    }

    private long callSum(long lPara1, long lPara2) {
        long lReturn = lPara1 < 0L || lPara2 < 0L ? -1L : lPara1 + lPara2;
        return lReturn;
    }

    private int callSum(int lPara1, int lPara2, int lPara3, int lPara4) {
        int lReturn = lPara1 < 0 || lPara2 < 0 || lPara3 < 0 || lPara4 < 0 ? -1 : lPara1 + lPara2 + lPara3 + lPara4;
        return lReturn;
    }

    private int callSum(int lPara1, int lPara2) {
        int lReturn = lPara1 < 0 || lPara2 < 0 ? -1 : lPara1 + lPara2;
        return lReturn;
    }

    private long capaSum(long ... para) {
        long lReturn = 0L;
        for (long lpara : para) {
            if (lpara < 0L) {
                lReturn = -1L;
                break;
            }
            lReturn += lpara;
        }
        return lReturn;
    }

    private int cntSum(int ... para) {
        int iReturn = 0;
        for (int ipara : para) {
            if (ipara < 0) {
                iReturn = -1;
                break;
            }
            iReturn += ipara;
        }
        return iReturn;
    }

    private long callAllocCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lPara1 = 0L;
        long lPara2 = 0L;
        long lPara3 = 0L;
        long lPara4 = 0L;
        if (num == 51 || num == 49 || num == 19 || num == 17) {
            lPara1 = lInformation.getOpenInternalAllocCapa();
        }
        if (num == 51 || num == 50 || num == 19 || num == 18) {
            lPara2 = lInformation.getOpenExternalAllocCapa();
        }
        if (num == 51 || num == 49 || num == 35 || num == 33) {
            lPara3 = lInformation.getMFInternalAllocCapa();
        }
        if (num == 51 || num == 50 || num == 35 || num == 34) {
            lPara4 = lInformation.getMFExternalAllocCapa();
        }
        this.getLogUty().putlog("Allocation", "Open_Internal = " + lPara1);
        this.getLogUty().putlog("Allocation", "Open_External = " + lPara2);
        this.getLogUty().putlog("Allocation", "MF_Internal = " + lPara3);
        this.getLogUty().putlog("Allocation", "MF_External = " + lPara4);
        long lResult = this.callSum(lPara1, lPara2, lPara3, lPara4);
        return lResult;
    }

    private long callUnAllocCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lPara1 = 0L;
        long lPara2 = 0L;
        if (num == 51 || num == 49 || num == 19 || num == 17) {
            lPara1 = lInformation.getOpenInternalUnallocCapa();
        }
        if (num == 51 || num == 50 || num == 19 || num == 18) {
            lPara2 = lInformation.getOpenExternalUnallocCapa();
        }
        this.getLogUty().putlog("UnAllocation", "Open_Internal = " + lPara1);
        this.getLogUty().putlog("UnAllocation", "Open_External = " + lPara2);
        long lResult = this.callSum(lPara1, lPara2);
        return lResult;
    }

    private long calUsedPoolCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lResult = 0L;
        long lOpenDpPoolUsedCapa = 0L;
        long lMFDPPoolUsedCapa = 0L;
        switch (num) {
            case 51: {
                lOpenDpPoolUsedCapa = lInformation.getOpenDPPoolUsedCapa();
                lMFDPPoolUsedCapa = lInformation.getMFDPPoolUsedCapa();
                break;
            }
            case 19: {
                lOpenDpPoolUsedCapa = lInformation.getOpenDPPoolUsedCapa();
                break;
            }
            case 35: {
                lMFDPPoolUsedCapa = lInformation.getMFDPPoolUsedCapa();
            }
        }
        lResult = this.capaSum(lOpenDpPoolUsedCapa, lMFDPPoolUsedCapa);
        this.getLogUty().putlog("Used Pool", "Open_DP_Pool_Used(D) = " + lResult);
        return lResult;
    }

    private long calUnUsedPoolCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lResult = 0L;
        long lOpenDpPoolRemainderCapa = 0L;
        long lMFDPPoolRemainderCapa = 0L;
        switch (num) {
            case 51: {
                lOpenDpPoolRemainderCapa = lInformation.getOpenDPPoolRemainderCapa();
                lMFDPPoolRemainderCapa = lInformation.getMFDPPoolRemainderCapa();
                break;
            }
            case 19: {
                lOpenDpPoolRemainderCapa = lInformation.getOpenDPPoolRemainderCapa();
                break;
            }
            case 35: {
                lMFDPPoolRemainderCapa = lInformation.getMFDPPoolRemainderCapa();
            }
        }
        lResult = this.capaSum(lOpenDpPoolRemainderCapa, lMFDPPoolRemainderCapa);
        this.getLogUty().putlog("Un Used Pool", "Open_DP_Pool_Remainder(A-D) = " + lResult);
        return lResult;
    }

    private long calReservedCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lPara1 = 0L;
        long lPara2 = 0L;
        long lPara3 = 0L;
        long lPara4 = 0L;
        long lOIPoolCapa = 0L;
        long lOEPoolCapa = 0L;
        long lMIPoolCapa = 0L;
        long lMEPoolCapa = 0L;
        if (num == 49 || num == 17) {
            lPara1 = lInformation.getOpenInternalReservedCapa();
        }
        if (num == 50 || num == 18) {
            lPara2 = lInformation.getOpenExternalReservedCapa();
        }
        if (num == 51 || num == 49 || num == 35 || num == 33) {
            lPara3 = lInformation.getMFInternalReservedCapa();
        }
        if (num == 51 || num == 50 || num == 35 || num == 34) {
            lPara4 = lInformation.getMFExternalReservedCapa();
        }
        if (num == 35 || num == 49 || num == 33) {
            lMIPoolCapa = lInformation.getMFInternalPoolCapa();
        }
        if (num == 35 || num == 50 || num == 34) {
            lMEPoolCapa = lInformation.getMFExternalPoolCapa();
        }
        if (num == 49 || num == 17) {
            lOIPoolCapa = lInformation.getOpenInternalPoolCapa();
        }
        if (num == 50 || num == 18) {
            lOEPoolCapa = lInformation.getOpenExternalPoolCapa();
        }
        this.getLogUty().putlog("Reserved", "Open_Internal = " + lPara1);
        this.getLogUty().putlog("Reserved", "Open_External = " + lPara2);
        this.getLogUty().putlog("Reserved", "MF_Internal = " + lPara3);
        this.getLogUty().putlog("Reserved", "MF_External = " + lPara4);
        this.getLogUty().putlog("Reserved", "MFInternalPoolCapa = " + lMIPoolCapa);
        this.getLogUty().putlog("Reserved", "MFExternalPoolCapa = " + lMEPoolCapa);
        this.getLogUty().putlog("Reserved", "OpenInternalPoolCapa = " + lOIPoolCapa);
        this.getLogUty().putlog("Reserved", "OpenExternalPoolCapa = " + lOEPoolCapa);
        long lResult = this.callSum(lPara1, lPara2, lPara3, lPara4);
        if (lResult < 0L) {
            return -1L;
        }
        long lResultPool = this.callSum(lMIPoolCapa, lMEPoolCapa, lOIPoolCapa, lOEPoolCapa);
        if (lResultPool < 0L) {
            return -1L;
        }
        long lParaA_D = 0L;
        long lParaB = 0L;
        long lParaC1 = 0L;
        long lParaC2 = 0L;
        long lParaD = 0L;
        long lParaOther = 0L;
        switch (num) {
            case 51: {
                lParaA_D = lInformation.getOpenDPPoolRemainderCapa();
                lParaA_D += lInformation.getMFDPPoolRemainderCapa();
                lParaB = lInformation.getOpenPoolTotalCapa();
                lParaB += lInformation.getMFPoolTotalCapa();
                lParaC1 = lInformation.getOpenInternalReservedCapa();
                lParaC2 = lInformation.getOpenExternalReservedCapa();
                lParaD = lInformation.getOpenDPPoolUsedCapa();
                lParaD += lInformation.getMFDPPoolUsedCapa();
                break;
            }
            case 19: {
                lParaA_D = lInformation.getOpenDPPoolRemainderCapa();
                lParaB = lInformation.getOpenPoolTotalCapa();
                lParaC1 = lInformation.getOpenInternalReservedCapa();
                lParaC2 = lInformation.getOpenExternalReservedCapa();
                lParaD = lInformation.getOpenDPPoolUsedCapa();
                break;
            }
            case 35: {
                lParaA_D = lInformation.getMFDPPoolRemainderCapa();
                lParaB = lResultPool;
                lParaC1 = lResult;
                lParaD = lInformation.getMFDPPoolUsedCapa();
                lResultPool = 0L;
                lResult = 0L;
            }
        }
        this.getLogUty().putlog("Reserved", "Open_DP_Pool_Remainder(A-D) = " + lParaA_D);
        this.getLogUty().putlog("Reserved", "Open_Pool_Total(B) = " + lParaB);
        this.getLogUty().putlog("Reserved", "Open_Internal_Reserved(C1) = " + lParaC1);
        this.getLogUty().putlog("Reserved", "Open_External_Reserved(C2) = " + lParaC2);
        this.getLogUty().putlog("Reserved", "Open_DP_Pool_Used(D) = " + lParaD);
        long lParaA = this.callSum(lParaA_D, lParaD);
        long lParaC = this.callSum(lParaC1, lParaC2);
        if (lParaA < 0L || lParaB < 0L || lParaC < 0L) {
            return -1L;
        }
        lParaOther = lParaB + lParaC - lParaA;
        lResult = this.callSum(lResult, lParaOther, lResultPool, 0L);
        return lResult;
    }

    private long calFreeCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lPara1 = 0L;
        long lPara2 = 0L;
        long lPara3 = 0L;
        long lPara4 = 0L;
        if (num == 51 || num == 49 || num == 19 || num == 17) {
            lPara1 = lInformation.getOpenInternalFreeCapa();
        }
        if (num == 51 || num == 50 || num == 19 || num == 18) {
            lPara2 = lInformation.getOpenExternalFreeCapa();
        }
        if (num == 51 || num == 49 || num == 35 || num == 33) {
            lPara3 = lInformation.getMFInternalFreeCapa();
        }
        if (num == 51 || num == 50 || num == 35 || num == 34) {
            lPara4 = lInformation.getMFExternalFreeCapa();
        }
        this.getLogUty().putlog("FreeSpace", "Open_Internal = " + lPara1);
        this.getLogUty().putlog("FreeSpace", "Open_External = " + lPara2);
        this.getLogUty().putlog("FreeSpace", "MF_Internal = " + lPara3);
        this.getLogUty().putlog("FreeSpace", "MF_External = " + lPara4);
        long lResult = this.callSum(lPara1, lPara2, lPara3, lPara4);
        return lResult;
    }

    private int calAllocCnt(int num, SJmoSubsystemCapacity lInformation) {
        int iPara1 = 0;
        int iPara2 = 0;
        int iPara3 = 0;
        int iPara4 = 0;
        if (num == 51 || num == 49 || num == 19 || num == 17) {
            iPara1 = lInformation.getOpenInternalAllocCnt();
        }
        if (num == 51 || num == 50 || num == 19 || num == 18) {
            iPara2 = lInformation.getOpenExternalAllocCnt();
        }
        if (num == 51 || num == 49 || num == 35 || num == 33) {
            iPara3 = lInformation.getMFInternalAllocCnt();
        }
        if (num == 51 || num == 50 || num == 35 || num == 34) {
            iPara4 = lInformation.getMFExternalAllocCnt();
        }
        this.getLogUty().putlog("Allocated_Cnt", "Open_Internal = " + iPara1);
        this.getLogUty().putlog("Allocated_Cnt", "Open_External = " + iPara2);
        this.getLogUty().putlog("Allocated_Cnt", "MF_Internal = " + iPara3);
        this.getLogUty().putlog("Allocated_Cnt", "MF_External = " + iPara4);
        int iResult = this.callSum(iPara1, iPara2, iPara3, iPara4);
        return iResult;
    }

    private int calUnAllocCnt(int num, SJmoSubsystemCapacity lInformation) {
        int iPara1 = 0;
        int iPara2 = 0;
        if (num == 51 || num == 49 || num == 19 || num == 17) {
            iPara1 = lInformation.getOpenInternalUnallocCnt();
        }
        if (num == 51 || num == 50 || num == 19 || num == 18) {
            iPara2 = lInformation.getOpenExternalUnallocCnt();
        }
        this.getLogUty().putlog("Unallocated_Cnt", "Open_Internal = " + iPara1);
        this.getLogUty().putlog("Unallocated_Cnt", "Open_External = " + iPara2);
        int iResult = this.callSum(iPara1, iPara2);
        return iResult;
    }

    private int calReservedCnt(int num, SJmoSubsystemCapacity lInformation) {
        int iPara1 = 0;
        int iPara2 = 0;
        int iPara3 = 0;
        int iPara4 = 0;
        if (num == 51 || num == 49 || num == 19 || num == 17) {
            iPara1 = lInformation.getOpenInternalReservedCnt();
        }
        if (num == 51 || num == 50 || num == 19 || num == 18) {
            iPara2 = lInformation.getOpenExternalReservedCnt();
        }
        if (num == 51 || num == 49 || num == 35 || num == 33) {
            iPara3 = lInformation.getMFInternalReservedCnt();
        }
        if (num == 51 || num == 50 || num == 35 || num == 34) {
            iPara4 = lInformation.getMFExternalReservedCnt();
        }
        this.getLogUty().putlog("Reserved_Cnt", "Open_Internal = " + iPara1);
        this.getLogUty().putlog("Reserved_Cnt", "Open_External = " + iPara2);
        this.getLogUty().putlog("Reserved_Cnt", "MF_Internal = " + iPara3);
        this.getLogUty().putlog("Reserved_Cnt", "MF_External = " + iPara4);
        int iResult = this.callSum(iPara1, iPara2, iPara3, iPara4);
        iResult = this.iUsedPoolCnt != -1 ? (iResult -= this.iUsedPoolCnt) : -1;
        return iResult;
    }

    private int calVvolCnt(int num, SJmoSubsystemCapacity lInformation) {
        int iResult = 0;
        switch (num) {
            case 19: 
            case 51: {
                iResult = lInformation.getVvolCnt();
            }
        }
        this.getLogUty().putlog("Vvol_Cnt", "VvolCnt = " + iResult);
        return iResult;
    }

    private long calDpVvolAllocCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lResult = 0L;
        long lOpenDpAllocCapa = 0L;
        long lMfDpAllocCapa = 0L;
        switch (num) {
            case 51: {
                lOpenDpAllocCapa = lInformation.getLOpenDpAllocCapa();
                lMfDpAllocCapa = lInformation.getLMFDpAllocCapa();
                break;
            }
            case 19: {
                lOpenDpAllocCapa = lInformation.getLOpenDpAllocCapa();
                break;
            }
            case 35: {
                lMfDpAllocCapa = lInformation.getLMFDpAllocCapa();
            }
        }
        lResult = this.callSum(lOpenDpAllocCapa, lMfDpAllocCapa);
        this.getLogUty().putlog("Dp_VVOL_AllocCapa", "Dp_VVOL_AllocCapa = " + lResult);
        return lResult;
    }

    private int calDpVvolAllocCnt(int num, SJmoSubsystemCapacity lInformation) {
        int iResult = 0;
        int iOpenDpAllocCnt = 0;
        int iMFDpAllocCnt = 0;
        switch (num) {
            case 51: {
                iOpenDpAllocCnt = lInformation.getIOpenDpAllocCnt();
                iMFDpAllocCnt = lInformation.getIMFDpAllocCnt();
                break;
            }
            case 19: {
                iOpenDpAllocCnt = lInformation.getIOpenDpAllocCnt();
                break;
            }
            case 35: {
                iMFDpAllocCnt = lInformation.getIMFDpAllocCnt();
            }
        }
        iResult = this.callSum(iOpenDpAllocCnt, iMFDpAllocCnt);
        this.getLogUty().putlog("Dp_VVOL_AllocCnt", "Dp_VVOL_AllocCnt = " + iResult);
        return iResult;
    }

    private long calDpVvolUnallocCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lResult = 0L;
        switch (num) {
            case 19: 
            case 51: {
                lResult += lInformation.getLOpenDpUnallocCapa();
            }
        }
        this.getLogUty().putlog("Dp_VVOL_UnallocCapa", "Dp_VVOL_UnallocCapa = " + lResult);
        return lResult;
    }

    private int calDpVvolUnallocCnt(int num, SJmoSubsystemCapacity lInformation) {
        int iResult = 0;
        switch (num) {
            case 19: 
            case 51: {
                iResult += lInformation.getIOpenDpUnallocCnt();
            }
        }
        this.getLogUty().putlog("Dp_VVOL_UnallocCnt", "Dp_VVOL_UnallocCnt = " + iResult);
        return iResult;
    }

    private long calDpVvolOtherCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lResult = 0L;
        long lOpenDpReservedCapa = 0L;
        long lOpenVOtherAllocCapa = 0L;
        long lOpenVOtherReservedCapa = 0L;
        long lOpenVOtherUnallocCapa = 0L;
        long lMFDpReservedCapa = 0L;
        long lMFVOtherAllocCapa = 0L;
        long lMFVOtherReservedCapa = 0L;
        switch (num) {
            case 51: {
                lOpenDpReservedCapa = lInformation.getLOpenDpReservedCapa();
                lOpenVOtherAllocCapa = lInformation.getLOpenVOtherAllocCapa();
                lOpenVOtherReservedCapa = lInformation.getLOpenVOtherReservedCapa();
                lOpenVOtherUnallocCapa = lInformation.getLOpenVOtherUnallocCapa();
                lMFDpReservedCapa = lInformation.getLMFDpReservedCapa();
                lMFVOtherAllocCapa = lInformation.getLMFVOtherAllocCapa();
                lMFVOtherReservedCapa = lInformation.getLMFVOtherReservedCapa();
                break;
            }
            case 19: {
                lOpenDpReservedCapa = lInformation.getLOpenDpReservedCapa();
                lOpenVOtherAllocCapa = lInformation.getLOpenVOtherAllocCapa();
                lOpenVOtherReservedCapa = lInformation.getLOpenVOtherReservedCapa();
                lOpenVOtherUnallocCapa = lInformation.getLOpenVOtherUnallocCapa();
                break;
            }
            case 35: {
                lMFDpReservedCapa = lInformation.getLMFDpReservedCapa();
                lMFVOtherAllocCapa = lInformation.getLMFVOtherAllocCapa();
                lMFVOtherReservedCapa = lInformation.getLMFVOtherReservedCapa();
            }
        }
        lResult = this.capaSum(lOpenDpReservedCapa, lOpenVOtherAllocCapa, lOpenVOtherReservedCapa, lOpenVOtherUnallocCapa, lMFDpReservedCapa, lMFVOtherAllocCapa, lMFVOtherReservedCapa);
        this.getLogUty().putlog("Dp_VVOLOtherCapa", "Dp_VVOL_OtherCapa = " + lResult);
        return lResult;
    }

    private int calDpVvolOtherCnt(int num, SJmoSubsystemCapacity lInformation) {
        int iResult = 0;
        int iOpenDpReservedCnt = 0;
        int iOpenVOtherAllocCnt = 0;
        int iOpenVOtherReservedCnt = 0;
        int iOpenVOtherUnallocCnt = 0;
        int iMFDpReservedCnt = 0;
        int iMFVOtherAllocCnt = 0;
        int iMFVOtherReservedCnt = 0;
        switch (num) {
            case 51: {
                iOpenDpReservedCnt = lInformation.getIOpenDpReservedCnt();
                iOpenVOtherAllocCnt = lInformation.getIOpenVOtherAllocCnt();
                iOpenVOtherReservedCnt = lInformation.getIOpenVOtherReservedCnt();
                iOpenVOtherUnallocCnt = lInformation.getIOpenVOtherUnallocCnt();
                iMFDpReservedCnt = lInformation.getIMFDpReservedCnt();
                iMFVOtherAllocCnt = lInformation.getIMFVOtherAllocCnt();
                iMFVOtherReservedCnt = lInformation.getIMFVOtherReservedCnt();
                break;
            }
            case 19: {
                iOpenDpReservedCnt = lInformation.getIOpenDpReservedCnt();
                iOpenVOtherAllocCnt = lInformation.getIOpenVOtherAllocCnt();
                iOpenVOtherReservedCnt = lInformation.getIOpenVOtherReservedCnt();
                iOpenVOtherUnallocCnt = lInformation.getIOpenVOtherUnallocCnt();
                break;
            }
            case 35: {
                iMFDpReservedCnt = lInformation.getIMFDpReservedCnt();
                iMFVOtherAllocCnt = lInformation.getIMFVOtherAllocCnt();
                iMFVOtherReservedCnt = lInformation.getIMFVOtherReservedCnt();
            }
        }
        iResult = this.cntSum(iOpenDpReservedCnt, iOpenVOtherAllocCnt, iOpenVOtherReservedCnt, iOpenVOtherUnallocCnt, iMFDpReservedCnt, iMFVOtherAllocCnt, iMFVOtherReservedCnt);
        this.getLogUty().putlog("Dp_VVOLOtherCapa", "Dp_VVOL_OtherCapa = " + iResult);
        return iResult;
    }

    private int calUsedPoolCnt(int num, SJmoSubsystemCapacity lInformation) {
        int iResult = 0;
        int iOpenInternalPoolCnt = 0;
        int iOpenExternalPoolCnt = 0;
        int iMFInternalPoolCnt = 0;
        int iMFExternalPoolCnt = 0;
        switch (num) {
            case 51: {
                iOpenInternalPoolCnt = lInformation.getOpenInternalPoolCnt();
                iOpenExternalPoolCnt = lInformation.getOpenExternalPoolCnt();
                iMFInternalPoolCnt = lInformation.getMFInternalPoolCnt();
                iMFExternalPoolCnt = lInformation.getMFExternalPoolCnt();
                break;
            }
            case 49: {
                iOpenInternalPoolCnt = lInformation.getOpenInternalPoolCnt();
                iMFInternalPoolCnt = lInformation.getMFInternalPoolCnt();
                break;
            }
            case 50: {
                iOpenExternalPoolCnt = lInformation.getOpenExternalPoolCnt();
                iMFExternalPoolCnt = lInformation.getMFExternalPoolCnt();
                break;
            }
            case 19: {
                iOpenInternalPoolCnt = lInformation.getOpenInternalPoolCnt();
                iOpenExternalPoolCnt = lInformation.getOpenExternalPoolCnt();
                break;
            }
            case 17: {
                iOpenInternalPoolCnt = lInformation.getOpenInternalPoolCnt();
                break;
            }
            case 18: {
                iOpenExternalPoolCnt = lInformation.getOpenExternalPoolCnt();
                break;
            }
            case 35: {
                iMFInternalPoolCnt = lInformation.getMFInternalPoolCnt();
                iMFExternalPoolCnt = lInformation.getMFExternalPoolCnt();
                break;
            }
            case 33: {
                iMFInternalPoolCnt = lInformation.getMFInternalPoolCnt();
                break;
            }
            case 34: {
                iMFExternalPoolCnt = lInformation.getMFExternalPoolCnt();
            }
        }
        iResult = this.cntSum(iOpenInternalPoolCnt, iOpenExternalPoolCnt, iMFInternalPoolCnt, iMFExternalPoolCnt);
        this.getLogUty().putlog("Used_DP_PoolCnt", "Used_DP_PoolCnt = " + iResult);
        iResult = this.iQsPoolCnt != -1 ? (iResult -= this.iQsPoolCnt) : -1;
        return iResult;
    }

    private long calDPPoolTotalCapa(int num, SJmoSubsystemCapacity lInformation) {
        long lResult = 0L;
        long lOpenDpPoolTotalCapaKB = 0L;
        long lMFDpPoolTotalCapaKB = 0L;
        long lOpenDpPoolTotalCapaPage = 0L;
        long lMFDpPoolTotalCapaPage = 0L;
        switch (num) {
            case 51: {
                lOpenDpPoolTotalCapaKB = lInformation.getLOpenDPPoolTotalCapa();
                lMFDpPoolTotalCapaKB = lInformation.getLMFDPPoolTotalCapa();
                break;
            }
            case 19: {
                lOpenDpPoolTotalCapaKB = lInformation.getLOpenDPPoolTotalCapa();
                break;
            }
            case 35: {
                lMFDpPoolTotalCapaKB = lInformation.getLMFDPPoolTotalCapa();
            }
        }
        lOpenDpPoolTotalCapaPage = lOpenDpPoolTotalCapaKB / 43008L;
        lMFDpPoolTotalCapaPage = lMFDpPoolTotalCapaKB / 38976L;
        if (lOpenDpPoolTotalCapaKB % 43008L > 0L) {
            ++lOpenDpPoolTotalCapaPage;
        }
        if (lMFDpPoolTotalCapaKB % 38976L > 0L) {
            ++lMFDpPoolTotalCapaPage;
        }
        lResult = this.callSum(lOpenDpPoolTotalCapaPage, lMFDpPoolTotalCapaPage);
        this.getLogUty().putlog("DpPool_TotalCapa", "DpPool_TotalCapa = " + lResult);
        return lResult;
    }

    private long calAOUUsed(int num, List<SJmoPoolDetail> poolDtlList) {
        long lResult = 0L;
        switch (num) {
            case 51: {
                lResult = SJctrPoolUtility.getAOUUsed((byte)2, 0, poolDtlList);
                lResult += SJctrPoolUtility.getAOUUsed((byte)2, 1, poolDtlList);
                break;
            }
            case 19: {
                lResult = SJctrPoolUtility.getAOUUsed((byte)2, 0, poolDtlList);
                break;
            }
            case 35: {
                lResult = SJctrPoolUtility.getAOUUsed((byte)2, 1, poolDtlList);
            }
        }
        this.getLogUty().putlog("Dp_AOU_Used", "Dp_AOU_Used = " + lResult);
        return lResult;
    }

    private int calQsPoolCnt(int num) {
        int iResult = 0;
        SJctrDataController dc = this.getDataController();
        List<?> poolDetailList = dc.getModelData(SJmoGetPoolDetail.class);
        if (poolDetailList == null) {
            iResult = -1;
            return iResult;
        }
        if (poolDetailList.size() == 0) {
            return iResult;
        }
        ArrayList plDetailList = new ArrayList(poolDetailList);
        Collections.sort(plDetailList, PoolDetailComparator);
        List<?> ldevDetailList = dc.getModelData(SJmoGetLdevDetail.class);
        if (ldevDetailList == null || ldevDetailList.size() == 0) {
            iResult = -1;
            return iResult;
        }
        int iOpenInternalQsPoolCnt = 0;
        int iOpenExternalQsPoolCnt = 0;
        int iMfInternalQsPoolCnt = 0;
        int iMfExternalQsPoolCnt = 0;
        ArrayList<Integer> poolIndexList = new ArrayList<Integer>();
        for (SJmoPoolDetail poolDetail : plDetailList) {
            byte poolKind = poolDetail.getPoolKind();
            if (poolKind != 1 && poolKind != 8) continue;
            int poolId = poolDetail.getPoolId();
            poolIndexList.add(poolId);
        }
        for (SJmoLdevDetail ldevDetail : ldevDetailList) {
            boolean externalFlg;
            short poolId;
            int index;
            if (!ldevDetail.getbPoolVol() || (index = Collections.binarySearch(poolIndexList, Integer.valueOf(poolId = ldevDetail.getSPoolID()))) < 0) continue;
            byte volumeFlg = ldevDetail.getByVolumeFlag();
            byte volumeType = ldevDetail.getByVolumeType();
            boolean openFlg = volumeFlg == 3;
            boolean internalFlg = volumeType == 0;
            boolean bl = externalFlg = volumeType == 1;
            if (openFlg && internalFlg) {
                ++iOpenInternalQsPoolCnt;
                continue;
            }
            if (openFlg && externalFlg) {
                ++iOpenExternalQsPoolCnt;
                continue;
            }
            if (!openFlg && internalFlg) {
                ++iMfInternalQsPoolCnt;
                continue;
            }
            if (openFlg || !externalFlg) continue;
            ++iMfExternalQsPoolCnt;
        }
        String msg = "OP_IN=" + iOpenInternalQsPoolCnt + ",OP_EX=" + iOpenExternalQsPoolCnt + ",MF_IN=" + iMfInternalQsPoolCnt + ",MF_EX=" + iMfExternalQsPoolCnt;
        this.getLogUty().putlog("QsPoolCnt", msg);
        switch (num) {
            case 51: {
                iResult = this.cntSum(iOpenInternalQsPoolCnt, iOpenExternalQsPoolCnt, iMfInternalQsPoolCnt, iMfExternalQsPoolCnt);
                break;
            }
            case 49: {
                iResult = this.cntSum(iOpenInternalQsPoolCnt, iMfInternalQsPoolCnt);
                break;
            }
            case 50: {
                iResult = this.cntSum(iOpenExternalQsPoolCnt, iMfExternalQsPoolCnt);
                break;
            }
            case 19: {
                iResult = this.cntSum(iOpenInternalQsPoolCnt, iOpenExternalQsPoolCnt);
                break;
            }
            case 17: {
                iResult = iOpenInternalQsPoolCnt;
                break;
            }
            case 18: {
                iResult = iOpenExternalQsPoolCnt;
                break;
            }
            case 35: {
                iResult = this.cntSum(iMfInternalQsPoolCnt, iMfExternalQsPoolCnt);
                break;
            }
            case 33: {
                iResult = iMfInternalQsPoolCnt;
                break;
            }
            case 34: {
                iResult = iMfExternalQsPoolCnt;
            }
        }
        return iResult;
    }

    public int checkCombo(SJctrComboBoxDataModel comboBoxOP, SJctrComboBoxDataModel comboBoxINTE) {
        String sInex;
        int iPattern = 0;
        String sOpmf = comboBoxOP.getSelection();
        if (sOpmf == null) {
            sOpmf = this.COM_TOTAL;
        }
        if ((sInex = comboBoxINTE.getSelection()) == null) {
            sInex = this.COM_TOTAL;
        }
        if (sOpmf.toString().equals(this.COM_TOTAL)) {
            if (sInex.toString().equals(this.COM_TOTAL)) {
                iPattern = 51;
            }
            if (sInex.toString().equals(this.COM_INTERNAL)) {
                iPattern = 49;
            }
            if (sInex.toString().equals(this.COM_EXTERNAL)) {
                iPattern = 50;
            }
        }
        if (sOpmf.toString().equals(this.COM_OPEN)) {
            if (sInex.toString().equals(this.COM_TOTAL)) {
                iPattern = 19;
            }
            if (sInex.toString().equals(this.COM_INTERNAL)) {
                iPattern = 17;
            }
            if (sInex.toString().equals(this.COM_EXTERNAL)) {
                iPattern = 18;
            }
        }
        if (sOpmf.toString().equals(this.COM_MF)) {
            if (sInex.toString().equals(this.COM_TOTAL)) {
                iPattern = 35;
            }
            if (sInex.toString().equals(this.COM_INTERNAL)) {
                iPattern = 33;
            }
            if (sInex.toString().equals(this.COM_EXTERNAL)) {
                iPattern = 34;
            }
        }
        if (this.giSelComboMode != iPattern) {
            this.savingCapArray = null;
        }
        this.giSelComboMode = iPattern;
        return iPattern;
    }

    private void checkCap(SJctrComboBoxDataModel comboBoxCAP) {
        int iUnit = 0;
        String sOpmf = comboBoxCAP.getSelection();
        if (sOpmf == null) {
            sOpmf = this.appropriate;
        }
        if (sOpmf.toString().equals(this.appropriate)) {
            iUnit = 1;
        } else if (sOpmf.toString().equals(this.sTB)) {
            iUnit = 2;
        } else if (sOpmf.toString().equals(this.sGB)) {
            iUnit = 3;
        } else if (sOpmf.toString().equals(this.sMB)) {
            iUnit = 4;
        }
        this.iCapUnit = iUnit;
    }

    public void getAllocationSummary(List<?> lCapacity, SJctrComboBoxDataModel comboBoxOP, SJctrComboBoxDataModel comboBoxINTE, SJctrComboBoxDataModel comboBoxCAP) {
        SJmoSubsystemCapacity lInformation = (SJmoSubsystemCapacity)lCapacity.get(0);
        int iPattern = this.checkCombo(comboBoxOP, comboBoxINTE);
        this.checkCap(comboBoxCAP);
        this.lAllocCapa = this.callAllocCapa(iPattern, lInformation);
        this.lUnAllocCapa = this.callUnAllocCapa(iPattern, lInformation);
        this.lUsedPoolCapa = this.calUsedPoolCapa(iPattern, lInformation);
        this.lUnUsedPoolCapa = this.calUnUsedPoolCapa(iPattern, lInformation);
        this.lReservedCapa = this.calReservedCapa(iPattern, lInformation);
        this.lFreeCapa = this.calFreeCapa(iPattern, lInformation);
        this.lTotalCapa = this.lAllocCapa < 0L || this.lUnAllocCapa < 0L || this.lUsedPoolCapa < 0L || this.lUnUsedPoolCapa < 0L || this.lReservedCapa < 0L || this.lFreeCapa < 0L ? -1L : this.lAllocCapa + this.lUnAllocCapa + this.lUsedPoolCapa + this.lUnUsedPoolCapa + this.lReservedCapa + this.lFreeCapa;
        this.lVvolAllocCapa = this.calDpVvolAllocCapa(iPattern, lInformation);
        this.lVvolUnAllocCapa = this.calDpVvolUnallocCapa(iPattern, lInformation);
        this.lVvolOtherCapa = this.calDpVvolOtherCapa(iPattern, lInformation);
        this.lVvolTotalCapa = this.lVvolAllocCapa < 0L || this.lVvolUnAllocCapa < 0L || this.lVvolOtherCapa < 0L ? -1L : this.lVvolAllocCapa + this.lVvolUnAllocCapa + this.lVvolOtherCapa;
        this.iQsPoolCnt = this.calQsPoolCnt(iPattern);
        this.iAllocCnt = this.calAllocCnt(iPattern, lInformation);
        this.iUsedPoolCnt = this.calUsedPoolCnt(iPattern, lInformation);
        this.iUnAllocCnt = this.calUnAllocCnt(iPattern, lInformation);
        this.iReservedCnt = this.calReservedCnt(iPattern, lInformation);
        this.iTotalCnt = this.iAllocCnt < 0 || this.iUnAllocCnt < 0 || this.iReservedCnt < 0 || this.iUsedPoolCnt < 0 ? -1 : this.iAllocCnt + this.iUnAllocCnt + this.iReservedCnt + this.iUsedPoolCnt;
        this.iVvolAllocCnt = this.calDpVvolAllocCnt(iPattern, lInformation);
        this.iVvolUnAllocCnt = this.calDpVvolUnallocCnt(iPattern, lInformation);
        this.iVvolOtherCnt = this.calDpVvolOtherCnt(iPattern, lInformation);
        this.iVvolTotalCnt = this.iVvolAllocCnt < 0 || this.iVvolUnAllocCnt < 0 || this.iVvolOtherCnt < 0 ? -1 : this.iVvolAllocCnt + this.iVvolUnAllocCnt + this.iVvolOtherCnt;
        if (this.lUsedPoolCapa < 0L || this.lUnUsedPoolCapa < 0L || this.lVvolAllocCapa < 0L || this.lVvolUnAllocCapa < 0L) {
            this.lDpTotalPer = -1L;
        } else {
            SJctrDataController dc = this.getDataController();
            List<SJmoPoolDetail> poolDtlList = dc.getModelData(SJmoGetPoolDetail.class);
            double totalPoolCapa = this.calDPPoolTotalCapa(iPattern, lInformation);
            double totalVvolCapa = this.calAOUUsed(iPattern, poolDtlList);
            if (totalPoolCapa != 0.0) {
                double per = totalVvolCapa / totalPoolCapa;
                BigDecimal bdBlock = new BigDecimal(per);
                double dpTotalPer = bdBlock.doubleValue() * 100.0;
                BigDecimal bdResult = new BigDecimal(dpTotalPer);
                bdResult = dpTotalPer < 1.0 || 100.0 < dpTotalPer && dpTotalPer < 101.0 ? bdResult.setScale(0, RoundingMode.CEILING) : bdResult.setScale(0, 1);
                this.lDpTotalPer = bdResult.longValue();
            }
        }
        this.iTotalLdevCnt = this.iVvolTotalCnt < 0 || this.iTotalCnt < 0 ? -1 : this.iVvolTotalCnt + this.iTotalCnt;
    }

    public int setPaichartCalculation(long lx, long ly) {
        int ret = 0;
        if (lx == 0L) {
            return ret;
        }
        if (lx < 0L || ly < 0L) {
            return -1;
        }
        ret = (int)(lx * 100L / ly);
        if (ret == 0) {
            ret = 1;
        }
        return ret;
    }

    public void setPaichartRoundingOff() {
        int iFlg = this.iAllocatedParc + this.iUnAllocatedParc + this.iUsedPoolParc + this.iUnUsedPoolParc + this.iReservedParc + this.iFreeSpaceParc;
        if (iFlg != 100 && iFlg != 0) {
            int y;
            int iSa = 100 - iFlg;
            int[][] iSort = new int[][]{{1, this.iAllocatedParc}, {2, this.iUnAllocatedParc}, {3, this.iUsedPoolParc}, {4, this.iUnUsedPoolParc}, {5, this.iReservedParc}, {6, this.iFreeSpaceParc}};
            int[] iSortWork = new int[]{this.iAllocatedParc, this.iUnAllocatedParc, this.iUsedPoolParc, this.iUnUsedPoolParc, this.iReservedParc, this.iFreeSpaceParc};
            int[][] iSortback = new int[6][2];
            int iLoopMax = 5;
            int iFuda = 0;
            int iWariai = 1;
            Arrays.sort(iSortWork);
            int x = iLoopMax;
            while (x >= 0) {
                for (y = 0; y <= iLoopMax; ++y) {
                    int iHikaku2;
                    int iHikaku1;
                    if (x < 0 || (iHikaku1 = iSortWork[x]) != (iHikaku2 = iSort[y][iWariai]) || iSort[y][iFuda] == 0) continue;
                    iSortback[x][iFuda] = iSort[y][iFuda];
                    iSortback[x][iWariai] = iSort[y][iWariai];
                    iSort[y][iFuda] = 0;
                    --x;
                }
            }
            int iSyusei = iSa < 0 ? -1 : 1;
            x = iSa;
            while (x != 0) {
                for (y = iLoopMax; y >= 0; --y) {
                    if (x == 0 || (iSortback[y][iWariai] <= 1 || iSyusei != -1) && (iSortback[y][iWariai] <= 0 || iSyusei != 1)) continue;
                    int[] nArray = iSortback[y];
                    int n = iWariai;
                    nArray[n] = nArray[n] + iSyusei;
                    x -= iSyusei;
                }
            }
            block12: for (int z = 0; z <= iLoopMax; ++z) {
                switch (iSortback[z][iFuda]) {
                    case 1: {
                        this.iAllocatedParc = iSortback[z][iWariai];
                        continue block12;
                    }
                    case 2: {
                        this.iUnAllocatedParc = iSortback[z][iWariai];
                        continue block12;
                    }
                    case 3: {
                        this.iUsedPoolParc = iSortback[z][iWariai];
                        continue block12;
                    }
                    case 4: {
                        this.iUnUsedPoolParc = iSortback[z][iWariai];
                        continue block12;
                    }
                    case 5: {
                        this.iReservedParc = iSortback[z][iWariai];
                        continue block12;
                    }
                    case 6: {
                        this.iFreeSpaceParc = iSortback[z][iWariai];
                    }
                }
            }
        }
    }

    public void setInfomationCalculation() {
        this.iAllocatedParc = this.setPaichartCalculation(this.lAllocCapa, this.lTotalCapa);
        this.iUnAllocatedParc = this.setPaichartCalculation(this.lUnAllocCapa, this.lTotalCapa);
        this.iUsedPoolParc = this.setPaichartCalculation(this.lUsedPoolCapa, this.lTotalCapa);
        this.iUnUsedPoolParc = this.setPaichartCalculation(this.lUnUsedPoolCapa, this.lTotalCapa);
        this.iReservedParc = this.setPaichartCalculation(this.lReservedCapa, this.lTotalCapa);
        this.iFreeSpaceParc = this.setPaichartCalculation(this.lFreeCapa, this.lTotalCapa);
        if (this.iAllocatedParc >= 0 && this.iUnAllocatedParc >= 0 && this.iUsedPoolParc >= 0 && this.iUnUsedPoolParc >= 0 && this.iReservedParc >= 0 && this.iFreeSpaceParc >= 0) {
            this.setPaichartRoundingOff();
        }
    }

    String convertCapacity(long lPara) {
        return this.convertCapacity(lPara, SJctrCapacityUtility.UNIT.KB);
    }

    String convertCapacity(long lPara, SJctrCapacityUtility.UNIT preUnit) {
        String ret = sQue;
        if (this.capaUtil != null && lPara >= 0L) {
            long block = 0L;
            block = preUnit == SJctrCapacityUtility.UNIT.BLOCK ? lPara : this.capaUtil.valueOf(lPara, preUnit);
            switch (this.iCapUnit) {
                case 1: {
                    ret = this.capaUtil.toUnitString(block);
                    break;
                }
                case 2: {
                    ret = this.capaUtil.toString(block, SJctrCapacityUtility.UNIT.TB);
                    ret = ret + " " + this.sTB;
                    break;
                }
                case 3: {
                    ret = this.capaUtil.toString(block, SJctrCapacityUtility.UNIT.GB);
                    ret = ret + " " + this.sGB;
                    break;
                }
                case 4: {
                    ret = this.capaUtil.toString(block, SJctrCapacityUtility.UNIT.MB);
                    ret = ret + " " + this.sMB;
                }
            }
        }
        return ret;
    }

    public String convertPercentage(int iPara) {
        String sRet = "[";
        String sHen = "]";
        if (iPara < 0) {
            sRet = sRet.concat(sQue).concat(this.sPar).concat(sHen);
            return sRet;
        }
        String str = SJctrComUtility.toDecString(iPara);
        sRet = sRet.concat(str).concat(this.sPar).concat(sHen);
        return sRet;
    }

    public void makeAllocationSummary() {
        SJctrComUtility comUtil = this.getDataController().getOwner().getComUtility();
        this.capaUtil = comUtil.getCapacityUtility();
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_ALLOCATED_CAP, this.convertCapacity(this.lAllocCapa));
        if (this.giSelComboMode == 35 || this.giSelComboMode == 33 || this.giSelComboMode == 34) {
            ((SJctrDataObject)summaryData).setData(KEY_UNALLOCATED_CAP, this.sHai);
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_UNALLOCATED_CAP, this.convertCapacity(this.lUnAllocCapa));
        }
        if (this.giSelComboMode == 51 || this.giSelComboMode == 19 || this.giSelComboMode == 35) {
            ((SJctrDataObject)summaryData).setData(KEY_USEDPOOL_CAP, this.convertCapacity(this.lUsedPoolCapa));
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_USEDPOOL_CAP, this.sHai);
        }
        if (this.giSelComboMode == 51 || this.giSelComboMode == 19 || this.giSelComboMode == 35) {
            ((SJctrDataObject)summaryData).setData(KEY_UNUSEDPOOL_CAP, this.convertCapacity(this.lUnUsedPoolCapa));
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_UNUSEDPOOL_CAP, this.sHai);
        }
        switch (this.giSelComboMode) {
            case 19: 
            case 35: 
            case 51: {
                ((SJctrDataObject)summaryData).setData(KEY_POOL_ALLOCATED_CAP, this.convertCapacity(this.lVvolAllocCapa));
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_OTHER_CAP, this.convertCapacity(this.lVvolOtherCapa));
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_TOTAL_CAP, this.convertCapacity(this.lVvolTotalCapa));
                break;
            }
            default: {
                ((SJctrDataObject)summaryData).setData(KEY_POOL_ALLOCATED_CAP, this.sHai);
                ((SJctrDataObject)summaryData).setData(KEY_POOL_UNALLOCATED_CAP, this.sHai);
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_OTHER_CAP, this.sHai);
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_TOTAL_CAP, this.sHai);
            }
        }
        if (this.giSelComboMode == 51 || this.giSelComboMode == 19) {
            ((SJctrDataObject)summaryData).setData(KEY_POOL_UNALLOCATED_CAP, this.convertCapacity(this.lVvolUnAllocCapa));
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_POOL_UNALLOCATED_CAP, this.sHai);
        }
        ((SJctrDataObject)summaryData).setData(KEY_OTHER_CAP, this.convertCapacity(this.lReservedCapa));
        ((SJctrDataObject)summaryData).setData(KEY_FREE_CAP, this.convertCapacity(this.lFreeCapa));
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_CAP, this.convertCapacity(this.lTotalCapa));
        ((SJctrDataObject)summaryData).setData(KEY_ALLOCATED_PER, this.convertPercentage(this.iAllocatedParc));
        if (this.giSelComboMode == 35 || this.giSelComboMode == 33 || this.giSelComboMode == 34) {
            ((SJctrDataObject)summaryData).setData(KEY_UNALLOCATED_PER, sParH);
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_UNALLOCATED_PER, this.convertPercentage(this.iUnAllocatedParc));
        }
        if (this.giSelComboMode == 51 || this.giSelComboMode == 19 || this.giSelComboMode == 35) {
            ((SJctrDataObject)summaryData).setData(KEY_USEDPOOL_PER, this.convertPercentage(this.iUsedPoolParc));
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_USEDPOOL_PER, sParH);
        }
        if (this.giSelComboMode == 51 || this.giSelComboMode == 19 || this.giSelComboMode == 35) {
            ((SJctrDataObject)summaryData).setData(KEY_UNUSEDPOOL_PER, this.convertPercentage(this.iUnUsedPoolParc));
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_UNUSEDPOOL_PER, sParH);
        }
        ((SJctrDataObject)summaryData).setData(KEY_OTHER_PER, this.convertPercentage(this.iReservedParc));
        ((SJctrDataObject)summaryData).setData(KEY_FREE_PER, this.convertPercentage(this.iFreeSpaceParc));
        if (this.iAllocCnt < 0) {
            ((SJctrDataObject)summaryData).setData(KEY_ALLOCATED_NUM, sQue);
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_ALLOCATED_NUM, SJctrComUtility.toDecString(this.iAllocCnt));
        }
        if (this.iUnAllocCnt < 0) {
            ((SJctrDataObject)summaryData).setData(KEY_UNALLOCATED_NUM, sQue);
        } else if (this.giSelComboMode == 35 || this.giSelComboMode == 33 || this.giSelComboMode == 34) {
            ((SJctrDataObject)summaryData).setData(KEY_UNALLOCATED_NUM, this.sHai);
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_UNALLOCATED_NUM, SJctrComUtility.toDecString(this.iUnAllocCnt));
        }
        if (this.iReservedCnt < 0) {
            ((SJctrDataObject)summaryData).setData(KEY_OTHER_NUM, sQue);
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_OTHER_NUM, SJctrComUtility.toDecString(this.iReservedCnt));
        }
        if (this.iTotalCnt < 0) {
            ((SJctrDataObject)summaryData).setData(KEY_TOTAL_NUM, sQue);
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_TOTAL_NUM, SJctrComUtility.toDecString(this.iTotalCnt));
        }
        if (this.iUsedPoolCnt < 0) {
            ((SJctrDataObject)summaryData).setData(KEY_USEDPOOL_NUM, sQue);
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_USEDPOOL_NUM, SJctrComUtility.toDecString(this.iUsedPoolCnt));
        }
        ((SJctrDataObject)summaryData).setData(KEY_UNUSEDPOOL_NUM, this.sHai);
        switch (this.giSelComboMode) {
            case 19: 
            case 35: 
            case 51: {
                if (this.iVvolAllocCnt < 0) {
                    ((SJctrDataObject)summaryData).setData(KEY_VVOL_ALLOCATED_NUM, sQue);
                } else {
                    ((SJctrDataObject)summaryData).setData(KEY_VVOL_ALLOCATED_NUM, SJctrComUtility.toDecString(this.iVvolAllocCnt));
                }
                if (this.iVvolOtherCnt < 0) {
                    ((SJctrDataObject)summaryData).setData(KEY_VVOL_OTHER_NUM, sQue);
                } else {
                    ((SJctrDataObject)summaryData).setData(KEY_VVOL_OTHER_NUM, SJctrComUtility.toDecString(this.iVvolOtherCnt));
                }
                if (this.iVvolTotalCnt < 0) {
                    ((SJctrDataObject)summaryData).setData(KEY_VVOL_TOTAL_NUM, sQue);
                } else {
                    ((SJctrDataObject)summaryData).setData(KEY_VVOL_TOTAL_NUM, SJctrComUtility.toDecString(this.iVvolTotalCnt));
                }
                if (this.lDpTotalPer < 0L) {
                    ((SJctrDataObject)summaryData).setData(KEY_TOTAL_POOL_PER, sQue + this.sPar);
                    break;
                }
                ((SJctrDataObject)summaryData).setData(KEY_TOTAL_POOL_PER, SJctrComUtility.toDecString(this.lDpTotalPer) + this.sPar);
                break;
            }
            default: {
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_ALLOCATED_NUM, this.sHai);
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_UNALLOCATED_NUM, this.sHai);
                ((SJctrDataObject)summaryData).setData(KEY_TOTAL_POOL_PER, this.sHai + this.sPar);
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_OTHER_NUM, this.sHai);
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_TOTAL_NUM, this.sHai);
            }
        }
        if (this.giSelComboMode == 51 || this.giSelComboMode == 19) {
            if (this.iVvolUnAllocCnt < 0) {
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_UNALLOCATED_NUM, sQue);
            } else {
                ((SJctrDataObject)summaryData).setData(KEY_VVOL_UNALLOCATED_NUM, SJctrComUtility.toDecString(this.iVvolUnAllocCnt));
            }
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_VVOL_UNALLOCATED_NUM, this.sHai);
        }
        String dispLdevMax = SJctrComUtility.toDecString(SJmoDataMacro_IF.MAX_EQIP_LDEV_LDKC);
        String strLdevMaxAllowed = String.format(this.ldevMax, " " + dispLdevMax);
        if (this.iTotalLdevCnt < 0) {
            ((SJctrDataObject)summaryData).setData(KEY_TOTAL_LDEV_NUM, sQue + " " + strLdevMaxAllowed);
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_TOTAL_LDEV_NUM, SJctrComUtility.toDecString(this.iTotalLdevCnt) + " " + strLdevMaxAllowed);
        }
        String strSavingEffect = this.makeSavingEffectString();
        ((SJctrDataObject)summaryData).setData(KEY_SAVING_EFFECT, strSavingEffect);
        if (this.iAllocatedParc < 0) {
            this.iAllocatedParc = 0;
        }
        if (this.iUnAllocatedParc < 0) {
            this.iUnAllocatedParc = 0;
        }
        if (this.iUsedPoolParc < 0) {
            this.iUsedPoolParc = 0;
        }
        if (this.iUnUsedPoolParc < 0) {
            this.iUnUsedPoolParc = 0;
        }
        if (this.iReservedParc < 0) {
            this.iReservedParc = 0;
        }
        if (this.iFreeSpaceParc < 0) {
            this.iFreeSpaceParc = 0;
        }
        this.chart.setPaichart(this.iAllocatedParc, KEY_CHART_ALLOCATED);
        this.chart.setPaichart(this.iUnAllocatedParc, KEY_CHART_UNALLOCATED);
        this.chart.setPaichart(this.iUsedPoolParc, KEY_CHART_USEDPOOL);
        this.chart.setPaichart(this.iUnUsedPoolParc, KEY_CHART_UNUSEDPOOL);
        this.chart.setPaichart(this.iReservedParc, KEY_CHART_OTHER);
        this.chart.setPaichart(this.iFreeSpaceParc, KEY_CHART_FREE);
    }

    private String makeSavingEffectString() {
        String strSavingRate = this.sHai;
        String strSavingCapa = this.sHai;
        String strDedupsavingRate = this.sHai;
        String strCompSavingRate = this.sHai;
        if ((this.giSelComboMode & 3) == 3) {
            if (this.savingCapArray == null) {
                List<SJmoPoolUsedCapacity> targetPoolCapInfoList = this.getTargetPoolCapInfoList();
                SJctrDataController dc = this.getDataController();
                List<SJmoPoolDetail> poolDtlList = dc.getModelData(SJmoGetPoolDetail.class);
                this.savingCapArray = SJctrPoolUtility.getSavingEffectCapaArray(targetPoolCapInfoList, poolDtlList);
            }
            int savingRate = SJctrPoolUtility.getSavingEffectRate(this.savingCapArray);
            strSavingRate = SJctrComUtility.toDecString(savingRate);
            long savingCapa = SJctrPoolUtility.getSavingEffectCapa(this.savingCapArray);
            strSavingCapa = this.convertCapacity(savingCapa, SJctrCapacityUtility.UNIT.BLOCK);
            int dedupsavingRate = SJctrPoolUtility.getDedupSavingEffectRate(this.savingCapArray);
            strDedupsavingRate = SJctrComUtility.toDecString(dedupsavingRate);
            int compSavingRate = SJctrPoolUtility.getCompSavingEffectRate(this.savingCapArray);
            strCompSavingRate = SJctrComUtility.toDecString(compSavingRate);
        }
        String strSavingEffect = String.format(this.strSavingEffect_Format, strSavingRate, strSavingCapa, strDedupsavingRate, strCompSavingRate);
        return strSavingEffect;
    }

    private List<SJmoPoolUsedCapacity> getTargetPoolCapInfoList() {
        SJctrDataController dc = this.getDataController();
        List<Object> poolCapInfoList = dc.getModelData(SJmoGetPoolUsedCapacity.class);
        if (poolCapInfoList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getTargetPoolCapInfoList", "poolCapInfoList is null.");
            poolCapInfoList = Collections.emptyList();
        }
        List<SJmoPoolUsedCapacity> retList = Collections.emptyList();
        if ((this.giSelComboMode & 0x30) == 48) {
            retList = new ArrayList(poolCapInfoList);
        } else {
            List<SJmoPoolDetail> poolDtlList = dc.getModelData(SJmoGetPoolDetail.class);
            if (poolDtlList == null) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getTargetPoolCapInfoList", "poolDtlList is null.");
                poolDtlList = Collections.emptyList();
            }
            retList = (this.giSelComboMode & 0x10) == 16 ? SJctrPoolUtility.getPoolUsedCapacityInfoListOpenOnly(poolDtlList, poolCapInfoList) : SJctrPoolUtility.getPoolUsedCapacityInfoListMFOnly(poolDtlList, poolCapInfoList);
        }
        return retList;
    }

    private void initChart() {
        this.chart = new SJctrInformationChartModel();
        this.addDataModel(KEY_CHART, this.chart);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.COM_TOTAL = util.getGuidance("INFORMATION", "TOTAL");
        this.COM_INTERNAL = util.getGuidance("INFORMATION", "INTERNAL_ONLY");
        this.COM_EXTERNAL = util.getGuidance("INFORMATION", "EXTERNAL_ONLY");
        this.COM_OPEN = util.getGuidance("INFORMATION", "OPEN_ONLY");
        this.COM_MF = util.getGuidance("INFORMATION", "MAINFRAME_ONLY");
        this.appropriate = util.getGuidance("COMMON", "APPROPRIATE");
        this.sMB = util.getGuidance("COMMON", "MB");
        this.sGB = util.getGuidance("COMMON", "GB");
        this.sTB = util.getGuidance("COMMON", "TB");
        this.sHai = util.getGuidance("COMMON", "BAR");
        this.sPar = util.getGuidance("COMMON", "PERCENT");
        this.ldevMax = util.getGuidance("COMMON", "LDEV_MAX_ALLOWED");
        this.strSavingEffect_Format = util.getGuidance("INFORMATION", "TOTAL_SAVING_DEDUPE_COMP");
        super.initGuidance(util);
    }

    static class SJmoPoolDetailComparator
    implements Comparator<SJmoPoolDetail> {
        SJmoPoolDetailComparator() {
        }

        @Override
        public int compare(SJmoPoolDetail o1, SJmoPoolDetail o2) {
            return o1.getPoolId() - o2.getPoolId();
        }
    }
}

