/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.ldev;

import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import sanproject.common.Robj_interface_CVSgetLDEVFormatProgInfo;
import sanproject.common.Robj_interface_CVSgetPreQuickFormatProgInfo;
import sanproject.common.Robj_interface_DKCResultInfo;
import sanproject.serverux.dataimpl.DKCgetShreddingStatus;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.arraygroup.com.SJctrArrayGroupUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrRMIgetLDEVFormatProgInfo;
import sanproject.sn2.controller.wizard.cvs.com.SJctrRMIgetPreQuickFormatProgInfo;
import sanproject.sn2.controller.wizard.cvs.shredldev.SJctrRMIgetShredProgInfo;
import sanproject.sn2.controller.wizard.cvs.verifyldevs.SJctrVerifyLDEVsProgressInfo;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgVerifyStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemCapacity;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemCapacity;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgVerifyStatusInfo;
import sanproject.sn2.sn2com.execapp.SJappDefConst;

public class SJctrLdevSummaryModel
extends SJctrSimpleDataModel
implements SJctrCVSMacro {
    public static final String COM_MF_ALLOCATED_NUM = "COM_MF_ALLOCATED_NUM";
    public static final String COM_MF_RESERVED_NUM = "COM_MF_RESERVED_NUM";
    public static final String COM_OP_ALLOCATED_NUM = "COM_OP_ALLOCATED_NUM";
    public static final String COM_OP_RESERVED_NUM = "COM_OP_RESERVED_NUM";
    public static final String COM_OP_VVOL_NUM = "COM_OP_VVOL_NUM";
    public static final String COM_OP_UNALLOCATED_NUM = "COM_OP_UNALLOCATED_NUM";
    public static final String COM_TOTAL_NUM = "COM_TOTAL_NUM";
    public static final String COM_PROGRESS = "COM_PROGRESS";
    private static final int MIN_CONFIRM_PATH_SIZE = 1;
    private static final int MAX_CONFIRM_PATH_SIZE = 65535;
    private static final short NON_LUSE_CONFIG = 1;
    public static final String COM_MF_VVOL_NUM = "COM_MF_VVOL_NUM";
    public static final String COM_PROGRESS_INITPR = "";
    public static final int PROGRESS_NOPROGRESS = 0;
    public static final int PROGRESS_FORMATTING = 1;
    public static final int PROGRESS_LDEVWRITE_ERR = 11;
    public static final int PROGRESS_FILE_ERR = 12;
    private static final String MY_CLASS_NAME = SJctrLdevSummaryModel.class.getSimpleName();
    private static final String VERIFICATION_TASK_PROGRESS_FORMAT = "%s %d %% ( %d / %d parity groups )";

    @Override
    public void makeDataObject() {
        List<SJmoGetSubsystemCapacity> ldevSummary = this.getBasicDataList(SJmoGetSubsystemCapacity.class);
        this.makeSummary(ldevSummary);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetSubsystemCapacity();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPgVerifyStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    protected void makeSummary(List<?> ldevSummary) {
        int op_allocated = 0;
        int op_unallocated = 0;
        int op_reserved = 0;
        int op_vvols = 0;
        int mf_allocated = 0;
        int mf_reserved = 0;
        int total = 0;
        int mf_vvols = 0;
        List<SJmoGetRSGgetAllRsgs> allRsgsList = super.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
        if (allRsgsList.size() > 0) {
            List<Object> availableLdevList = super.getBasicDataList(SJmoGetLdevDetail.class);
            List<SJmoGetLdevLuseInfo> allLuseList = super.getBasicDataList(SJmoGetLdevLuseInfo.class);
            availableLdevList = SJctrArrayGroupUtility.extractAvailableLdevList(availableLdevList, (SJmoRSGgetAllRsgs)((Object)allRsgsList.get(0)), this.getDataController().getOwner());
            for (SJmoLdevLuseInfo sJmoLdevLuseInfo : allLuseList) {
                Collections.sort(sJmoLdevLuseInfo.getAlLUSELdevIndex());
            }
            for (SJmoLdevDetail sJmoLdevDetail : availableLdevList) {
                if (sJmoLdevDetail.getbVvol()) {
                    if (sJmoLdevDetail.getbOpenVolume()) {
                        ++op_vvols;
                        continue;
                    }
                    ++mf_vvols;
                    continue;
                }
                if (sJmoLdevDetail.getbOpenVolume()) {
                    if (this.isDefinedOpenLdev(sJmoLdevDetail)) {
                        int ldevCount = this.countDefinedOpenLdevNumLookAboutLuse(sJmoLdevDetail, allLuseList);
                        op_allocated += ldevCount;
                        if (ldevCount < 2) continue;
                        op_unallocated -= ldevCount - 1;
                        continue;
                    }
                    if (this.isReserveLdev(sJmoLdevDetail)) {
                        ++op_reserved;
                        continue;
                    }
                    ++op_unallocated;
                    continue;
                }
                if (!sJmoLdevDetail.getbMfVolume() && !sJmoLdevDetail.getbMiddleVolume()) continue;
                if (this.isReserveLdev(sJmoLdevDetail)) {
                    ++mf_reserved;
                    continue;
                }
                ++mf_allocated;
            }
            total = op_allocated + op_unallocated + op_reserved + mf_allocated + mf_reserved + op_vvols + mf_vvols;
        } else if (ldevSummary.size() > 0) {
            SJmoSubsystemCapacity summary = (SJmoSubsystemCapacity)ldevSummary.get(0);
            op_allocated = this.getOpenAllocatedCount(summary);
            op_unallocated = this.getOpenUnallocatedCount(summary);
            op_reserved = this.getOpenReservedCount(summary);
            op_vvols = this.getOpenVvolCount(summary);
            mf_allocated = this.getMFAllocatedCount(summary);
            mf_reserved = this.getMFReservedCount(summary);
            total = op_allocated + op_unallocated + op_reserved + mf_allocated + mf_reserved + op_vvols;
        }
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(COM_OP_ALLOCATED_NUM, SJctrComUtility.toDecString(op_allocated));
        ((SJctrDataObject)summaryData).setData(COM_OP_UNALLOCATED_NUM, SJctrComUtility.toDecString(op_unallocated));
        ((SJctrDataObject)summaryData).setData(COM_OP_RESERVED_NUM, SJctrComUtility.toDecString(op_reserved));
        ((SJctrDataObject)summaryData).setData(COM_OP_VVOL_NUM, SJctrComUtility.toDecString(op_vvols));
        ((SJctrDataObject)summaryData).setData(COM_MF_ALLOCATED_NUM, SJctrComUtility.toDecString(mf_allocated));
        ((SJctrDataObject)summaryData).setData(COM_MF_RESERVED_NUM, SJctrComUtility.toDecString(mf_reserved));
        ((SJctrDataObject)summaryData).setData(COM_MF_VVOL_NUM, SJctrComUtility.toDecString(mf_vvols));
        ((SJctrDataObject)summaryData).setData(COM_TOTAL_NUM, SJctrComUtility.toDecString(total));
        ((SJctrDataObject)summaryData).setData(COM_PROGRESS, SJctrLdevSummaryModel.getDispStringProg(this));
        String[] verifyResultFileInfo = SJctrLdevSummaryModel.getVerifyResultFileInfo(this.getDataController());
        ((SJctrDataObject)summaryData).setData("COM_VERIFY_FILE", verifyResultFileInfo[0].equals(COM_PROGRESS_INITPR) ? COM_PROGRESS_INITPR : SJappDefConst.URL_BASEHEAD + SJcEnvUty.getDkcRootName() + "/" + "verify" + "/" + verifyResultFileInfo[0]);
        ((SJctrDataObject)summaryData).setData("COM_VERIFY_MODTIME", verifyResultFileInfo[1]);
    }

    private int countDefinedOpenLdevNumLookAboutLuse(SJmoLdevDetail ldevDetail, List<SJmoLdevLuseInfo> allLuseList) {
        if (ldevDetail.getSLUSEEmlCount() == 1) {
            return 1;
        }
        int size = 0;
        int idx = Collections.binarySearch(allLuseList, ldevDetail);
        if (idx >= 0) {
            size = allLuseList.get(idx).getAlLUSELdevIndex().size() + 1;
        }
        return size;
    }

    private boolean isDefinedOpenLdev(SJmoLdevDetail ldevDetail) {
        return 1 <= ldevDetail.getILUPathNumber() && ldevDetail.getILUPathNumber() <= 65535;
    }

    private boolean isReserveLdev(SJmoLdevDetail ldevDetail) {
        return ldevDetail.getbPoolVol() || ldevDetail.getbJNLVolume() || ldevDetail.getbHIHSMReserve() || ldevDetail.getbSystemDisk() || this.getComUtility().getCVSUtility().getEmulationTypeName(ldevDetail.getIEmulationType()).equals("3390-V") || ldevDetail.getBLockVolume();
    }

    private int getOpenAllocatedCount(SJmoSubsystemCapacity summary) {
        int num = summary.getOpenInternalAllocCnt() + summary.getOpenExternalAllocCnt();
        return num;
    }

    private int getOpenUnallocatedCount(SJmoSubsystemCapacity summary) {
        int num = summary.getOpenInternalUnallocCnt() + summary.getOpenExternalUnallocCnt();
        return num;
    }

    private int getOpenReservedCount(SJmoSubsystemCapacity summary) {
        int num = summary.getOpenInternalReservedCnt() + summary.getOpenExternalReservedCnt();
        return num;
    }

    private int getMFAllocatedCount(SJmoSubsystemCapacity summary) {
        int num = summary.getMFInternalAllocCnt() + summary.getMFExternalAllocCnt();
        return num;
    }

    private int getMFReservedCount(SJmoSubsystemCapacity summary) {
        int num = summary.getMFInternalReservedCnt() + summary.getMFExternalReservedCnt();
        return num;
    }

    private int getOpenVvolCount(SJmoSubsystemCapacity summary) {
        int num = summary.getVvolCnt();
        return num;
    }

    public static String getDispStringProg(SJctrSimpleDataModel sdm) {
        List<SJmoGetLdevDetail> allLdevList = sdm.getBasicDataList(SJmoGetLdevDetail.class);
        List<SJmoGetLdevStatusInfo> stsList = sdm.getBasicDataList(SJmoGetLdevStatusInfo.class);
        List<SJmoGetPgVerifyStatusInfo> verifyStsList = sdm.getBasicDataList(SJmoGetPgVerifyStatusInfo.class);
        String rtn = COM_PROGRESS_INITPR;
        boolean found = false;
        try {
            SJmoPgVerifyStatusInfo verifyStat;
            int iVerifyStatusInfo;
            for (int i = 0; i < allLdevList.size(); ++i) {
                SJmoLdevIndex ldev = (SJmoLdevIndex)((Object)allLdevList.get(i));
                int iStsIndex = Collections.binarySearch(stsList, ldev);
                if (iStsIndex < 0) continue;
                SJmoLdevStatusInfo ldevStatus = (SJmoLdevStatusInfo)((Object)stsList.get(iStsIndex));
                if (ldevStatus.getLDEVStatus() == 3) {
                    rtn = SJctrLdevSummaryModel.getFormatProgress(sdm);
                    found = true;
                    break;
                }
                if (ldevStatus.getLDEVStatus() == 10) {
                    rtn = SJctrLdevSummaryModel.getQuickFormatProgress(sdm);
                    found = true;
                    break;
                }
                if (ldevStatus.getLDEVStatus() != 101) continue;
                rtn = SJctrLdevSummaryModel.getShredProgress(sdm);
                found = true;
                break;
            }
            if ((iVerifyStatusInfo = (verifyStat = (SJmoPgVerifyStatusInfo)((Object)verifyStsList.get(0))).getIVerifyStatusInfo()) == 0 && SJctrDataController.isHM() && !found) {
                rtn = SJctrLdevSummaryModel.getVerifyProgressString(sdm);
            }
        }
        catch (Exception ex) {
            SJctrLogUty.error("CVSPROG", "getDispStringProg", "Exception=" + ex.toString());
        }
        return rtn;
    }

    private static String getFormatProgress(SJctrSimpleDataModel sdm) {
        String rtn = COM_PROGRESS_INITPR;
        Object obj = SJctrLdevSummaryModel.getData(new SJctrRMIgetLDEVFormatProgInfo());
        if (obj != null) {
            Robj_interface_CVSgetLDEVFormatProgInfo format = (Robj_interface_CVSgetLDEVFormatProgInfo)obj;
            if (format.getNFormatFlag() == 1) {
                rtn = SJctrLdevSummaryModel.getDispProg(sdm, "FORMATTING", format.getNProg());
            } else if (format.getNErrCode() == 0) {
                rtn = SJctrLdevSummaryModel.getDispProg(sdm, "FORMATTING", 100);
            }
            SJctrLogUty.info("CVSPROG", "***FORMAT***", "FMTFLG=" + format.getNFormatFlag() + " ERRCODE=" + format.getNErrCode());
        }
        return rtn;
    }

    private static String getQuickFormatProgress(SJctrSimpleDataModel sdm) {
        String rtn = COM_PROGRESS_INITPR;
        Object obj = SJctrLdevSummaryModel.getData(new SJctrRMIgetPreQuickFormatProgInfo());
        if (obj != null) {
            Robj_interface_CVSgetPreQuickFormatProgInfo format = (Robj_interface_CVSgetPreQuickFormatProgInfo)obj;
            int wkFormatFlg = format.getIQFormatFlag();
            if (wkFormatFlg == 1) {
                rtn = SJctrLdevSummaryModel.getDispProg(sdm, "PREPARING_QUICK_FORMAT", format.getIProg());
            } else if (wkFormatFlg == 0) {
                rtn = SJctrLdevSummaryModel.getDispProg(sdm, "PREPARING_QUICK_FORMAT", 100);
            }
            SJctrLogUty.info("CVSPROG", "***QUICK***", "FMTFLG=" + format.getIQFormatFlag());
        }
        return rtn;
    }

    private static String getShredProgress(SJctrSimpleDataModel sdm) {
        String rtn = COM_PROGRESS_INITPR;
        Object obj = SJctrLdevSummaryModel.getData(new SJctrRMIgetShredProgInfo(new Class[]{Integer.TYPE}, new Object[]{-1}));
        if (obj != null) {
            String wkLog = COM_PROGRESS_INITPR;
            DKCgetShreddingStatus[] shredList = (DKCgetShreddingStatus[])obj;
            DKCgetShreddingStatus shred = shredList[0];
            if (shred.getNStatus() == 0) {
                rtn = SJctrLdevSummaryModel.getDispProg(sdm, "SHREDDING", 100);
            } else if (shred.getNStatus() != 11 && shred.getNStatus() != 12) {
                Robj_interface_DKCResultInfo[] ResultInf = shred.getObjResultInfo();
                if (shred.getNProcMax() != 0) {
                    if (shred.getNProcNum() != 0) {
                        int wk = 100 / shred.getNProcMax();
                        int iProg = wk * (shred.getNProcNum() - 1) + wk * ResultInf[shred.getNProcNum() - 1].getNPercent() / 100;
                        rtn = SJctrLdevSummaryModel.getDispProg(sdm, "SHREDDING", iProg);
                    }
                } else {
                    rtn = SJctrLdevSummaryModel.getDispProg(sdm, "SHREDDING", 100);
                }
                for (int i = 0; i < ResultInf.length; ++i) {
                    wkLog = "[" + i + "]" + ResultInf[i].getNOutputResult() + "," + ResultInf[i].getNShreddingResult() + "," + ResultInf[i].getNPercent() + ",";
                }
            }
            SJctrLogUty.info("CVSPROG", "***SHRED   ***", "STATUS=" + shred.getNStatus() + ",MAX=" + shred.getNProcMax() + ",MIN=" + shred.getNProcNum() + ",ERRCODE=" + shred.getNErrorCode());
            SJctrLogUty.info("CVSPROG", "***SHRED(C)***", "[CNT]R1,R2,PROG=" + wkLog);
        }
        return rtn;
    }

    private static String getDispProg(SJctrSimpleDataModel sdm, String keyGuid, int iProg) {
        if (iProg <= 0) {
            iProg = 1;
        }
        if (iProg >= 100) {
            iProg = 99;
        }
        String rtn = sdm.getComUtility().getGuidance(keyGuid) + " " + iProg + " %";
        return rtn;
    }

    private static Object getData(SJmoGetKind_IF kind) {
        Object rtn = new Object();
        try {
            ArrayList<SJmoGetDirect> listDirect = new ArrayList<SJmoGetDirect>();
            SJmoGetRange_IF range = null;
            List filterList = null;
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            listDirect.add(direct);
            SJmoGetAgent agent = SJmoModelMgr.getModelMgr().getDataAgent();
            List getList = agent.getDataInf(listDirect);
            List throughRmiList = (List)getList.get(0);
            SJmoThroughRmiData throughRmi = (SJmoThroughRmiData)throughRmiList.get(0);
            rtn = throughRmi.getObjRmi();
        }
        catch (Exception ex) {
            rtn = null;
        }
        return rtn;
    }

    static String getVerifyProgressString(SJctrSimpleDataModel sdm) {
        String verifyProgressString = COM_PROGRESS_INITPR;
        SJctrVerifyLDEVsProgressInfo verifyProgress = SJctrLdevSummaryModel.getVerifyProgress();
        if (verifyProgress.getErrorCode() == 0 && verifyProgress.getStatus() == 0) {
            verifyProgressString = String.format(VERIFICATION_TASK_PROGRESS_FORMAT, sdm.getComUtility().getGuidance("VERIFY_STATUS"), verifyProgress.getTotalProgress(), verifyProgress.getCurrentPgNo() - 1, verifyProgress.getTotalPgCount());
        }
        return verifyProgressString;
    }

    public static SJctrVerifyLDEVsProgressInfo getVerifyProgress() {
        SJctrVerifyLDEVsProgressInfo rtn = new SJctrVerifyLDEVsProgressInfo();
        try {
            SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
            SanRequest direct = agent.newRequest("MNTgetVerifyProgressInfo");
            SanResponse responseData = agent.getDataInf(direct, true);
            SanObject errorInfo = responseData.getObj("ErrorInfo");
            rtn.setErrorCode(errorInfo.getInt("ErrorCode"));
            if (rtn.getErrorCode() == 0) {
                SanObject verifyInfo = responseData.getObj("VerifyProgressInfo");
                rtn.setStatus(verifyInfo.getInt("VerifyStatus"));
                if (rtn.getStatus() == 0) {
                    rtn.setCurrentPgProgress(verifyInfo.getInt("Progress"));
                    rtn.setTotalPgCount(verifyInfo.getInt("TotalParityGroupCount"));
                    rtn.setCurrentPgNo(verifyInfo.getInt("CurrentParityGroupNumber"));
                }
            } else {
                int[] messageId = errorInfo.getIntArray("MessageId");
                rtn.setFuncId(messageId[0] / 100);
                rtn.setModuleId(messageId[0] % 100);
                rtn.setMessageId(messageId[1]);
                SJctrLogUty.error(MY_CLASS_NAME, "getVerifyProgress", "Function ID = " + rtn.getFuncId() + ", Module ID = " + rtn.getModuleId() + ", Message ID = " + rtn.getMessageId());
            }
        }
        catch (Exception e) {
            SJctrLogUty.error(MY_CLASS_NAME, "getVerifyProgress", "Exception", e);
        }
        SJctrLogUty.info(MY_CLASS_NAME, "***VERIFY***", "errorCode = " + rtn.getErrorCode() + ", funcId = " + rtn.getFuncId() + ", moduleId = " + rtn.getModuleId() + ", messageId = " + rtn.getMessageId() + ", status = " + rtn.getStatus() + ", currentPgProgress = " + rtn.getCurrentPgProgress() + ", totalPgCount = " + rtn.getTotalPgCount() + ", currentPgNo = " + rtn.getCurrentPgNo() + ", totalProgress = " + rtn.getTotalProgress());
        return rtn;
    }

    public static String[] getVerifyResultFileInfo(SJctrDataController dc) {
        String VERIFY_RESULT_FILE_PATTERN = "VER_[0-9][0-9][0-9][0-9][0-1][0-9][0-3][0-9][0-2][0-9][0-6][0-9][0-6][0-9]\\.txt";
        String VERIFY_REPORT_DIR_PATH = SJcEnvUty.getSnDataPath() + "data\\verify";
        String[] rtn = new String[]{COM_PROGRESS_INITPR, COM_PROGRESS_INITPR};
        if (!SJctrDataController.isHM()) {
            return rtn;
        }
        SJctrAuthorizeContainer authorizeContainer = dc.getOwner().getAuthorizeContainer();
        if (authorizeContainer.getSystemParamContainer().isLocalHost() && authorizeContainer.getRoleResourceContainer().checkAuthority(155)) {
            Pattern verifyResultFilePattern = Pattern.compile("VER_[0-9][0-9][0-9][0-9][0-1][0-9][0-3][0-9][0-2][0-9][0-6][0-9][0-6][0-9]\\.txt");
            String verifyReportDirPath = VERIFY_REPORT_DIR_PATH;
            File dir = new File(verifyReportDirPath);
            String[] files = dir.list();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    if (!verifyResultFilePattern.matcher(fileName).matches()) continue;
                    rtn[0] = fileName;
                    rtn[1] = fileName.substring(4, 8) + "/" + fileName.substring(8, 10) + "/" + fileName.substring(10, 12) + " " + fileName.substring(12, 14) + ":" + fileName.substring(14, 16) + ":" + fileName.substring(16, 18);
                    break;
                }
            }
        }
        return rtn;
    }
}

