/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.comparator.SJctrPoolIndexForPoolNameComparator;
import sanproject.sn2.controller.com.model.SJctrNewTreeDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemExpandListener;
import sanproject.sn2.controller.com.model.node.SJctrNodeData;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrItemExpandListenerPool
implements SJctrItemExpandListener {
    @Override
    public void treeCollapsed(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        ArrayList<String> keyList = new ArrayList<String>(childeNodeData.getNodePathToArgsMap().keySet());
        for (String childeNodePath : keyList) {
            dataModel.removeItem(childeNodePath);
        }
    }

    @Override
    public void treeExpanded(SJctrItemExpandEvent<String> event) {
        SJctrNewTreeDataModel dataModel = (SJctrNewTreeDataModel)event.getSource();
        String childeLogicalPath = (String)event.getParameter();
        SJctrNodeData childeNodeData = dataModel.getLogicalPathToNodeDataMap().get(childeLogicalPath);
        ArrayList<SJmoPoolNameInfo> poolNameInfList = new ArrayList<SJmoPoolNameInfo>(childeNodeData.getDataModel().getDataController().getModelData(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        if (poolNameInfList == null) {
            return;
        }
        List<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(childeNodeData.getDataModel().getDataController().getModelData(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        if (poolDtlList == null) {
            return;
        }
        ArrayList<SJmoLdevDetail> ldevDtlList = new ArrayList<SJmoLdevDetail>(childeNodeData.getDataModel().getDataController().getModelData(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        if (ldevDtlList == null) {
            return;
        }
        ArrayList allRsgsList = new ArrayList(childeNodeData.getDataModel().getDataController().getModelData(SJctrPoolUtility.KEY_CLASS_ALL_RSG));
        if (allRsgsList != null && 0 < allRsgsList.size()) {
            poolDtlList = SJctrPoolUtility.extractAvailablePoolList(poolDtlList, ldevDtlList, dataModel.getDataController().getOwner(), (SJmoRSGgetAllRsgs)allRsgsList.get(0));
            Collections.sort(poolDtlList);
            for (int iCnt = 0; iCnt < poolNameInfList.size(); ++iCnt) {
                SJmoPoolNameInfo poolNameInf = (SJmoPoolNameInfo)poolNameInfList.get(iCnt);
                int iPoolIdx = Collections.binarySearch(poolDtlList, poolNameInf);
                if (iPoolIdx >= 0) continue;
                poolNameInfList.remove(iCnt);
                --iCnt;
            }
        } else {
            return;
        }
        Collections.sort(poolNameInfList, new SJctrPoolIndexForPoolNameComparator(poolNameInfList));
        for (SJmoPoolNameInfo poolNameInf : poolNameInfList) {
            Object[] args = new Object[]{poolNameInf};
            HashMap<String, Object> item = dataModel.createItem(childeNodeData, args);
            if (dataModel.addItem(item, childeNodeData, args)) continue;
        }
    }
}

