/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolSummary;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoLicenseDetail;
import sanproject.sn2.model.data.system.SJmoPPKget1PPInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemCapacity;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrPoolsSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_DP_POOL_CAP = "COM_DP_POOL_CAP";
    public static final String KEY_DP_POOL_RMN_CAP_EST = "COM_DP_POOL_RMN_CAP_EST";
    public static final String KEY_DP_LICENCE_CAP = "COM_DP_LICENCE_CAP";
    public static final String KEY_POOL_NUM = "COM_POOL_NUM";
    public static final String KEY_MFDP_POOL_CAP = "COM_MF_POOL_CAP";
    public static final String KEY_MFDP_POOL_RMN_CAP_EST = "COM_MF_POOL_RMN_CAP_EST";
    public static final String KEY_MFDP_LICENCE_CAP = "COM_MF_LICENCE_CAP";
    public static final String KEY_DP_POOL_CAP_PER = "COM_DP_POOL_CAP_PER";
    public static final String KEY_DP_VVOL_CAP = "COM_DP_VVOL_CAP";
    public static final String KEY_DP_VVOL_CAP_PER = "COM_DP_VVOL_CAP_PER";
    public static final String KEY_DP_VVOL_RMN_CAP_EST = "COM_DP_VVOL_RMN_CAP_EST";
    public static final String KEY_MFDP_POOL_CAP_PER = "COM_MF_POOL_CAP_PER";
    public static final String KEY_MFDP_VVOL_CAP = "COM_MF_VVOL_CAP";
    public static final String KEY_MFDP_VVOL_CAP_PER = "COM_MF_VVOL_CAP_PER";
    public static final String KEY_MFDP_VVOL_RMN_CAP_EST = "COM_MF_VVOL_RMN_CAP_EST";
    public static final String KEY_DP_POOL_ICON = "COM_DP_POOL_ICON";
    public static final String KEY_MF_POOL_ICON = "COM_MF_POOL_ICON";
    public static final String KEY_DP_VVOL_ICON = "COM_DP_VVOL_ICON";
    public static final String KEY_MF_VVOL_ICON = "COM_MF_VVOL_ICON";
    public static final String KEY_TI_POOL_CAP = "COM_DSS_POOL_CAP";
    public static final String KEY_TI_POOL_CAP_PER = "COM_DSS_POOL_CAP_PER";
    public static final String KEY_TI_POOL_RMN_CAP = "COM_DSS_POOL_RMN_CAP";
    public static final String KEY_TI_LICENCE_CAP = "COM_DSS_LICENCE_CAP";
    public static final String KEY_TI_POOL_ICON = "COM_DSS_POOL_ICON";
    private final int CAPACITY_INFO = 0;
    private final int CAPACITY_RATIO_INFO = 1;
    private final String ICON_ENABLE_STR = "0.00";
    private boolean dpPoolCapaIconFlg = false;
    private boolean mfDpPoolCapaIconFlg = false;
    private boolean dpVvolCapaIconFlg = false;
    private boolean mfDpVvolCapaIconFlg = false;
    private boolean tiPoolCapaIconFlg = false;
    private SummaryData summary;

    @Override
    public void makeDataObject() {
        int iIndex = 0;
        ArrayList LicenseList = new ArrayList();
        SJmoPPKget1PPInfo obj = new SJmoPPKget1PPInfo();
        this.summary = new SummaryData();
        List<?> poolSummaryList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY);
        this.summary.poolSummary = (SJmoPoolSummary)poolSummaryList.get(0);
        List<?> LicenceDetailList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_LICENSE_DETAIL);
        if (LicenceDetailList.size() == 1) {
            LicenseList = ((SJmoLicenseDetail)LicenceDetailList.get(0)).getPpl1ppinfo();
        }
        SJmoPPKget1PPInfo DPKeyData = new SJmoPPKget1PPInfo();
        DPKeyData.setStrPPID(SJctrLicenseContainer.PPID_DP);
        iIndex = Collections.binarySearch(LicenseList, DPKeyData);
        this.summary.dpLicense = iIndex < 0 ? obj : (SJmoPPKget1PPInfo)LicenseList.get(iIndex);
        SJmoPPKget1PPInfo MFDPKeyData = new SJmoPPKget1PPInfo();
        MFDPKeyData.setStrPPID(SJctrLicenseContainer.PPID_DPFM);
        iIndex = Collections.binarySearch(LicenseList, MFDPKeyData);
        this.summary.mfDpLicense = iIndex < 0 ? obj : (SJmoPPKget1PPInfo)LicenseList.get(iIndex);
        SJmoPPKget1PPInfo TIKeyData = new SJmoPPKget1PPInfo();
        TIKeyData.setStrPPID(SJctrLicenseContainer.PPID_DSS);
        iIndex = Collections.binarySearch(LicenseList, TIKeyData);
        this.summary.tiLicense = iIndex < 0 ? obj : (SJmoPPKget1PPInfo)LicenseList.get(iIndex);
        this.summary.poolDetailList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        this.summary.hdpRelationList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_HDP_RELATION);
        this.summary.ldevDetailList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        this.summary.poolVolDetailList = new ArrayList(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        ArrayList allRsgsList = new ArrayList(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_ALL_RSG));
        SJmoRSGgetAllRsgs allRsgs = null;
        if (0 < allRsgsList.size()) {
            allRsgs = (SJmoRSGgetAllRsgs)allRsgsList.get(0);
        }
        this.summary.allRsgs = allRsgs;
        List<?> subsystemCapacityList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_SUBSYSTEM_CAP_INFO);
        SJmoSubsystemCapacity subsystemInfo = null;
        if (0 < subsystemCapacityList.size()) {
            subsystemInfo = (SJmoSubsystemCapacity)subsystemCapacityList.get(0);
        }
        this.summary.subSystemCapacity = subsystemInfo;
        this.makeSummary();
    }

    @Override
    protected void makeModelDirect() {
        this.directList.add(this.makeModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY));
        this.directList.add(this.makeModelDirect(SJctrPoolUtility.KEY_CLASS_LICENSE_DETAIL));
        this.directList.add(this.makeModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        this.directList.add(this.makeModelDirect(SJctrPoolUtility.KEY_CLASS_HDP_RELATION));
        this.directList.add(this.makeModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        this.directList.add(this.makeModelDirect(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        this.directList.add(this.makeModelDirect(SJctrPoolUtility.KEY_CLASS_ALL_RSG));
        this.directList.add(this.makeModelDirect(SJctrPoolUtility.KEY_CLASS_SUBSYSTEM_CAP_INFO));
    }

    protected SJctrGetDirectWrapper makeModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper reqData = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList filterList = new ArrayList();
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            reqData = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return reqData;
    }

    protected void makeSummary() {
        List<String> dpPoolCapacityList = null;
        List<String> dpVvolCapacityList = null;
        List<String> mfDpPoolCapacityList = null;
        List<String> mfDpVvolCapacityList = null;
        List<String> tiPoolCapacityList = null;
        int iAllPoolNum = 0;
        if (null != this.summary.poolDetailList) {
            iAllPoolNum = this.summary.poolDetailList.size();
        }
        SJctrUserController user = this.getDataController().getOwner();
        List<SJmoPoolDetail> poolDetailListRSG = SJctrPoolUtility.extractAvailablePoolList(this.summary.poolDetailList, this.summary.ldevDetailList, user, this.summary.allRsgs);
        SJctrLicenseContainer licenseContainer = user.getAuthorizeContainer().getLisenceContainer();
        Object summaryData = this.getManageData();
        dpPoolCapacityList = this.getDpPoolCapacityInfo(poolDetailListRSG);
        ((SJctrDataObject)summaryData).setData(KEY_DP_POOL_CAP, dpPoolCapacityList.get(0));
        ((SJctrDataObject)summaryData).setData(KEY_DP_POOL_CAP_PER, dpPoolCapacityList.get(1));
        ((SJctrDataObject)summaryData).setData(KEY_DP_POOL_RMN_CAP_EST, this.getDpPoolRmnCapacity(this.summary.poolSummary, this.summary.poolDetailList, licenseContainer));
        ((SJctrDataObject)summaryData).setData(KEY_DP_LICENCE_CAP, this.getDpLicenceCapacity(this.summary.dpLicense, this.summary.poolDetailList));
        dpVvolCapacityList = this.getDpVvolCapacityInfo(this.summary.subSystemCapacity);
        ((SJctrDataObject)summaryData).setData(KEY_DP_VVOL_CAP, dpVvolCapacityList.get(0));
        ((SJctrDataObject)summaryData).setData(KEY_DP_VVOL_CAP_PER, dpVvolCapacityList.get(1));
        ((SJctrDataObject)summaryData).setData(KEY_DP_VVOL_RMN_CAP_EST, this.getDpVvolEstimatedCapacity(this.summary.poolSummary, this.summary.poolDetailList, licenseContainer));
        mfDpPoolCapacityList = this.getMfDpPoolCapacityInfo(poolDetailListRSG);
        ((SJctrDataObject)summaryData).setData(KEY_MFDP_POOL_CAP, mfDpPoolCapacityList.get(0));
        ((SJctrDataObject)summaryData).setData(KEY_MFDP_POOL_CAP_PER, mfDpPoolCapacityList.get(1));
        ((SJctrDataObject)summaryData).setData(KEY_MFDP_POOL_RMN_CAP_EST, this.getMfDpPoolRmnCapacity(this.summary.poolSummary, this.summary.poolDetailList, licenseContainer));
        ((SJctrDataObject)summaryData).setData(KEY_MFDP_LICENCE_CAP, this.getMfDpLicenceCapacity(this.summary.mfDpLicense, this.summary.poolDetailList));
        mfDpVvolCapacityList = this.getMfDpVvolCapacityInfo(this.summary.subSystemCapacity);
        ((SJctrDataObject)summaryData).setData(KEY_MFDP_VVOL_CAP, mfDpVvolCapacityList.get(0));
        ((SJctrDataObject)summaryData).setData(KEY_MFDP_VVOL_CAP_PER, mfDpVvolCapacityList.get(1));
        ((SJctrDataObject)summaryData).setData(KEY_MFDP_VVOL_RMN_CAP_EST, this.getMfDpVvolEstimatedCapacity(this.summary.poolSummary, this.summary.poolDetailList, licenseContainer));
        tiPoolCapacityList = this.getTiPoolCapacityInfo(poolDetailListRSG);
        ((SJctrDataObject)summaryData).setData(KEY_TI_POOL_CAP, tiPoolCapacityList.get(0));
        ((SJctrDataObject)summaryData).setData(KEY_TI_POOL_CAP_PER, tiPoolCapacityList.get(1));
        ((SJctrDataObject)summaryData).setData(KEY_TI_POOL_RMN_CAP, this.getTiPoolRmnCapacity(this.summary.poolSummary, licenseContainer));
        ((SJctrDataObject)summaryData).setData(KEY_TI_LICENCE_CAP, this.getTiLicenceCapacity(this.summary.tiLicense, this.summary.poolDetailList));
        ((SJctrDataObject)summaryData).setData(KEY_POOL_NUM, this.getPoolNum(poolDetailListRSG, iAllPoolNum));
        ((SJctrDataObject)summaryData).setData(KEY_DP_POOL_ICON, this.dpPoolCapaIconFlg);
        ((SJctrDataObject)summaryData).setData(KEY_MF_POOL_ICON, this.mfDpPoolCapaIconFlg);
        ((SJctrDataObject)summaryData).setData(KEY_DP_VVOL_ICON, this.dpVvolCapaIconFlg);
        ((SJctrDataObject)summaryData).setData(KEY_MF_VVOL_ICON, this.mfDpVvolCapaIconFlg);
        ((SJctrDataObject)summaryData).setData(KEY_TI_POOL_ICON, this.tiPoolCapaIconFlg);
    }

    private List<String> getDpPoolCapacityInfo(List<SJmoPoolDetail> poolDetailList) {
        String strDpPoolCapa = "";
        long lDpPoolTotalCapa = 0L;
        long lDpPoolUsedReservedCapa = 0L;
        SJctrPoolUtility poolUtil = null;
        String capaRatio = "";
        ArrayList<String> dpPoolCapacityInfoList = new ArrayList<String>();
        poolUtil = this.getComUtility().getPoolUtility();
        if (poolDetailList == null) {
            strDpPoolCapa = poolUtil.toCompSummaryDisplay("?", "?");
            capaRatio = "?";
            dpPoolCapacityInfoList.add(strDpPoolCapa);
            dpPoolCapacityInfoList.add(capaRatio);
            return dpPoolCapacityInfoList;
        }
        for (int iCnt = 0; iCnt < poolDetailList.size(); ++iCnt) {
            SJmoPoolDetail poolDtl = poolDetailList.get(iCnt);
            if (2 != poolDtl.getPoolKind() || 0 != poolDtl.getEmulationType()) continue;
            long lPageSize = poolDtl.getPageSize();
            long lPoolPages = poolDtl.getPoolPages();
            long lPoolCapa = lPageSize * lPoolPages;
            lDpPoolTotalCapa += lPoolCapa;
            long lPoolUsedReservedPages = poolDtl.getPoolUsedPages() + poolDtl.getLPoolReservedPages();
            long lPoolUsedReservedCapa = lPageSize * lPoolUsedReservedPages;
            lDpPoolUsedReservedCapa += lPoolUsedReservedCapa;
        }
        strDpPoolCapa = poolUtil.toCapaRatioSumaryDisplay(lDpPoolUsedReservedCapa, lDpPoolTotalCapa, SJctrCapacityUtility.UNIT.KB, this.getComUtility(), false);
        capaRatio = poolUtil.capaRatioCalculation(lDpPoolUsedReservedCapa, lDpPoolTotalCapa);
        dpPoolCapacityInfoList.add(strDpPoolCapa);
        dpPoolCapacityInfoList.add(capaRatio);
        return dpPoolCapacityInfoList;
    }

    private String getDpPoolRmnCapacity(SJmoPoolSummary poolSummary, List<SJmoPoolDetail> poolDetailList, SJctrLicenseContainer licenseContainer) {
        String strDpPoolRmnCapa = "";
        long lDpPoolTotalCapa = 0L;
        long lDpPoolEnsCapa = 0L;
        long lDpPoolRmnCapa = 0L;
        long lDpPoolRmnBlock = 0L;
        SJctrCapacityUtility capaUtil = null;
        boolean dpLicenseFlg = licenseContainer.checkPP(SJctrLicenseContainer.PPID_DP);
        capaUtil = this.getComUtility().getCapacityUtility();
        if (dpLicenseFlg) {
            if (poolSummary == null || poolDetailList == null) {
                strDpPoolRmnCapa = "?";
            } else {
                lDpPoolTotalCapa = poolSummary.getLAOUPoolSysCapaEst();
                lDpPoolRmnCapa = lDpPoolTotalCapa - (lDpPoolEnsCapa = poolSummary.getAOUPoolTotalCapa());
                if (lDpPoolRmnCapa >= 0L) {
                    lDpPoolRmnBlock = capaUtil.valueOf(lDpPoolRmnCapa, SJctrCapacityUtility.UNIT.MB);
                    SJctrCapacityUtility.UNIT unit = capaUtil.getUnit(lDpPoolRmnBlock);
                    String capString = capaUtil.toString(lDpPoolRmnBlock, unit);
                    String unitString = capaUtil.getUnitString(unit);
                    this.dpPoolCapaIconFlg = "0.00".equals(capString);
                    strDpPoolRmnCapa = capString + " " + unitString;
                } else {
                    strDpPoolRmnCapa = "?";
                }
            }
        } else {
            strDpPoolRmnCapa = SJctrPoolUtility.HAIFUN_STR;
        }
        return strDpPoolRmnCapa;
    }

    private String getDpLicenceCapacity(SJmoPPKget1PPInfo dPLicense, List<SJmoPoolDetail> poolDetailList) {
        String strDpLicense = "";
        strDpLicense = this.getSummaryLicenceDisplay(poolDetailList, dPLicense, (byte)2);
        return strDpLicense;
    }

    private List<String> getDpVvolCapacityInfo(SJmoSubsystemCapacity subSystemCapacityInfo) {
        String strDpVvolCapa = "";
        long lDpVvolTotalCapa = 0L;
        long lDpVvolAllocatedCapa = 0L;
        SJctrPoolUtility poolUtil = null;
        String dpVvolcapaRatio = "";
        ArrayList<String> dpVvolCapacityInfoList = new ArrayList<String>();
        poolUtil = this.getComUtility().getPoolUtility();
        if (subSystemCapacityInfo == null) {
            strDpVvolCapa = poolUtil.toCompSummaryDisplay("?", "?");
            dpVvolcapaRatio = "?";
        } else {
            lDpVvolAllocatedCapa = subSystemCapacityInfo.getLOpenDpAllocCapa();
            lDpVvolTotalCapa = lDpVvolAllocatedCapa + subSystemCapacityInfo.getLOpenDpUnallocCapa();
            strDpVvolCapa = poolUtil.toCapaRatioSumaryDisplay(lDpVvolAllocatedCapa, lDpVvolTotalCapa, SJctrCapacityUtility.UNIT.KB, this.getComUtility(), false);
            dpVvolcapaRatio = poolUtil.capaRatioCalculation(lDpVvolAllocatedCapa, lDpVvolTotalCapa);
        }
        dpVvolCapacityInfoList.add(strDpVvolCapa);
        dpVvolCapacityInfoList.add(dpVvolcapaRatio);
        return dpVvolCapacityInfoList;
    }

    private String getDpVvolEstimatedCapacity(SJmoPoolSummary poolSummary, List<SJmoPoolDetail> poolDetailList, SJctrLicenseContainer licenseContainer) {
        String strCapaRtn = "";
        long lDpVolTotalCapa = 0L;
        long lDpVolUsedPage = 0L;
        long lPageSize = 0L;
        long lDpVolUsedCapa = 0L;
        long lDpVolRmnCapa = 0L;
        SJmoPoolDetail poolDetail = null;
        int iCnt = 0;
        long lDPVvolRmnCapaBlock = 0L;
        SJctrCapacityUtility capaUtil = null;
        boolean dpLicenseFlg = licenseContainer.checkPP(SJctrLicenseContainer.PPID_DP);
        capaUtil = this.getComUtility().getCapacityUtility();
        if (dpLicenseFlg) {
            if (poolSummary == null || poolDetailList == null) {
                strCapaRtn = "?";
            } else {
                lDpVolTotalCapa = poolSummary.getLDPVolSysCapaEst();
                lDpVolTotalCapa *= 1024L;
                for (iCnt = 0; iCnt < poolDetailList.size(); ++iCnt) {
                    poolDetail = poolDetailList.get(iCnt);
                    if (poolDetail.getPoolKind() != 2 || poolDetail.getEmulationType() != 0) continue;
                    lDpVolUsedPage = poolDetail.getAouUsed();
                    lPageSize = poolDetail.getPageSize();
                    lDpVolUsedCapa += lDpVolUsedPage * lPageSize;
                }
                lDpVolRmnCapa = lDpVolTotalCapa - lDpVolUsedCapa;
                if (lDpVolRmnCapa >= 0L) {
                    lDPVvolRmnCapaBlock = capaUtil.valueOf(lDpVolRmnCapa, SJctrCapacityUtility.UNIT.KB);
                    SJctrCapacityUtility.UNIT unit = capaUtil.getUnit(lDPVvolRmnCapaBlock);
                    String capString = capaUtil.toString(lDPVvolRmnCapaBlock, unit);
                    String unitString = capaUtil.getUnitString(unit);
                    this.dpVvolCapaIconFlg = "0.00".equals(capString);
                    strCapaRtn = capString + " " + unitString;
                } else {
                    strCapaRtn = "?";
                }
            }
        } else {
            strCapaRtn = SJctrPoolUtility.HAIFUN_STR;
        }
        return strCapaRtn;
    }

    private String getPoolNum(List<SJmoPoolDetail> poolDetailList, int iAllPoolNum) {
        int iPoolNum = 0;
        String strPoolNum = "";
        String strMaxPoolNum = "";
        String strPoolNumDisplay = "";
        if (poolDetailList == null) {
            strMaxPoolNum = this.getComUtility().getStrMaxAllowed(SJctrPoolUtility.POOL_MAX_DKC);
            strPoolNumDisplay = "?" + strMaxPoolNum;
        } else {
            iPoolNum = poolDetailList.size();
            strPoolNum = SJctrComUtility.toDecString(iPoolNum);
            strMaxPoolNum = this.getComUtility().getStrMaxAllowed(SJctrPoolUtility.POOL_MAX_DKC - (iAllPoolNum - iPoolNum));
            strPoolNumDisplay = strPoolNum + strMaxPoolNum;
        }
        return strPoolNumDisplay;
    }

    private String getLicenceCapacity(SJmoPPKget1PPInfo licenseInfo) {
        String strLicenseCapa = "?";
        long lLicenseCapa = 0L;
        long lLicenseBlock = 0L;
        int iPPStatus = 0;
        String MINUS = " - ";
        String PLUS = " + ";
        String METER_UNIT = "-Days";
        if (licenseInfo == null) {
            strLicenseCapa = "?";
        } else {
            iPPStatus = licenseInfo.getIStatus();
            if (iPPStatus == 1 || iPPStatus == 3) {
                switch (licenseInfo.getIKeyKind()) {
                    case 2: 
                    case 7: 
                    case 8: {
                        lLicenseCapa = licenseInfo.getIPermitVol();
                        if (lLicenseCapa == -1L) {
                            strLicenseCapa = this.getComUtility().getGuidance("UNLIMITED");
                            break;
                        }
                        if (lLicenseCapa <= 0L) break;
                        lLicenseBlock = this.getComUtility().getCapacityUtility().valueOf(lLicenseCapa, SJctrCapacityUtility.UNIT.TB);
                        strLicenseCapa = this.getComUtility().getCapacityUtility().toUnitString(lLicenseBlock);
                        if (licenseInfo.getIKeyKind() != 8) break;
                        long lDiffCapa = licenseInfo.getLPermDiffCapa();
                        if (lDiffCapa >= 0L) {
                            strLicenseCapa = strLicenseCapa + PLUS;
                        } else {
                            lDiffCapa = Math.abs(lDiffCapa);
                            strLicenseCapa = strLicenseCapa + MINUS;
                        }
                        long lDiffCapaBlock = this.getComUtility().getCapacityUtility().valueOf(lDiffCapa, SJctrCapacityUtility.UNIT.GB);
                        strLicenseCapa = strLicenseCapa + this.getComUtility().getCapacityUtility().toUnitString(lDiffCapaBlock) + METER_UNIT;
                        break;
                    }
                    case 1: 
                    case 3: {
                        lLicenseCapa = licenseInfo.getIPermitVol();
                        if (lLicenseCapa != -1L && lLicenseCapa < 0L) break;
                        strLicenseCapa = this.getComUtility().getGuidance("UNLIMITED");
                        break;
                    }
                    case 4: {
                        lLicenseCapa = licenseInfo.getIPermitVol();
                        if (lLicenseCapa != -1L) break;
                        strLicenseCapa = this.getComUtility().getGuidance("UNLIMITED");
                    }
                }
            } else {
                strLicenseCapa = "-";
            }
        }
        return strLicenseCapa;
    }

    private List<String> getMfDpPoolCapacityInfo(List<SJmoPoolDetail> poolDetailList) {
        String strMfDpPoolCapa = "";
        long lMfDpPoolTotalCapa = 0L;
        long lMfDpPoolUsedReservedCapa = 0L;
        SJctrPoolUtility poolUtil = null;
        String capaRatio = "";
        ArrayList<String> mfDpPoolCapacityInfoList = new ArrayList<String>();
        poolUtil = this.getComUtility().getPoolUtility();
        if (poolDetailList == null) {
            strMfDpPoolCapa = poolUtil.toCompSummaryDisplay("?", "?");
            capaRatio = "?";
            mfDpPoolCapacityInfoList.add(strMfDpPoolCapa);
            mfDpPoolCapacityInfoList.add(capaRatio);
            return mfDpPoolCapacityInfoList;
        }
        for (int iCnt = 0; iCnt < poolDetailList.size(); ++iCnt) {
            SJmoPoolDetail poolDtl = poolDetailList.get(iCnt);
            if (2 != poolDtl.getPoolKind() || 1 != poolDtl.getEmulationType()) continue;
            long lPageSize = poolDtl.getPageSize();
            long lPoolPages = poolDtl.getPoolPages();
            long lPoolCapa = lPageSize * lPoolPages;
            lMfDpPoolTotalCapa += lPoolCapa;
            long lMfPoolUsedReservedPages = poolDtl.getPoolUsedPages() + poolDtl.getLPoolReservedPages();
            long lMfPoolUsedReservedCapa = lPageSize * lMfPoolUsedReservedPages;
            lMfDpPoolUsedReservedCapa += lMfPoolUsedReservedCapa;
        }
        strMfDpPoolCapa = poolUtil.toCapaRatioSumaryDisplay(lMfDpPoolUsedReservedCapa, lMfDpPoolTotalCapa, SJctrCapacityUtility.UNIT.KB, this.getComUtility(), false);
        capaRatio = poolUtil.capaRatioCalculation(lMfDpPoolUsedReservedCapa, lMfDpPoolTotalCapa);
        mfDpPoolCapacityInfoList.add(strMfDpPoolCapa);
        mfDpPoolCapacityInfoList.add(capaRatio);
        return mfDpPoolCapacityInfoList;
    }

    private String getMfDpPoolRmnCapacity(SJmoPoolSummary poolSummary, List<SJmoPoolDetail> poolDetailList, SJctrLicenseContainer licenseContainer) {
        String strMfDpPoolRmnCapa = "";
        long lMfDpPoolTotalCapa = 0L;
        long lMfDpPoolEnsCapa = 0L;
        long lMfDpPoolRmnCapa = 0L;
        long lMfDpPoolRmnBlock = 0L;
        SJctrCapacityUtility capaUtil = null;
        boolean mfDpLicenseFlg = licenseContainer.checkPP(SJctrLicenseContainer.PPID_DP) & licenseContainer.checkPP(SJctrLicenseContainer.PPID_DPFM);
        capaUtil = this.getComUtility().getCapacityUtility();
        if (mfDpLicenseFlg) {
            if (poolSummary == null || poolDetailList == null) {
                strMfDpPoolRmnCapa = "?";
            } else {
                lMfDpPoolTotalCapa = poolSummary.getLMFAOUPoolSysCapaEst();
                lMfDpPoolRmnCapa = lMfDpPoolTotalCapa - (lMfDpPoolEnsCapa = poolSummary.getLMFAOUPoolCapaTotal());
                if (lMfDpPoolRmnCapa >= 0L) {
                    lMfDpPoolRmnBlock = capaUtil.valueOf(lMfDpPoolRmnCapa, SJctrCapacityUtility.UNIT.MB);
                    SJctrCapacityUtility.UNIT unit = capaUtil.getUnit(lMfDpPoolRmnBlock);
                    String capString = capaUtil.toString(lMfDpPoolRmnBlock, unit);
                    String unitString = capaUtil.getUnitString(unit);
                    this.mfDpPoolCapaIconFlg = "0.00".equals(capString);
                    strMfDpPoolRmnCapa = capString + " " + unitString;
                } else {
                    strMfDpPoolRmnCapa = "?";
                }
            }
        } else {
            strMfDpPoolRmnCapa = SJctrPoolUtility.HAIFUN_STR;
        }
        return strMfDpPoolRmnCapa;
    }

    private String getMfDpLicenceCapacity(SJmoPPKget1PPInfo dPLicense, List<SJmoPoolDetail> poolDetailList) {
        String strMfDpLicense = "";
        strMfDpLicense = this.getSummaryLicenceDisplay(poolDetailList, dPLicense, (byte)3);
        return strMfDpLicense;
    }

    private List<String> getMfDpVvolCapacityInfo(SJmoSubsystemCapacity subSystemCapacityInfo) {
        String strMfDpVvolCapa = "";
        long lMfDpVvolAllocatedCapa = 0L;
        SJctrPoolUtility poolUtil = null;
        String mfDpVvolcapaRatio = "";
        ArrayList<String> mfDpVvolCapacityInfoList = new ArrayList<String>();
        poolUtil = this.getComUtility().getPoolUtility();
        if (subSystemCapacityInfo == null) {
            strMfDpVvolCapa = poolUtil.toCompSummaryDisplay("?", "?");
            mfDpVvolcapaRatio = "?";
        } else {
            lMfDpVvolAllocatedCapa = subSystemCapacityInfo.getLMFDpAllocCapa();
            strMfDpVvolCapa = poolUtil.toCapaRatioSumaryDisplay(lMfDpVvolAllocatedCapa, lMfDpVvolAllocatedCapa, SJctrCapacityUtility.UNIT.KB, this.getComUtility(), false);
            mfDpVvolcapaRatio = poolUtil.capaRatioCalculation(lMfDpVvolAllocatedCapa, lMfDpVvolAllocatedCapa);
        }
        mfDpVvolCapacityInfoList.add(strMfDpVvolCapa);
        mfDpVvolCapacityInfoList.add(mfDpVvolcapaRatio);
        return mfDpVvolCapacityInfoList;
    }

    private String getMfDpVvolEstimatedCapacity(SJmoPoolSummary poolSummary, List<SJmoPoolDetail> poolDetailList, SJctrLicenseContainer licenseContainer) {
        String strCapaRtn = "";
        long lMfDpVolTotalCapa = 0L;
        long lMfDpVolUsedPage = 0L;
        long lPageSize = 0L;
        long lMfDpVolUsedCapa = 0L;
        long lMfDpVolRmnCapa = 0L;
        SJmoPoolDetail poolDetail = null;
        int iCnt = 0;
        long lMfDPVvolRmnCapaBlock = 0L;
        SJctrCapacityUtility capaUtil = null;
        boolean mfDpLicenseFlg = licenseContainer.checkPP(SJctrLicenseContainer.PPID_DP) & licenseContainer.checkPP(SJctrLicenseContainer.PPID_DPFM);
        capaUtil = this.getComUtility().getCapacityUtility();
        if (mfDpLicenseFlg) {
            if (poolSummary == null || poolDetailList == null) {
                strCapaRtn = "?";
            } else {
                lMfDpVolTotalCapa = poolSummary.getLMFDPVolSysCapaEst();
                lMfDpVolTotalCapa *= 1024L;
                for (iCnt = 0; iCnt < poolDetailList.size(); ++iCnt) {
                    poolDetail = poolDetailList.get(iCnt);
                    if (poolDetail.getPoolKind() != 2 || poolDetail.getEmulationType() != 1) continue;
                    lMfDpVolUsedPage = poolDetail.getAouUsed();
                    lPageSize = poolDetail.getPageSize();
                    lMfDpVolUsedCapa += lMfDpVolUsedPage * lPageSize;
                }
                lMfDpVolRmnCapa = lMfDpVolTotalCapa - lMfDpVolUsedCapa;
                lMfDpVolRmnCapa /= 38976L;
                if ((lMfDpVolRmnCapa *= 38976L) >= 0L) {
                    lMfDPVvolRmnCapaBlock = capaUtil.valueOf(lMfDpVolRmnCapa, SJctrCapacityUtility.UNIT.KB);
                    SJctrCapacityUtility.UNIT unit = capaUtil.getUnit(lMfDPVvolRmnCapaBlock);
                    String capString = capaUtil.toString(lMfDPVvolRmnCapaBlock, unit);
                    String unitString = capaUtil.getUnitString(unit);
                    this.mfDpVvolCapaIconFlg = "0.00".equals(capString);
                    strCapaRtn = capString + " " + unitString;
                } else {
                    strCapaRtn = "?";
                }
            }
        } else {
            strCapaRtn = SJctrPoolUtility.HAIFUN_STR;
        }
        return strCapaRtn;
    }

    private String getSummaryLicenceDisplay(List<SJmoPoolDetail> poolDetailList, SJmoPPKget1PPInfo ppLicense, byte iPoolkind) {
        String strLicense = "";
        String strPoolLicenseUsedCapa = "";
        long lPoolLicenseUsedCapa = 0L;
        long lLicenseUsedBlock = 0L;
        SJctrPoolUtility poolUtil = null;
        SJctrCapacityUtility capaUtil = null;
        poolUtil = this.getComUtility().getPoolUtility();
        capaUtil = this.getComUtility().getCapacityUtility();
        if (poolDetailList == null) {
            strLicense = poolUtil.toCompSummaryDisplay("?", "?");
            return strLicense;
        }
        strLicense = this.getLicenceCapacity(ppLicense);
        if (!strLicense.equals("?")) {
            lPoolLicenseUsedCapa = ppLicense.getIUsedCapa();
            if (lPoolLicenseUsedCapa >= 0L) {
                lLicenseUsedBlock = capaUtil.valueOf(lPoolLicenseUsedCapa, SJctrCapacityUtility.UNIT.GB);
                strPoolLicenseUsedCapa = capaUtil.toUnitString(lLicenseUsedBlock);
                strLicense = poolUtil.toCompSummaryDisplay(strPoolLicenseUsedCapa, strLicense);
            } else {
                strLicense = poolUtil.toCompSummaryDisplay("?", "?");
            }
        } else {
            strLicense = poolUtil.toCompSummaryDisplay("?", "?");
        }
        return strLicense;
    }

    private String getTiPoolRmnCapacity(SJmoPoolSummary poolSummary, SJctrLicenseContainer licenseContainer) {
        String strTiPoolRmnCapa = "";
        long lTiPoolTotalCapa = 0L;
        long lTiPoolEnsCapa = 0L;
        long lTiPoolRmnCapa = 0L;
        long lTiPoolRmnBlock = 0L;
        SJctrCapacityUtility capaUtil = null;
        boolean tiLicenseFlg = licenseContainer.checkPP(SJctrLicenseContainer.PPID_DSS);
        capaUtil = this.getComUtility().getCapacityUtility();
        if (tiLicenseFlg) {
            if (poolSummary == null) {
                strTiPoolRmnCapa = "?";
            } else {
                lTiPoolTotalCapa = poolSummary.getLDSPoolSysCapaEst();
                lTiPoolRmnCapa = lTiPoolTotalCapa - (lTiPoolEnsCapa = poolSummary.getLDSPoolCapaTotal());
                if (lTiPoolRmnCapa >= 0L) {
                    lTiPoolRmnBlock = capaUtil.valueOf(lTiPoolRmnCapa, SJctrCapacityUtility.UNIT.MB);
                    SJctrCapacityUtility.UNIT unit = capaUtil.getUnit(lTiPoolRmnBlock);
                    String capString = capaUtil.toString(lTiPoolRmnBlock, unit);
                    String unitString = capaUtil.getUnitString(unit);
                    this.tiPoolCapaIconFlg = "0.00".equals(capString);
                    strTiPoolRmnCapa = capString + " " + unitString;
                } else {
                    strTiPoolRmnCapa = "?";
                }
            }
        } else {
            strTiPoolRmnCapa = SJctrPoolUtility.HAIFUN_STR;
        }
        return strTiPoolRmnCapa;
    }

    private String getTiLicenceCapacity(SJmoPPKget1PPInfo tiLicense, List<SJmoPoolDetail> poolDetailList) {
        String strTiLicense = "";
        strTiLicense = this.getSummaryLicenceDisplay(poolDetailList, tiLicense, (byte)8);
        return strTiLicense;
    }

    private List<String> getTiPoolCapacityInfo(List<SJmoPoolDetail> poolDetailList) {
        String strTiPoolCapa = "";
        long lTiPoolTotalCapa = 0L;
        long lTiPoolUsedCapa = 0L;
        SJctrPoolUtility poolUtil = null;
        String capaRatio = "";
        ArrayList<String> tiPoolCapacityInfoList = new ArrayList<String>();
        poolUtil = this.getComUtility().getPoolUtility();
        if (poolDetailList == null) {
            strTiPoolCapa = poolUtil.toCompSummaryDisplay("?", "?");
            capaRatio = "?";
            tiPoolCapacityInfoList.add(strTiPoolCapa);
            tiPoolCapacityInfoList.add(capaRatio);
            return tiPoolCapacityInfoList;
        }
        for (int iCnt = 0; iCnt < poolDetailList.size(); ++iCnt) {
            SJmoPoolDetail poolDtl = poolDetailList.get(iCnt);
            if (8 != poolDtl.getPoolKind()) continue;
            long lPageSize = poolDtl.getPageSize();
            long lPoolPages = poolDtl.getPoolPages();
            long lPoolCapa = lPageSize * lPoolPages;
            lTiPoolTotalCapa += lPoolCapa;
            long lPoolUsedPages = poolDtl.getPoolUsedPages();
            long lPoolUsedCapa = lPageSize * lPoolUsedPages;
            lTiPoolUsedCapa += lPoolUsedCapa;
        }
        strTiPoolCapa = poolUtil.toCapaRatioSumaryDisplay(lTiPoolUsedCapa, lTiPoolTotalCapa, SJctrCapacityUtility.UNIT.KB, this.getComUtility(), false);
        capaRatio = poolUtil.capaRatioCalculation(lTiPoolUsedCapa, lTiPoolTotalCapa);
        tiPoolCapacityInfoList.add(strTiPoolCapa);
        tiPoolCapacityInfoList.add(capaRatio);
        return tiPoolCapacityInfoList;
    }

    private class SummaryData {
        SJmoPoolSummary poolSummary;
        SJmoPPKget1PPInfo dpLicense;
        SJmoPPKget1PPInfo mfDpLicense;
        SJmoPPKget1PPInfo tiLicense;
        List<SJmoPoolDetail> poolDetailList;
        List<SJmoHDPRelation> hdpRelationList;
        List<SJmoLdevDetail> ldevDetailList;
        List<SJmoPoolVolDetail> poolVolDetailList;
        SJmoRSGgetAllRsgs allRsgs;
        SJmoSubsystemCapacity subSystemCapacity;

        private SummaryData() {
        }
    }
}

