/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.port.hostgroup.SJctrHostGroupSelectDC;
import sanproject.sn2.controller.topwindow.port.hostgroup.SJctrIscsiTargetSelectDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrIscsiTargetSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_IT_NAME = "COM_ISCSI_TARGET_NAME";
    public static final String KEY_IT_ALIAS = "COM_ISCSI_TARGET_ALIAS";
    public static final String KEY_PT_NAME = "COM_PT_NAME";
    public static final String KEY_VSS_MODELSN = "COM_VSS_MDL_SN";
    public static final String KEY_HOSTMODE = "COM_HOSTMODE";
    public static final String KEY_PT_SECU = "COM_PT_SECU";
    public static final String KEY_CHAP_AUTH = "COM_AUTHE";
    public static final String KEY_CHAP_MODE = "COM_MODE";
    public static final String KEY_CHAP_USER_NAME = "COM_USER_NAME";
    private SJctrPortHostGroupTableKey selectPortITInfo = null;

    @Override
    public void makeDataObject() {
        SJmoIscsiTargetInfo itSummary = this.getIscsiTargetSummary(this.getBasicDataMap().get(SJmoGetPortIscsiTargetInfo.class));
        SJmoPortDetail ptDetailSummary = this.getPortDetailSummary(this.getBasicDataMap().get(SJmoGetPortDetail.class));
        SJmoHUVMVirtualDkc virtualDkcSummary = this.getVirtualDkcSummary(this.getBasicDataList(SJmoGetHUVMVirtualDkc.class));
        SJmoPortAttributeInfo attrInfo = this.getPortAttributeInfo(this.getBasicDataMap().get(SJmoGetPortAttributeInfo.class));
        this.makeSummary(ptDetailSummary, itSummary, virtualDkcSummary, attrInfo);
    }

    public SJmoIscsiTargetInfo getIscsiTargetSummary(List<SJmoPortIscsiTargetInfo> portIscsiTargetInfo) {
        SJmoIscsiTargetInfo ret = null;
        if (portIscsiTargetInfo == null) {
            this.logUty.putlog("getIscsiTargetSummary", "Information of SJmoPortIscsiTargetInfo data list is null.");
            return ret;
        }
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrIscsiTargetSelectDC) {
            SJctrIscsiTargetSelectDC itSelDc = (SJctrIscsiTargetSelectDC)dc;
            short selectPort = itSelDc.getSelectPort();
            short selectIscsiTarget = itSelDc.getSelectIscsiTarget();
            SJmoPortIscsiTargetInfo ptITInfo = new SJmoPortIscsiTargetInfo();
            for (SJmoPortIscsiTargetInfo ptIT : portIscsiTargetInfo) {
                if (ptIT.getSPort() != selectPort) continue;
                ptITInfo = ptIT;
                break;
            }
            if (ptITInfo != null) {
                ArrayList<SJmoIscsiTargetInfo> itInfoList = ptITInfo.getAlPortIscsiTarget();
                for (SJmoIscsiTargetInfo it : itInfoList) {
                    if (it.getSIscsiTarget() != selectIscsiTarget) continue;
                    ret = it;
                    this.selectPortITInfo = new SJctrPortHostGroupTableKey(ptITInfo, it);
                    break;
                }
            }
        }
        return ret;
    }

    public SJmoPortDetail getPortDetailSummary(List<SJmoPortDetail> portDetailList) {
        SJmoPortDetail ret = null;
        if (portDetailList == null) {
            this.logUty.putlog("getPortDetailSummary", "Information of SJmoPortDetail data list is null.");
            return ret;
        }
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrIscsiTargetSelectDC) {
            SJctrIscsiTargetSelectDC itSelDc = (SJctrIscsiTargetSelectDC)dc;
            short selectPort = itSelDc.getSelectPort();
            for (SJmoPortDetail ptDetail : portDetailList) {
                if (ptDetail.getSPort() != selectPort) continue;
                ret = ptDetail;
                break;
            }
        }
        return ret;
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    public SJmoPortAttributeInfo getPortAttributeInfo(List<SJmoPortAttributeInfo> portAttributeList) {
        SJctrDataController dc;
        SJmoPortAttributeInfo attrInfo = null;
        if (portAttributeList != null && (dc = this.getDataController()) instanceof SJctrIscsiTargetSelectDC) {
            SJctrIscsiTargetSelectDC itSelDc = (SJctrIscsiTargetSelectDC)dc;
            short selectPort = itSelDc.getSelectPort();
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(selectPort);
            int search = Collections.binarySearch(portAttributeList, portIndex);
            if (search >= 0) {
                attrInfo = portAttributeList.get(search);
            }
        }
        return attrInfo;
    }

    private SJmoHUVMVirtualDkc getVirtualDkcSummary(List<SJmoHUVMVirtualDkc> vdkcList) {
        List<SJmoGetRSGgetAllRsgs> rsgList;
        SJctrDataController dc;
        SJmoHUVMVirtualDkc ret = null;
        SJmoRSGgetRsg rsg = null;
        if (this.getDataController() instanceof SJctrHostGroupSelectDC) {
            dc = (SJctrHostGroupSelectDC)this.getDataController();
            rsgList = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
            if (rsgList == null || rsgList.size() == 0) {
                return ret;
            }
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(dc.getOwner(), (SJmoRSGgetAllRsgs)((Object)rsgList.get(0)));
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            hgIndex.setSPort(((SJctrHostGroupSelectDC)dc).getSelectPort());
            hgIndex.setSHostGroup(((SJctrHostGroupSelectDC)dc).getSelectHostGroup());
            rsg = rsgUtil.getRsgFromHg(hgIndex);
        } else if (this.getDataController() instanceof SJctrIscsiTargetSelectDC) {
            dc = (SJctrIscsiTargetSelectDC)this.getDataController();
            rsgList = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
            if (rsgList == null || rsgList.size() == 0) {
                return ret;
            }
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(dc.getOwner(), (SJmoRSGgetAllRsgs)((Object)rsgList.get(0)));
            SJmoPortIndex portIdx = new SJmoPortIndex();
            portIdx.setSPort(((SJctrIscsiTargetSelectDC)dc).getSelectPort());
            rsg = rsgUtil.getRsgFromPort(portIdx);
        }
        if (rsg == null) {
            return ret;
        }
        SJmoHUVMvboxIndex targetIndex = rsg.getRsgInfo().getVboxIndex();
        int vBoxIndex = Collections.binarySearch(vdkcList, targetIndex);
        if (vBoxIndex < 0) {
            return ret;
        }
        ret = vdkcList.get(vBoxIndex);
        return ret;
    }

    protected void makeSummary(SJmoPortDetail portDetail, SJmoIscsiTargetInfo iscsiTarInfo, SJmoHUVMVirtualDkc virtualDkc, SJmoPortAttributeInfo portAttribute) {
        SJmoHostGroupInfo hgInfo = new SJmoHostGroupInfo();
        hgInfo.setSHostGroup(iscsiTarInfo.getSIscsiTarget());
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrComUtility util = uc.getComUtility();
        SJctrPortUtility ptUtil = util.getPortUtility();
        SJctrIscsiUtility iscsiUtil = util.getIscsiUtility();
        SJctrRsgUtility rsgUtil = this.getComUtility().getRsgUtility();
        boolean initiatorflg = false;
        if (portAttribute != null) {
            initiatorflg = portAttribute.getByPortKind() == 5;
        }
        String vssModelSerialNo = SJctrPortUtility.STR_HYPHEN;
        if (!initiatorflg) {
            vssModelSerialNo = rsgUtil.toDispStringVssModelSerialNo(virtualDkc);
        }
        byte byHostMode = (byte)iscsiTarInfo.getIHostMode();
        String chap_user = this.getChapUserName(iscsiTarInfo);
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_IT_NAME, SJctrIscsiUtility.getIscsiTargetNameString(iscsiTarInfo));
        ((SJctrDataObject)summaryData).setData(KEY_IT_ALIAS, iscsiUtil.getIscsiTargetAliasIdString(iscsiTarInfo));
        ((SJctrDataObject)summaryData).setData(KEY_PT_NAME, portDetail.getStrPortDisplayName());
        ((SJctrDataObject)summaryData).setData(KEY_VSS_MODELSN, vssModelSerialNo);
        ((SJctrDataObject)summaryData).setData(KEY_HOSTMODE, ptUtil.toHostModeDisplay(byHostMode));
        ((SJctrDataObject)summaryData).setData(KEY_PT_SECU, ptUtil.toPortSecuritySwitchDisplay(portDetail, hgInfo));
        ((SJctrDataObject)summaryData).setData(KEY_CHAP_AUTH, ptUtil.toDispStringChapAuth(iscsiTarInfo));
        ((SJctrDataObject)summaryData).setData(KEY_CHAP_MODE, ptUtil.toDispStringChapMode(iscsiTarInfo));
        ((SJctrDataObject)summaryData).setData(KEY_CHAP_USER_NAME, chap_user);
    }

    public String getChapUserName(SJmoIscsiTargetInfo iscsiTargetInfo) {
        String userName = "?";
        if (iscsiTargetInfo != null) {
            userName = iscsiTargetInfo.getStrTargetUserName();
        }
        return userName;
    }

    public SJctrPortHostGroupTableKey getSelectPortITTableKey() {
        return this.selectPortITInfo;
    }
}

