/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.hostgroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.port.hostgroup.SJctrHostGroupSelectDC;
import sanproject.sn2.controller.topwindow.port.port.SJctrPortSelectDC;
import sanproject.sn2.controller.topwindow.port.port.host.SJctrIscsiPortHostDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrHostGroupSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_HG_NAME = "COM_HG_NAME";
    public static final String KEY_PT_NAME = "COM_PT_NAME";
    public static final String KEY_HOSTMODE = "COM_HOSTMODE";
    public static final String KEY_PT_SECU = "COM_PT_SECU";
    public static final String KEY_VSS_MODELSN = "COM_VSS_MDL_SN";
    public static final String KEY_ALUASTATE = "COM_ASYM_STATE";
    public static final String KEY_T10PI_MODE = "COM_T10PI_MODE";
    private SJctrPortHostGroupTableKey selectPortHGInfo = null;
    private SummaryData summary = null;

    @Override
    public void makeDataObject() {
        this.summary = new SummaryData();
        this.summary.hgInfo = this.getHostGroupSummary(this.getBasicDataList(SJmoGetPortHostGroupInfo.class));
        this.summary.portDetail = this.getPortDetailSummary(this.getBasicDataList(SJmoGetPortDetail.class));
        this.summary.virtualDkc = this.getVirtualDkcSummary(this.getBasicDataList(SJmoGetHUVMVirtualDkc.class));
        this.summary.portAttribute = this.getPortAttributeSummary(this.getBasicDataList(SJmoGetPortAttributeInfo.class));
        this.makeSummary();
    }

    public SJmoHostGroupInfo getHostGroupSummary(List<SJmoPortHostGroupInfo> portHostGroupInfo) {
        SJmoHostGroupInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrHostGroupSelectDC) {
            SJctrHostGroupSelectDC hgSelDc = (SJctrHostGroupSelectDC)dc;
            short selectPort = hgSelDc.getSelectPort();
            short selectHostGroup = hgSelDc.getSelectHostGroup();
            SJmoPortHostGroupInfo ptHgInfo = null;
            for (SJmoPortHostGroupInfo ptHg : portHostGroupInfo) {
                if (ptHg.getSPort() != selectPort) continue;
                ptHgInfo = ptHg;
                break;
            }
            if (ptHgInfo != null) {
                ArrayList hgInfoList = ptHgInfo.getAlPortHostGroup();
                for (SJmoHostGroupInfo hg : hgInfoList) {
                    if (hg.getSHostGroup() != selectHostGroup) continue;
                    ret = hg;
                    this.selectPortHGInfo = new SJctrPortHostGroupTableKey(ptHgInfo, hg);
                    break;
                }
            }
        }
        return ret;
    }

    public SJmoPortDetail getPortDetailSummary(List<SJmoPortDetail> portDetailList) {
        SJmoPortDetail ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrHostGroupSelectDC) {
            SJctrHostGroupSelectDC hgSelDc = (SJctrHostGroupSelectDC)dc;
            short selectPort = hgSelDc.getSelectPort();
            for (SJmoPortDetail ptDetail : portDetailList) {
                if (ptDetail.getSPort() != selectPort) continue;
                ret = ptDetail;
                break;
            }
        }
        return ret;
    }

    private SJmoHUVMVirtualDkc getVirtualDkcSummary(List<SJmoHUVMVirtualDkc> vdkcList) {
        List<SJmoGetRSGgetAllRsgs> rsgList;
        SJctrDataController dc;
        SJmoHUVMVirtualDkc ret = null;
        SJmoRSGgetRsg rsg = null;
        if (this.getDataController() instanceof SJctrHostGroupSelectDC) {
            this.logUty.putlog("getVirtualDkcSummary", "HostGroup DC root.");
            dc = (SJctrHostGroupSelectDC)this.getDataController();
            rsgList = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
            if (rsgList == null || rsgList.size() == 0) {
                return ret;
            }
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(dc.getOwner(), (SJmoRSGgetAllRsgs)((Object)rsgList.get(0)));
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            hgIndex.setSPort(((SJctrHostGroupSelectDC)dc).getSelectPort());
            hgIndex.setSHostGroup(((SJctrHostGroupSelectDC)dc).getSelectHostGroup());
            rsg = rsgUtil.getRsgFromHg(hgIndex);
        } else if (this.getDataController() instanceof SJctrIscsiPortHostDC) {
            this.logUty.putlog("getVirtualDkcSummary", "IscsiPortHost DC root.");
            dc = (SJctrIscsiPortHostDC)this.getDataController();
            rsgList = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
            if (rsgList == null || rsgList.size() == 0) {
                return ret;
            }
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(dc.getOwner(), (SJmoRSGgetAllRsgs)((Object)rsgList.get(0)));
            SJmoPortIndex portIdx = new SJmoPortIndex();
            portIdx.setSPort(((SJctrPortSelectDC)dc).getSelectPort());
            rsg = rsgUtil.getRsgFromPort(portIdx);
        }
        if (rsg == null) {
            return ret;
        }
        SJmoHUVMvboxIndex targetIndex = rsg.getRsgInfo().getVboxIndex();
        int vBoxIndex = Collections.binarySearch(vdkcList, targetIndex);
        if (vBoxIndex < 0) {
            this.logUty.putlog("getVirtualDkcSummary", "vBoxIndex not found.");
            return ret;
        }
        ret = vdkcList.get(vBoxIndex);
        this.logUty.putlog("getVirtualDkcSummary", "vBoxIndex:" + ret);
        return ret;
    }

    public SJmoPortAttributeInfo getPortAttributeSummary(List<SJmoPortAttributeInfo> portAttributeList) {
        SJctrDataController dc;
        SJmoPortAttributeInfo ret = null;
        if (portAttributeList != null && (dc = this.getDataController()) instanceof SJctrHostGroupSelectDC) {
            SJctrHostGroupSelectDC hgSelDc = (SJctrHostGroupSelectDC)dc;
            short selectPort = hgSelDc.getSelectPort();
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(selectPort);
            int search = Collections.binarySearch(portAttributeList, portIndex);
            if (search >= 0) {
                ret = portAttributeList.get(search);
            }
        }
        this.logUty.putlog("getPortAttributeSummary", "portAttributeList:" + ret);
        return ret;
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetPortHostGroupInfo ptHgInfo_kind = new SJmoGetPortHostGroupInfo();
        SJmoGetRange_IF ptHgInfo_range = null;
        ArrayList ptHgInfo_filterList = new ArrayList();
        SJmoGetDirect ptHgInfo_direct = new SJmoGetDirect(ptHgInfo_kind, ptHgInfo_range, ptHgInfo_filterList);
        this.directList.add(new SJctrGetDirectWrapper(ptHgInfo_direct));
        SJmoGetPortDetail ptDetail_kind = new SJmoGetPortDetail();
        SJmoGetRange_IF ptDetail_range = null;
        ArrayList ptDetail_filterList = new ArrayList();
        SJmoGetDirect ptDetail_direct = new SJmoGetDirect(ptDetail_kind, ptDetail_range, ptDetail_filterList);
        this.directList.add(new SJctrGetDirectWrapper(ptDetail_direct));
        SJmoGetKind_IF kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    protected void makeSummary() {
        SJmoHostGroupInfo hostGrpInfo = null;
        SJmoPortDetail portDetail = null;
        SJmoHUVMVirtualDkc virtualDkc = null;
        SJmoPortAttributeInfo portAttribute = null;
        if (this.summary != null) {
            hostGrpInfo = this.summary.hgInfo;
            portDetail = this.summary.portDetail;
            virtualDkc = this.summary.virtualDkc;
            portAttribute = this.summary.portAttribute;
        }
        SJctrRsgUtility rsgUtil = this.getComUtility().getRsgUtility();
        String hg_name = this.getHostGroupName(hostGrpInfo);
        String pt_name = this.getPortName(portDetail);
        String hostmode = this.getHostMode(hostGrpInfo);
        String pt_secu = this.getPortSecurity(portDetail, hostGrpInfo);
        boolean initiatorflg = false;
        if (portAttribute != null) {
            initiatorflg = portAttribute.getByPortKind() == 5;
        }
        String vssModelSerialNo = SJctrPortUtility.STR_HYPHEN;
        if (!initiatorflg) {
            vssModelSerialNo = rsgUtil.toDispStringVssModelSerialNo(virtualDkc);
            this.logUty.putlog("makeSummary", "vssModelSerialNo:" + vssModelSerialNo);
        }
        String t10pimode = this.getT10PiMode(portDetail);
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_HG_NAME, hg_name);
        ((SJctrDataObject)summaryData).setData(KEY_PT_NAME, pt_name);
        ((SJctrDataObject)summaryData).setData(KEY_HOSTMODE, hostmode);
        ((SJctrDataObject)summaryData).setData(KEY_PT_SECU, pt_secu);
        ((SJctrDataObject)summaryData).setData(KEY_VSS_MODELSN, vssModelSerialNo);
        ((SJctrDataObject)summaryData).setData(KEY_T10PI_MODE, t10pimode);
        String aluaState = this.getAsymmetricAccessState(this.getSelectPortHGTableKey());
        ((SJctrDataObject)summaryData).setData(KEY_ALUASTATE, aluaState);
    }

    private String getHostGroupName(SJmoHostGroupInfo hostGrpInfo) {
        String name = "";
        if (hostGrpInfo != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            name = portutil.toHostGroupNameDisplay(hostGrpInfo);
        }
        return name;
    }

    private String getPortName(SJmoPortDetail portDetail) {
        String name = "";
        if (portDetail != null) {
            name = portDetail.getStrPortDisplayName();
        }
        return name;
    }

    private String getHostMode(SJmoHostGroupInfo hostGrpInfo) {
        String mode = "";
        if (hostGrpInfo != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            mode = portutil.toHostModeDisplay(hostGrpInfo);
        }
        return mode;
    }

    private String getPortSecurity(SJmoPortDetail portDetail, SJmoHostGroupInfo hostGrpInfo) {
        String secu = "";
        if (portDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            secu = portutil.toPortSecuritySwitchDisplay(portDetail, hostGrpInfo);
        }
        return secu;
    }

    private String getAsymmetricAccessState(SJctrPortHostGroupTableKey phgTableKey) {
        String aluaState = SJctrPortUtility.STR_HYPHEN;
        List<SJmoGetPortLunInfo> portLunInfoList = this.getBasicDataList(SJmoGetPortLunInfo.class);
        SJmoPortHostGroupInfo hostGroupInfo = phgTableKey.getPortHostGroupInfo();
        if (hostGroupInfo == null) {
            return aluaState;
        }
        int portIndex = Collections.binarySearch(portLunInfoList, hostGroupInfo);
        if (portIndex < 0) {
            return aluaState;
        }
        SJmoPortLunInfo portLunInfo = (SJmoPortLunInfo)((Object)portLunInfoList.get(portIndex));
        ArrayList portLunList = portLunInfo.getAlHostGroupLun(phgTableKey.getHostGroupInfo().getSHostGroup());
        if (portLunList.size() > 0) {
            SJmoPortLunDetail portLunDetail = (SJmoPortLunDetail)portLunList.get(0);
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            aluaState = portutil.toAluaStateDisplay(portLunDetail);
        }
        return aluaState;
    }

    public SJctrPortHostGroupTableKey getSelectPortHGTableKey() {
        return this.selectPortHGInfo;
    }

    private String getT10PiMode(SJmoPortDetail ptDetail) {
        String t10PiMode = "?";
        if (ptDetail != null) {
            SJctrUserController uc = this.getDataController().getOwner();
            SJctrComUtility util = uc.getComUtility();
            SJctrPortUtility portutil = util.getPortUtility();
            t10PiMode = portutil.toT10PIModeDisplay(ptDetail);
        }
        return t10PiMode;
    }

    private class SummaryData {
        SJmoHostGroupInfo hgInfo = null;
        SJmoPortDetail portDetail = null;
        SJmoHUVMVirtualDkc virtualDkc = null;
        SJmoPortAttributeInfo portAttribute = null;

        private SummaryData() {
        }
    }
}

