/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.iscsi.port;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.port.port.SJctrPortSelectDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortChapUserInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrIscsiPortSummaryModel
extends SJctrSimpleDataModel {
    private static final String COM_IPV4_IP_ADDR = "COM_IPV4_IP_ADDR";
    private static final String COM_IPV4_SUBNET_MASK = "COM_IPV4_SUBNET_MASK";
    private static final String COM_IPV4_DEF_GATEWAY = "COM_IPV4_DEF_GATEWAY";
    private static final String COM_IPV6_MODE = "COM_IPV6_MODE";
    private static final String COM_IPV6_LINK_LOCAL_ADDR = "COM_IPV6_LINK_LOCAL_ADDR";
    private static final String COM_IPV6_GLOBAL_ADDR = "COM_IPV6_GLOBAL_ADDR";
    private static final String COM_IPV6_GLOBAL_ADDR2 = "COM_IPV6_GLOBAL_ADDR2";
    private static final String COM_IPV6_ASSIGN_DEF_GATEWAY = "COM_IPV6_ASSIGN_DEF_GATEWAY";
    private static final String COM_INTERNAL_ISCSI_NAME = "COM_INTERNAL_ISCSI_NAME";
    private static final String COM_SPEED = "COM_SPEED";
    private static final String COM_SECURITY = "COM_SECURITY";
    private static final String COM_ATTRIBUTE = "COM_ATTRIBUTE";
    private static final String COM_TCP_PORT_NUM = "COM_TCP_PORT_NUM";
    private static final String COM_MTU_SIZE = "COM_MTU_SIZE";
    private static final String COM_MAC_ADDR = "COM_MAC_ADDR";
    private static final String COM_KEEP_ALIVE_TIME = "COM_KEEP_ALIVE_TIME";
    private static final String COM_SEL_ACK = "COM_SEL_ACK";
    private static final String COM_DEL_ACK = "COM_DEL_ACK";
    private static final String COM_MAXIMUM_WINDOW_SIZE = "COM_MAXIMUM_WINDOW_SIZE";
    private static final String COM_ISNS_MODE = "COM_ISNS_MODE";
    private static final String COM_ISNS_IP_ADDR = "COM_ISNS_IP_ADDR";
    private static final String COM_ISNS_TCP_PORT_NUM = "COM_ISNS_TCP_PORT_NUM";
    private static final String COM_VLAN_TAG_MODE = "COM_VLAN_TAG_MODE";
    private static final String COM_VLAN_NAME = "COM_VLAN_NAME";
    private static final String COM_CHAP_USER_NAME = "COM_CHAP_USER_NAME";
    private static final String COM_NUM_OF_LUN = "COM_NUM_OF_LUN";
    private static final String COM_NUM_OF_HOST = "COM_NUM_OF_HOST";
    private static final String COM_NUM_OF_ISCSI = "COM_NUM_OF_ISCSI";
    private static final String COM_NUM_OF_CHAP_USER = "COM_NUM_OF_CHAP_USER";
    private static final String COM_ISCSI_VPORT_MODE = "COM_ISCSI_VPORT_MODE";

    @Override
    protected void makeModelDirect() {
        super.makeModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortChapUserInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public void makeDataObject() {
        List<SJmoGetPortChapUserInfo> portChapUserInfoList;
        List<SJmoGetPortIscsiNameInfo> portIscsiNameInfoList;
        List<?> portIscsiTargetInfoList;
        List<SJmoGetPortLunInfo> portLunInfoList;
        List<?> portAttributeList;
        List<?> portdetailList = this.getBasicDataMap().get(SJmoGetPortDetail.class);
        if (portdetailList == null) {
            this.logUty.putlog("makeDataObject", "Information of SJmoPortDetail data list is null.");
        }
        if ((portAttributeList = this.getBasicDataMap().get(SJmoGetPortAttributeInfo.class)) == null) {
            this.logUty.putlog("makeDataObject", "Information of SJmoPortAttributeInfo data list is null.");
        }
        if ((portLunInfoList = this.getBasicDataList(SJmoGetPortLunInfo.class)) == null) {
            this.logUty.putlog("makeDataObject", "Information of SJmoPortLunInfo data list is null.");
        }
        if ((portIscsiTargetInfoList = this.getBasicDataMap().get(SJmoGetPortIscsiTargetInfo.class)) == null) {
            this.logUty.putlog("makeDataObject", "Information of SJmoPortIscsiTargetInfo data list is null.");
        }
        if ((portIscsiNameInfoList = this.getBasicDataList(SJmoGetPortIscsiNameInfo.class)) == null) {
            this.logUty.putlog("makeDataObject", "Information of SJmoPortIscsiNameInfo data list is null.");
        }
        if ((portChapUserInfoList = this.getBasicDataList(SJmoGetPortChapUserInfo.class)) == null) {
            this.logUty.putlog("makeDataObject", "Information of SJmoPortChapUserInfo data list is null.");
        }
        SJmoRSGgetAllRsgs allRsgs = null;
        List<?> allRsgsList = this.getBasicDataMap().get(SJmoGetRSGgetAllRsgs.class);
        if (null == allRsgsList) {
            this.logUty.putlog("makeDataObject", "Information of SJmoRSGgetAllRsgs data list is null.");
        } else if (0 == allRsgsList.size()) {
            this.logUty.putlog("makeDataObject", "Size of SJmoRSGgetAllRsgs data list is zero.");
        } else {
            allRsgs = (SJmoRSGgetAllRsgs)allRsgsList.get(0);
            if (null == allRsgs) {
                this.logUty.putlog("makeDataObject", "Information of SJmoRSGgetAllRsgs is null.");
            }
        }
        short portId = this.getPortID();
        SJmoPortDetail ptDetailInfo = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortId(portdetailList, portId);
        SJmoPortAttributeInfo ptAttributeInfo = (SJmoPortAttributeInfo)SJctrIscsiUtility.getPortInfoByPortId(portAttributeList, portId);
        SJmoPortLunInfo ptLunInfo = (SJmoPortLunInfo)SJctrIscsiUtility.getPortInfoByPortId(portLunInfoList, portId);
        SJmoPortIscsiTargetInfo ptIscsiTargetInfo = (SJmoPortIscsiTargetInfo)SJctrIscsiUtility.getPortInfoByPortId(portIscsiTargetInfoList, portId);
        SJmoPortIscsiNameInfo ptIscsiNameInfo = (SJmoPortIscsiNameInfo)SJctrIscsiUtility.getPortInfoByPortId(portIscsiNameInfoList, portId);
        SJmoPortChapUserInfo ptChapUserInfo = (SJmoPortChapUserInfo)SJctrIscsiUtility.getPortInfoByPortId(portChapUserInfoList, portId);
        SJctrIscsiUtility iscsiUtil = this.getComUtility().getIscsiUtility();
        SJctrPortUtility portUtil = this.getComUtility().getPortUtility();
        SJctrResourceGroupUtility rsgUtil = null;
        if (allRsgs != null) {
            rsgUtil = new SJctrResourceGroupUtility(this.getDataController().getOwner(), allRsgs);
        }
        String ipAdrIP4 = SJctrPortUtility.STR_HYPHEN;
        String subNetIP4 = SJctrPortUtility.STR_HYPHEN;
        String defIP4 = SJctrPortUtility.STR_HYPHEN;
        String modeIP6 = SJctrPortUtility.STR_HYPHEN;
        String linkLocalIP6 = SJctrPortUtility.STR_HYPHEN;
        String grobalIP6 = SJctrPortUtility.STR_HYPHEN;
        String grobal2IP6 = SJctrPortUtility.STR_HYPHEN;
        String assignDefGateWayIP6 = SJctrPortUtility.STR_HYPHEN;
        String mtuSize = SJctrPortUtility.STR_HYPHEN;
        String tcpPortNum = SJctrPortUtility.STR_HYPHEN;
        String kept = SJctrPortUtility.STR_HYPHEN;
        String selAck = SJctrPortUtility.STR_HYPHEN;
        String delAcl = SJctrPortUtility.STR_HYPHEN;
        String maxWinSize = SJctrPortUtility.STR_HYPHEN;
        String tagMode = SJctrPortUtility.STR_HYPHEN;
        String id = SJctrPortUtility.STR_HYPHEN;
        String internalIscsiName = SJctrIscsiUtility.getInternalIscsiNameString(ptDetailInfo);
        String speed = portUtil.toChannelSpeedDisplay(ptDetailInfo);
        String security = portUtil.toPortSecuritySwitchDisplay(ptDetailInfo);
        String attribute = portUtil.toPortAttributeDisplay(ptAttributeInfo);
        String macAdr = iscsiUtil.getMacAddrString(ptDetailInfo);
        String modeIsns = iscsiUtil.getIsnsModeString(ptDetailInfo);
        String ipIsns = iscsiUtil.getIsnsIpAddrString(ptDetailInfo);
        String tcpPortNumIsns = iscsiUtil.getIsnsTcpPortNumString(ptDetailInfo);
        String chapUserName = SJctrIscsiUtility.getInitiatorChapUserNameString(ptDetailInfo);
        String numLun = iscsiUtil.getNumOfLunsString(ptLunInfo);
        String numHost = iscsiUtil.getNumOfHostsString(ptIscsiNameInfo);
        String numIscsi = iscsiUtil.getNumOfIscsiTargetsString(ptIscsiTargetInfo, rsgUtil);
        String numChap = iscsiUtil.getNumOfChapUsersString(ptChapUserInfo);
        String vportMode = iscsiUtil.getVPortModeString(ptDetailInfo);
        if (ptDetailInfo.getIVPortMode() != 1) {
            ipAdrIP4 = iscsiUtil.getIpv4AddrString(ptDetailInfo);
            subNetIP4 = iscsiUtil.getIpv4SubnetMaskString(ptDetailInfo);
            defIP4 = iscsiUtil.getIpv4DefGatewayString(ptDetailInfo);
            modeIP6 = iscsiUtil.getIpv6ModeString(ptDetailInfo);
            linkLocalIP6 = iscsiUtil.getIpv6LinkLocalAddrString(ptDetailInfo);
            grobalIP6 = iscsiUtil.getIpv6GlobalAddrString(ptDetailInfo);
            grobal2IP6 = iscsiUtil.getIpv6GlobalAddr2String(ptDetailInfo);
            assignDefGateWayIP6 = iscsiUtil.getIpv6AssignDefGatewayString(ptDetailInfo);
            mtuSize = iscsiUtil.getMtuSizeString(ptDetailInfo);
            tcpPortNum = iscsiUtil.getTcpPortNumString(ptDetailInfo);
            kept = iscsiUtil.getKeepAliveTimerString(ptDetailInfo);
            selAck = iscsiUtil.getSelectiveAckString(ptDetailInfo);
            delAcl = iscsiUtil.getDelayedAckString(ptDetailInfo);
            maxWinSize = iscsiUtil.getMaximumWindowSizeString(ptDetailInfo);
            tagMode = iscsiUtil.getVlanTagModeString(ptDetailInfo);
            id = iscsiUtil.getVlanIdString(ptDetailInfo);
        }
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(COM_ISCSI_VPORT_MODE, vportMode);
        ((SJctrDataObject)summaryData).setData(COM_IPV4_IP_ADDR, ipAdrIP4);
        ((SJctrDataObject)summaryData).setData(COM_IPV4_SUBNET_MASK, subNetIP4);
        ((SJctrDataObject)summaryData).setData(COM_IPV4_DEF_GATEWAY, defIP4);
        ((SJctrDataObject)summaryData).setData(COM_IPV6_MODE, modeIP6);
        ((SJctrDataObject)summaryData).setData(COM_IPV6_LINK_LOCAL_ADDR, linkLocalIP6);
        ((SJctrDataObject)summaryData).setData(COM_IPV6_GLOBAL_ADDR, grobalIP6);
        ((SJctrDataObject)summaryData).setData(COM_IPV6_GLOBAL_ADDR2, grobal2IP6);
        ((SJctrDataObject)summaryData).setData(COM_IPV6_ASSIGN_DEF_GATEWAY, assignDefGateWayIP6);
        ((SJctrDataObject)summaryData).setData(COM_INTERNAL_ISCSI_NAME, internalIscsiName);
        ((SJctrDataObject)summaryData).setData(COM_SPEED, speed);
        ((SJctrDataObject)summaryData).setData(COM_SECURITY, security);
        ((SJctrDataObject)summaryData).setData(COM_ATTRIBUTE, attribute);
        ((SJctrDataObject)summaryData).setData(COM_MTU_SIZE, mtuSize);
        ((SJctrDataObject)summaryData).setData(COM_TCP_PORT_NUM, tcpPortNum);
        ((SJctrDataObject)summaryData).setData(COM_MAC_ADDR, macAdr);
        ((SJctrDataObject)summaryData).setData(COM_KEEP_ALIVE_TIME, kept);
        ((SJctrDataObject)summaryData).setData(COM_SEL_ACK, selAck);
        ((SJctrDataObject)summaryData).setData(COM_DEL_ACK, delAcl);
        ((SJctrDataObject)summaryData).setData(COM_MAXIMUM_WINDOW_SIZE, maxWinSize);
        ((SJctrDataObject)summaryData).setData(COM_ISNS_MODE, modeIsns);
        ((SJctrDataObject)summaryData).setData(COM_ISNS_IP_ADDR, ipIsns);
        ((SJctrDataObject)summaryData).setData(COM_ISNS_TCP_PORT_NUM, tcpPortNumIsns);
        ((SJctrDataObject)summaryData).setData(COM_VLAN_TAG_MODE, tagMode);
        ((SJctrDataObject)summaryData).setData(COM_VLAN_NAME, id);
        ((SJctrDataObject)summaryData).setData(COM_CHAP_USER_NAME, chapUserName);
        ((SJctrDataObject)summaryData).setData(COM_NUM_OF_LUN, numLun);
        ((SJctrDataObject)summaryData).setData(COM_NUM_OF_HOST, numHost);
        ((SJctrDataObject)summaryData).setData(COM_NUM_OF_ISCSI, numIscsi);
        ((SJctrDataObject)summaryData).setData(COM_NUM_OF_CHAP_USER, numChap);
    }

    public short getPortID() {
        short ret = -1;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrPortSelectDC) {
            SJctrPortSelectDC ptSelDc = (SJctrPortSelectDC)dc;
            ret = ptSelDc.getSelectPort();
        }
        return ret;
    }
}

