/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.loginwwn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.port.SJctrPortSummaryModel;
import sanproject.sn2.controller.topwindow.port.loginwwn.SJctrLoginWwnActionMenuModel;
import sanproject.sn2.controller.topwindow.port.loginwwn.SJctrLoginWwnTableModel;
import sanproject.sn2.controller.wizard.lunm.addtohostgroups.SJctrAddtoHGSubWizard;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortWwnTableKey;
import sanproject.sn2.controller.wizard.lunm.delloginwwns.SJctrDelLoginWWNsSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteloginiscsinames.SJctrDeleteLoginIscsiNamesSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.viewloginiscsinamestatus.SJctrViewLoginIscsiNameStatusDC;
import sanproject.sn2.controller.wizard.lunm.loginwwnstatus.SJctrViewLoginWwnStatusDC;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoPortWwnInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;

public class SJctrLoginWwnDC
extends SJctrDataController {
    public static final int DISP_ID = 1812;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    public static final String KEY_SELECTED_ISCSI_NAMES = "KEY_SELECTED_ISCSI_NAMES";

    private void initDataObjectModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrPortSummaryModel());
        SJctrLoginWwnTableModel tableModel = new SJctrLoginWwnTableModel();
        this.addDataObjectModel(KEY_TABLE, tableModel);
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrLoginWwnActionMenuModel());
    }

    public SJctrLoginWwnDC() throws SJcException {
        super(1812);
        this.initDataObjectModel();
        this.initListener();
    }

    private void initListener() {
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_DEL_LOGINWWNS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLoginWwnDC.this.makeDelLoginWwns(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_ADDTOHOSTGROUPS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLoginWwnDC.this.makeAddtoHostGroups(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_VIEWLOGINWWNSTATUS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLoginWwnDC.this.makeViewLoginWWNStatus(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_DEL_LOGINISCSISNAME, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLoginWwnDC.this.makeDelLoginIscsiNames(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_VIEWLOGINISCSINAMESTATUS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLoginWwnDC.this.makeViewLoginIscsiStatus(event, dstModel);
            }
        });
    }

    private void makeDelLoginWwns(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDelLoginWwns", "not selected");
            return;
        }
        ArrayList<SJctrPortWwnTableKey> selPtWwnList = new ArrayList<SJctrPortWwnTableKey>();
        for (Object rowObj : selectedRowList) {
            SJctrPortWwnTableKey portWwnKey = (SJctrPortWwnTableKey)rowObj;
            if (!portWwnKey.isFibre()) {
                this.getLogUty().putlog("makeDelLoginWwns", "selected row is iSCSI");
                SJctrError err = new SJctrError(10, 22, 206517);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoPortWwnInfo portWwnInfo = portWwnKey.getPortWwnInfo();
            SJmoWwn wwnInfo = portWwnKey.getWwnInfo();
            SJctrPortWwnTableKey sel1PtWwn = new SJctrPortWwnTableKey(portWwnInfo, wwnInfo);
            selPtWwnList.add(sel1PtWwn);
        }
        HashMap param = new HashMap();
        param.put(SJctrPortWwnTableKey.class.getName(), selPtWwnList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrDelLoginWWNsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeAddtoHostGroups(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeCreateAltPaths", "not selected");
            return;
        }
        ArrayList<SJmoWwn> selecteList = new ArrayList<SJmoWwn>(selectedRowList.size());
        for (Object selectRow : selectedRowList) {
            SJctrPortWwnTableKey tableKey = (SJctrPortWwnTableKey)selectRow;
            if (!tableKey.isFibre()) {
                this.getLogUty().putlog("makeDelLoginWwns", "selected row is iSCSI");
                SJctrError err = new SJctrError(10, 22, 206517);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoWwn wwn = tableKey.getWwnInfo();
            selecteList.add(wwn);
        }
        HashMap param = new HashMap();
        param.put(SJmoWwn.class.getName(), selecteList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAddtoHGSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeViewLoginWWNStatus(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrViewLoginWwnStatusDC.class, null);
        this.addUpdateDisp(dialogRelated);
    }

    protected void makeDelLoginIscsiNames(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDelLoginIscsiName", "not selected");
            return;
        }
        ArrayList<SJmoIscsiName> selPtIscsiNameList = new ArrayList<SJmoIscsiName>();
        for (Object selectRow : selectedRowList) {
            SJctrPortWwnTableKey tableKey = (SJctrPortWwnTableKey)selectRow;
            if (!tableKey.isFibre()) {
                selPtIscsiNameList.add(tableKey.getIscsiNameInfo());
                continue;
            }
            this.getLogUty().putlog("makeEditHGs", "selected row is Fibre");
            SJctrError err = new SJctrError(10, 22, 206518);
            SJcException exp = err.createException();
            throw exp;
        }
        HashMap param = new HashMap();
        param.put(KEY_SELECTED_ISCSI_NAMES, selPtIscsiNameList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrDeleteLoginIscsiNamesSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    protected void makeViewLoginIscsiStatus(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrViewLoginIscsiNameStatusDC.class, null);
        this.addUpdateDisp(dialogRelated);
    }

    public static enum HG_NOTIFY_STATE implements SJctrNotifyState
    {
        MAKE_DEL_LOGINWWNS,
        MAKE_ADDTOHOSTGROUPS,
        MAKE_VIEWLOGINWWNSTATUS,
        MAKE_DEL_LOGINISCSISNAME,
        MAKE_VIEWLOGINISCSINAMESTATUS;

    }
}

