/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.portcondition;

import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.portcondition.SJctrDKCKgetPortLEDStatusInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrPortConditionSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_NUM_OF_CONCT = "COM_NUM_OF_CONCT";
    public static final String KEY_NUM_OF_NOT_CONCT = "COM_NUM_OF_NOT_CONCT";
    public static final String KEY_NUM_OF_NOT_AVAIL = "COM_NUM_OF_NOT_AVAIL";
    private List<SJmoPortDetail> portDetailList = null;
    private List<SJmoPortIndex> resourcePortIndexList = null;
    private List<SJctrDKCKgetPortLEDStatusInfo> portLEDInfoList = null;

    @Override
    public void makeDataModel() {
        int countNotAvailable = 0;
        int countConect = 0;
        int countNotConect = 0;
        for (SJmoPortDetail portDetail : this.portDetailList) {
            byte kind = portDetail.getByPortKindNo();
            if (SJctrPortUtility.isHnasPort(kind)) continue;
            int resourcePortIndex = Collections.binarySearch(this.resourcePortIndexList, portDetail);
            if (resourcePortIndex >= 0) {
                int portLEDIndex = Collections.binarySearch(this.portLEDInfoList, portDetail);
                if (portLEDIndex < 0) continue;
                SJctrDKCKgetPortLEDStatusInfo portLEDInfo = this.portLEDInfoList.get(portLEDIndex);
                int iPortLEDStatus = portLEDInfo.getPortLEDStatus();
                switch (iPortLEDStatus) {
                    case 1: {
                        ++countNotAvailable;
                        break;
                    }
                    case 2: {
                        ++countConect;
                        break;
                    }
                    case 3: {
                        ++countNotConect;
                        break;
                    }
                    default: {
                        SJctrLogUty.warn(SJctrPortConditionSummaryModel.class.getSimpleName(), "makeDataModel", "Port LED Status : Unknown(" + iPortLEDStatus + ")");
                    }
                }
                continue;
            }
            ++countNotAvailable;
        }
        SJctrLogUty.info(SJctrPortConditionSummaryModel.class.getSimpleName(), "makeDataModel", "Not Available : " + countNotAvailable + ", Available (Connected) : " + countConect + ", Available (Not Connected) : " + countNotConect);
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_NUM_OF_CONCT, Integer.toString(countConect));
        ((SJctrDataObject)summaryData).setData(KEY_NUM_OF_NOT_CONCT, Integer.toString(countNotConect));
        ((SJctrDataObject)summaryData).setData(KEY_NUM_OF_NOT_AVAIL, Integer.toString(countNotAvailable));
    }

    public void setCreateSummaryData(List<SJmoPortDetail> portDetailList, List<SJmoPortIndex> resourcePortIndexList, List<SJctrDKCKgetPortLEDStatusInfo> portLEDInfoList) {
        this.portDetailList = portDetailList;
        this.resourcePortIndexList = resourcePortIndexList;
        this.portLEDInfoList = portLEDInfoList;
    }
}

