/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.vpm;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrVirtualPartitionManagerSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_NUM_OF_CLPR = "COM_NUM_OF_CLPR";
    public static final String KEY_GENERAL = "COM_GENERAL";
    public static final String KEY_RESIDENT = "COM_RESIDENT";
    public static final String KEY_TOTAL_SIZE = "COM_TOTAL_SIZE";
    public static final String KEY_PG_NUM = "COM_PG_NUM";
    public static final String KEY_VVOL_NUM = "COM_VVOL_NUM";
    public static final String KEY_TOTAL_RSC = "COM_TOTAL_RSC";
    private SummaryData summary;

    @Override
    public void makeDataObject() {
        if (SJctrDataController.isHM()) {
            this.getComUtility().getVPMUtility();
        }
        this.summary = new SummaryData();
        this.summary.capacityUtil = this.getComUtility().getCapacityUtility();
        this.summary.clprInfoList = this.getBasicDataList(SJctrVpmUtility.KEY_CLASS_CLPR_INFO);
        this.makeSummary();
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetClprInfo kind = new SJmoGetClprInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    protected void makeSummary() {
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_NUM_OF_CLPR, this.getNumOfClpr(this.summary.clprInfoList));
        ((SJctrDataObject)summaryData).setData(KEY_GENERAL, this.getGeneral(this.summary.clprInfoList));
        ((SJctrDataObject)summaryData).setData(KEY_RESIDENT, this.getResident(this.summary.clprInfoList));
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_SIZE, this.getTotalSize(this.summary.clprInfoList));
        ((SJctrDataObject)summaryData).setData(KEY_PG_NUM, this.getPgNum(this.summary.clprInfoList));
        ((SJctrDataObject)summaryData).setData(KEY_VVOL_NUM, this.getVvolnum(this.summary.clprInfoList));
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_RSC, this.getTotalRscNum(this.summary.clprInfoList));
    }

    private String getNumOfClpr(List<SJmoClprInfo> clprList) {
        String strRet = "?";
        if (clprList != null) {
            strRet = clprList.size() + this.getComUtility().getStrMaxAllowed(SJctrVpmUtility.CLPR_MAX);
        }
        return strRet;
    }

    private String getGeneral(List<SJmoClprInfo> clprList) {
        String strRet = "?";
        if (clprList != null) {
            long lBlockSize = 0L;
            for (SJmoClprInfo clprInfo : clprList) {
                lBlockSize += this.summary.capacityUtil.valueOf((long)(clprInfo.getICacheCapacity() - clprInfo.getIDCRCapacity()), SJctrCapacityUtility.UNIT.MB);
            }
            strRet = this.summary.capacityUtil.toUnitString(lBlockSize);
        }
        return strRet;
    }

    private String getResident(List<SJmoClprInfo> clprList) {
        String strRet = "?";
        if (clprList != null) {
            long lBlockSize = 0L;
            for (SJmoClprInfo clprInfo : clprList) {
                lBlockSize += this.summary.capacityUtil.valueOf((long)clprInfo.getIDCRCapacity(), SJctrCapacityUtility.UNIT.MB);
            }
            strRet = this.summary.capacityUtil.toUnitString(lBlockSize);
        }
        return strRet;
    }

    private String getTotalSize(List<SJmoClprInfo> clprList) {
        String strRet = "?";
        if (clprList != null) {
            long lBlockSize = 0L;
            for (SJmoClprInfo clprInfo : clprList) {
                lBlockSize += this.summary.capacityUtil.valueOf((long)clprInfo.getICacheCapacity(), SJctrCapacityUtility.UNIT.MB);
            }
            strRet = this.summary.capacityUtil.toUnitString(lBlockSize);
        }
        return strRet;
    }

    private String getPgNum(List<SJmoClprInfo> clprList) {
        String strRet = "?";
        if (clprList != null) {
            int iResCnt = 0;
            for (SJmoClprInfo clprInfo : clprList) {
                iResCnt += SJctrVpmUtility.getPgNum(clprInfo);
            }
            strRet = String.valueOf(iResCnt);
        }
        return strRet;
    }

    private String getVvolnum(List<SJmoClprInfo> clprList) {
        String strRet = "?";
        if (clprList != null) {
            int iResCnt = 0;
            for (SJmoClprInfo clprInfo : clprList) {
                iResCnt += SJctrVpmUtility.getVvolNum(clprInfo);
            }
            strRet = String.valueOf(iResCnt);
        }
        return strRet;
    }

    private String getTotalRscNum(List<SJmoClprInfo> clprList) {
        String strRet = "?";
        if (clprList != null) {
            int iResCnt = 0;
            for (SJmoClprInfo clprInfo : clprList) {
                iResCnt += SJctrVpmUtility.getPgNum(clprInfo) + SJctrVpmUtility.getVvolNum(clprInfo);
            }
            strRet = String.valueOf(iResCnt);
        }
        return strRet;
    }

    private class SummaryData {
        SJctrCapacityUtility capacityUtil;
        List<SJmoClprInfo> clprInfoList;

        private SummaryData() {
        }
    }
}

