/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.deleteusers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDefaultAuditLogData;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrUserInfoDetailUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogUty;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.deleteusers.SJctrDeleteUsersAC;
import sanproject.sn2.controller.wizard.account.deleteusers.SJctrDeleteUsersSelectData;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;

public class SJctrDeleteUsersSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "DELETE_USERS";
    private static final Class<?> CONFIRM_DC = SJctrAccountDataMacro.WIZARD_DELETEUSERS_CONFIRM_DC;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        String strLogTitle = this.getClass().getSimpleName();
        String strLogSubTitle = "constructConfirmData";
        SJctrLogUty logUty = wizard.getLogUty();
        logUty.setTitle(strLogTitle);
        Class[] paramClass = new Class[]{String[].class};
        logUty.putlog(strLogSubTitle, "start");
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrDeleteUsersAC ac = new SJctrDeleteUsersAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(wizard.getClass());
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        List<?> param = dc.getProxy().getCache(SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA);
        if (param == null || param.isEmpty()) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        Object obj = param.get(0);
        if (obj == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_DELETEUSERS_SELECT_DATA.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        if (!(obj instanceof SJctrDeleteUsersSelectData)) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrDeleteUsersSelectData deleteUsersSelectData = (SJctrDeleteUsersSelectData)obj;
        List<SJctrUserInfoDetail> userInfoDetailList = deleteUsersSelectData.getUserInfoDetailList();
        if (userInfoDetailList == null || userInfoDetailList.isEmpty()) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (User Info Detail List) is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        int userNum = userInfoDetailList.size();
        String[] userIDs = new String[userNum];
        for (int i = 0; i < userNum; ++i) {
            userIDs[i] = userInfoDetailList.get(i).getUserName();
        }
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        Object[] params = null;
        paramList.add(userIDs);
        params = paramList.toArray(new Object[0]);
        Class<SJcUserInfoUty> cls = SJcUserInfoUty.class;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KEY_METHOD_NAME", "deleteUser");
        map.put("KEY_PARAM_CLASS", paramClass);
        map.put("KEY_OBJECT", cls);
        map.put("KEY_PARAM", params);
        ArrayList<Map<String, Object>> applyData = new ArrayList<Map<String, Object>>();
        applyData.add(map);
        ac.setApplyList(applyData);
        SJctrAccAdtLogData adtLogData = this.makeAdtLogData(logUty, (SJbaseUserSession)wizard.getOwner().getUserSession(), wizard.getOwner().getComUtility(), deleteUsersSelectData);
        ac.setAdtLogData(adtLogData);
        wizard.addConfirmData(ac, related);
        logUty.putlog(strLogSubTitle, "end");
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    private SJctrAccAdtLogData makeAdtLogData(SJctrLogUty logUty, SJbaseUserSession userSession, SJctrComUtility comUty, SJctrDeleteUsersSelectData deleteUsersSelectData) {
        String strLogSubTitle = "makeAdtLogData";
        SJctrAccAdtLogData adtLogData = new SJctrAccAdtLogData();
        try {
            adtLogData = SJctrAccAdtLogUty.makeAccAdtLogData(logUty, userSession, comUty.getGuidance("ACCOUNT", "ADT_DELETE_USERS"));
            adtLogData.setDetailList(this.makeAdtDetailList(comUty, deleteUsersSelectData));
            if (!adtLogData.getDetailList().isEmpty()) {
                adtLogData.setStrFooter(comUty.getGuidance("ACCOUNT", "ADT_USER_NUM"));
            }
            adtLogData.setStrNormalEnd(comUty.getGuidance("ADT_NORMAL_END"));
            adtLogData.setStrError(comUty.getGuidance("ADT_ERROR"));
        }
        catch (Exception e) {
            if (logUty != null) {
                logUty.putlog(strLogSubTitle, "[Logic Error]makeAdtLogData() is failed.", e, 40000);
            }
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        return adtLogData;
    }

    private List<SJctrAuditLogData> makeAdtDetailList(SJctrComUtility util, SJctrDeleteUsersSelectData deleteUsersSelectData) {
        ArrayList<SJctrAuditLogData> detailList = new ArrayList<SJctrAuditLogData>();
        SJctrUserInfoDetailUtility userInfoDetailUty = util.getUserInfoDetailUtility();
        ArrayList<String> partsIDList = new ArrayList<String>();
        partsIDList.add("ADT_USER_ID");
        partsIDList.add("ADT_RESULT");
        List<SJctrUserInfoDetail> userInfoDetailList = deleteUsersSelectData.getUserInfoDetailList();
        for (int i = 0; i < deleteUsersSelectData.getUserInfoDetailList().size(); ++i) {
            SJctrDefaultAuditLogData adtData = new SJctrDefaultAuditLogData();
            adtData.setKeys(partsIDList);
            adtData.setScrID(new ArrayList<String>(0));
            adtData.setTitle("ADT_USER_ID", util.getGuidance("ACCOUNT", "ADT_USER_ID"));
            adtData.setValue("ADT_USER_ID", userInfoDetailUty.toUserIDDisplay(userInfoDetailList.get(i)));
            adtData.setTitle("ADT_RESULT", util.getGuidance("ADT_RESULT"));
            adtData.setValue("ADT_RESULT", util.getGuidance("ADT_NORMAL_END"));
            detailList.add(adtData);
        }
        return detailList;
    }
}

