/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.edituser;

import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserDC;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserSelectData;

public class SJctrEditUserAccountDataModel
extends SJctrSimpleDataModel {
    public static final String COM_TITLE = "COM_TITLE";
    public static final String COM_CHECKBOX = "COM_CHECKBOX";
    public static final String COM_DISPSTATE = "COM_DISPSTATE";
    public static final String COM_ACC = "COM_ACC";
    public static final String COM_ACTIVE = "COM_ACTIVE";
    public static final String COM_LOCKED = "COM_LOCKED";

    public SJctrEditUserAccountDataModel() {
        this.initDataModel();
    }

    protected void initDataModel() {
        this.addDataModel(COM_TITLE, new SJctrSimpleDataModel());
        SJctrSimpleDataModel titleDataModel = (SJctrSimpleDataModel)this.getDataModel(COM_TITLE);
        titleDataModel.addDataModel(COM_CHECKBOX, new SJctrCheckBoxDataModel());
        Object dataObject = titleDataModel.getManageData();
        ((SJctrDataObject)dataObject).setData(COM_DISPSTATE, 0);
        this.addDataModel(COM_ACC, this.createAccountRadioButtonGroup());
    }

    private SJctrRadioButtonGroupDataModel createAccountRadioButtonGroup() {
        SJctrRadioButtonGroupDataModel radio = new SJctrRadioButtonGroupDataModel();
        radio.add(COM_ACTIVE);
        radio.add(COM_LOCKED);
        return radio;
    }

    @Override
    protected void makeDataObject() {
        String strLogSubTitle = "makeDataObject";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrCheckBoxDataModel accountCheckBox = (SJctrCheckBoxDataModel)this.getDataModel(COM_TITLE).getDataModel(COM_CHECKBOX);
        SJctrRadioButtonGroupDataModel accountRadioButton = (SJctrRadioButtonGroupDataModel)this.getDataModel(COM_ACC);
        accountCheckBox.setSelect(false);
        SJctrEditUserDC dc = (SJctrEditUserDC)this.getDataController();
        List<?> dat = dc.getCache(SJctrAccountDataMacro.WIZARD_EDITUSER_SELECT_DATA);
        if (!dc.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrEditUserSelectData editUserSelectData = (SJctrEditUserSelectData)dat.get(0);
        SJctrUserInfoDetail userInfoDetail = editUserSelectData.getUserInfoDetail();
        if (userInfoDetail == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        boolean bAccount = userInfoDetail.getEnable();
        if (bAccount) {
            accountRadioButton.setSelect(COM_ACTIVE);
        } else {
            accountRadioButton.setSelect(COM_LOCKED);
        }
        SJctrUserController uc = this.getDataController().getOwner();
        String myUserID = uc.getUserSession().getUserName();
        String selectUserID = userInfoDetail.getUserName();
        if (myUserID == null || selectUserID == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]userID is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        if (myUserID.equals(selectUserID)) {
            if (bAccount) {
                accountRadioButton.setEnable(false);
                accountCheckBox.setEnable(false);
            } else {
                accountRadioButton.setEnable(true);
                accountCheckBox.setEnable(true);
            }
        } else {
            accountRadioButton.setEnable(true);
            accountCheckBox.setEnable(true);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }
}

