/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.edituser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDefaultAuditLogData;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrUserInfoDetailUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogUty;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserAC;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserData;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;

public class SJctrEditUserSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "EDIT_USER";
    private static final Class<?> CONFIRM_DC = SJctrAccountDataMacro.WIZARD_EDITUSER_CONFIRM_DC;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        String strLogTitle = this.getClass().getSimpleName();
        String strLogSubTitle = "constructConfirmData";
        SJctrLogUty logUty = wizard.getLogUty();
        logUty.setTitle(strLogTitle);
        Class[] setEnableDisableParam = new Class[]{String[].class, Boolean.TYPE};
        Class[] setAuthPatternParam = new Class[]{String.class, Integer.TYPE, String.class};
        logUty.putlog(strLogSubTitle, "start");
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrEditUserAC ac = new SJctrEditUserAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(wizard.getClass());
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        List<?> dat = dc.getProxy().getCache(SJctrAccountDataMacro.WIZARD_EDITUSER_DATA);
        if (dat == null || dat.isEmpty()) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_EDITUSER_DATA.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        if (!(obj instanceof SJctrEditUserData)) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrEditUserData editUserData = (SJctrEditUserData)obj;
        SJctrUserInfoDetail userInfoDetail = editUserData.getUserInfoDetail();
        if (userInfoDetail == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        List<String> changeList = editUserData.getChangeList();
        if (changeList == null) {
            logUty.putlog(strLogSubTitle, "[Logic Error]Contact Data (Change List) is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        String userID = userInfoDetail.getUserName();
        boolean bAccount = userInfoDetail.getEnable();
        int iAuthServ = userInfoDetail.getAuthPtn();
        String password = null;
        String passBuff = userInfoDetail.getPassword();
        if (passBuff != null && !passBuff.equals("******")) {
            password = passBuff;
        }
        Object[] params = null;
        Class<SJcUserInfoUty> cls = SJcUserInfoUty.class;
        ArrayList<Map<String, Object>> applyData = new ArrayList<Map<String, Object>>();
        if (0 <= Collections.binarySearch(changeList, "COM_ACC")) {
            String[] userIDs = new String[]{userID};
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.add(userIDs);
            paramList.add(bAccount);
            params = paramList.toArray(new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("KEY_METHOD_NAME", "setEnableDisable");
            map.put("KEY_PARAM_CLASS", setEnableDisableParam);
            map.put("KEY_OBJECT", cls);
            map.put("KEY_PARAM", params);
            applyData.add(map);
        }
        if (0 <= Collections.binarySearch(changeList, "COM_AUTH")) {
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.add(userID);
            paramList.add(iAuthServ);
            paramList.add(password);
            params = paramList.toArray(new Object[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("KEY_METHOD_NAME", "setAuthPattern");
            map.put("KEY_PARAM_CLASS", setAuthPatternParam);
            map.put("KEY_OBJECT", cls);
            map.put("KEY_PARAM", params);
            applyData.add(map);
        }
        ac.setApplyList(applyData);
        SJctrAccAdtLogData adtLogData = this.makeAdtLogData(logUty, (SJbaseUserSession)wizard.getOwner().getUserSession(), wizard.getOwner().getComUtility(), editUserData);
        ac.setAdtLogData(adtLogData);
        wizard.addConfirmData(ac, related);
        logUty.putlog(strLogSubTitle, "end");
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{SJctrAccountDataMacro.WIZARD_EDITUSER_DC};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    private SJctrAccAdtLogData makeAdtLogData(SJctrLogUty logUty, SJbaseUserSession userSession, SJctrComUtility comUty, SJctrEditUserData editUserData) {
        String strLogSubTitle = "makeAdtLogData";
        SJctrAccAdtLogData adtLogData = new SJctrAccAdtLogData();
        try {
            adtLogData = SJctrAccAdtLogUty.makeAccAdtLogData(logUty, userSession, comUty.getGuidance("ACCOUNT", "ADT_EDIT_USER"));
            adtLogData.setDetailList(this.makeAdtDetailList(comUty, editUserData));
            if (!adtLogData.getDetailList().isEmpty()) {
                adtLogData.setStrFooter(comUty.getGuidance("ACCOUNT", "ADT_USER_NUM"));
            }
            adtLogData.setStrNormalEnd(comUty.getGuidance("ADT_NORMAL_END"));
            adtLogData.setStrError(comUty.getGuidance("ADT_ERROR"));
        }
        catch (Exception e) {
            if (logUty != null) {
                logUty.putlog(strLogSubTitle, "[Logic Error]makeAdtLogData() is failed.", e, 40000);
            }
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        return adtLogData;
    }

    private List<SJctrAuditLogData> makeAdtDetailList(SJctrComUtility util, SJctrEditUserData editUserData) {
        ArrayList<SJctrAuditLogData> detailList = new ArrayList<SJctrAuditLogData>();
        SJctrUserInfoDetailUtility userInfoDetailUty = util.getUserInfoDetailUtility();
        ArrayList<String> partsIDList = new ArrayList<String>();
        partsIDList.add("ADT_USER_ID");
        partsIDList.add("ADT_ACC");
        partsIDList.add("ADT_AUTH");
        partsIDList.add("ADT_RESULT");
        SJctrUserInfoDetail[] userInfo_array = new SJctrUserInfoDetail[]{editUserData.getUserInfoDetail()};
        List<String> changeList = editUserData.getChangeList();
        Collections.sort(changeList);
        for (int i = 0; i < userInfo_array.length; ++i) {
            SJctrDefaultAuditLogData adtData = new SJctrDefaultAuditLogData();
            adtData.setKeys(partsIDList);
            adtData.setScrID(new ArrayList<String>(0));
            adtData.setTitle("ADT_USER_ID", util.getGuidance("ACCOUNT", "ADT_USER_ID"));
            adtData.setValue("ADT_USER_ID", userInfoDetailUty.toUserIDDisplay(userInfo_array[i]));
            adtData.setTitle("ADT_ACC", util.getGuidance("ACCOUNT", "ADT_ACC"));
            if (0 > Collections.binarySearch(changeList, "COM_ACC")) {
                adtData.setValue("ADT_ACC", util.getGuidance("BAR"));
            } else {
                adtData.setValue("ADT_ACC", userInfoDetailUty.toUserAccountAdtDisplay(userInfo_array[i]));
            }
            adtData.setTitle("ADT_AUTH", util.getGuidance("ACCOUNT", "ADT_AUTH"));
            if (0 > Collections.binarySearch(changeList, "COM_AUTH")) {
                adtData.setValue("ADT_AUTH", util.getGuidance("BAR"));
            } else {
                adtData.setValue("ADT_AUTH", userInfoDetailUty.toUserAuthAdtDisplay(userInfo_array[i]));
            }
            adtData.setTitle("ADT_RESULT", util.getGuidance("ADT_RESULT"));
            adtData.setValue("ADT_RESULT", util.getGuidance("ADT_NORMAL_END"));
            detailList.add(adtData);
        }
        return detailList;
    }
}

