/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.setupldap;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfiguration;
import sanproject.sn2.base.authentication.module.external.common.SJbaseGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExTrialException;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalFile;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalTrial;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrExtAuthServerUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrMsgCodeDef;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrValidatorUtility;
import sanproject.sn2.controller.wizard.account.extauth.com.file.SJctrCertificationFileUpload;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrCertifyFileNameDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrExistDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrPasswordDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrProtocolComboBoxDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTestResult2DataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTestResultDataModel;
import sanproject.sn2.controller.wizard.account.extauth.com.model.SJctrTextDataModel;
import sanproject.sn2.controller.wizard.account.extauth.setupldap.SJctrLdapServerConfirmData;

public class SJctrLdapServerDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 16826400;
    public static final String TITLE = "SETUP_SERVER";
    public static final String KEY_BROWSE_BTN = "COM_BROWSE_BTN";
    public static final String KEY_TEST_BTN = "COM_TEST_BTN";
    SJctrExtAuthServerInfo extAuthServerInfo = null;
    SJctrCertifyFileNameDataModel certifyFileNameDataModel = null;
    SJctrCertificationFileUpload fileUpload = null;
    SJctrExistDataModel dnsLookupDataModel = null;
    SJctrProtocolComboBoxDataModel protocolDataModel = null;
    SJctrExistDataModel authorizeDataModel = null;
    SJctrTextDataModel priHostNameDataModel = null;
    SJctrTextDataModel priPortNumberDataModel = null;
    SJctrTextDataModel domainNameDataModel = null;
    SJctrTextDataModel attributeDataModel = null;
    SJctrTextDataModel timeoutDataModel = null;
    SJctrTextDataModel intervalDataModel = null;
    SJctrTextDataModel retriesDataModel = null;
    SJctrTextDataModel baseDnDataModel = null;
    SJctrTextDataModel searchDnDataModel = null;
    SJctrPasswordDataModel passwordDataModel = null;
    SJctrPasswordDataModel rePasswordDataModel = null;
    SJctrExistDataModel secServerDataModel = null;
    SJctrTextDataModel secHostNameDataModel = null;
    SJctrTextDataModel secPortNumberDataModel = null;
    SJctrTextDataModel testUserNameDataModel = null;
    SJctrPasswordDataModel testPasswordDataModel = null;
    SJctrTestResultDataModel testResultDataModel = null;
    SJctrTestResult2DataModel testResult2DataModel = null;
    public static int RESULT_NORMAL = 0;
    public static int LDAP_NON_CFFILE = SJctrMsgCodeDef.NON_CFFILE;
    public static int LDAP_INVALID_CFFILE = SJctrMsgCodeDef.INVALID_CFFILE;
    public static int LDAP_NON_HOSTNAME = SJctrMsgCodeDef.NON_HOSTNAME;
    public static int LDAP_OVER_LENGTH_HOSTNAME = SJctrMsgCodeDef.OVER_LENGTH_HOSTNAME;
    public static int LDAP_INVALID_HOSTNAME = SJctrMsgCodeDef.INVALID_HOSTNAME;
    public static int LDAP_NON_PORT = SJctrMsgCodeDef.NON_PORT;
    public static int LDAP_INVALID_PORT = SJctrMsgCodeDef.INVALID_PORT;
    public static int LDAP_NOT_RANGE_PORT = SJctrMsgCodeDef.NOT_RANGE_PORT;
    public static int LDAP_NON_DOMAIN = SJctrMsgCodeDef.NON_DOMAIN;
    public static int LDAP_OVER_LENGTH_DOMAIN = SJctrMsgCodeDef.OVER_LENGTH_DOMAIN;
    public static int LDAP_INVALID_DOMAIN = SJctrMsgCodeDef.INVALID_DOMAIN;
    public static int LDAP_NON_ATTRIBUTE = SJctrMsgCodeDef.NON_ATTRIBUTE;
    public static int LDAP_INVALID_ATTRIBUTE = SJctrMsgCodeDef.INVALID_ATTRIBUTE;
    public static int LDAP_NON_TIMEOUTE = SJctrMsgCodeDef.NON_TIMEOUTE;
    public static int LDAP_INVALID_TIMEOUT = SJctrMsgCodeDef.INVALID_TIMEOUT;
    public static int LDAP_NOT_RANGE_TIMEOUT = SJctrMsgCodeDef.NOT_RANGE_TIMEOUT;
    public static int LDAP_NON_INTERVAL = SJctrMsgCodeDef.NON_INTERVAL;
    public static int LDAP_INVALID_INTERVAL = SJctrMsgCodeDef.INVALID_INTERVAL;
    public static int LDAP_NOT_RANGE_INTERVAL = SJctrMsgCodeDef.NOT_RANGE_INTERVAL;
    public static int LDAP_NON_RETRIES = SJctrMsgCodeDef.NON_RETRIES;
    public static int LDAP_INVALID_RETRIES = SJctrMsgCodeDef.INVALID_RETRIES;
    public static int LDAP_NOT_RANGE_RETRIES = SJctrMsgCodeDef.NOT_RANGE_RETRIES;
    public static int LDAP_NON_BASEDN = SJctrMsgCodeDef.NON_BASEDN;
    public static int LDAP_OVER_LENGTH_BASEDN = SJctrMsgCodeDef.OVER_LENGTH_BASEDN;
    public static int LDAP_INVALID_BASEDN = SJctrMsgCodeDef.INVALID_BASEDN;
    public static int LDAP_NON_SEARCHDN = SJctrMsgCodeDef.NON_SEARCHDN;
    public static int LDAP_OVER_LENGTH_SEARCHDN = SJctrMsgCodeDef.OVER_LENGTH_SEARCHDN;
    public static int LDAP_INVALID_SEARCHDN = SJctrMsgCodeDef.INVALID_SEARCHDN;
    public static int LDAP_NON_PASSWORD = SJctrMsgCodeDef.NON_PASSWORD;
    public static int LDAP_OVER_LENGTH_PASSWORD = SJctrMsgCodeDef.OVER_LENGTH_PASSWORD;
    public static int LDAP_INVALID_PASSWORD = SJctrMsgCodeDef.INVALID_PASSWORD;
    public static int LDAP_NON_REPASSWORD = SJctrMsgCodeDef.NON_REPASSWORD;
    public static int LDAP_OVER_LENGTH_REPASSWORD = SJctrMsgCodeDef.OVER_LENGTH_REPASSWORD;
    public static int LDAP_INVALID_REPASSWORD = SJctrMsgCodeDef.INVALID_REPASSWORD;
    public static int LDAP_NOT_SET_SECONDARY = SJctrMsgCodeDef.NOT_SET_SECONDARY;
    public static int LDAP_NOT_SELECT_LDAPS = SJctrMsgCodeDef.NOT_SELECT_LDAPS;
    public static int LDAP_NOT_EQUAL_PASSWORD = SJctrMsgCodeDef.NOT_EQUAL_PASSWORD;
    public static int LDAP_NON_SEC_HOSTNAME = SJctrMsgCodeDef.NON_SEC_HOSTNAME;
    public static int LDAP_OVER_LENGTH_SEC_HOSTNAME = SJctrMsgCodeDef.OVER_LENGTH_SEC_HOSTNAME;
    public static int LDAP_INVALID_SEC_HOSTNAME = SJctrMsgCodeDef.INVALID_SEC_HOSTNAME;
    public static int LDAP_NON_SEC_PORT = SJctrMsgCodeDef.NON_SEC_PORT;
    public static int LDAP_INVALID_SEC_PORT = SJctrMsgCodeDef.INVALID_SEC_PORT;
    public static int LDAP_NOT_RANGE_SEC_PORT = SJctrMsgCodeDef.NOT_RANGE_SEC_PORT;
    public static int LDAP_NON_USERNAME = SJctrMsgCodeDef.NON_USERNAME;
    public static int LDAP_OVERLENGTH_USERNAME = SJctrMsgCodeDef.OVERLENGTH_USERNAME;
    public static int LDAP_INVALID_USERNAME = SJctrMsgCodeDef.INVALID_USERNAME;
    public static int LDAP_NON_TPASSWORD = SJctrMsgCodeDef.NON_TPASSWORD;
    public static int LDAP_OVERLENGTH_TPASSWORD = SJctrMsgCodeDef.OVERLENGTH_TPASSWORD;
    public static int LDAP_INVALID_TPASSWORD = SJctrMsgCodeDef.INVALID_TPASSWORD;
    boolean debug_testresult = false;

    public SJctrLdapServerDC() throws SJcException {
        super(16826400);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("COMMON", TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_CERTIFICATES", new SJctrCertifyFileNameDataModel());
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_BROWSE_BTN, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrLdapServerDC.this.browseAction();
            }
        });
        this.addDataObjectModel("COM_DNSINF", new SJctrExistDataModel());
        this.addDataObjectModel("COM_AUTH_PROT_INF", new SJctrProtocolComboBoxDataModel());
        this.addDataObjectModel("COM_EXT_AUTH_INF", new SJctrExistDataModel());
        this.addDataObjectModel("COM_PRI_HOST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_PRI_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_DOMAIN_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_ATTR_TYPE", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TOV", new SJctrTextDataModel());
        this.addDataObjectModel("COM_RET_INTERVAL", new SJctrTextDataModel());
        this.addDataObjectModel("COM_RET_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_BASE_DN", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SEARCH_DN", new SJctrTextDataModel());
        this.addDataObjectModel("COM_PASSWORD", new SJctrPasswordDataModel());
        this.addDataObjectModel("COM_RE_PASSWORD", new SJctrPasswordDataModel());
        this.addDataObjectModel("COM_SEC_SRV_AUTH", new SJctrExistDataModel());
        this.addDataObjectModel("COM_SEC_HOST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_SEC_PORT_NUM", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TEST_NAME", new SJctrTextDataModel());
        this.addDataObjectModel("COM_TEST_PASS", new SJctrPasswordDataModel());
        button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_TEST_BTN, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrLdapServerDC.this.testAction();
            }
        });
        this.addDataObjectModel("COM_TEST_RESULT", new SJctrTestResultDataModel());
        this.addDataObjectModel("COM_TEST_RESULT2", new SJctrTestResult2DataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void browseAction() {
        this.fileUpload = new SJctrCertificationFileUpload();
        this.fileUpload.setFileNameDataModel(this.certifyFileNameDataModel);
        SJctrRelatedDispDataObject relatedDisp = null;
        relatedDisp = this.createFileUpload(this.fileUpload);
        this.addUpdateDisp(relatedDisp);
    }

    private void testAction() {
        int errcode = this.checkSetting();
        if (errcode == RESULT_NORMAL) {
            errcode = this.checkTestSetting();
        }
        if (errcode != RESULT_NORMAL) {
            SJctrError err = new SJctrError(2, 22, errcode);
            SJcException exp = err.createException();
            throw exp;
        }
        SJbaseLdapConfiguration setConfig_pri = null;
        SJbaseLdapConfiguration setConfig_sec = null;
        SJbaseLdapGroupConfiguration setGroupConfig_pri = null;
        SJbaseLdapGroupConfiguration setGroupConfig_sec = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        HashMap<String, SJbaseLdapConfiguration> confmap = null;
        HashMap<String, SJbaseLdapGroupConfiguration> gconfmap = null;
        confmap = new HashMap<String, SJbaseLdapConfiguration>();
        setConfig_pri = (SJbaseLdapConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        if (setConfig_pri == null) {
            setConfig_pri = new SJbaseLdapConfiguration();
        }
        this.updateLdapSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        if (this.secServerDataModel.isSelectEnable()) {
            setConfig_sec = this.extAuthServerInfo.copyLdapConfig(setConfig_pri);
            this.updateLdapSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        }
        if (this.authorizeDataModel.isSelectEnable()) {
            gconfmap = new HashMap<String, SJbaseLdapGroupConfiguration>();
            setGroupConfig_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            if (setGroupConfig_pri == null) {
                setGroupConfig_pri = new SJbaseLdapGroupConfiguration();
            }
            this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
            if (this.secServerDataModel.isSelectEnable()) {
                setGroupConfig_sec = this.extAuthServerInfo.copyLdapGroupConfig(setGroupConfig_pri);
                this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
            }
        }
        info.setCertifyFullPathName(this.certifyFileNameDataModel.getDisplayFileName());
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        if (gconfmap == null) {
            gconfmap = new HashMap();
        }
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
        info.setServerType(SJctrExtAuthServerInfo.SERVER_TYPE_LDAP);
        info.setConfiguration(setConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setConfiguration(setConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        info.setGroupConfiguration(setGroupConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setGroupConfiguration(setGroupConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        String name = this.testUserNameDataModel.getValue();
        String pass = this.testPasswordDataModel.getValue();
        String priErrorType = SJctrExtAuthServerUtility.TRAIL_SERVER_TYPE_LDAP;
        int priErrorCode = RESULT_NORMAL;
        SJcLogUty.getLogger().info("SJctrLdapServerDC", "SJctrLdapServerDC", "ConnectTest(Primary)", "Test start.");
        try {
            SJbaseLdapConfiguration conf = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            boolean group = false;
            if (this.authorizeDataModel.isSelectEnable()) {
                group = true;
            }
            SJbaseExternalTrial.externalLdapConnect(name, pass, conf, group);
        }
        catch (SJbaseExTrialException e) {
            priErrorType = e.getServerType();
            priErrorCode = e.getErrCode();
        }
        SJcLogUty.getLogger().info("SJctrLdapServerDC", "SJctrLdapServerDC", "ConnectTest(Primary)", "Test end. result=" + priErrorType + ":" + priErrorCode);
        boolean execSecondary = false;
        String secErrorType = SJctrExtAuthServerUtility.TRAIL_SERVER_TYPE_LDAP;
        int secErrorCode = RESULT_NORMAL;
        if (priErrorCode == RESULT_NORMAL && this.secServerDataModel.isSelectEnable()) {
            SJcLogUty.getLogger().info("SJctrLdapServerDC", "SJctrLdapServerDC", "ConnectTest(Secondary)", "Test start.");
            try {
                SJbaseLdapConfiguration conf = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                boolean group = false;
                if (this.authorizeDataModel.isSelectEnable()) {
                    group = true;
                }
                SJbaseExternalTrial.externalLdapConnect(name, pass, conf, group);
            }
            catch (SJbaseExTrialException e) {
                secErrorType = e.getServerType();
                secErrorCode = e.getErrCode();
            }
            execSecondary = true;
            SJcLogUty.getLogger().info("SJctrLdapServerDC", "SJctrLdapServerDC", "ConnectTest(Secondary)", "Test end. result=" + secErrorType + ":" + secErrorCode);
        }
        if (this.debug_testresult) {
            Properties debug_properties = new Properties();
            String confFileName = "C:\\DKC200\\others\\exauth.properties";
            try {
                debug_properties.load(new FileInputStream(confFileName));
            }
            catch (Exception e) {
                // empty catch block
            }
            priErrorType = debug_properties.getProperty("TestPrimaryErrorType");
            priErrorCode = Integer.parseInt(debug_properties.getProperty("TestPrimaryErrorType"));
            execSecondary = Boolean.valueOf(debug_properties.getProperty("TestExecuteSecondary"));
            secErrorType = debug_properties.getProperty("TestSecondaryErrorType");
            secErrorCode = Integer.parseInt(debug_properties.getProperty("TestSecondaryErrorCode"));
        }
        SJctrComUtility comUtility = this.getOwner().getComUtility();
        SJctrExtAuthServerUtility extAuthServerUtility = comUtility.getExtAuthServerUtility();
        boolean result = false;
        if (priErrorCode == RESULT_NORMAL) {
            result = true;
        }
        this.testResultDataModel.setTestResut(result);
        String[] guidekey = new String[]{"", ""};
        guidekey = SJctrExtAuthServerUtility.isTrailServerTypeLdap(priErrorType) ? extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.LDAPTestResult, priErrorCode) : extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.LDAPGroupTestResult, priErrorCode);
        this.testResultDataModel.setOutLine(guidekey[SJctrExtAuthServerUtility.OUTLINE_GUIDEKEY_INDEX]);
        this.testResultDataModel.setDetail(guidekey[SJctrExtAuthServerUtility.DETAIL_GUIDEKEY_INDEX]);
        this.testResultDataModel.setDirty();
        if (execSecondary && this.secServerDataModel.isSelectEnable()) {
            result = false;
            if (secErrorCode == RESULT_NORMAL) {
                result = true;
            }
            this.testResult2DataModel.setTestResut(result);
            guidekey = new String[]{"", ""};
            guidekey = SJctrExtAuthServerUtility.isTrailServerTypeLdap(secErrorType) ? extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.LDAPTestResult, secErrorCode) : extAuthServerUtility.getTestResultGuidId(SJctrExtAuthServerUtility.LDAPGroupTestResult, secErrorCode);
            this.testResult2DataModel.setOutLine(guidekey[SJctrExtAuthServerUtility.OUTLINE_GUIDEKEY_INDEX]);
            this.testResult2DataModel.setDetail(guidekey[SJctrExtAuthServerUtility.DETAIL_GUIDEKEY_INDEX]);
            this.testResult2DataModel.setDirty();
        }
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        int errorCode = RESULT_NORMAL;
        SJbaseExternalFile config = new SJbaseExternalFile();
        HashMap<String, SJbaseConfiguration> config_map = null;
        HashMap<String, SJbaseGroupConfiguration> config_group_map = null;
        SJbaseLdapConfiguration config_data = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        String type = config.getType();
        if (SJctrExtAuthServerUtility.isServerTypeLdap(type)) {
            config_map = config.getConfiguration(type);
            config_group_map = config.getGroupConfiguration(type);
            if (config_map != null && (config_data = (SJbaseLdapConfiguration)config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY)) != null) {
                info.setServerType(type);
                SJbaseConfiguration pri_conf = null;
                SJbaseConfiguration sec_conf = null;
                if (config_map != null) {
                    pri_conf = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                    sec_conf = config_map.get(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                }
                info.setConfiguration(pri_conf, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                info.setConfiguration(sec_conf, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                SJbaseGroupConfiguration pri_gconf = null;
                SJbaseGroupConfiguration sec_gconf = null;
                if (config_group_map != null) {
                    pri_gconf = config_group_map.get(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                    sec_gconf = config_group_map.get(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
                }
                info.setGroupConfiguration(pri_gconf, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
                info.setGroupConfiguration(sec_gconf, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
            }
        }
        this.extAuthServerInfo = info;
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        this.certifyFileNameDataModel = (SJctrCertifyFileNameDataModel)this.getDataObjectModel("COM_CERTIFICATES");
        this.dnsLookupDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_DNSINF");
        this.protocolDataModel = (SJctrProtocolComboBoxDataModel)this.getDataObjectModel("COM_AUTH_PROT_INF");
        this.authorizeDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_EXT_AUTH_INF");
        this.priHostNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_PRI_HOST_NAME");
        this.priPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_PRI_PORT_NUM");
        this.priPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.priPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.domainNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_DOMAIN_NAME");
        this.attributeDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_ATTR_TYPE");
        this.timeoutDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_TOV");
        this.timeoutDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MIN));
        this.timeoutDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.TIMEOUT_MAX));
        this.intervalDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_RET_INTERVAL");
        this.intervalDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.RETRY_INTERVAL_MIN));
        this.intervalDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.RETRY_INTERVAL_MAX));
        this.retriesDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_RET_NUM");
        this.retriesDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.RETRY_TIMES_MIN));
        this.retriesDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.RETRY_TIMES_MAX));
        this.baseDnDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_BASE_DN");
        this.searchDnDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEARCH_DN");
        this.passwordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_PASSWORD");
        this.rePasswordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_RE_PASSWORD");
        this.secServerDataModel = (SJctrExistDataModel)this.getDataObjectModel("COM_SEC_SRV_AUTH");
        this.secHostNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEC_HOST_NAME");
        this.secPortNumberDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_SEC_PORT_NUM");
        this.secPortNumberDataModel.setMin(Integer.toString(SJctrExtAuthServerInfo.PORT_MIN));
        this.secPortNumberDataModel.setMax(Integer.toString(SJctrExtAuthServerInfo.PORT_MAX));
        this.testUserNameDataModel = (SJctrTextDataModel)this.getDataObjectModel("COM_TEST_NAME");
        this.testPasswordDataModel = (SJctrPasswordDataModel)this.getDataObjectModel("COM_TEST_PASS");
        this.testResultDataModel = (SJctrTestResultDataModel)this.getDataObjectModel("COM_TEST_RESULT");
        this.testResultDataModel.setEnable(true);
        this.testResultDataModel.setTestResut(true);
        this.testResult2DataModel = (SJctrTestResult2DataModel)this.getDataObjectModel("COM_TEST_RESULT2");
        this.testResult2DataModel.setEnable(true);
        this.testResult2DataModel.setTestResut(true);
        this.initialSettings();
        this.initialSettings_Test();
        return ret;
    }

    private void initialSettings() {
        SJctrComUtility comUtility = this.getOwner().getComUtility();
        SJctrExtAuthServerUtility extAuthServerUtility = comUtility.getExtAuthServerUtility();
        SJbaseLdapConfiguration config_pri = (SJbaseLdapConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseLdapConfiguration config_sec = (SJbaseLdapConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        SJbaseLdapGroupConfiguration groupConfig_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseLdapGroupConfiguration groupConfig_sec = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        boolean initialSetting = false;
        if (config_pri == null) {
            config_pri = this.extAuthServerInfo.getDefaultLdapConfig();
            initialSetting = true;
        }
        this.certifyFileNameDataModel.setFixed(true, true);
        String value = comUtility.getGuidance("COMMON", "FIXED_TEXT_BROWSE_BTN");
        this.certifyFileNameDataModel.setDisplayFileName(value);
        if (SJctrExtAuthServerUtility.isInvalidStr(config_pri.getDnsLookup())) {
            this.dnsLookupDataModel.selectEnable();
        } else {
            this.dnsLookupDataModel.selectDisable();
        }
        String protocol = this.protocolDataModel.getSelectionName(config_pri.getProtocol());
        this.protocolDataModel.addItem(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS, comUtility.getGuidance("COMMON", "STARTTLS"));
        this.protocolDataModel.addItem(SJctrExtAuthServerInfo.PROTOCOL_LDAPS, comUtility.getGuidance("COMMON", "LDAPS"));
        if (protocol.equals("")) {
            this.protocolDataModel.setSelection(SJctrExtAuthServerInfo.PROTOCOL_STARTTLS);
        } else {
            this.protocolDataModel.setSelection(protocol);
        }
        if (groupConfig_pri != null) {
            this.authorizeDataModel.selectEnable();
        } else {
            this.authorizeDataModel.selectDisable();
        }
        String value2 = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            value2 = config_pri.getHost();
        }
        this.priHostNameDataModel.setValue(value2);
        value2 = "";
        if (this.dnsLookupDataModel.isSelectDisable()) {
            value2 = String.valueOf(config_pri.getPort());
        }
        if (protocol.equals("")) {
            value2 = String.valueOf(SJctrExtAuthServerInfo.LDAP_PORT_NUMBER_DEF);
        }
        this.priPortNumberDataModel.setValue(value2);
        if (this.dnsLookupDataModel.isSelectEnable()) {
            // empty if block
        }
        value2 = config_pri.getDomainName();
        this.domainNameDataModel.setValue(value2);
        value2 = config_pri.getUserAttr();
        this.attributeDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getTimeout());
        this.timeoutDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getRetryInterval());
        this.intervalDataModel.setValue(value2);
        value2 = String.valueOf(config_pri.getRetryTimes());
        this.retriesDataModel.setValue(value2);
        value2 = config_pri.getSearchDN();
        this.baseDnDataModel.setValue(value2);
        value2 = config_pri.getSearchUserDN();
        if (value2 == null) {
            value2 = "";
        }
        this.searchDnDataModel.setValue(value2);
        value2 = config_pri.getSearchUserPassword();
        if (value2 == null) {
            value2 = "";
        }
        this.passwordDataModel.setValue(value2);
        value2 = config_pri.getSearchUserPassword();
        if (value2 == null) {
            value2 = "";
        }
        this.rePasswordDataModel.setValue(value2);
        if (config_sec != null) {
            this.secServerDataModel.selectEnable();
        } else {
            if (initialSetting) {
                this.secServerDataModel.selectEnable();
            } else {
                this.secServerDataModel.selectDisable();
            }
            config_sec = this.extAuthServerInfo.getDefaultLdapConfig();
        }
        value2 = config_sec.getHost();
        this.secHostNameDataModel.setValue(value2);
        value2 = String.valueOf(config_sec.getPort());
        this.secPortNumberDataModel.setValue(value2);
        if (this.secServerDataModel.isSelectDisable()) {
            // empty if block
        }
    }

    private void initialSettings_Test() {
        this.testUserNameDataModel.setValue("");
        this.testPasswordDataModel.setValue("");
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        int errcode = this.checkSetting();
        if (errcode != RESULT_NORMAL) {
            ret = false;
            SJctrError err = new SJctrError(2, 22, errcode);
            SJcException exp = err.createException();
            throw exp;
        }
        SJbaseLdapConfiguration setConfig_pri = null;
        SJbaseLdapConfiguration setConfig_sec = null;
        SJbaseLdapGroupConfiguration setGroupConfig_pri = null;
        SJbaseLdapGroupConfiguration setGroupConfig_sec = null;
        SJctrExtAuthServerInfo info = new SJctrExtAuthServerInfo();
        HashMap<String, SJbaseLdapConfiguration> confmap = null;
        HashMap<String, SJbaseLdapGroupConfiguration> gconfmap = null;
        confmap = new HashMap<String, SJbaseLdapConfiguration>();
        setConfig_pri = (SJbaseLdapConfiguration)this.extAuthServerInfo.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        if (setConfig_pri == null) {
            setConfig_pri = new SJbaseLdapConfiguration();
        }
        this.updateLdapSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        if (this.secServerDataModel.isSelectEnable()) {
            setConfig_sec = this.extAuthServerInfo.copyLdapConfig(setConfig_pri);
            this.updateLdapSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        }
        if (this.authorizeDataModel.isSelectEnable()) {
            gconfmap = new HashMap<String, SJbaseLdapGroupConfiguration>();
            setGroupConfig_pri = (SJbaseLdapGroupConfiguration)this.extAuthServerInfo.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
            if (setGroupConfig_pri == null) {
                setGroupConfig_pri = new SJbaseLdapGroupConfiguration();
            }
            this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
            if (this.secServerDataModel.isSelectEnable()) {
                setGroupConfig_sec = this.extAuthServerInfo.copyLdapGroupConfig(setGroupConfig_pri);
                this.updateLdapGroupSetting(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
            }
        }
        info.setCertifyFullPathName(this.certifyFileNameDataModel.getDisplayFileName());
        if (this.fileUpload == null || this.fileUpload.getOriginFileName() == "") {
            info.setCertifyFullPathName("");
        }
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setConfig_pri);
        confmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setConfig_sec);
        if (gconfmap == null) {
            gconfmap = new HashMap();
        }
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY, setGroupConfig_pri);
        gconfmap.put(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY, setGroupConfig_sec);
        info.setServerType(SJctrExtAuthServerInfo.SERVER_TYPE_LDAP);
        info.setConfiguration(setConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setConfiguration(setConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        info.setGroupConfiguration(setGroupConfig_pri, SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        info.setGroupConfiguration(setGroupConfig_sec, SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        ArrayList<SJctrLdapServerConfirmData> confirmDataList = new ArrayList<SJctrLdapServerConfirmData>(1);
        SJctrLdapServerConfirmData confirmData = new SJctrLdapServerConfirmData(info);
        confirmDataList.add(confirmData);
        this.putCache(SJctrLdapServerConfirmData.LDAP_SERVER_CONFIRM_DATA, confirmDataList);
        return ret;
    }

    private int checkSetting() {
        String domain;
        int errcode = RESULT_NORMAL;
        SJctrValidatorUtility validUtil = new SJctrValidatorUtility();
        if (this.fileUpload != null && this.fileUpload.getOriginFileName() != "") {
            String full = this.certifyFileNameDataModel.getDisplayFileName();
            if (full == null || full.length() <= 0) {
                errcode = LDAP_NON_CFFILE;
                return errcode;
            }
            if (!validUtil.isValid(full, SJctrValidatorUtility.nFullPathName)) {
                errcode = LDAP_INVALID_CFFILE;
                return errcode;
            }
        }
        if (this.dnsLookupDataModel.isSelectEnable()) {
            String name = this.protocolDataModel.getSelection();
            if (SJctrExtAuthServerUtility.isLdapsProtocol(name)) {
                errcode = LDAP_NOT_SELECT_LDAPS;
                return errcode;
            }
        } else {
            String host = this.priHostNameDataModel.getValue();
            if (host == null || host.length() <= 0) {
                errcode = LDAP_NON_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.Length_1to255)) {
                errcode = LDAP_OVER_LENGTH_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.HostName)) {
                errcode = LDAP_INVALID_HOSTNAME;
                return errcode;
            }
            String port = this.priPortNumberDataModel.getValue();
            if (port == null || port.length() <= 0) {
                errcode = LDAP_NON_PORT;
                return errcode;
            }
            if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
                errcode = LDAP_INVALID_PORT;
                return errcode;
            }
            int portvalue = Integer.valueOf(port);
            if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
                errcode = LDAP_NOT_RANGE_PORT;
                return errcode;
            }
        }
        if ((domain = this.domainNameDataModel.getValue()) == null || domain.length() <= 0) {
            errcode = LDAP_NON_DOMAIN;
            return errcode;
        }
        if (!validUtil.isValid(domain, SJctrValidatorUtility.Length_1to255)) {
            errcode = LDAP_OVER_LENGTH_DOMAIN;
            return errcode;
        }
        if (!validUtil.isValid(domain, SJctrValidatorUtility.DomainName)) {
            errcode = LDAP_INVALID_DOMAIN;
            return errcode;
        }
        String attribute = this.attributeDataModel.getValue();
        if (attribute == null || attribute.length() <= 0) {
            errcode = LDAP_NON_ATTRIBUTE;
            return errcode;
        }
        if (!validUtil.isValid(attribute, SJctrValidatorUtility.NameAttribute)) {
            errcode = LDAP_INVALID_ATTRIBUTE;
            return errcode;
        }
        String timeout = this.timeoutDataModel.getValue();
        if (timeout == null || timeout.length() <= 0) {
            errcode = LDAP_NON_TIMEOUTE;
            return errcode;
        }
        if (!validUtil.isValid(timeout, SJctrValidatorUtility.Timeout)) {
            errcode = LDAP_INVALID_TIMEOUT;
            return errcode;
        }
        int timeoutvalue = Integer.valueOf(timeout);
        if (timeoutvalue < SJctrExtAuthServerInfo.TIMEOUT_MIN || SJctrExtAuthServerInfo.TIMEOUT_MAX < timeoutvalue) {
            errcode = LDAP_NOT_RANGE_TIMEOUT;
            return errcode;
        }
        String interval = this.intervalDataModel.getValue();
        if (interval == null || interval.length() <= 0) {
            errcode = LDAP_NON_INTERVAL;
            return errcode;
        }
        if (!validUtil.isValid(interval, SJctrValidatorUtility.Timeout)) {
            errcode = LDAP_INVALID_INTERVAL;
            return errcode;
        }
        int intervalvalue = Integer.valueOf(interval);
        if (intervalvalue < SJctrExtAuthServerInfo.RETRY_INTERVAL_MIN || SJctrExtAuthServerInfo.RETRY_INTERVAL_MAX < intervalvalue) {
            errcode = LDAP_NOT_RANGE_INTERVAL;
            return errcode;
        }
        String retries = this.retriesDataModel.getValue();
        if (retries == null || retries.length() <= 0) {
            errcode = LDAP_NON_RETRIES;
            return errcode;
        }
        if (!validUtil.isValid(retries, SJctrValidatorUtility.Retries)) {
            errcode = LDAP_INVALID_RETRIES;
            return errcode;
        }
        int retriesvalue = Integer.valueOf(retries);
        if (retriesvalue < SJctrExtAuthServerInfo.RETRY_TIMES_MIN || SJctrExtAuthServerInfo.RETRY_TIMES_MAX < retriesvalue) {
            errcode = LDAP_NOT_RANGE_RETRIES;
            return errcode;
        }
        String baseDn = this.baseDnDataModel.getValue();
        if (baseDn == null || baseDn.length() <= 0) {
            errcode = LDAP_NON_BASEDN;
            return errcode;
        }
        if (!validUtil.isValid(baseDn, SJctrValidatorUtility.Length_1to255)) {
            errcode = LDAP_OVER_LENGTH_BASEDN;
            return errcode;
        }
        if (!validUtil.isValid(baseDn, SJctrValidatorUtility.BaseDN)) {
            errcode = LDAP_INVALID_BASEDN;
            return errcode;
        }
        String searchDn = this.searchDnDataModel.getValue();
        String password = this.passwordDataModel.getValue();
        String rePassword = this.rePasswordDataModel.getValue();
        if (attribute.equalsIgnoreCase(SJctrExtAuthServerInfo.LDAP_USER_ATTR_DEF) || this.authorizeDataModel.isSelectEnable()) {
            if (searchDn == null || searchDn.length() <= 0) {
                errcode = LDAP_NON_SEARCHDN;
                return errcode;
            }
            if (password == null || password.length() <= 0) {
                errcode = LDAP_NON_PASSWORD;
                return errcode;
            }
        }
        if (!validUtil.isValid(searchDn, SJctrValidatorUtility.Length_1to255)) {
            errcode = LDAP_OVER_LENGTH_SEARCHDN;
            return errcode;
        }
        if (!validUtil.isValid(searchDn, SJctrValidatorUtility.SearchDN)) {
            errcode = LDAP_INVALID_SEARCHDN;
            return errcode;
        }
        if (!validUtil.isValid(password, SJctrValidatorUtility.Length_1to256)) {
            errcode = LDAP_OVER_LENGTH_PASSWORD;
            return errcode;
        }
        if (!validUtil.isValid(password, SJctrValidatorUtility.Password)) {
            errcode = LDAP_INVALID_PASSWORD;
            return errcode;
        }
        if (password.length() >= 0) {
            if (rePassword == null || rePassword.length() <= 0) {
                errcode = LDAP_NON_REPASSWORD;
                return errcode;
            }
            if (!validUtil.isValid(rePassword, SJctrValidatorUtility.Length_1to256)) {
                errcode = LDAP_OVER_LENGTH_REPASSWORD;
                return errcode;
            }
            if (!validUtil.isValid(rePassword, SJctrValidatorUtility.Password)) {
                errcode = LDAP_INVALID_REPASSWORD;
                return errcode;
            }
        }
        if (!password.equals(rePassword)) {
            errcode = LDAP_NOT_EQUAL_PASSWORD;
            return errcode;
        }
        if (this.secServerDataModel.isSelectEnable()) {
            if (this.dnsLookupDataModel.isSelectEnable()) {
                errcode = LDAP_NOT_SET_SECONDARY;
                return errcode;
            }
            String host = this.secHostNameDataModel.getValue();
            if (host == null || host.length() <= 0) {
                errcode = LDAP_NON_SEC_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.Length_1to255)) {
                errcode = LDAP_OVER_LENGTH_SEC_HOSTNAME;
                return errcode;
            }
            if (!validUtil.isValid(host, SJctrValidatorUtility.HostName)) {
                errcode = LDAP_INVALID_SEC_HOSTNAME;
                return errcode;
            }
            String port = this.secPortNumberDataModel.getValue();
            if (port == null || port.length() <= 0) {
                errcode = LDAP_NON_SEC_PORT;
                return errcode;
            }
            if (!validUtil.isValid(port, SJctrValidatorUtility.PortNumber)) {
                errcode = LDAP_INVALID_SEC_PORT;
                return errcode;
            }
            int portvalue = Integer.valueOf(port);
            if (portvalue < SJctrExtAuthServerInfo.PORT_MIN || SJctrExtAuthServerInfo.PORT_MAX < portvalue) {
                errcode = LDAP_NOT_RANGE_SEC_PORT;
                return errcode;
            }
        }
        return errcode;
    }

    private int checkTestSetting() {
        int errcode = RESULT_NORMAL;
        SJctrValidatorUtility varidUtil = new SJctrValidatorUtility();
        String name = this.testUserNameDataModel.getValue();
        String password = this.testPasswordDataModel.getValue();
        if (name == null || name.length() <= 0) {
            errcode = LDAP_NON_USERNAME;
            return errcode;
        }
        if (!varidUtil.isValid(name, SJctrValidatorUtility.Length_1to128)) {
            errcode = LDAP_OVERLENGTH_USERNAME;
            return errcode;
        }
        if (!varidUtil.isValid(name, SJctrValidatorUtility.TestUserName)) {
            errcode = LDAP_INVALID_USERNAME;
            return errcode;
        }
        if (password == null || password.length() <= 0) {
            errcode = LDAP_NON_TPASSWORD;
            return errcode;
        }
        if (!varidUtil.isValid(password, SJctrValidatorUtility.Length_1to128)) {
            errcode = LDAP_OVERLENGTH_TPASSWORD;
            return errcode;
        }
        if (!varidUtil.isValid(password, SJctrValidatorUtility.TestPassword)) {
            errcode = LDAP_INVALID_TPASSWORD;
            return errcode;
        }
        return errcode;
    }

    private void updateLdapSetting(String key, SJbaseLdapConfiguration conf) {
        conf.setServerName(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        String dnsLookup = SJctrExtAuthServerUtility.FALSE_DATA;
        if (this.dnsLookupDataModel.isSelectEnable()) {
            dnsLookup = SJctrExtAuthServerUtility.TRUE_DATA;
        }
        conf.setDnsLookup(dnsLookup);
        String protocol = this.protocolDataModel.getSelection();
        conf.setProtocol(protocol);
        String host = "";
        int port = SJctrExtAuthServerInfo.INVALID_VALUE;
        if (this.dnsLookupDataModel.isSelectDisable()) {
            host = this.priHostNameDataModel.getValue();
            String strport = this.priPortNumberDataModel.getValue();
            if (strport.length() > 0) {
                port = Integer.parseInt(strport);
            }
        }
        conf.setHost(host);
        conf.setPort(port);
        String domainName = this.domainNameDataModel.getValue();
        conf.setDomainName(domainName);
        String userAttr = this.attributeDataModel.getValue();
        conf.setUserAttr(userAttr);
        int timeout = Integer.parseInt(this.timeoutDataModel.getValue());
        conf.setTimeout(timeout);
        int retryInterval = Integer.parseInt(this.intervalDataModel.getValue());
        conf.setRetryInterval(retryInterval);
        int retryTimes = Integer.parseInt(this.retriesDataModel.getValue());
        conf.setRetryTimes(retryTimes);
        String baseDN = this.baseDnDataModel.getValue();
        conf.setSearchDN(baseDN);
        String searchUserDN = this.searchDnDataModel.getValue();
        conf.setSearchUserDN(searchUserDN);
        String searchUserPassword = this.passwordDataModel.getValue();
        conf.setSearchUserPassword(searchUserPassword);
        if (SJctrExtAuthServerUtility.isSecondaryServer(key)) {
            conf.setServerName(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
            String sechost = "";
            int secport = SJctrExtAuthServerInfo.INVALID_VALUE;
            if (this.secServerDataModel.isSelectEnable()) {
                sechost = this.secHostNameDataModel.getValue();
                String strsecport = this.secPortNumberDataModel.getValue();
                if (strsecport.length() > 0) {
                    secport = Integer.parseInt(strsecport);
                }
            }
            conf.setHost(sechost);
            conf.setPort(secport);
        }
    }

    private void updateLdapGroupSetting(String key, SJbaseLdapGroupConfiguration conf) {
        String dnsLookup = SJctrExtAuthServerUtility.FALSE_DATA;
        if (this.dnsLookupDataModel.isSelectEnable()) {
            dnsLookup = SJctrExtAuthServerUtility.TRUE_DATA;
        }
        conf.setDnsLookup(dnsLookup);
        String protocol = this.protocolDataModel.getSelection();
        conf.setProtocol(protocol);
        String host = "";
        int port = SJctrExtAuthServerInfo.INVALID_VALUE;
        if (this.dnsLookupDataModel.isSelectDisable()) {
            host = this.priHostNameDataModel.getValue();
            String strport = this.priPortNumberDataModel.getValue();
            if (strport.length() > 0) {
                port = Integer.parseInt(strport);
            }
        }
        conf.setHost(host);
        conf.setPort(port);
        String domainName = this.domainNameDataModel.getValue();
        conf.setDomainName(domainName);
        int timeout = Integer.parseInt(this.timeoutDataModel.getValue());
        conf.setTimeout(timeout);
        int retryInterval = Integer.parseInt(this.retriesDataModel.getValue());
        conf.setRetryInterval(retryInterval);
        int retryTimes = Integer.parseInt(this.intervalDataModel.getValue());
        conf.setRetryTimes(retryTimes);
        String baseDN = this.baseDnDataModel.getValue();
        conf.setSearchDN(baseDN);
        String searchUserDN = this.searchDnDataModel.getValue();
        conf.setSearchUserDN(searchUserDN);
        String searchUserPassword = this.passwordDataModel.getValue();
        conf.setSearchUserPassword(searchUserPassword);
        if (SJctrExtAuthServerUtility.isSecondaryServer(key)) {
            String sechost = "";
            int secport = SJctrExtAuthServerInfo.INVALID_VALUE;
            if (this.secServerDataModel.isSelectEnable()) {
                sechost = this.secHostNameDataModel.getValue();
                String strsecport = this.secPortNumberDataModel.getValue();
                if (strsecport.length() > 0) {
                    secport = Integer.parseInt(strsecport);
                }
            }
            conf.setHost(sechost);
            conf.setPort(secport);
        }
    }
}

