/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.extauth.setupldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlFreeFormElemCon;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.controller.com.SJctrExtAuthServerUtility;
import sanproject.sn2.controller.com.SJctrGuidanceOfLangType;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrExtAuthServerInfo;
import sanproject.sn2.controller.wizard.account.extauth.com.SJctrValidatorUtility;

public class SJctrSetupServerLdapAuditLog
implements Serializable {
    static final String FUNCTION_NAME = "ADT_FC_ACOUNT";
    static final int NUMBER_OF_SERVERS = 1;
    public static String[][] KeyTable_BasicInfo = new String[][]{{"COMMON", "ADT_SETUP_SERVER"}, {"COMMON", "LDAP"}, {"COMMON", "ADT_NUM_OF_SERVERS"}};
    public static String[][] KeyTable_DtlInfo_Auth = new String[][]{{"COMMON", "CERTIFICATION_FILE_NAME"}, {"COMMON", "DNS_LOOKUP"}, {"COMMON", "AUTHENTICATION_PROTOCOL"}, {"COMMON", "EXT_AUTHORIZATION"}, {"COMMON", "PRIMARY_HOSTNAME"}, {"COMMON", "PRIMARY_PORT_NUM"}, {"COMMON", "DOMAIN_NAME"}, {"COMMON", "USER_ATTRIBUTE"}, {"COMMON", "BASE_DN"}, {"COMMON", "SEARCH_DN"}, {"COMMON", "TIMEOUT"}, {"COMMON", "RETRY_INTERVAL"}, {"COMMON", "RETRY_TIMES"}};
    public static String[][] KeyTable_DtlInfo_SecServer = new String[][]{{"AUTH", "SECOND_SERVER_AUTH"}, {"COMMON", "SECONDARY_HOSTNAME"}, {"COMMON", "SECONDARY_PORT_NUM"}};
    private static final int INDEX_DISPID = 0;
    private static final int INDEX_PARTSID = 1;
    private Map<String, String> TitleEnGuideMap = null;
    private Map<String, String> DataEnGuideMap = null;
    HashMap<String, String> addition = null;
    private String headAuth = "";
    private List<String> detailAuth = new ArrayList<String>();
    private String headSecSever = "";
    private List<String> detailSecSever = new ArrayList<String>();
    private String footer = "";

    SJctrSetupServerLdapAuditLog() {
        SJctrGuidanceOfLangType guidance = new SJctrGuidanceOfLangType("EN");
        this.TitleEnGuideMap = new HashMap<String, String>();
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_BasicInfo));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_Auth));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_SecServer));
        this.DataEnGuideMap = new HashMap<String, String>();
        this.DataEnGuideMap = guidance.getGuidance(SJctrExtAuthServerUtility.AdtGuideKeyTable);
        this.addition = new HashMap();
    }

    public void setAdditionData(SJbaseUserSession userSession) {
        this.addition.put("SN2_AUDITLOG_ADD_LOGTYPE", "USER");
        this.addition.put("SN2_AUDITLOG_ADD_USER", userSession.getUserName());
        this.addition.put("SN2_AUDITLOG_ADD_HOST", SJcSessionUty.getIPAddress(userSession));
        this.addition.put("SN2_AUDITLOG_ADD_LOGID", Integer.toString(userSession.getSessionIdentificationID()));
        String strExtIFID = null;
        strExtIFID = userSession.getLoginType().equals("SVP") ? Integer.toString(5) : Integer.toString(4);
        this.addition.put("SN2_AUDITLOG_ADD_EXTIF", strExtIFID);
    }

    SJcAuditLogCtrlFreeFormElemCon createElemCon() {
        SJcAuditLogCtrlFreeFormElemCon elemCon = new SJcAuditLogCtrlFreeFormElemCon();
        elemCon.setFunctionName(FUNCTION_NAME);
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_SETUP_SERVER");
        String opeName = this.TitleEnGuideMap.get(key);
        elemCon.setOperationName(opeName);
        key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "LDAP");
        String opeParam = this.TitleEnGuideMap.get(key);
        elemCon.setOperationParameter(opeParam);
        elemCon.setAdditionalInfo(this.addition);
        elemCon.setHeadHier1st(this.headAuth);
        elemCon.setDetailHier1st(this.detailAuth);
        elemCon.setHeadHier2nd(this.headSecSever);
        elemCon.setDetailHier2nd(this.detailSecSever);
        elemCon.setFooter(this.footer);
        return elemCon;
    }

    public void setPrintData(SJctrExtAuthServerInfo info) {
        String key;
        String key2;
        String key3;
        String key4;
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < KeyTable_DtlInfo_Auth.length; ++index) {
            key4 = SJctrGuidanceOfLangType.makeGuidanceKey(KeyTable_DtlInfo_Auth[index][0], KeyTable_DtlInfo_Auth[index][1]);
            buffer.append(this.TitleEnGuideMap.get(key4));
            if (index == KeyTable_DtlInfo_Auth.length - 1) break;
            buffer.append(",");
        }
        this.headAuth = "{" + buffer.toString() + "}" + "=" + "\n";
        SJbaseLdapConfiguration config = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        SJbaseLdapGroupConfiguration gconfig = (SJbaseLdapGroupConfiguration)info.getGroupConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_PRIMARY);
        StringBuffer buffer2 = new StringBuffer();
        buffer2.append("{");
        buffer2.append(info.getCertifyFileName() + ",");
        String dns = "";
        if (SJctrExtAuthServerUtility.isInvalidStr(config.getDnsLookup())) {
            key3 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            dns = this.DataEnGuideMap.get(key3);
        } else {
            key3 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            dns = this.DataEnGuideMap.get(key3);
        }
        buffer2.append(dns + ",");
        String protocol = "";
        if (SJctrExtAuthServerUtility.isLdapsProtocol(config.getProtocol())) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "LDAPS");
            protocol = this.DataEnGuideMap.get(key2);
        } else if (SJctrExtAuthServerUtility.isStarttlsProtocol(config.getProtocol())) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "STARTTLS");
            protocol = this.DataEnGuideMap.get(key2);
        }
        buffer2.append(protocol + ",");
        String authorize = "";
        if (gconfig != null) {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            authorize = this.DataEnGuideMap.get(key);
        } else {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            authorize = this.DataEnGuideMap.get(key);
        }
        buffer2.append(authorize + ",");
        buffer2.append("\n");
        String data = buffer2.toString();
        this.detailAuth.add(data);
        buffer2 = new StringBuffer();
        String host = "";
        String port = "";
        if (!SJctrExtAuthServerUtility.isInvalidStr(config.getDnsLookup())) {
            host = config.getHost();
            port = String.valueOf(config.getPort());
        }
        buffer2.append(host + ",");
        buffer2.append(port + ",");
        buffer2.append(config.getDomainName() + ",");
        buffer2.append(config.getUserAttr() + ",");
        buffer2.append("\n");
        String data2 = buffer2.toString();
        this.detailAuth.add(data2);
        SJctrValidatorUtility validUtil = new SJctrValidatorUtility();
        StringBuffer buffer3 = new StringBuffer();
        String baseDN = validUtil.replaceStr(config.getSearchDN(), SJctrValidatorUtility.Comma, " ");
        buffer3.append(baseDN + ",");
        String searchDN = validUtil.replaceStr(config.getSearchUserDN(), SJctrValidatorUtility.Comma, " ");
        buffer3.append(searchDN + ",");
        String timeout = String.valueOf(config.getTimeout());
        buffer3.append(timeout + ",");
        String interval = String.valueOf(config.getRetryInterval());
        buffer3.append(interval + ",");
        String retries = String.valueOf(config.getRetryTimes());
        buffer3.append(retries);
        buffer3.append("}\n");
        String data3 = buffer3.toString();
        this.detailAuth.add(data3);
        buffer = new StringBuffer();
        for (int index = 0; index <= KeyTable_DtlInfo_SecServer.length; ++index) {
            key4 = SJctrGuidanceOfLangType.makeGuidanceKey(KeyTable_DtlInfo_SecServer[index][0], KeyTable_DtlInfo_SecServer[index][1]);
            buffer.append(this.TitleEnGuideMap.get(key4));
            if (index == KeyTable_DtlInfo_SecServer.length - 1) break;
            buffer.append(",");
        }
        this.headSecSever = "{" + buffer.toString() + "}" + "=" + "\n";
        SJbaseLdapConfiguration config_sec = (SJbaseLdapConfiguration)info.getConfiguration(SJctrExtAuthServerInfo.KEY_SERVER_SECONDARY);
        StringBuffer buffer4 = new StringBuffer();
        String secondary = "";
        host = "";
        port = "";
        if (config_sec != null) {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            secondary = this.DataEnGuideMap.get(key2);
            host = config_sec.getHost();
            port = String.valueOf(config_sec.getPort());
        } else {
            key2 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            secondary = this.DataEnGuideMap.get(key2);
        }
        buffer4.append("{");
        buffer4.append(secondary + ",");
        buffer4.append(host + ",");
        buffer4.append(port);
        buffer4.append("}");
        data2 = buffer4.toString();
        this.detailSecSever.add(data2);
        String key5 = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_NUM_OF_SERVERS");
        this.footer = this.TitleEnGuideMap.get(key5) + "=" + 1;
    }
}

