/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.addresources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.comparator.SJctrRsgHGNameComparator;
import sanproject.sn2.controller.com.comparator.SJctrRsgITAliasComparator;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.account.rsg.addresources.SJctrAddResourcesConfirmData;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgHostGroupsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgIscsiTargetsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPgsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgPortsTableModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgsTableModel;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrAddResourcesConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 16781631;
    private static final String KEY_TABLE_SELECTED_RSG = "COM_TABLE_SELECTED_RSG";
    private static final String KEY_TABLE_SEL_PGS = "COM_TABLE_SEL_PGS";
    private static final String KEY_TABLE_SEL_LDEVS = "COM_TABLE_SEL_LDEVS";
    private static final String KEY_TABLE_SEL_PTS = "COM_TABLE_SEL_PTS";
    private static final String KEY_TABLE_SEL_HGS = "COM_TABLE_SEL_HGS";
    private static final String KEY_TABLE_SEL_ISCSIS = "COM_TABLE_SEL_ISCSIS";

    public SJctrAddResourcesConfirmDC() throws SJcException {
        super(16781631);
        this.initDataModel();
    }

    protected void initDataModel() {
        SJctrRsgsTableModel selectedRsgTable = new SJctrRsgsTableModel();
        selectedRsgTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SELECTED_RSG, selectedRsgTable);
        SJctrRsgPgsTableModel addPgsRscTable = new SJctrRsgPgsTableModel();
        addPgsRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_PGS, addPgsRscTable);
        SJctrRsgLdevsTableModel addLdevsRscTable = new SJctrRsgLdevsTableModel();
        addLdevsRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_LDEVS, addLdevsRscTable);
        SJctrRsgPortsTableModel addPortsRscTable = new SJctrRsgPortsTableModel();
        addPortsRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_PTS, addPortsRscTable);
        SJctrRsgHostGroupsTableModel addHgsRscTable = new SJctrRsgHostGroupsTableModel();
        addHgsRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_HGS, addHgsRscTable);
        SJctrRsgIscsiTargetsTableModel addIscsisRscTable = new SJctrRsgIscsiTargetsTableModel();
        addIscsisRscTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SEL_ISCSIS, addIscsisRscTable);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrAddResourcesConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrAddResourcesConfirmData.class);
        if (confirmDataList == null) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(207, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (confirmDataList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(207, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        confirmData = (SJctrAddResourcesConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(207, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrAddResourcesConfirmData.class);
        SJctrAddResourcesConfirmData confirmData = (SJctrAddResourcesConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        SJctrRsgUtility.setOldTaskNothingData(this);
        super.makeDataObjectModel(keyList);
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJctrAddResourcesConfirmData confirmData = (SJctrAddResourcesConfirmData)this.getProxy().getCache(SJctrAddResourcesConfirmData.class).get(0);
            SJctrRsgsTableModel confirmTable = (SJctrRsgsTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED_RSG);
            confirmTable.setBasicDataList(confirmData.getAddResourcesInfo());
            SJmoRSGgetRsg rsgInfo = confirmData.getAddResourcesInfo().get(0).getRsgInfo();
            ArrayList<SJmoPgIndex> pgIndexList = rsgInfo.getVdevs();
            ArrayList pgDetailList = (ArrayList)SJctrRsgUtility.getSJmoPgDetail(this);
            ArrayList vdevDetailList = (ArrayList)SJctrRsgUtility.getSJmoVdevDetail(this);
            ArrayList pdevDetailList = (ArrayList)SJctrRsgUtility.getSJmoPdevDetail(this);
            ArrayList pgStList = (ArrayList)SJctrRsgUtility.getSJmoPgScatteredInfo(this);
            ArrayList pgEncList = (ArrayList)SJctrRsgUtility.getSJmoPgEncryptionInfo(this);
            ArrayList ldevDetailList = (ArrayList)SJctrRsgUtility.getSJmoLdevDetail(this);
            ArrayList ldevStatusList = (ArrayList)SJctrRsgUtility.getSJmoLdevStatusInfo(this);
            ArrayList luseList = (ArrayList)SJctrRsgUtility.getSJmoLdevLuseInfo(this);
            List<SJctrRsgPgInfo> pgTableList = SJctrRsgUtility.createRsgPgInfoList(pgIndexList, pgDetailList, vdevDetailList, pdevDetailList, pgStList, pgEncList, ldevDetailList, ldevStatusList, luseList);
            SJctrRsgPgsTableModel addPgsRscTable = (SJctrRsgPgsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PGS);
            SJctrRsgUtility.makePgCapacityUnit(addPgsRscTable, pgTableList);
            addPgsRscTable.setBasicDataList(pgTableList);
            ArrayList<SJmoLdevIndex> ldevIndexList = rsgInfo.getLdevs();
            List<SJctrRsgLdevInfo> ldevTableList = SJctrRsgUtility.createRsgLdevInfoList(ldevIndexList, ldevDetailList);
            SJctrRsgLdevsTableModel addLdevsRscTable = (SJctrRsgLdevsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_LDEVS);
            SJctrRsgUtility.makeLdevCapacityUnit(addLdevsRscTable, ldevTableList);
            addLdevsRscTable.setBasicDataList(ldevTableList);
            ArrayList<SJmoPortIndex> portIndexList = rsgInfo.getPorts();
            ArrayList portDetailList = (ArrayList)SJctrRsgUtility.getSJmoPortDetail(this);
            List<SJctrRsgPortInfo> portTableList = SJctrRsgUtility.createRsgPortInfoList(portIndexList, portDetailList);
            SJctrRsgPortsTableModel addPortsRscTable = (SJctrRsgPortsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_PTS);
            addPortsRscTable.setBasicDataList(portTableList);
            ArrayList<SJmoHostGroupIndex> hgIndexList = rsgInfo.getHostGrps();
            ArrayList hgInfoList = (ArrayList)SJctrRsgUtility.getSJmoPortHostGroupInfo(this);
            List<SJctrRsgHostGroupInfo> hgTableList = SJctrRsgUtility.createRsgHgInfoList(hgIndexList, portDetailList, hgInfoList);
            Collections.sort(hgTableList, new SJctrRsgHGNameComparator());
            SJctrRsgHostGroupsTableModel addHgsRscTable = (SJctrRsgHostGroupsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_HGS);
            addHgsRscTable.setBasicDataList(hgTableList);
            List<SJmoPortIscsiTargetInfo> iscsiInfoList = SJctrRsgUtility.getSJmoPortIscsiTargetInfo(this);
            List<SJctrRsgIscsiTargetInfo> iscsiTableList = SJctrRsgUtility.createRsgIscsiInfoList(hgIndexList, portDetailList, iscsiInfoList);
            Collections.sort(iscsiTableList, new SJctrRsgITAliasComparator());
            SJctrRsgIscsiTargetsTableModel addIscsisRscTable = (SJctrRsgIscsiTargetsTableModel)this.getDataObjectModel(KEY_TABLE_SEL_ISCSIS);
            addIscsisRscTable.setBasicDataList(iscsiTableList);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrAddResourcesConfirmData.class);
        retMap.put(SJctrAddResourcesConfirmData.class.getName(), confirmDataList);
        return retMap;
    }
}

