/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.releasegadreserves;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgLdevInfo;
import sanproject.sn2.controller.wizard.account.rsg.releasegadreserves.SJctrReleaseGADReservesAC;
import sanproject.sn2.controller.wizard.account.rsg.releasegadreserves.SJctrReleaseGADReservesConfirmDC;
import sanproject.sn2.controller.wizard.account.rsg.releasegadreserves.SJctrReleaseGADReservesConfirmData;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrReleaseGADReservesSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "RELEASE_GAD_RESERVES";
    private static final Class<?> CONFIRM_DC = SJctrReleaseGADReservesConfirmDC.class;

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrReleaseGADReservesAC ac = new SJctrReleaseGADReservesAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<Object> releaseInfo = new ArrayList();
            releaseInfo = dc.getProxy().getCache(SJctrRsgInfo.class.getName());
            SJctrReleaseGADReservesConfirmData confirmData = new SJctrReleaseGADReservesConfirmData();
            if (null == releaseInfo) {
                uc.getLogUty().putlog("constructConfirmData", "Information of SJctrRsgInfo is null.");
                SJctrError err = new SJctrError(207, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (releaseInfo.size() == 0) {
                uc.getLogUty().putlog("constructConfirmData", "Size of SJctrRsgInfo data list is zero.");
                SJctrError err = new SJctrError(207, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoRSGgetRsg rsgInfo = ((SJctrRsgInfo)releaseInfo.get(0)).getRsgInfo();
            ArrayList rsgInfoList = (ArrayList)SJctrRsgUtility.getRsgListInfo(dc);
            SJmoRSGgetRsg releaseRsgInfo = SJctrRsgUtility.getRsgInfoByRsgId(rsgInfo.getRsgInfo().getRsgId(), rsgInfoList);
            if (null == releaseRsgInfo) {
                uc.getLogUty().putlog("checkConstructData", "The resource group to edit does not exist.");
                SJctrError err = new SJctrError(207, 22, 105303);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<SJmoLdevIndex> checkLdevList = rsgInfo.getLdevs();
            if (checkLdevList.size() > 0) {
                List<SJmoHUVMVirtualLdev> vLdevList;
                List<SJmoLdevDetail> ldevDetailList = SJctrRsgUtility.getSJmoLdevDetail(dc);
                List<SJctrRsgLdevInfo> exLdevInfoList = SJctrRsgUtility.createRsgLdevInfoList(checkLdevList, ldevDetailList, vLdevList = SJctrRsgUtility.getSJmoHUVMVirtualLdev(dc));
                boolean attributeResult = SJctrRsgUtility.isVirtualLdevListNotReserve(exLdevInfoList);
                if (attributeResult) {
                    uc.getLogUty().putlog("constructConfirmData", "Selected ldev is not reserve attribute.");
                    SJctrError err = new SJctrError(207, 22, 205102);
                    SJcException exp = err.createException();
                    throw exp;
                }
                boolean migration = SJctrRsgUtility.isIncludeMigrationVolume(exLdevInfoList);
                if (migration) {
                    uc.getLogUty().putlog("constructConfirmData", "Selected virtual ldev include migration ldev.");
                    SJctrError err = new SJctrError(207, 22, 205104);
                    SJcException exp = err.createException();
                    throw exp;
                }
            }
            confirmData.setReleaseInfo(releaseInfo);
            ArrayList<SJctrReleaseGADReservesConfirmData> confirmDataList = new ArrayList<SJctrReleaseGADReservesConfirmData>();
            confirmDataList.add(confirmData);
            confirmData.setNeedData(dc);
            dc.getProxy().putCache(SJctrReleaseGADReservesConfirmData.class, confirmDataList);
            ac.setApplyData(confirmData);
            wizard.addConfirmData(ac, related);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107002);
        }
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public Class<?>[] getClassList() {
        return new Class[0];
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }
}

