/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.arraygroup.createpgs.cntl;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.arraygroup.com.SJctrParityGroupUtility;
import sanproject.sn2.controller.wizard.forcibly.com.SJctrForciblyAC;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;

public class SJctrCreatePgAC
extends SJctrForciblyAC {
    private static final long serialVersionUID = 4968474993419699414L;
    private Map<Integer, SJctrParityGroupUtility.ScatteredPgInfo> info;
    private List<SJctrError> resultData = new ArrayList<SJctrError>();

    public SJctrCreatePgAC(Map<Integer, SJctrParityGroupUtility.ScatteredPgInfo> info) {
        this.info = info;
    }

    @Override
    public int getLeadTime() {
        return 65;
    }

    public ArrayList<SanRequest> getSetList() {
        ArrayList<SanRequest> list = new ArrayList<SanRequest>();
        try {
            SanRequest request = this.newRequest("MNTcreateParityGroups");
            SanList parityGroups = request.newList("ParityGroups");
            for (SJctrParityGroupUtility.ScatteredPgInfo pgInfo : this.info.values()) {
                for (SJctrParityGroupUtility.PgPdevInfo pgPdev : pgInfo.getPgPdevs()) {
                    StringBuffer buf = new StringBuffer();
                    SJmoPgDetail pgDtl = pgPdev.getPg();
                    SanObject pg = parityGroups.addObj();
                    pg.putIntArray("Id", new int[]{pgDtl.getFB4(), pgDtl.getPG()});
                    pg.putInt("RaidLevel", pgDtl.getRaidLevel());
                    SanObject clpr = pg.newObj("Clpr");
                    clpr.putInt("Id", (int)pgDtl.getCLPR());
                    pg.putBoolean("Encryption", pgPdev.getEnc().getEncrypt() == 1);
                    pg.putBoolean("Copyback", pgDtl.getCopybackMode() == SJctrParityGroupUtility.RMI_VALUE_COPYBACK_ENABLED);
                    pg.putBoolean("VirtualizationMode", pgDtl.getBVirtMode());
                    pg.putInt("EmulationType", pgDtl.getBaseEmulationType());
                    SanList drives = pg.newList("Drives");
                    for (SJmoPdevDetail pdev : pgPdev.getPdevs()) {
                        SanObject drive = drives.addObj();
                        drive.putIntArray("Id", new int[]{pdev.getCDEV(), pdev.getRDEV()});
                        if (buf.length() > 0) {
                            buf.append(",");
                        }
                        buf.append(pdev.toString());
                    }
                    SJctrLogUty.info(this.getClass().getSimpleName(), "getSetList", "PG:" + pgDtl.getIndexKey() + " PDEV:" + buf.toString());
                }
            }
            SanList interleavedInfos = request.newList("InterleavingSettings");
            for (SJctrParityGroupUtility.ScatteredPgInfo pgInfo : this.info.values()) {
                if (!pgInfo.isConcatenatedPg()) continue;
                SanObject interleavedInfo = interleavedInfos.addObj();
                SanList memberPgs = interleavedInfo.newList("ParityGroups");
                for (SJctrParityGroupUtility.PgPdevInfo pgPdev : pgInfo.getPgPdevs()) {
                    SJmoPgDetail pgDtl = pgPdev.getPg();
                    SanObject memberPg = memberPgs.addObj();
                    memberPg.putIntArray("Id", new int[]{pgDtl.getFB4(), pgDtl.getPG()});
                }
            }
            list.add(request);
        }
        catch (SanDataException e) {
            SJctrError error = SJctrParityGroupUtility.createPgInternalError();
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "getSetList", "Failed to build set list", e);
        }
        return list;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        try {
            if (resultObject == null) {
                return;
            }
            SanResponse response = (SanResponse)resultObject;
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(response);
            if (errorInfo.getErrorCode() != 0) {
                SJctrError error = errorInfo.createError();
                this.setError(error);
                SanList parityGroups = response.getList("ParityGroups");
                for (SanObject pg : parityGroups) {
                    SanObject pgErrorInfo = pg.getObj("ErrorInfo");
                    SJctrError createError = new SJctrKeyValueErrorInfo(pgErrorInfo).createError();
                    this.resultData.add(createError);
                }
            }
        }
        catch (SanDataException e) {
            SJctrError error = SJctrParityGroupUtility.createPgInternalError();
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "setApplyResult", "Failed to build result list", e);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }
}

