/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.base;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcBitSetUty;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageExchanger;
import sanproject.sn2.controller.com.SJctrQueueBox;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardChildModel;
import sanproject.sn2.controller.wizard.base.SJctrWizardCrumbTrailModel;
import sanproject.sn2.controller.wizard.confirm.SJctrConfirmDC;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoGetAgent;

public final class SJctrWizardWindowDC
extends SJctrDataController {
    public static final String COM_CHILD = "COM_CHILD";
    public static final String COM_CRUMB = "COM_CRUMB";
    public static final int DISP_ID = 0x1000000;
    private SJctrDataController parentDC;
    private SJctrTask mTask;
    private long wizardStartTime;
    private Map<String, List<?>> currentCache;
    private Set<Integer> createdDialogSet;
    private List<BitSet> lockList = new ArrayList<BitSet>();

    public SJctrWizardWindowDC() throws SJcException {
        super(0x1000000);
        this.initDataModel();
        this.initListener();
        this.wizardStartTime = System.currentTimeMillis();
        this.makeTask();
    }

    public void abort() {
        this.mTask = null;
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        crumbModel.abort();
        this.clearData();
    }

    public void addConfirmData(SJctrApplyController ac, SJctrRelatedDispDataObject related) {
        SJctrDataController confirmDataController = this.getOwner().getDataController(related);
        if (!(confirmDataController instanceof SJctrConfirmDataController)) {
            return;
        }
        confirmDataController.setProxy(this.getProxy());
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        SJctrConfirmDC confirmDc = (SJctrConfirmDC)crumbModel.getNowWizardDataController();
        confirmDc.addConfirmDataController(related);
        this.mTask.add(ac, (SJctrConfirmDataController)confirmDataController);
    }

    public boolean addSubWizard(Class<? extends SJctrSubWizard> cls) {
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        boolean addResult = crumbModel.addSubWizard(cls);
        if (addResult) {
            SJctrSubWizard wiz = this.getSubWizard(cls);
            this.setDKCLock(wiz);
        }
        return addResult;
    }

    public boolean addSubWizardForRegularBackup(Class<? extends SJctrSubWizard> cls) {
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        return crumbModel.addSubWizard(cls);
    }

    public SJctrSubWizard getSubWizard(Class<? extends SJctrSubWizard> cls) {
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        return crumbModel.getSubWizard(cls);
    }

    public boolean isHistoryAccept() {
        SJctrUserController uc = this.getOwner();
        SJctrQueueBox queue = uc.getQueueBox();
        return queue.isHistoryAccept();
    }

    public boolean apply() throws SJcException {
        boolean result = this.getCrumbTrailModel().isApply();
        if (result) {
            SJctrUserController uc = this.getOwner();
            SJctrQueueBox queue = uc.getQueueBox();
            BitSet lockBit = this.getResourceGroupIdSet();
            this.mTask.setResourceGroupId(lockBit);
            queue.addTask(this.mTask);
        }
        return result;
    }

    public boolean autoApply() throws SJcException {
        boolean result = this.getCrumbTrailModel().isApply();
        if (result) {
            SJctrUserController uc = this.getOwner();
            SJctrQueueBox queue = uc.getQueueBox();
            BitSet lockBit = this.getResourceGroupIdSet();
            this.mTask.setResourceGroupId(lockBit);
            queue.addTaskForRegularBackup(this.mTask);
        }
        return result;
    }

    public boolean back() {
        boolean result = this.getCrumbTrailModel().isBack();
        if (result) {
            SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
            SJctrWizardChildModel childModel = this.getChildModel();
            crumbModel.doBack();
            childModel.setNextDisp(crumbModel.getNowDisp());
        }
        return result;
    }

    public boolean confirm() {
        boolean result = this.getCrumbTrailModel().isFinish();
        if (result) {
            this.setUnitSelect();
            SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
            SJctrWizardChildModel childModel = this.getChildModel();
            crumbModel.doFinish();
            childModel.setNextDisp(crumbModel.getNowDisp());
            SJctrWizardDataController confirm = crumbModel.getNowWizardDataController();
            if (!confirm.isConstruct()) {
                boolean taskNameFlg = false;
                this.makeSubWizardConstructData();
                SJctrComUtility comUtil = this.getOwner().getComUtility();
                for (SJctrSubWizard subWizard : crumbModel.getSubWizardList()) {
                    SJctrGuidance taskNameKey = subWizard.getTaskNameGuidance();
                    if (!taskNameFlg) {
                        this.mTask.setTypeEn(taskNameKey.getGuidanceEN());
                        this.mTask.setType(taskNameKey.getGuidance(comUtil));
                        taskNameFlg = true;
                    }
                    this.mTask.addActionType(taskNameKey.getGuidance(comUtil));
                    this.mTask.addActionTypeEn(taskNameKey.getGuidanceEN());
                    this.mTask.addActionGuidance(taskNameKey);
                    this.cacheSubWizardUnit(subWizard);
                    subWizard.constructConfirmData(this);
                }
                SJctrNestedListDataObject crumbTrail = (SJctrNestedListDataObject)crumbModel.getDataObject(null);
                this.mTask.setCrumbTrail(crumbTrail);
            } else {
                for (SJctrSubWizard subWizard : crumbModel.getSubWizardList()) {
                    this.cacheSubWizardUnit(subWizard);
                    Class<?> key = subWizard.getConfirmClass();
                    String unit = subWizard.getUnitSelect();
                    this.mTask.setUnitSelect(key, unit);
                }
            }
        }
        return result;
    }

    private void cacheSubWizardUnit(SJctrSubWizard subWizard) {
        Class<?> confirmCls = subWizard.getConfirmClass();
        if (confirmCls == null) {
            return;
        }
        String unit = subWizard.getUnitSelect();
        if (unit == null) {
            return;
        }
        String key = SJctrConfirmDataController.getConfirmUnitKey(confirmCls);
        ArrayList<String> list = new ArrayList<String>();
        list.add(unit);
        this.getProxy().putCache(key, list);
    }

    private void makeSubWizardConstructData() {
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        HashSet<SJctrGetDirectWrapper> directList = new HashSet<SJctrGetDirectWrapper>();
        for (SJctrSubWizard subWizard : crumbModel.getSubWizardList()) {
            directList.addAll(subWizard.getModelDirect());
        }
        if (directList.size() > 0) {
            Map<SJctrGetDirectWrapper, List<?>> map = this.proxy.getDataInf(directList);
        }
    }

    public void singleWizardConfirm() {
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        crumbModel.doSingleWizard();
        this.confirm();
    }

    @Override
    public void finish() throws SJcException {
        this.mTask = null;
        this.releaseDKCLock();
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        Collection<SJctrSubWizard> subWizards = crumbModel.getSubWizardList();
        SJctrSubWizard[] subs = new SJctrSubWizard[subWizards.size()];
        for (SJctrSubWizard subWizard : subs = subWizards.toArray(subs)) {
            crumbModel.removeSubWizard(subWizard.getClass());
        }
        if (this.createdDialogSet != null) {
            SJctrUserController uc = this.getOwner();
            if (uc != null) {
                for (Integer dispId : this.createdDialogSet) {
                    HashMap<String, Object> ctrlData = uc.getControlData(dispId);
                    Iterator<String> ite = ctrlData.keySet().iterator();
                    while (ite.hasNext()) {
                        String key = ite.next();
                        if ("COM_VIEWINFO".equals(key)) continue;
                        ite.remove();
                    }
                }
            } else {
                this.getLogUty().putlog("finish", "UserController is null.", 40000);
            }
        }
        super.finish();
    }

    public void registerDataController(SJctrRelatedDispDataObject related) {
        int dispId;
        SJctrUserController uc = this.getOwner();
        if (uc == null) {
            this.getLogUty().putlog("saveDialogSetting", "UserController is null.", 40000);
            return;
        }
        SJctrDataController dc = uc.getDataController(related);
        if (dc == null) {
            this.getLogUty().putlog("saveDialogSetting", "DataController is null.", 40000);
            return;
        }
        if (dc instanceof SJctrWizardDataController) {
            SJctrWizardDataController wizDc = (SJctrWizardDataController)dc;
            wizDc.setTopWizard(this);
        }
        if (SJctrWizardWindowDC.isDispKind(dispId = dc.getDisplayId(), 0x2000000) || SJctrWizardWindowDC.isDispKind(dispId, 0x2100000)) {
            dc.setRestoreFlg(true);
            if (this.createdDialogSet == null) {
                this.createdDialogSet = new HashSet<Integer>();
            }
            this.createdDialogSet.add(dispId);
        }
    }

    public boolean isWizardDialog(int dispId) {
        boolean result = false;
        if (this.createdDialogSet != null) {
            result = this.createdDialogSet.contains(dispId);
        }
        return result;
    }

    public boolean isApply() {
        return this.getCrumbTrailModel().isApply();
    }

    public boolean isBack() {
        return this.getCrumbTrailModel().isBack();
    }

    public boolean isFinish() {
        return this.getCrumbTrailModel().isFinish();
    }

    public boolean isNext() {
        return this.getCrumbTrailModel().isNext();
    }

    public List<?> getCache(Class<?> key) {
        return this.getCache(key.getName());
    }

    public List<?> getCache(String key) {
        return this.currentCache.get(key);
    }

    public SJctrWizardDataController getFirstWizardDataController(Class<? extends SJctrSubWizard> cls) {
        return this.getCrumbTrailModel().getFirstWizardDataController(cls);
    }

    public SJctrWizardDataController getNextIndexWizardDataController() {
        return this.getCrumbTrailModel().getNextIndexWizardDataController();
    }

    public SJctrWizardDataController getNextWizardDataController() {
        return this.getCrumbTrailModel().getNextWizardDataController();
    }

    public SJctrWizardDataController getNowWizardDataController() {
        return this.getCrumbTrailModel().getNowWizardDataController();
    }

    public SJctrSubWizard getFirstSubWizard() {
        SJctrSubWizard retSubWiz;
        block0: {
            SJctrSubWizard subWiz;
            retSubWiz = null;
            SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
            Iterator<SJctrSubWizard> i$ = crumbModel.getSubWizardList().iterator();
            if (!i$.hasNext()) break block0;
            retSubWiz = subWiz = i$.next();
        }
        return retSubWiz;
    }

    public Class<? extends SJctrSubWizard> getSubWizard(SJctrWizardDataController wizDc) {
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        return crumbModel.getSubWizard(wizDc);
    }

    public SJctrTask getTask() {
        return this.mTask;
    }

    public void makeTask() {
        this.mTask = new SJctrTask();
        this.mTask.setWizardStartTime(this.wizardStartTime);
    }

    public boolean next() {
        boolean result = this.getCrumbTrailModel().isNext();
        if (result) {
            this.setUnitSelect();
            SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
            SJctrWizardChildModel childModel = this.getChildModel();
            crumbModel.doNext();
            childModel.setNextDisp(crumbModel.getNowDisp());
        }
        return result;
    }

    public void putCache(Class<?> key, List<?> list) {
        this.putCache(key.getName(), list);
    }

    public void putCache(String key, List<?> list) {
        this.currentCache.put(key, list);
    }

    public void removeSubWizard(Class<? extends SJctrSubWizard> cls) {
        SJctrWizardCrumbTrailModel crumbModel = this.getCrumbTrailModel();
        crumbModel.removeSubWizard(cls);
    }

    public void rollback() {
        SJctrWizardCrumbTrailModel crumbTrail = this.getCrumbTrailModel();
        crumbTrail.rollback();
    }

    public boolean isDoRollback() {
        SJctrWizardCrumbTrailModel crumbTrail = this.getCrumbTrailModel();
        boolean ret = crumbTrail.isDoRollBack();
        return ret;
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_CRUMB, new SJctrWizardCrumbTrailModel());
        this.addDataObjectModel(COM_CHILD, new SJctrWizardChildModel());
    }

    @Override
    protected void initProxy() {
        super.initProxy();
        this.currentCache = new HashMap();
        this.getProxy().setCacheMap(this.currentCache);
    }

    private SJctrWizardChildModel getChildModel() {
        return (SJctrWizardChildModel)this.getDataObjectModel(COM_CHILD);
    }

    private SJctrWizardCrumbTrailModel getCrumbTrailModel() {
        return (SJctrWizardCrumbTrailModel)this.getDataObjectModel(COM_CRUMB);
    }

    private void initListener() {
        this.addMessageEventListener(SJctrDataController.NOTIFY_STATE.MOVE_DISP, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrWizardCrumbTrailModel crumbModel = SJctrWizardWindowDC.this.getCrumbTrailModel();
                SJctrWizardChildModel childModel = SJctrWizardWindowDC.this.getChildModel();
                childModel.setNextDisp(crumbModel.getNowDisp());
                SJctrWizardWindowDC.this.getDataObjectModel(SJctrWizardWindowDC.COM_CRUMB).setDirty();
                SJctrWizardWindowDC.this.getDataObjectModel(SJctrWizardWindowDC.COM_CHILD).setDirty();
            }
        });
    }

    public SJctrDataController getParentDC() {
        return this.parentDC;
    }

    public void setParentDC(SJctrDataController dc) {
        this.parentDC = dc;
    }

    private void setDKCLock(SJctrSubWizard subwiz) throws SJcException {
        BitSet lockBit = SJcBitSetUty.booolean2bitset(this.getOwner().getUserSession().getRoleResourceInfo().getResourceGroup());
        SJmoGetAgent agent = this.getOwner().getModelAgent();
        SJctrUserController uc = this.getOwner();
        long lockId = uc.getLockId();
        boolean allRSGFlg = uc.getAuthorizeContainer().getRoleResourceContainer().checkAllResourceGroup();
        int lockType = SJctrQueueController.getLockType(allRSGFlg);
        if (lockType == 0) {
            lockBit = null;
        }
        int ssoOpt = uc.getSsoOpt();
        uc.setLockId(-1L);
        try {
            if (lockId == -1L) {
                SJbaseUserSessionInterface us = uc.getUserSession();
                String userId = us.getUserName();
                String pass = ((SJbaseUserSessionInterfaceInternal)us).getPassword();
                String IPAdress = SJcSessionUty.getIPAddress(us);
                lockId = agent.setDkcLock(userId, pass, lockBit, lockType, IPAdress, ssoOpt);
            } else {
                try {
                    lockId = agent.setDkcLock(lockId, lockBit, lockType, ssoOpt);
                }
                catch (SJcException e) {
                    SJctrLogUty.info(SJctrWizardWindowDC.class.getSimpleName(), "setDkcLock", "lockId fail. lockId=" + lockId);
                    SJbaseUserSessionInterface us = uc.getUserSession();
                    String userId = us.getUserName();
                    String pass = ((SJbaseUserSessionInterfaceInternal)us).getPassword();
                    String IPAdress = SJcSessionUty.getIPAddress(us);
                    lockId = agent.setDkcLock(userId, pass, lockBit, lockType, IPAdress, ssoOpt);
                }
            }
        }
        catch (SJcException e) {
            throw SJctrMessageExchanger.exchange(e);
        }
        uc.setLockId(lockId);
        SJctrLogUty.info(SJctrWizardWindowDC.class.getSimpleName(), "setDKCLock", "lockId=" + lockId);
        this.lockList.add(lockBit);
    }

    private void releaseDKCLock() {
        SJctrUserController uc = this.getOwner();
        long lockId = uc.getLockId();
        SJctrAuthorizeContainer auth = uc.getAuthorizeContainer();
        SJcRoleResourceContainer role = auth.getRoleResourceContainer();
        boolean allRSGFlg = role.checkAllResourceGroup();
        int lockType = SJctrQueueController.getLockType(allRSGFlg);
        SJmoGetAgent agent = uc.getModelAgent();
        for (BitSet lockBit : this.lockList) {
            try {
                agent.releaseDkcLock(lockId, lockBit, lockType);
            }
            catch (SJmoException e) {
                String msgLock = lockBit == null ? "null" : lockBit.toString();
                SJctrLogUty.warn(SJctrWizardWindowDC.class.getSimpleName(), "releaseDkcLock", "Release DKC Lock fail:" + msgLock, e);
            }
        }
    }

    public BitSet getResourceGroupIdSet() {
        BitSet ret = new BitSet();
        for (BitSet lockBit : this.lockList) {
            if (lockBit == null) continue;
            ret.or(lockBit);
        }
        return ret;
    }

    private void setUnitSelect() {
        boolean construct = this.getCrumbTrailModel().isConstructIndex();
        if (!construct) {
            return;
        }
        SJctrWizardDataController now = this.getNowWizardDataController();
        if (now == null) {
            return;
        }
        String unit = now.getUnitSelect();
        if (unit == null) {
            return;
        }
        now.setUnitSelect(unit);
    }
}

