/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.createldevs.hdp.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.controller.wizard.cvs.createldevs.hdp.com.SJctrPoolDetail;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;

public class SJctrUsedCapacityFromPoolDetailColumn
extends SJctrCapacityColumn {
    public SJctrUsedCapacityFromPoolDetailColumn(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("USED_RESERVED"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String select = this.getUnitSelect();
        SJctrCapacityUtility.UNIT unit = select.length() == 0 ? (this.hasOpenVolume ? SJctrCapacityUtility.UNIT.GB : SJctrCapacityUtility.UNIT.CYL) : SJctrCapacityUtility.UNIT.valueOf(select);
        SJctrPoolDetail data = (SJctrPoolDetail)dataList.get(0);
        SJctrCapacityUtility util = this.getTable().getComUtility().getCapacityUtility();
        long lSize = data.getPoolUsedLBA();
        int iEmu = this.getTable().getComUtility().getCVSUtility().getEmu(data.getEmuTypeName());
        StringBuilder buf = new StringBuilder(util.toString(lSize, unit, iEmu));
        buf.append(" ");
        buf.append(util.getUnitString(unit));
        return buf.toString();
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJctrPoolDetail pool = (SJctrPoolDetail)this.getPrimaryKeyObject(dat);
        long lSize = pool.getPoolUsedLBA();
        return lSize;
    }

    @Override
    public boolean hasMainframeVolume(Map<Class<?>, List<?>> basicData) {
        boolean rtn = false;
        List<?> list = basicData.get(SJmoGetPoolDetail.class);
        for (int i = 0; i < list.size(); ++i) {
            SJctrPoolDetail pool = (SJctrPoolDetail)list.get(i);
            if (pool.isOpen()) continue;
            rtn = true;
            break;
        }
        return rtn;
    }

    @Override
    public boolean hasOpenVolume(Map<Class<?>, List<?>> basicData) {
        boolean rtn = false;
        List<?> list = basicData.get(SJmoGetPoolDetail.class);
        for (int i = 0; i < list.size(); ++i) {
            SJctrPoolDetail pool = (SJctrPoolDetail)list.get(i);
            if (!pool.isOpen()) continue;
            rtn = true;
            break;
        }
        return rtn;
    }

    @Override
    protected long getCylinderNumber(Map<String, Object> dat) {
        SJctrPoolDetail pool = (SJctrPoolDetail)this.getPrimaryKeyObject(dat);
        int emuType = this.getTable().getComUtility().getCVSUtility().getEmu(pool.getEmuTypeName());
        long block = this.getNumber(dat);
        SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
        long cylinder = capaUtil.toCylValue(block, emuType);
        return cylinder;
    }
}

