/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.editldevs;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.common.Robj_interface_POOLgetAOUVolRelation;
import sanproject.common.Robj_interface_POOLsetAllocationOptionData;
import sanproject.common.Robj_interface_POOLsetLaneAOUVolData;
import sanproject.common.Robj_interface_POOLsetPbTSMOptionAOUVolData;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serversx.data.RJiLDKCIndex;
import sanproject.serverux.dataimpl.POOLgetAOUVolRelation;
import sanproject.serverux.dataimpl.POOLsetAllocationOptionData;
import sanproject.serverux.dataimpl.POOLsetAllocationOption_IN;
import sanproject.serverux.dataimpl.POOLsetAllocationOption_OUT;
import sanproject.serverux.dataimpl.POOLsetLaneAOUVolData;
import sanproject.serverux.dataimpl.POOLsetLaneAOUVol_IN;
import sanproject.serverux.dataimpl.POOLsetLaneAOUVol_OUT;
import sanproject.serverux.dataimpl.POOLsetPbTSMOptionAOUVolData;
import sanproject.serverux.dataimpl.POOLsetPbTSMOptionAOUVol_IN;
import sanproject.serverux.dataimpl.POOLsetPbTSMOptionAOUVol_OUT;
import sanproject.serverux.dataimpl.RJiRESOURCEsetName_IN;
import sanproject.serverux.dataimpl.RJiRESOURCEsetName_OUT;
import sanproject.serverux.dataimpl.RJiResourceName;
import sanproject.serverux.dataimpl.RJiSetResourceNameResult;
import sanproject.serverux.dataimpl.SanRmiInputInterface;
import sanproject.serverux.dataimpl.SetAOUVolRelation;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;

public class SJctrEditLDEVsAC
extends SJctrApplyController {
    List<SJctrLDEVDetail> LDEVList = new ArrayList<SJctrLDEVDetail>();
    boolean bLdevNameCheck = true;
    boolean bThresholdCheck = true;
    boolean bTierCheck = true;
    boolean bTierLevelCheck = true;
    boolean bRelPrio = true;
    boolean bFaAttri = true;
    boolean bALUAMode = true;
    boolean bDataSaving = true;
    private int iApplyType = 0;
    public static final int APPLY_TYPE_LDEVNAME = 1;
    public static final int APPLY_TYPE_THRESHOLD = 2;
    public static final int APPLY_TYPE_TIER = 3;
    public static final int APPLY_TYPE_TIERLEVEL = 4;
    public static final int APPLY_TYPE_FULLALL = 5;
    public static final int APPLY_TYPE_ALUAMODE = 6;
    public static final int APPLY_TYPE_DATASAVING = 7;
    protected List<SJctrError> resultData = null;
    boolean bNewPageCheck = true;

    public void setApplyList(List<SJctrLDEVDetail> LDEVList, boolean bLdevNameCheck, boolean bThresholdCheck, boolean bTierCheck, boolean bTierLevelCheck, boolean bNewPageCheck, boolean bRelPrio, boolean bFaAttri, boolean bALUAMode, boolean bDataSaving, int iApplyType) {
        this.LDEVList = LDEVList;
        this.bLdevNameCheck = bLdevNameCheck;
        this.bThresholdCheck = bThresholdCheck;
        this.bTierCheck = bTierCheck;
        this.bTierLevelCheck = bTierLevelCheck;
        this.bNewPageCheck = bNewPageCheck;
        this.bRelPrio = bRelPrio;
        this.bFaAttri = bFaAttri;
        this.bALUAMode = bALUAMode;
        this.bDataSaving = bDataSaving;
        this.iApplyType = iApplyType;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRmiInputInterface> addList = new ArrayList<SanRmiInputInterface>();
        switch (this.iApplyType) {
            case 1: {
                if (!this.bLdevNameCheck) break;
                addList.add(this.getResourceName());
                break;
            }
            case 2: {
                if (!this.bThresholdCheck) break;
                addList.add(this.getRelationData());
                break;
            }
            case 5: {
                if (!this.bFaAttri) break;
                addList.add(this.getFaAttriData());
                break;
            }
            case 3: {
                if (!this.bTierCheck) break;
                addList.add(this.getTierData());
                break;
            }
            case 4: {
                if (!this.bTierLevelCheck && !this.bNewPageCheck && !this.bRelPrio) break;
                addList.add(this.getTierLevelData());
                break;
            }
            case 7: {
                if (!this.bDataSaving) break;
                addList.add((SanRmiInputInterface)this.getDataSavingData());
                break;
            }
            case 6: {
                if (!this.bALUAMode) break;
                addList.add((SanRmiInputInterface)this.getALUAModeData());
            }
        }
        ArrayList<SanRmiInputInterface> applyList = new ArrayList<SanRmiInputInterface>(addList.size());
        applyList.addAll(addList);
        return applyList;
    }

    private RJiRESOURCEsetName_IN getResourceName() {
        Robj_interface_RJiResourceName[] resourceName = new RJiResourceName[this.LDEVList.size()];
        for (int i = 0; i < this.LDEVList.size(); ++i) {
            SJctrLDEVDetail ldevDetail = this.LDEVList.get(i);
            resourceName[i] = new RJiResourceName();
            ((RJiResourceName)resourceName[i]).setNumber(SJctrCVSUtility.getLdevNumber(ldevDetail));
            ((RJiResourceName)resourceName[i]).setType(1);
            ((RJiResourceName)resourceName[i]).setName(ldevDetail.getStrLdevName());
        }
        RJiRESOURCEsetName_IN rtn = new RJiRESOURCEsetName_IN();
        rtn.setResourceName(resourceName);
        return rtn;
    }

    private SetAOUVolRelation getRelationData() {
        Robj_interface_POOLgetAOUVolRelation[] AOUVolData = new POOLgetAOUVolRelation[this.LDEVList.size()];
        for (int i = 0; i < this.LDEVList.size(); ++i) {
            SJctrLDEVDetail Detail = this.LDEVList.get(i);
            AOUVolData[i] = new POOLgetAOUVolRelation();
            ((RJiLDKCIndex)((Object)AOUVolData[i])).setSLDKC(Detail.getSLdkc());
            ((RJiCUIndex)((Object)AOUVolData[i])).setSCU(Detail.getSCu());
            ((RJiLDEVIndex)((Object)AOUVolData[i])).setSLDEV(Detail.getSLdev());
            ((POOLgetAOUVolRelation)AOUVolData[i]).setSPoolId((short)Detail.getIRelationPoolID());
            ((POOLgetAOUVolRelation)AOUVolData[i]).setSThreshold(Detail.getSRelationThreshold());
            ((POOLgetAOUVolRelation)AOUVolData[i]).setLAouVolCapa(0L);
        }
        SetAOUVolRelation rtn = new SetAOUVolRelation();
        rtn.setObjAOUVolData(AOUVolData);
        rtn.setLComannd(3L);
        return rtn;
    }

    private POOLsetAllocationOption_IN getFaAttriData() {
        POOLsetAllocationOption_IN rtn = new POOLsetAllocationOption_IN();
        Robj_interface_POOLsetAllocationOptionData[] data = new POOLsetAllocationOptionData[this.LDEVList.size()];
        for (int i = 0; i < this.LDEVList.size(); ++i) {
            SJctrLDEVDetail Detail = this.LDEVList.get(i);
            data[i] = new POOLsetAllocationOptionData();
            ((POOLsetAllocationOptionData)data[i]).setSPoolId((short)Detail.getIRelationPoolID());
            ((POOLsetAllocationOptionData)data[i]).setSLDKC(Detail.getSLdkc());
            ((POOLsetAllocationOptionData)data[i]).setSCU(Detail.getSCu());
            ((POOLsetAllocationOptionData)data[i]).setSLDEV(Detail.getSLdev());
            if (Detail.getIFaAttri() == 1) {
                ((POOLsetAllocationOptionData)data[i]).setLFullAllocationFlag(0x10000000L);
                continue;
            }
            ((POOLsetAllocationOptionData)data[i]).setLFullAllocationFlag(0L);
        }
        rtn.setObjAOUVolData(data);
        return rtn;
    }

    private POOLsetPbTSMOptionAOUVol_IN getTierData() {
        POOLsetPbTSMOptionAOUVol_IN rtn = new POOLsetPbTSMOptionAOUVol_IN();
        Robj_interface_POOLsetPbTSMOptionAOUVolData[] data = new POOLsetPbTSMOptionAOUVolData[this.LDEVList.size()];
        for (int i = 0; i < this.LDEVList.size(); ++i) {
            SJctrLDEVDetail Detail = this.LDEVList.get(i);
            data[i] = new POOLsetPbTSMOptionAOUVolData();
            ((POOLsetPbTSMOptionAOUVolData)data[i]).setSPoolId((short)Detail.getIRelationPoolID());
            ((POOLsetPbTSMOptionAOUVolData)data[i]).setSLDKC(Detail.getSLdkc());
            ((POOLsetPbTSMOptionAOUVolData)data[i]).setSCU(Detail.getSCu());
            ((POOLsetPbTSMOptionAOUVolData)data[i]).setSLDEV(Detail.getSLdev());
            ((POOLsetPbTSMOptionAOUVolData)data[i]).setSUseTier((short)0);
            if (Detail.isBTier()) {
                ((POOLsetPbTSMOptionAOUVolData)data[i]).setSPbTSMControlFlag((short)0);
                continue;
            }
            ((POOLsetPbTSMOptionAOUVolData)data[i]).setSPbTSMControlFlag((short)128);
        }
        rtn.setObjAOUVolData(data);
        return rtn;
    }

    private POOLsetLaneAOUVol_IN getTierLevelData() {
        POOLsetLaneAOUVol_IN rtn = new POOLsetLaneAOUVol_IN();
        Robj_interface_POOLsetLaneAOUVolData[] data = new POOLsetLaneAOUVolData[this.LDEVList.size()];
        for (int i = 0; i < this.LDEVList.size(); ++i) {
            SJctrLDEVDetail Detail = this.LDEVList.get(i);
            data[i] = new POOLsetLaneAOUVolData();
            ((POOLsetLaneAOUVolData)data[i]).setSPoolId((short)Detail.getIRelationPoolID());
            ((RJiLDKCIndex)((Object)data[i])).setSLDKC(Detail.getSLdkc());
            ((RJiCUIndex)((Object)data[i])).setSCU(Detail.getSCu());
            ((RJiLDEVIndex)((Object)data[i])).setSLDEV(Detail.getSLdev());
            if (this.bTierLevelCheck) {
                ((POOLsetLaneAOUVolData)data[i]).setSTierLevel(Detail.getSTierLevel());
            }
            if (this.bNewPageCheck) {
                ((POOLsetLaneAOUVolData)data[i]).setSNewPageAssignmentTier(Detail.getSNewPageAssgin());
            }
            if (!this.bRelPrio) continue;
            ((POOLsetLaneAOUVolData)data[i]).setSRelocationPriority(Detail.getSRelPriority());
        }
        rtn.setObjAOUVolData(data);
        return rtn;
    }

    private SanRequest getDataSavingData() {
        SanRequest request = this.newRequest("VVOLupdateDataSavingOptions");
        try {
            SanList ldevs = request.newList("ThinProvisioningVolumes");
            for (SJctrLDEVDetail ldev : this.LDEVList) {
                SanObject ldevParameter = ldevs.addObj();
                int[] id = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
                ldevParameter.putIntArray("Id", id);
                ldevParameter.putInt("DataSaving", (int)ldev.getSDataSaving());
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        return request;
    }

    private SanRequest getALUAModeData() {
        SanRequest request = this.newRequest("LUNMupdateAluaMode");
        try {
            SanList ldevs = request.newList("Ldevs");
            for (SJctrLDEVDetail ldev : this.LDEVList) {
                SanObject ldevParameter = ldevs.addObj();
                int[] id = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
                ldevParameter.putIntArray("Id", id);
                ldevParameter.putBoolean("AluaMode", ldev.getBAluaMode());
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        return request;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        SJctrError error;
        long iError;
        int i;
        Object[] data;
        Object result;
        super.setApplyResult(resultObject);
        if (resultObject instanceof RJiRESOURCEsetName_OUT) {
            RJiRESOURCEsetName_OUT out = (RJiRESOURCEsetName_OUT)resultObject;
            result = (RJiSetResourceNameResult[])out.getResult();
            this.setErrData((RJiSetResourceNameResult[])result);
        }
        if (resultObject instanceof POOLsetPbTSMOptionAOUVol_OUT) {
            boolean bErrorFlg = false;
            this.resultData = new ArrayList<SJctrError>();
            result = (POOLsetPbTSMOptionAOUVol_OUT)resultObject;
            data = ((POOLsetPbTSMOptionAOUVol_OUT)result).getObjAOUVolData();
            for (i = 0; i < data.length; ++i) {
                iError = data[i].getLErrorCode();
                error = new SJctrError(30, 5, 0);
                error.setError((int)iError);
                if (iError != 0L && !bErrorFlg) {
                    this.setError(error);
                    bErrorFlg = true;
                }
                this.resultData.add(error);
            }
            if (!bErrorFlg) {
                this.resultData = new ArrayList<SJctrError>();
            }
        }
        if (resultObject instanceof POOLsetLaneAOUVol_OUT) {
            boolean bErrorFlg = false;
            this.resultData = new ArrayList<SJctrError>();
            result = (POOLsetLaneAOUVol_OUT)resultObject;
            data = (POOLsetLaneAOUVolData[])((POOLsetLaneAOUVol_OUT)result).getObjAOUVolData();
            for (i = 0; i < data.length; ++i) {
                iError = ((POOLsetLaneAOUVolData)data[i]).getLErrorCode();
                error = new SJctrError(30, 5, 0);
                error.setError((int)iError);
                if (iError != 0L && !bErrorFlg) {
                    this.setError(error);
                    bErrorFlg = true;
                }
                this.resultData.add(error);
            }
            if (!bErrorFlg) {
                this.resultData = new ArrayList<SJctrError>();
            }
        }
        if (resultObject instanceof POOLsetAllocationOption_OUT) {
            boolean bErrorFlg = false;
            this.resultData = new ArrayList<SJctrError>();
            result = (POOLsetAllocationOption_OUT)resultObject;
            data = (POOLsetAllocationOptionData[])((POOLsetAllocationOption_OUT)result).getObjAOUVolData();
            for (i = 0; i < data.length; ++i) {
                iError = ((POOLsetAllocationOptionData)data[i]).getLErrorCode();
                error = new SJctrError(30, 5, 0);
                error.setError((int)iError);
                if (iError != 0L && !bErrorFlg) {
                    this.setError(error);
                    bErrorFlg = true;
                }
                this.resultData.add(error);
            }
            if (!bErrorFlg) {
                this.resultData = new ArrayList<SJctrError>();
            }
        }
        if (resultObject instanceof SanResponse) {
            SanResponse response = (SanResponse)resultObject;
            if ("VVOLupdateDataSavingOptions".equals(response.id())) {
                this.setDataSavingResult(response);
            } else {
                this.setALUAModeResult((SanResponse)resultObject);
            }
        }
    }

    private void setErrData(RJiSetResourceNameResult[] result) {
        RJiSetResourceNameResult resourceResult;
        int[] iErrorLen;
        int iError = 0;
        for (int i = 0; i < result.length && (iError = (iErrorLen = (resourceResult = result[i]).getError())[1]) == 0; ++i) {
        }
        this.resultData = new ArrayList<SJctrError>();
        if (iError != 0) {
            boolean bErrFlg = false;
            for (int i = 0; i < result.length; ++i) {
                SJctrError resultError = new SJctrError(30, 5, 0);
                RJiSetResourceNameResult resourceResult2 = result[i];
                int[] iErrorLen2 = resourceResult2.getError();
                resultError.setError(iErrorLen2[1]);
                this.resultData.add(resultError);
                if (iErrorLen2[1] == 0 || bErrFlg) continue;
                this.setError(resultError);
                bErrFlg = true;
            }
            if (!bErrFlg) {
                this.resultData = new ArrayList<SJctrError>();
            }
        }
    }

    @Override
    public int getLeadTime() {
        int rtn = 0;
        switch (this.iApplyType) {
            case 1: {
                rtn = this.LDEVList.size() / 2048;
                if (this.LDEVList.size() % 2048 > 0) {
                    ++rtn;
                }
                rtn *= 3;
                break;
            }
            case 2: {
                SetAOUVolRelation wkRel = this.getRelationData();
                rtn = 45 + wkRel.getObjAOUVolData().length / 5;
                break;
            }
            case 5: {
                rtn = 45 + this.LDEVList.size() / 5;
                break;
            }
            case 3: {
                rtn = 45 + this.LDEVList.size() / 5;
                break;
            }
            case 4: {
                rtn = 45 + this.LDEVList.size() / 5;
                rtn += this.LDEVList.size() / 1024;
                break;
            }
            case 6: 
            case 7: {
                int comTime = this.LDEVList.size() / 450;
                if (this.LDEVList.size() % 450 > 0) {
                    ++comTime;
                }
                comTime *= 3;
                int setTime = this.LDEVList.size() / 2000;
                if (this.LDEVList.size() % 2000 > 0) {
                    ++setTime;
                }
                rtn = comTime + setTime;
            }
        }
        return rtn;
    }

    public ArrayList getApplyList(List<SJctrLDEVDetail> LDEVList, boolean bLdevNameCheck, boolean bThresholdCheck, boolean bTierCheck, boolean bTierLevelCheck, boolean bNewPageCheck, boolean bRelPrio, boolean bFaAttri, boolean bALUAMode, boolean bDataSaving) {
        SJctrEditLDEVsAC ac;
        ArrayList<SJctrEditLDEVsAC> rtn = new ArrayList<SJctrEditLDEVsAC>();
        if (bLdevNameCheck) {
            ac = new SJctrEditLDEVsAC();
            ac.setApplyList(LDEVList, bLdevNameCheck, bThresholdCheck, bTierCheck, bTierLevelCheck, bNewPageCheck, bRelPrio, bFaAttri, bALUAMode, bDataSaving, 1);
            rtn.add(ac);
        }
        if (bThresholdCheck) {
            ac = new SJctrEditLDEVsAC();
            ac.setApplyList(LDEVList, bLdevNameCheck, bThresholdCheck, bTierCheck, bTierLevelCheck, bNewPageCheck, bRelPrio, bFaAttri, bALUAMode, bDataSaving, 2);
            rtn.add(ac);
        }
        if (bFaAttri) {
            ac = new SJctrEditLDEVsAC();
            ac.setApplyList(LDEVList, bLdevNameCheck, bThresholdCheck, bTierCheck, bTierLevelCheck, bNewPageCheck, bRelPrio, bFaAttri, bALUAMode, bDataSaving, 5);
            rtn.add(ac);
        }
        if (bTierCheck) {
            ac = new SJctrEditLDEVsAC();
            ac.setApplyList(LDEVList, bLdevNameCheck, bThresholdCheck, bTierCheck, bTierLevelCheck, bNewPageCheck, bRelPrio, bFaAttri, bALUAMode, bDataSaving, 3);
            rtn.add(ac);
        }
        if (bTierLevelCheck || bNewPageCheck || bRelPrio) {
            ac = new SJctrEditLDEVsAC();
            ac.setApplyList(LDEVList, bLdevNameCheck, bThresholdCheck, bTierCheck, bTierLevelCheck, bNewPageCheck, bRelPrio, bFaAttri, bALUAMode, bDataSaving, 4);
            rtn.add(ac);
        }
        if (bDataSaving) {
            ac = new SJctrEditLDEVsAC();
            ac.setApplyList(LDEVList, bLdevNameCheck, bThresholdCheck, bTierCheck, bTierLevelCheck, bNewPageCheck, bRelPrio, bFaAttri, bALUAMode, bDataSaving, 7);
            rtn.add(ac);
        }
        if (bALUAMode) {
            ac = new SJctrEditLDEVsAC();
            ac.setApplyList(LDEVList, bLdevNameCheck, bThresholdCheck, bTierCheck, bTierLevelCheck, bNewPageCheck, bRelPrio, bFaAttri, bALUAMode, bDataSaving, 6);
            rtn.add(ac);
        }
        return rtn;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        switch (this.iApplyType) {
            case 1: {
                rtn = true;
                break;
            }
            case 2: {
                rtn = false;
                break;
            }
            case 3: {
                rtn = true;
                break;
            }
            case 4: {
                rtn = true;
                break;
            }
            case 5: {
                rtn = true;
                break;
            }
            case 7: {
                rtn = this.getResultData() != null && !this.getResultData().isEmpty();
                break;
            }
            case 6: {
                rtn = true;
            }
        }
        return rtn;
    }

    protected void setALUAModeResult(SanResponse kvResponse) {
        this.resultData = new ArrayList<SJctrError>();
        try {
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvResponse);
            if (!errorInfo.hasLowerNodeError()) {
                if (errorInfo.isOverAll()) {
                    SJctrError error = errorInfo.createError();
                    this.setError(error);
                    return;
                }
                return;
            }
            SJctrError error = errorInfo.createError();
            this.setError(error);
            SanList kvResultLdevs = kvResponse.getList("Ldevs");
            this.resultData = SJctrCVSUtility.createStatusList(error.getFunc(), error.getModule(), this.LDEVList, kvResultLdevs);
        }
        catch (SanDataException ex) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
    }

    protected void setDataSavingResult(SanResponse kvResponse) {
        this.resultData = new ArrayList<SJctrError>();
        try {
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvResponse);
            if (!errorInfo.hasLowerNodeError()) {
                if (errorInfo.isOverAll()) {
                    SJctrError error = errorInfo.createError();
                    this.setError(error);
                    return;
                }
                return;
            }
            SJctrError error = errorInfo.createError();
            this.setError(error);
            SanList kvResultLdevs = kvResponse.getList("ThinProvisioningVolumes");
            this.resultData = SJctrCVSUtility.createStatusList(error.getFunc(), error.getModule(), this.LDEVList, kvResultLdevs);
        }
        catch (SanDataException ex) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
    }
}

