/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.verifyldevs;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.topwindow.ldev.SJctrLdevSummaryModel;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSKeyValueAC;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.verifyldevs.SJctrVerifyLDEVsProgressInfo;

public class SJctrVerifyLDEVsAC
extends SJctrCVSKeyValueAC
implements SJctrCVSMacro {
    private static final long serialVersionUID = -4699927153468731845L;
    List<SJctrLDEVDetail> LDEVInfo = new ArrayList<SJctrLDEVDetail>();
    boolean autoCorrectMode;
    int MONITOR_BACKGROUND_SLEEP_TIME = 5000;
    int VERIFY_PROGRESS_COMPLETE = 100;
    int errorStopCount;

    public SJctrVerifyLDEVsAC() {
        this.async = true;
    }

    public void setApplyList(List<SJctrLDEVDetail> LDEVList, boolean autoCorrectMode, int errorStopCount) {
        this.LDEVInfo = LDEVList;
        this.autoCorrectMode = autoCorrectMode;
        this.errorStopCount = errorStopCount;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>();
        try {
            SanRequest requestData = this.newRequest("MNTstartVerify");
            requestData.putBoolean("AutoCorrectMode", this.autoCorrectMode);
            requestData.putInt("ErrorStopCount", this.errorStopCount);
            SanList ldevlist = requestData.newList("Ldevs");
            for (int i = 0; i < this.LDEVInfo.size(); ++i) {
                SJctrLDEVDetail ldevDetail = this.LDEVInfo.get(i);
                int[] ldevIndex = new int[]{ldevDetail.getSLdkc(), ldevDetail.getSCu(), ldevDetail.getSLdev()};
                SanObject ldev = ldevlist.addObj();
                ldev.putIntArray("Id", ldevIndex);
            }
            applyList.add(requestData);
        }
        catch (SanDataException e) {
            this.setError(SJctrError.parseError((Exception)((Object)e)));
            SJctrLogUty.error(this.title, "getSetList", "SanDataException thrown", e);
        }
        return applyList;
    }

    @Override
    public SJctrError monitorBackground() {
        SJctrError rtn = new SJctrError(201, 22, 0);
        boolean loop = true;
        block7: while (loop) {
            try {
                Thread.sleep(this.MONITOR_BACKGROUND_SLEEP_TIME);
            }
            catch (Exception ex) {
                loop = false;
            }
            if (!this.isPauseMonitor()) {
                SJctrVerifyLDEVsProgressInfo verifyProgress = SJctrLdevSummaryModel.getVerifyProgress();
                SJctrLogUty.info(SJctrVerifyLDEVsAC.class.getSimpleName(), "monitorBackground", "errorCode = " + verifyProgress.getErrorCode() + ", funcId = " + verifyProgress.getFuncId() + ", moduleId = " + verifyProgress.getModuleId() + ", messageId = " + verifyProgress.getMessageId() + ", status = " + verifyProgress.getStatus() + ", currentPgProgress = " + verifyProgress.getCurrentPgProgress() + ", totalPgCount = " + verifyProgress.getTotalPgCount() + ", currentPgNo = " + verifyProgress.getCurrentPgNo() + ", totalProgress = " + verifyProgress.getTotalProgress());
                if (verifyProgress.getErrorCode() != 0) {
                    if (SJctrComUtility.checkSVPMessage(verifyProgress.getFuncId(), verifyProgress.getModuleId(), verifyProgress.getMessageId())) continue;
                    rtn = new SJctrError(verifyProgress.getFuncId(), verifyProgress.getModuleId(), verifyProgress.getMessageId());
                    loop = false;
                    break;
                }
                switch (verifyProgress.getStatus()) {
                    case 0: {
                        this.setProgress(verifyProgress.getTotalProgress());
                        continue block7;
                    }
                    case 2: {
                        this.setProgress(this.VERIFY_PROGRESS_COMPLETE);
                        loop = false;
                        continue block7;
                    }
                    case 4: {
                        rtn = new SJctrError(30, 22, 208002);
                        loop = false;
                        continue block7;
                    }
                }
                SJctrLogUty.info(SJctrVerifyLDEVsAC.class.getSimpleName(), "monitorBackground", "Verification task status = " + verifyProgress.getStatus());
                rtn = new SJctrError(30, 22, 208001);
                loop = false;
                continue;
            }
            rtn = new SJctrError(201, 22, -1);
            loop = false;
        }
        return rtn;
    }

    @Override
    public int getLeadTime() {
        return SJctrComCVSUtility.getFormatLeadTime(this.LDEVInfo);
    }
}

