/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.syslog.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlMultiStratumFormElemCon;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrGuidanceOfLangType;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.settings.tab.syslog.model.SJctrEditAlertSyslogSettingData;

public class SJctrEditAlertSyslogAuditLog
implements Serializable,
SJctrGuidIdDefinition,
SJctrEditAlertDef {
    private static final long serialVersionUID = 1L;
    static final String FUNCTION_NAME = "ADT_FC_BASE";
    public static String[][] KeyTable_BasicInfo = new String[][]{{"COMMON", "ADT_EDIT_SIM_SYSLOG"}, {"COMMON", "ADT_NUM_OF_SERVERS"}};
    public static String[][] KeyTable_DtlInfo_Common = new String[][]{{"COMMON", "TRANSFER_PROTOCOL"}, {"COMMON", "LOCATION_IDNTF_NAME"}, {"COMMON", "TIMEOUT"}, {"COMMON", "RETRY_INTERVAL"}, {"COMMON", "RETRY_TIMES"}, {"COMMON", "PRIMARY_SERVER"}, {"COMMON", "SECONDARY_SERVER"}};
    public static String[][] KeyTable_DtlInfo_Server = new String[][]{{"COMMON", "ADT_SERVER_TYPE"}, {"COMMON", "ADT_SIM_TRANSFER"}, {"COMMON", "ADT_IP_VERSION"}, {"COMMON", "IP_ADDRESS"}, {"COMMON", "PORT_NUMBER"}, {"COMMON", "CLIENT_CRT_FILE_NAME"}, {"COMMON", "ROOT_CRT_FILE_NAME"}};
    public static String[][] AdtGuideKeyTable = new String[][]{{"COMMON", "ENABLE"}, {"COMMON", "DISABLE"}, {"COMMON", "ADT_UDP"}, {"COMMON", "ADT_TLS_1_2"}, {"COMMON", "PRIMARY"}, {"COMMON", "SECONDARY"}, {"COMMON", "IPV4"}, {"COMMON", "IPV6"}};
    private static final int INDEX_DISPID = 0;
    private static final int INDEX_PARTSID = 1;
    private Map<String, String> TitleEnGuideMap = null;
    private Map<String, String> DataEnGuideMap = null;
    HashMap<String, String> addition = null;
    private List<String> commonInfo = new ArrayList<String>();
    private String headServer = "";
    private String detailServer = "";
    private String footer = "";
    private static final int NUM_OF_SERVERS = 2;

    public SJctrEditAlertSyslogAuditLog() {
        SJctrGuidanceOfLangType guidance = new SJctrGuidanceOfLangType("EN");
        this.TitleEnGuideMap = new HashMap<String, String>();
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_BasicInfo));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_Common));
        this.TitleEnGuideMap.putAll(guidance.getGuidance(KeyTable_DtlInfo_Server));
        this.DataEnGuideMap = new HashMap<String, String>();
        this.DataEnGuideMap = guidance.getGuidance(AdtGuideKeyTable);
        this.addition = new HashMap();
    }

    public void setAdditionData(SJbaseUserSession userSession) {
        this.addition.put("SN2_AUDITLOG_ADD_LOGTYPE", "USER");
        this.addition.put("SN2_AUDITLOG_ADD_USER", userSession.getUserName());
        this.addition.put("SN2_AUDITLOG_ADD_HOST", SJcSessionUty.getIPAddress(userSession));
        this.addition.put("SN2_AUDITLOG_ADD_LOGID", Integer.toString(userSession.getSessionIdentificationID()));
        String strExtIFID = null;
        strExtIFID = userSession.getLoginType().equals("SVP") ? Integer.toString(5) : Integer.toString(4);
        this.addition.put("SN2_AUDITLOG_ADD_EXTIF", strExtIFID);
    }

    public SJcAuditLogCtrlMultiStratumFormElemCon createElemCon() {
        SJcAuditLogCtrlMultiStratumFormElemCon elemCon = new SJcAuditLogCtrlMultiStratumFormElemCon();
        elemCon.setFunctionName(FUNCTION_NAME);
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_EDIT_SIM_SYSLOG");
        String opeName = this.TitleEnGuideMap.get(key);
        elemCon.setOperationName(opeName);
        elemCon.setOperationParameter("");
        elemCon.setAdditionalInfo(this.addition);
        for (String log : this.commonInfo) {
            elemCon.setLog(log);
            elemCon.addStratum();
        }
        elemCon.setLog(this.headServer);
        elemCon.setLog(this.detailServer);
        elemCon.setLog(this.footer);
        return elemCon;
    }

    public void setPrintData(SJctrEditAlertSyslogSettingData syslogData) {
        this.setCommonInfo(syslogData);
        this.setServerHeader();
        this.setServerInfo(syslogData);
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_NUM_OF_SERVERS");
        this.footer = "," + this.TitleEnGuideMap.get(key) + "=" + 2;
    }

    private void setServerInfo(SJctrEditAlertSyslogSettingData syslogData) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(this.getPrimaryServerLog(syslogData));
        buf.append(",");
        buf.append(this.getSecondaryServerLog(syslogData));
        buf.append("]");
        this.detailServer = buf.toString();
    }

    private String getPrimaryServerLog(SJctrEditAlertSyslogSettingData syslogData) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "PRIMARY");
        String serverType = this.DataEnGuideMap.get(key);
        buf.append(serverType);
        buf.append(",");
        if (syslogData.isEnablePrimary()) {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            buf.append(this.DataEnGuideMap.get(key));
            buf.append(",");
            key = syslogData.getIpVersionPrimary() == 0 ? SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "IPV4") : SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "IPV6");
            buf.append(this.DataEnGuideMap.get(key));
            buf.append(",");
            buf.append(syslogData.getIpTextPrimary());
            buf.append(",");
            buf.append(syslogData.getPortNumPrimary());
            buf.append(",");
            if (syslogData.isUploadedClientPrimary()) {
                buf.append(syslogData.getClientFilePrimary());
            }
            buf.append(",");
            if (syslogData.isUploadedRootPrimary()) {
                buf.append(syslogData.getRootFilePrimary());
            }
        } else {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            buf.append(this.DataEnGuideMap.get(key));
            buf.append(",");
            buf.append(",");
            buf.append(",");
            buf.append(",");
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }

    private String getSecondaryServerLog(SJctrEditAlertSyslogSettingData syslogData) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "SECONDARY");
        String serverType = this.DataEnGuideMap.get(key);
        buf.append(serverType);
        buf.append(",");
        if (syslogData.isEnableSecondary()) {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ENABLE");
            buf.append(this.DataEnGuideMap.get(key));
            buf.append(",");
            key = syslogData.getIpVersionSecondary() == 0 ? SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "IPV4") : SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "IPV6");
            buf.append(this.DataEnGuideMap.get(key));
            buf.append(",");
            buf.append(syslogData.getIpTextSecondary());
            buf.append(",");
            buf.append(syslogData.getPortNumSecondary());
            buf.append(",");
            if (syslogData.isUploadedClientSecondary()) {
                buf.append(syslogData.getClientFileSecondary());
            }
            buf.append(",");
            if (syslogData.isUploadedRootSecondary()) {
                buf.append(syslogData.getRootFileSecondary());
            }
        } else {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "DISABLE");
            buf.append(this.DataEnGuideMap.get(key));
            buf.append(",");
            buf.append(",");
            buf.append(",");
            buf.append(",");
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }

    private void setServerHeader() {
        StringBuffer bufHeader = new StringBuffer();
        for (int index = 0; index <= KeyTable_DtlInfo_Server.length; ++index) {
            String key = SJctrGuidanceOfLangType.makeGuidanceKey(KeyTable_DtlInfo_Server[index][0], KeyTable_DtlInfo_Server[index][1]);
            bufHeader.append(this.TitleEnGuideMap.get(key));
            if (index == KeyTable_DtlInfo_Server.length - 1) break;
            bufHeader.append(",");
        }
        this.headServer = "{" + bufHeader.toString() + "}" + "=" + "\n";
    }

    private void setCommonInfo(SJctrEditAlertSyslogSettingData syslogData) {
        StringBuffer buf = new StringBuffer();
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "TRANSFER_PROTOCOL");
        buf.append(this.TitleEnGuideMap.get(key));
        buf.append("=");
        if (syslogData.isSelectedTLS()) {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_TLS_1_2");
            buf.append(this.DataEnGuideMap.get(key));
        } else {
            key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "ADT_UDP");
            buf.append(this.DataEnGuideMap.get(key));
        }
        this.commonInfo.add(buf.toString());
        buf = new StringBuffer();
        key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "LOCATION_IDNTF_NAME");
        buf.append(this.TitleEnGuideMap.get(key));
        buf.append("=");
        buf.append(syslogData.getLocation());
        this.commonInfo.add(buf.toString());
        if (syslogData.isSelectedTLS()) {
            this.setTLSCommonInfo(syslogData);
        }
    }

    private void setTLSCommonInfo(SJctrEditAlertSyslogSettingData syslogData) {
        StringBuffer buf = new StringBuffer();
        String key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "TIMEOUT");
        buf.append(this.TitleEnGuideMap.get(key));
        buf.append("=");
        buf.append(syslogData.getTimeout());
        this.commonInfo.add(buf.toString());
        buf = new StringBuffer();
        key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "RETRY_INTERVAL");
        buf.append(this.TitleEnGuideMap.get(key));
        buf.append("=");
        buf.append(syslogData.getInterval());
        this.commonInfo.add(buf.toString());
        buf = new StringBuffer();
        key = SJctrGuidanceOfLangType.makeGuidanceKey("COMMON", "RETRY_TIMES");
        buf.append(this.TitleEnGuideMap.get(key));
        buf.append("=");
        buf.append(syslogData.getNumOfRetries());
        this.commonInfo.add(buf.toString());
    }
}

