/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model;

import sanproject.serverux.data.AuditConfigData;
import sanproject.serverux.data.SetSysLog;
import sanproject.serverux.data.SysLogServ;
import sanproject.serverux.data.SysLogServSet;
import sanproject.sn2.controller.wizard.editauditlog.com.SJctrEditAuditLogDef;
import sanproject.sn2.controller.wizard.editauditlog.com.SJctrEditAuditLogUtility;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogSettingData;

public class SJctrEditAuditSyslogSettingData
extends SJctrSyslogSettingData
implements SJctrEditAuditLogDef,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final int[] EMPTY_ARRAY = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int output = 0;
    private SJctrEditAuditSyslogSettingData cloneData;
    private static final int INITIAL_DATA = 0;
    private SetSysLog applyData = null;

    public SJctrEditAuditSyslogSettingData(AuditConfigData configData) {
        this.transportType = configData.sTransportType;
        this.location = configData.S_Location;
        this.timeout = configData.sTimeout;
        this.interval = configData.sRetryInterval;
        this.numOfRetries = configData.sRetry;
        this.output = configData.B_Detail ? 1 : 0;
        SysLogServ srv = configData.syslogserv[0];
        this.enabledPrimary = srv.B_On ? 1 : 0;
        this.ipVersionPrimary = srv.B_IPv6 ? 1 : 0;
        this.ipTextPrimary = srv.strIPAddrStr;
        this.portNumPrimary = srv.I_Port;
        srv = configData.syslogserv[1];
        this.enabledSecondary = srv.B_On ? 1 : 0;
        this.ipVersionSecondary = srv.B_IPv6 ? 1 : 0;
        this.ipTextSecondary = srv.strIPAddrStr;
        this.portNumSecondary = srv.I_Port;
        this.cloneData = (SJctrEditAuditSyslogSettingData)this.clone();
        if (this.transportType == 0) {
            this.enabledPrimary = 0;
            this.ipVersionPrimary = 0;
            this.ipTextPrimary = "192.168.0.1";
            this.portNumPrimary = 514;
            this.enabledSecondary = 0;
            this.ipVersionSecondary = 0;
            this.ipTextSecondary = "192.168.0.2";
            this.portNumSecondary = 514;
        }
        if (this.timeout == 0) {
            this.timeout = 10;
        }
        if (this.interval == 0) {
            this.interval = 1;
        }
        if (this.numOfRetries == 0) {
            this.numOfRetries = 3;
        }
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public SetSysLog getApplyData() {
        SetSysLog syslog = this.getApplyDataCommon();
        syslog.syslogservset = new SysLogServSet[2];
        syslog.syslogservset[0] = this.getApplyDataPrimary();
        syslog.syslogservset[1] = this.getApplyDataSecondary();
        this.applyData = syslog;
        return this.applyData;
    }

    public SetSysLog getAppliedData() {
        if (this.applyData == null) {
            this.applyData = this.getApplyData();
        }
        return this.applyData;
    }

    private SetSysLog getApplyDataCommon() {
        SetSysLog syslog = new SetSysLog();
        if (this.transportType == this.cloneData.transportType) {
            syslog.B_TransportType_change = false;
        } else {
            syslog.B_TransportType_change = true;
            syslog.sTransportType = (short)this.transportType;
        }
        if (this.output == this.cloneData.output) {
            syslog.B_Detail_change = false;
        } else {
            syslog.B_Detail_change = true;
            syslog.B_Detail = this.isEnableOutput();
        }
        if (this.location.equals(this.cloneData.location)) {
            syslog.B_Location_change = false;
            syslog.S_Location = "";
        } else {
            syslog.B_Location_change = true;
            syslog.S_Location = this.location;
        }
        if (!this.isSelectedTLS()) {
            syslog.B_Timeout_change = false;
            syslog.B_RetryInterval_change = false;
            syslog.B_Retry_change = false;
            return syslog;
        }
        if (this.timeout == this.cloneData.timeout) {
            syslog.B_Timeout_change = false;
        } else {
            syslog.B_Timeout_change = true;
            syslog.sTimeout = (short)this.timeout;
        }
        if (this.interval == this.cloneData.interval) {
            syslog.B_RetryInterval_change = false;
        } else {
            syslog.B_RetryInterval_change = true;
            syslog.sRetryInterval = (short)this.interval;
        }
        if (this.numOfRetries == this.cloneData.numOfRetries) {
            syslog.B_Retry_change = false;
        } else {
            syslog.B_Retry_change = true;
            syslog.sRetry = (short)this.numOfRetries;
        }
        return syslog;
    }

    private SysLogServSet getApplyDataPrimary() {
        SysLogServSet primary = new SysLogServSet();
        if (this.enabledPrimary == this.cloneData.enabledPrimary) {
            primary.B_On_change = false;
        } else {
            primary.B_On_change = true;
            primary.B_On = this.isEnablePrimary();
        }
        boolean bl = primary.B_sUpdateCertificate_change = this.isUploadedClientPrimary || this.isUploadedRootPrimary;
        if (!this.isEnablePrimary()) {
            primary.B_IPv6_change = false;
            primary.B_IP_Add_change = false;
            primary.B_strIPAddrStr_change = false;
            primary.strIPAddrStr = "";
            primary.I_IP_Add = EMPTY_ARRAY;
            primary.B_Port_change = false;
            return primary;
        }
        if (this.ipVersionPrimary == this.cloneData.ipVersionPrimary) {
            primary.B_IPv6_change = false;
        } else {
            primary.B_IPv6_change = true;
            boolean bl2 = primary.B_IPv6 = this.getIpVersionPrimary() == 1;
        }
        if (this.ipTextPrimary.equals(this.cloneData.ipTextPrimary)) {
            primary.B_IP_Add_change = false;
            primary.B_strIPAddrStr_change = false;
            primary.strIPAddrStr = "";
            primary.I_IP_Add = EMPTY_ARRAY;
        } else {
            primary.B_IP_Add_change = true;
            primary.B_strIPAddrStr_change = true;
            primary.strIPAddrStr = this.ipTextPrimary;
            primary.I_IP_Add = SJctrEditAuditLogUtility.getArrayAddr(this.ipTextPrimary, this.getIpVersionPrimary() == 1);
        }
        if (this.portNumPrimary == this.cloneData.portNumPrimary) {
            primary.B_Port_change = false;
        } else {
            primary.B_Port_change = true;
            primary.I_Port = this.portNumPrimary;
        }
        primary.B_Reserve_change = false;
        return primary;
    }

    private SysLogServSet getApplyDataSecondary() {
        SysLogServSet secondary = new SysLogServSet();
        if (this.enabledSecondary == this.cloneData.enabledSecondary) {
            secondary.B_On_change = false;
        } else {
            secondary.B_On_change = true;
            secondary.B_On = this.isEnableSecondary();
        }
        boolean bl = secondary.B_sUpdateCertificate_change = this.isUploadedClientSecondary || this.isUploadedRootSecondary;
        if (!this.isEnableSecondary()) {
            secondary.B_IPv6_change = false;
            secondary.B_IP_Add_change = false;
            secondary.B_strIPAddrStr_change = false;
            secondary.strIPAddrStr = "";
            secondary.I_IP_Add = EMPTY_ARRAY;
            secondary.B_Port_change = false;
            return secondary;
        }
        if (this.ipVersionSecondary == this.cloneData.ipVersionSecondary) {
            secondary.B_IPv6_change = false;
        } else {
            secondary.B_IPv6_change = true;
            boolean bl2 = secondary.B_IPv6 = this.getIpVersionSecondary() == 1;
        }
        if (this.ipTextSecondary.equals(this.cloneData.ipTextSecondary)) {
            secondary.B_IP_Add_change = false;
            secondary.B_strIPAddrStr_change = false;
            secondary.strIPAddrStr = "";
            secondary.I_IP_Add = EMPTY_ARRAY;
        } else {
            secondary.B_IP_Add_change = true;
            secondary.B_strIPAddrStr_change = true;
            secondary.strIPAddrStr = this.ipTextSecondary;
            secondary.I_IP_Add = SJctrEditAuditLogUtility.getArrayAddr(this.ipTextSecondary, this.getIpVersionSecondary() == 1);
        }
        if (this.portNumSecondary == this.cloneData.portNumSecondary) {
            secondary.B_Port_change = false;
        } else {
            secondary.B_Port_change = true;
            secondary.I_Port = this.portNumSecondary;
        }
        secondary.B_Reserve_change = false;
        return secondary;
    }

    public boolean isEnableOutput() {
        return this.output == 1;
    }

    public void setEnabledOutput(boolean enabled) {
        this.output = enabled ? 1 : 0;
    }
}

