/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import sanproject.serverux.data.AuditLogFileData;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrFileDownloadInterface;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model.SJctrGetSysLogFile;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.syslog.model.SJctrGetSysLogFileNew;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogSettingDef;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrSyslogFileDownloadIF
implements SJctrFileDownloadInterface,
SJctrSyslogSettingDef {
    private SJctrDataController controller;
    private int protocol;
    private String defaultFileNameFormat = "syslog{0}.tgz";
    private String defaultFileName = "";
    private static final String DIRECTORY = "controller\\auditsvptmp";

    public SJctrSyslogFileDownloadIF(SJctrDataController controller, int protocol) {
        this.controller = controller;
        this.protocol = protocol;
    }

    @Override
    public ArrayList<String> fileDownload() {
        SJcLogUty.getLogger().info("SJctrFileDownloadInterface", "SJctrSyslogFileDownload", "fileDownload()", "Download start.");
        List<?> datalist = null;
        datalist = 2 == this.protocol ? this.controller.getModelData(SJctrGetSysLogFileNew.class) : this.controller.getModelData(SJctrGetSysLogFile.class);
        if (datalist == null) {
            if (2 == this.protocol) {
                this.controller.getLogUty().putlog("getModelData", "SJctrGetSysLogFileNew is null");
            } else {
                this.controller.getLogUty().putlog("getModelData", "SJctrGetSysLogFile is null");
            }
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)datalist.get(0);
        AuditLogFileData auditLog = (AuditLogFileData)rmiData.getObjRmi();
        String randomFileName = this.saveDownloadFile(auditLog);
        ArrayList<String> result = new ArrayList<String>();
        result.add(randomFileName);
        SJcLogUty.getLogger().info("SJctrFileDownloadInterface", "SJctrSyslogFileDownload", "fileDownload()", "Download end.");
        return result;
    }

    private String saveDownloadFile(AuditLogFileData AuditLog) {
        String fileName = UUID.randomUUID().toString();
        SJcFileUty.saveBinary(DIRECTORY, fileName, AuditLog.byBinData, 0);
        String randomFileName = SJcFileUty.saveDownloadFile(DIRECTORY, fileName);
        SJcFileUty.deleteFile(DIRECTORY, fileName);
        return randomFileName;
    }

    @Override
    public ArrayList<String> getDefaultFileNameList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getDefaultFileName());
        return list;
    }

    private String getDefaultFileName() {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd");
        String yyyyMMdd = sdf1.format(new Date());
        MessageFormat formName = null;
        formName = new MessageFormat(this.defaultFileNameFormat);
        String[] ymdarg = new String[]{yyyyMMdd};
        this.defaultFileName = formName.format(ymdarg);
        return this.defaultFileName;
    }
}

