/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.deletekeys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.topwindow.encryption.SJctrEncDetail;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncKeysBaseDC;
import sanproject.sn2.controller.wizard.encryption.deletekeys.SJctrDelEncDetail;
import sanproject.sn2.controller.wizard.encryption.deletekeys.SJctrDeleteKeysSubWizard;
import sanproject.sn2.controller.wizard.encryption.deletekeys.SJctrDeleteKeysTableModel;
import sanproject.sn2.model.connector.kind.SJmoGetEncryptionKeyInfoMgr;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyInfo;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyInfoDEK;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;

public class SJctrDeleteKeysDC
extends SJctrEncKeysBaseDC {
    private List<SJmoEncryptionKeyInfoMgr> m_keyInfo;

    public SJctrDeleteKeysDC() throws SJcException {
        super(17830785);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("DELKEY");
    }

    private void initDataModel() {
        SJctrDeleteKeysTableModel tableModel = new SJctrDeleteKeysTableModel();
        this.addDataObjectModel("COM_TABLE", tableModel);
        SJctrFooterDataModel footerModel = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footerModel);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(SJctrEncryptionKeysUtility.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR));
        return set;
    }

    @Override
    public boolean checkStartData() {
        List<?> encryptionKeys = this.getCache("KEYID");
        if (encryptionKeys == null) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
            SJctrLogUty.error(this.getClass().getSimpleName(), "checkStartData", "Not found cache Info : EncryptionKeys");
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        List<SJmoEncryptionKeyInfoMgr> mgrList = this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR);
        this.m_keyInfo = mgrList;
        SJmoEncryptionKeyInfoMgr mgr = this.m_keyInfo.get(0);
        SJmoEncryptionKeyGenerationInfo policyInfo = mgr.getGenerationInfo();
        int policy = policyInfo.getIEncKeyGenerationInfo();
        if (policy <= -1) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
            return false;
        }
        if (policy == 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(105493);
            return false;
        }
        SJctrEncryptionKeysUtility.chkKekKey(mgrList);
        List<?> targetKeyList = this.getCache("KEYID");
        ArrayList infoDEKList = mgr.getAlEncryptionKeyInfoDEK();
        ArrayList<SJctrDelEncDetail> encList = new ArrayList<SJctrDelEncDetail>();
        for (int i = 0; i < targetKeyList.size(); ++i) {
            boolean flg = false;
            SJctrEncDetail targetkey = (SJctrEncDetail)targetKeyList.get(i);
            if (targetkey.getIEncryptKey() == -1) {
                SJctrEncryptionKeysUtility.createErrorDialog(105494);
                return false;
            }
            for (int k = 0; k < infoDEKList.size(); ++k) {
                SJmoEncryptionKeyInfoDEK dekKey = (SJmoEncryptionKeyInfoDEK)infoDEKList.get(k);
                if (dekKey.getIEncryptKey() != targetkey.getIEncryptKey()) continue;
                if (targetkey.getIKeyKind() == 0) {
                    flg = true;
                    break;
                }
                SJctrEncryptionKeysUtility.createErrorDialog(105494);
                return false;
            }
            if (!flg) {
                SJctrEncryptionKeysUtility.createErrorDialog(105196);
                return false;
            }
            SJctrDelEncDetail delEnc = new SJctrDelEncDetail();
            delEnc.setIEncryptKey(targetkey.getIEncryptKey());
            encList.add(delEnc);
        }
        Collections.sort(encList);
        this.putCache("KEY_DELETE_KEYS", encList);
        return true;
    }

    @Override
    protected void checkEncryptionKey(SJmoEncryptionKeyInfo checkTarget, List<?> allEncryptions, List<SJmoEncryptionKeyInfo> retTargetList, List<SJctrErrorColumnData> errorList) {
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
    }

    @Override
    public boolean preNextEvent(SJctrMessageEvent msgEvent, SJctrDataObjectModel<?> dstModel) {
        this.selectFinish(false);
        SJctrRelatedDispDataObject related = null;
        if (!this.existsOtherValidKeys()) {
            related = this.getMessageDataObject(105471);
        } else {
            if (SJctrEncryptionKeysUtility.kmsServerIsEnabled()) {
                return true;
            }
            related = this.createServerDisabledMsgDialog(msgEvent, dstModel);
        }
        this.addUpdateDisp(related);
        return false;
    }

    private boolean existsOtherValidKeys() {
        return true;
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent msgEvent, SJctrDataObjectModel<?> dstModel) {
        this.selectFinish(true);
        return false;
    }

    @Override
    public void selectNextTask(SJctrActionDefine actDefine) {
        if (actDefine == SJctrActionDefine.ACT_BACKUPSERVER) {
            SJmoEncryptionKeyInfoMgr cloneMgr = new SJmoEncryptionKeyInfoMgr();
            try {
                cloneMgr = (SJmoEncryptionKeyInfoMgr)this.m_keyInfo.get(0).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            ArrayList infoDEKList = cloneMgr.getAlEncryptionKeyInfoDEK();
            List<?> targetList = this.getCache("KEY_DELETE_KEYS");
            if (infoDEKList.size() == targetList.size()) {
                cloneMgr.setAlEncryptionKeyInfoDEK(new ArrayList());
            }
            ArrayList<SJmoEncryptionKeyInfoMgr> cloneList = new ArrayList<SJmoEncryptionKeyInfoMgr>();
            cloneList.add(cloneMgr);
            this.putCache(SJmoGetEncryptionKeyInfoMgr.class, cloneList);
        }
    }

    private void selectFinish(boolean bFinish) {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject relatedDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(relatedDisp);
        Class<? extends SJctrSubWizard> subWiz = dc.getSubWizard(this);
        SJctrDeleteKeysSubWizard sub = (SJctrDeleteKeysSubWizard)dc.getSubWizard(subWiz);
        sub.setBFiish(bFinish);
    }
}

