/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.enviromentalset.data;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLog;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.enviromentalset.data.SJctrConfiguration;

public class SJctrEditEnviromentalSetAuditLog
extends SJctrEncryptionAuditLog
implements SJctrEncryptionKeyDef {
    private static final long serialVersionUID = -8263333088632792976L;

    public SJctrEditEnviromentalSetAuditLog(SJbaseUserSession userSession) {
        super(userSession);
    }

    @Override
    protected String getFuncName() {
        return "ADT_FC_ENC";
    }

    @Override
    protected String getOperationName() {
        return "ADT_TITLE_SETUPKEY";
    }

    @Override
    protected String[][] getBaseKey() {
        String[][] rtn = new String[][]{{"COMMON", "ADT_TITLE_SETUPKEY"}, {"COMMON", "ADT_NUM_OF_SERVERS"}, {"COMMON", "ADT_NUM_OF_SETTINGS"}};
        return rtn;
    }

    @Override
    protected String[][] getHeadKey() {
        String[][] rtn = new String[][]{{"COMMON", "SERVER_TYPE"}, {"COMMON", "KMIP_MAPPING"}, {"COMMON", "HOST_NAME"}, {"COMMON", "PORT_NUMBER"}, {"COMMON", "TIMEOUT"}, {"COMMON", "RETRY_INTERVAL"}, {"COMMON", "RETRY_TIMES"}, {"COMMON", "CFILENAME"}, {"COMMON", "RFILENAME"}};
        return rtn;
    }

    @Override
    protected String[][] getHeadKeyForSub() {
        String[][] rtn = new String[][]{{"COMMON", "REGULAR_BACKUP"}, {"COMMON", "RN_TIME"}, {"COMMON", "RB_USER_NAME"}};
        return rtn;
    }

    @Override
    protected String[][] getDataKey() {
        String[][] rtn = new String[][]{{"COMMON", "ENABLE"}, {"COMMON", "DISABLE"}, {"COMMON", "PRIMARY"}, {"COMMON", "SECONDARY"}, {"COMMON", "NOSET"}, {"COMMON", "YES"}, {"COMMON", "NO"}};
        return rtn;
    }

    @Override
    protected String getNumOfName() {
        return "ADT_NUM_OF_SERVERS";
    }

    @Override
    protected String getNumOfNameForSub() {
        return "ADT_NUM_OF_SETTINGS";
    }

    @Override
    protected List<List<String>> getDetailData(Object wkInfo) {
        ArrayList<List<String>> rtn = new ArrayList<List<String>>();
        SJctrConfiguration info = (SJctrConfiguration)wkInfo;
        List confList = info.getConfList();
        for (int i = 0; i < confList.size(); ++i) {
            ArrayList<String> strDataList = new ArrayList<String>();
            SJctrConfiguration infoData = (SJctrConfiguration)confList.get(i);
            if (infoData.getEnabled()) {
                if (infoData.getServerName().equals("PrimaryServer")) {
                    strDataList.add(this.getDataGuidance("COMMON", "PRIMARY"));
                } else if (infoData.getServerName().equals("SecondaryServer")) {
                    strDataList.add(this.getDataGuidance("COMMON", "SECONDARY"));
                }
                strDataList.add(this.getDataGuidance("COMMON", "ENABLE"));
                strDataList.add(infoData.getHost());
                strDataList.add(Integer.toString(infoData.getPort()));
                strDataList.add(Integer.toString(infoData.getTimeout()));
                strDataList.add(Integer.toString(infoData.getRetryInterval()));
                strDataList.add(Integer.toString(infoData.getRetryTimes()));
                strDataList.add(infoData.getCFileName());
                strDataList.add(infoData.getRFileName());
            } else {
                if (infoData.getServerName().equals("PrimaryServer")) {
                    strDataList.add(this.getDataGuidance("COMMON", "PRIMARY"));
                } else if (infoData.getServerName().equals("SecondaryServer")) {
                    strDataList.add(this.getDataGuidance("COMMON", "SECONDARY"));
                }
                strDataList.add(this.getDataGuidance("COMMON", "DISABLE"));
                strDataList.add("");
                strDataList.add("");
                strDataList.add("");
                strDataList.add("");
                strDataList.add("");
                strDataList.add("");
                strDataList.add("");
            }
            rtn.add(strDataList);
        }
        return rtn;
    }

    @Override
    protected List<List<String>> getDetailDataForSub(Object wkInfo) {
        ArrayList<List<String>> rtn = new ArrayList<List<String>>();
        SJctrConfiguration info = (SJctrConfiguration)wkInfo;
        List confList = info.getConfList();
        for (int i = 0; i < confList.size(); ++i) {
            ArrayList<String> strDataList = new ArrayList<String>();
            SJctrConfiguration infoData = (SJctrConfiguration)confList.get(i);
            if (infoData.getServerName().equals("PrimaryServer") && infoData.getEnabled()) {
                if (infoData.getRegularbackupEnabled()) {
                    strDataList.add(this.getDataGuidance("COMMON", "YES"));
                } else {
                    strDataList.add(this.getDataGuidance("COMMON", "NO"));
                }
                strDataList.add(SJctrEncryptionKeysUtility.toRegularBackupTimeDisplay(infoData.getRegularBackupTime(), "_"));
                strDataList.add(infoData.getRegularbackupUserid());
                rtn.add(strDataList);
                continue;
            }
            if (!infoData.getServerName().equals("SecondaryServer") || infoData.getEnabled()) continue;
            rtn.clear();
            strDataList.add("");
            strDataList.add("");
            strDataList.add("");
            rtn.add(strDataList);
        }
        return rtn;
    }
}

