/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.license.installlicenses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.PPKget1PPInfo;
import sanproject.serverux.dataimpl.PPKgetKeyDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPPLicenseUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.license.com.SJctr1PPInfo;
import sanproject.sn2.controller.wizard.license.com.SJctrFileInstallCheckExecute;
import sanproject.sn2.controller.wizard.license.com.SJctrGetKeyDetail;
import sanproject.sn2.controller.wizard.license.com.SJctrInstall1PPCheckExecute;
import sanproject.sn2.controller.wizard.license.com.SJctrLicenseConfirmData;
import sanproject.sn2.controller.wizard.license.com.SJctrPPIDAscendingComparator;
import sanproject.sn2.controller.wizard.license.com.SJctrPPSetCheckExecute;
import sanproject.sn2.controller.wizard.license.com.SJctrSelectLicenseKeysTableModel;
import sanproject.sn2.controller.wizard.license.installlicenses.SJctrKeyFileTextModel;
import sanproject.sn2.controller.wizard.license.installlicenses.SJctrLicenseKeyFileUpload;
import sanproject.sn2.controller.wizard.license.installlicenses.SJctrSelectInputTypeModel;
import sanproject.sn2.controller.wizard.license.licensecheckresult.SJctrLicenseCheckResultDialogDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrInstallLicensesDC
extends SJctrWizardDataController {
    public static final int DISP_ID = 0x1101661;
    public static final String TITLE = "DISP_DI166S_TITLE";
    public static final String KEY_SEL_KEY_INF = "COM_SEL_KEY_INF";
    public static final String KEY_CODE_TEXT = "COM_CODE_TEXT";
    public static final String KEY_FILE_TEXT = "COM_FILE_TEXT";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_BROWSE = "COM_BROWSE";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_ENABLE = "COM_ENABLE";
    public static final String KEY_DISABLE = "COM_DISABLE";
    public static final String KEY_CLEARALL = "COM_CLEARALL";
    private static SJctrPPIDAscendingComparator PPID_COMP = new SJctrPPIDAscendingComparator();
    private SJctrSelectInputTypeModel selKeyInfoModel = null;
    private SJctrTextBoxDataModel keyCodeTxtModel = null;
    private SJctrKeyFileTextModel fileTxtModel = null;
    private SJctrSelectLicenseKeysTableModel licensesTableModel = null;
    private PPKget1PPInfo[] orgPPInfoArray = null;
    private PPKget1PPInfo[] wkPPInfoArray = null;
    private List<SJctr1PPInfo> updateList = Collections.emptyList();

    public SJctrInstallLicensesDC() throws SJcException {
        super(0x1101661);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.selKeyInfoModel = new SJctrSelectInputTypeModel();
        this.addDataObjectModel(KEY_SEL_KEY_INF, this.selKeyInfoModel);
        this.keyCodeTxtModel = new SJctrTextBoxDataModel();
        this.addDataObjectModel(KEY_CODE_TEXT, this.keyCodeTxtModel);
        this.fileTxtModel = new SJctrKeyFileTextModel();
        this.addDataObjectModel(KEY_FILE_TEXT, this.fileTxtModel);
        this.licensesTableModel = new SJctrSelectLicenseKeysTableModel();
        this.licensesTableModel.setTableKeyData(new ArrayList<SJctr1PPInfo>());
        this.addDataObjectModel(KEY_TABLE, this.licensesTableModel);
        SJctrButtonDataModel browseBtnModel = new SJctrButtonDataModel();
        browseBtnModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrLicenseKeyFileUpload fileUpload = new SJctrLicenseKeyFileUpload();
                fileUpload.setKeyFileTextModel(SJctrInstallLicensesDC.this.fileTxtModel);
                SJctrRelatedDispDataObject relatedDisp = null;
                relatedDisp = SJctrInstallLicensesDC.this.createFileUpload(fileUpload);
                SJctrInstallLicensesDC.this.addUpdateDisp(relatedDisp);
            }
        });
        this.addDataObjectModel(KEY_BROWSE, browseBtnModel);
        SJctrButtonDataModel addBtnModel = new SJctrButtonDataModel();
        addBtnModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrInstallLicensesDC.this.addAction();
            }
        });
        this.addDataObjectModel(KEY_ADD, addBtnModel);
        SJctrButtonDataModel enableBtnModel = new SJctrButtonDataModel();
        enableBtnModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrInstallLicensesDC.this.enableAction();
            }
        });
        this.addDataObjectModel(KEY_ENABLE, enableBtnModel);
        SJctrButtonDataModel disableBtnModel = new SJctrButtonDataModel();
        disableBtnModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrInstallLicensesDC.this.disableAction();
            }
        });
        this.addDataObjectModel(KEY_DISABLE, disableBtnModel);
        SJctrButtonDataModel clearAllBtnModel = new SJctrButtonDataModel();
        clearAllBtnModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrInstallLicensesDC.this.clearAllAction();
            }
        });
        this.addDataObjectModel(KEY_CLEARALL, clearAllBtnModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void addAction() {
        if (this.selKeyInfoModel.isKeyCodeRadioSelect()) {
            this.installKeyCode();
        } else {
            this.installFile();
        }
    }

    private void installKeyCode() {
        this.updateList.clear();
        String keyCode = this.keyCodeTxtModel.getValue();
        if (keyCode == null || keyCode.length() == 0) {
            SJctrError error = new SJctrError(4, 22, 205003);
            SJcException exp = error.createException();
            throw exp;
        }
        SJctrInstall1PPCheckExecute installChkObj = new SJctrInstall1PPCheckExecute(keyCode, this.wkPPInfoArray);
        installChkObj.execute(this);
        this.keyCodeTxtModel.setValue("");
        this.updateList = installChkObj.getUpDateList();
        this.wkPPInfoArray = installChkObj.getResultArray();
        List<SJctr1PPInfo> errorList = installChkObj.getErrorList();
        if (!errorList.isEmpty()) {
            this.createResultDialog(errorList);
        } else {
            this.updateTable();
        }
    }

    private void installFile() {
        this.updateList.clear();
        if (!this.fileTxtModel.isSelectFile()) {
            SJctrError error = new SJctrError(4, 22, 205004);
            SJcException exp = error.createException();
            throw exp;
        }
        String randomName = this.fileTxtModel.getRandomFileName();
        String orgFileName = this.fileTxtModel.getOrgFileName();
        if (orgFileName.length() > 200) {
            SJctrError error = new SJctrError(4, 22, 205005);
            SJcException exp = error.createException();
            throw exp;
        }
        SJctrFileInstallCheckExecute installChkObj = new SJctrFileInstallCheckExecute(randomName, orgFileName, this.wkPPInfoArray);
        installChkObj.execute(this);
        this.fileTxtModel.setDefaultValue();
        this.updateList = installChkObj.getUpDateList();
        this.wkPPInfoArray = installChkObj.getResultArray();
        List<SJctr1PPInfo> errorList = installChkObj.getErrorList();
        if (!errorList.isEmpty()) {
            this.createResultDialog(errorList);
        } else {
            this.updateTable();
        }
    }

    private void enableAction() {
        List<Object> rowData = this.licensesTableModel.getSelectedRowData();
        List<Object> selPPList = rowData;
        if (selPPList.isEmpty()) {
            SJctrError error = new SJctrError(4, 22, 205002);
            SJcException exp = error.createException();
            throw exp;
        }
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selPPList.size());
        for (SJctr1PPInfo sJctr1PPInfo : selPPList) {
            int status = sJctr1PPInfo.getStatus();
            if (status == 8) continue;
            SJctrError errInfo = new SJctrError(4, 22, 205007);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(sJctr1PPInfo, errInfo);
            errList.add(errData);
        }
        if (!errList.isEmpty()) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController sJctrErrorDataController = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            sJctrErrorDataController.setParameter(this.licensesTableModel, errList);
            SJctrError representErrorInfo = sJctrErrorDataController.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.checkExecute(selPPList, 3);
    }

    private void disableAction() {
        List<Object> rowData = this.licensesTableModel.getSelectedRowData();
        List<Object> selPPList = rowData;
        if (selPPList.isEmpty()) {
            SJctrError error = new SJctrError(4, 22, 205002);
            SJcException exp = error.createException();
            throw exp;
        }
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selPPList.size());
        for (SJctr1PPInfo sJctr1PPInfo : selPPList) {
            int status = sJctr1PPInfo.getStatus();
            if (status == 1) continue;
            SJctrError errInfo = new SJctrError(4, 22, 205009);
            SJctrErrorColumnData errData = new SJctrErrorColumnData(sJctr1PPInfo, errInfo);
            errList.add(errData);
        }
        if (!errList.isEmpty()) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController sJctrErrorDataController = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            sJctrErrorDataController.setParameter(this.licensesTableModel, errList);
            SJctrError representErrorInfo = sJctrErrorDataController.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.checkExecute(selPPList, 2);
    }

    private void clearAllAction() {
        this.wkPPInfoArray = SJctrPPLicenseUtility.clonePPKget1PPInfoArray(this.orgPPInfoArray);
        this.updateList.clear();
        this.licensesTableModel.clearRowData();
        this.licensesTableModel.doRefresh();
    }

    private void checkExecute(List<SJctr1PPInfo> selPPList, int action) {
        List<SJctr1PPInfo> errorList;
        this.updateList.clear();
        SJctrPPSetCheckExecute checkExe = new SJctrPPSetCheckExecute(action, selPPList, this.wkPPInfoArray);
        checkExe.execute(this);
        this.updateList = checkExe.getUpDateList();
        if (!this.updateList.isEmpty()) {
            this.wkPPInfoArray = checkExe.getResultArray();
        }
        if (!(errorList = checkExe.getErrorList()).isEmpty()) {
            this.createResultDialog(errorList);
        } else {
            this.updateTable();
        }
    }

    @Override
    public boolean checkStartData() {
        if (SJctrPPLicenseUtility.checkQueueingLicenseTask(this.getOwner())) {
            SJctrError error = new SJctrError(4, 22, 205010);
            SJcException exp = error.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        List<?> getList = this.getCache(SJctrGetKeyDetail.class);
        if (getList == null || getList.isEmpty()) {
            SJctrError error = new SJctrError(4, 22, 207002);
            SJcException exp = error.createException();
            throw exp;
        }
        SJmoThroughRmiData rmiObj = (SJmoThroughRmiData)getList.get(0);
        PPKgetKeyDetail ppKeyDtl = (PPKgetKeyDetail)rmiObj.getObjRmi();
        this.orgPPInfoArray = ppKeyDtl.getPPKget1PPInfo();
        this.wkPPInfoArray = SJctrPPLicenseUtility.clonePPKget1PPInfoArray(this.orgPPInfoArray);
        return true;
    }

    @Override
    public boolean checkEndData() {
        List<Object> rowDataList = this.licensesTableModel.getAllRowData();
        if (rowDataList.isEmpty()) {
            SJctrError error = new SJctrError(4, 22, 207003);
            SJcException exp = error.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public void makeDataModel() {
        this.licensesTableModel.setTableKeyData(new ArrayList<SJctr1PPInfo>());
        super.makeDataModel();
    }

    private void createResultDialog(List<SJctr1PPInfo> errorList) {
        HashMap param = new HashMap();
        param.put("LICENSE_CHECK_ERROR", errorList);
        SJctrRelatedDispDataObject related = this.createDialog(SJctrLicenseCheckResultDialogDC.class, param);
        this.addUpdateDisp(related);
    }

    private void initListener() {
        this.addMessageEventListener(SJctrLicenseCheckResultDialogDC.CHECKRESULT_MSG.CLOSE_DIALOG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrInstallLicensesDC.this.updateTable();
            }
        });
    }

    public void updateTable() {
        this.keyCodeTxtModel.setDirty();
        this.fileTxtModel.setDirty();
        if (this.updateList.isEmpty()) {
            return;
        }
        List<Object> allRowDataList = this.licensesTableModel.getAllRowData();
        Collections.sort(allRowDataList);
        ArrayList<SJctr1PPInfo> rmvRowDataList = new ArrayList<SJctr1PPInfo>(this.updateList.size());
        ArrayList<SJctr1PPInfo> newRowList = new ArrayList<SJctr1PPInfo>(this.updateList.size());
        for (SJctr1PPInfo updateInfo : this.updateList) {
            int index = Collections.binarySearch(allRowDataList, updateInfo);
            if (index >= 0) {
                SJctr1PPInfo rowData = (SJctr1PPInfo)allRowDataList.get(index);
                rmvRowDataList.add(rowData);
            }
            newRowList.add(updateInfo);
        }
        if (!rmvRowDataList.isEmpty()) {
            this.licensesTableModel.removeRowData(rmvRowDataList);
        }
        if (!newRowList.isEmpty()) {
            this.licensesTableModel.addRowDataTop(newRowList);
        }
        this.getWizardWindow().rollback();
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJctrGetKeyDetail kind = new SJctrGetKeyDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    public SJctrLicenseConfirmData createConfirmData() {
        SJctrLicenseConfirmData confirmData = new SJctrLicenseConfirmData();
        List<Object> rowDataList = this.licensesTableModel.getAllRowData();
        Collections.sort(rowDataList, PPID_COMP);
        PPKget1PPInfo[] setDataArray = this.wkPPInfoArray;
        confirmData.setAllPPInfoArray(setDataArray);
        confirmData.setUpdatePPInfoList(rowDataList);
        ArrayList<SJctrLicenseConfirmData> confirmDataList = new ArrayList<SJctrLicenseConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache("PPLICENSE_CONFIRMDATA", confirmDataList);
        return confirmData;
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LICENSE", TITLE);
    }
}

