/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.license.removelicenses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.PPKget1PPInfo;
import sanproject.serverux.dataimpl.PPKgetKeyDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrPPLicenseUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.license.com.SJctr1PPInfo;
import sanproject.sn2.controller.wizard.license.com.SJctrGetKeyDetail;
import sanproject.sn2.controller.wizard.license.com.SJctrLicenseConfirmData;
import sanproject.sn2.controller.wizard.license.com.SJctrLicenseKeysErrorTableModel;
import sanproject.sn2.controller.wizard.license.com.SJctrPPSetCheckExecute;
import sanproject.sn2.controller.wizard.license.com.SJctrSetLicenseKeyAC;
import sanproject.sn2.controller.wizard.license.removelicenses.SJctrRemoveLicensesConfirmDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.system.SJmoPPKget1PPInfo;

public class SJctrRemoveLicensesSubWizard
extends SJctrSubWizard {
    public static final String REMOVE_LICENSE_DATA = "REMOVE_LICENSE_DATA";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String TITLE = "REMOVE_LICENSES";
    private static final Class<?> CONFIRM_DC = SJctrRemoveLicensesConfirmDC.class;
    private PPKget1PPInfo[] orgPPInfoArray = null;
    private PPKget1PPInfo[] wkPPInfoArray = null;

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrUserController uc = wizard.getOwner();
        if (SJctrPPLicenseUtility.checkQueueingLicenseTask(uc)) {
            SJctrError error = new SJctrError(4, 22, 205010);
            SJcException exp = error.createException();
            throw exp;
        }
        List<?> selectList = wizard.getCache(REMOVE_LICENSE_DATA);
        if (selectList == null || selectList.isEmpty()) {
            SJctrError error = new SJctrError(4, 22, 207002);
            SJcException exp = error.createException();
            throw exp;
        }
        List<SJctr1PPInfo> targetList = this.checkSelectLicense(wizard, selectList);
        List<?> licenseDtl = wizard.getCache(SJctrGetKeyDetail.class);
        if (licenseDtl == null || licenseDtl.isEmpty()) {
            SJctrError error = new SJctrError(4, 22, 207002);
            SJcException exp = error.createException();
            throw exp;
        }
        SJmoThroughRmiData rmiObj = (SJmoThroughRmiData)licenseDtl.get(0);
        PPKgetKeyDetail ppKeyDtl = (PPKgetKeyDetail)rmiObj.getObjRmi();
        this.orgPPInfoArray = ppKeyDtl.getPPKget1PPInfo();
        this.wkPPInfoArray = SJctrPPLicenseUtility.clonePPKget1PPInfoArray(this.orgPPInfoArray);
        List<SJctr1PPInfo> updateList = this.removePPCheck(wizard, targetList, this.wkPPInfoArray);
        Collections.sort(updateList);
        PPKget1PPInfo[] setDataArray = this.wkPPInfoArray;
        SJctrLicenseConfirmData confirmData = new SJctrLicenseConfirmData();
        Collections.sort(targetList);
        confirmData.setAllPPInfoArray(setDataArray);
        confirmData.setUpdatePPInfoList(updateList);
        ArrayList<SJctrLicenseConfirmData> confirmDataList = new ArrayList<SJctrLicenseConfirmData>();
        confirmDataList.add(confirmData);
        wizard.putCache("PPLICENSE_CONFIRMDATA", confirmDataList);
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrSetLicenseKeyAC ac = new SJctrSetLicenseKeyAC(setDataArray, targetList, true);
        wizard.addConfirmData(ac, related);
    }

    private List<SJctr1PPInfo> checkSelectLicense(SJctrWizardWindowDC wizard, List<?> selectList) {
        ArrayList<SJctr1PPInfo> retList = new ArrayList<SJctr1PPInfo>(selectList.size());
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selectList.size());
        for (Object selectInfo : selectList) {
            SJmoPPKget1PPInfo selectPPInfo = (SJmoPPKget1PPInfo)selectInfo;
            int status = selectPPInfo.getIStatus();
            if (status == 2) {
                SJctrError errInfo = new SJctrError(4, 22, 205006);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(selectPPInfo, errInfo);
                errList.add(errData);
                continue;
            }
            SJctr1PPInfo targetInfo = SJctrPPLicenseUtility.chgCtrPPInfo(selectPPInfo);
            retList.add(targetInfo);
        }
        if (!errList.isEmpty()) {
            SJctrDataController parentDC = wizard.getParentDC();
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
            SJctrRelatedDispDataObject rel = wizard.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)wizard.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return retList;
    }

    private List<SJctr1PPInfo> removePPCheck(SJctrWizardWindowDC wizard, List<SJctr1PPInfo> targetList, PPKget1PPInfo[] ppInfoArray) {
        List<SJctr1PPInfo> updateList = null;
        SJctrPPSetCheckExecute checkObj = new SJctrPPSetCheckExecute(0, targetList, ppInfoArray);
        checkObj.execute(wizard);
        updateList = checkObj.getUpDateList();
        List<SJctr1PPInfo> errorList = checkObj.getErrorList();
        if (!errorList.isEmpty()) {
            SJctrLicenseKeysErrorTableModel errorTabla = new SJctrLicenseKeysErrorTableModel();
            errorTabla.setDataController(wizard);
            errorTabla.initGuidance(this.getComUtility());
            errorTabla.createModelDirect();
            errorTabla.divideModelData(wizard.getProxy().getModelDataMap());
            errorTabla.setTableKeyData(errorList);
            errorTabla.makeDataModel();
            ArrayList<SJctrErrorColumnData> errColumnDataList = new ArrayList<SJctrErrorColumnData>(errorList.size());
            for (SJctr1PPInfo errorData : errorList) {
                int errCode = errorData.getErrCode();
                SJctrError errInfo = new SJctrError(4, 5, errCode);
                SJctrErrorColumnData errColumnData = new SJctrErrorColumnData(errorData, errInfo);
                errColumnDataList.add(errColumnData);
            }
            SJctrRelatedDispDataObject rel = wizard.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)wizard.getOwner().getDataController(rel);
            errDc.setParameter(errorTabla, errColumnDataList);
            SJctrError representErrorInfo = errDc.getRepresentativeError(errColumnDataList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.wkPPInfoArray = checkObj.getResultArray();
        return updateList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJctrGetKeyDetail kind = new SJctrGetKeyDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

