/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortWwnInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrReplaceDataForConfirm {
    public static final String THIS_CLASS_NAME = "SJctrReplaceDataForConfirm";

    private SJctrReplaceDataForConfirm() {
    }

    public static List<SJmoPortHostGroupInfo> getConfirmPortHostGroupInfo(List<SJmoPortIndex> targetPortList, List<SJmoPortHostGroupInfo> portHgList) {
        ArrayList<SJmoPortHostGroupInfo> confirmPortHgList = new ArrayList<SJmoPortHostGroupInfo>();
        for (SJmoPortIndex portIndex : targetPortList) {
            int searchResult = Collections.binarySearch(portHgList, portIndex);
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getConfirmPortHostGroupInfo", "SJmoPortHostGroupInfo not found.");
                continue;
            }
            SJmoPortHostGroupInfo portHg = portHgList.get(searchResult);
            confirmPortHgList.add(portHg);
        }
        return confirmPortHgList;
    }

    public static List<SJmoPortAttributeInfo> getConfirmPortAttrInfo(List<SJmoPortIndex> targetPortList, List<SJmoPortAttributeInfo> portAttributeList) {
        ArrayList<SJmoPortAttributeInfo> confirmPortAttrList = new ArrayList<SJmoPortAttributeInfo>();
        for (SJmoPortIndex portIndex : targetPortList) {
            int searchResult = Collections.binarySearch(portAttributeList, portIndex);
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getConfirmPortAttrInfo", "SJmoPortAttributeInfo not found.");
                continue;
            }
            SJmoPortAttributeInfo portAttribute = portAttributeList.get(searchResult);
            confirmPortAttrList.add(portAttribute);
        }
        return confirmPortAttrList;
    }

    public static List<SJmoPortDetail> getConfirmPortDetail(List<SJmoPortIndex> targetPortList, List<SJmoPortDetail> portDetailList) {
        ArrayList<SJmoPortDetail> confirmPortDetailList = new ArrayList<SJmoPortDetail>();
        for (SJmoPortIndex portIndex : targetPortList) {
            int searchResult = Collections.binarySearch(portDetailList, portIndex);
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getConfirmPortDetail", "SJmoPortDetail not found.");
                continue;
            }
            SJmoPortDetail portDetail = portDetailList.get(searchResult);
            confirmPortDetailList.add(portDetail);
        }
        return confirmPortDetailList;
    }

    public static List<SJmoPortWwnInfo> getConfirmPortWwnInfo(List<SJmoPortIndex> targetPortList, List<SJmoPortWwnInfo> portWwnList) {
        ArrayList<SJmoPortWwnInfo> confirmPortWwnList = new ArrayList<SJmoPortWwnInfo>();
        for (SJmoPortIndex portIndex : targetPortList) {
            int searchResult = Collections.binarySearch(portWwnList, portIndex);
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getConfirmPortWwnInfo", "SJmoPortWwnInfo not found.");
                continue;
            }
            SJmoPortWwnInfo portWwn = portWwnList.get(searchResult);
            confirmPortWwnList.add(portWwn);
        }
        return confirmPortWwnList;
    }

    public static List<SJmoPortLunInfo> getConfirmPortLunInfo(List<SJmoPortIndex> targetPortList, List<SJmoPortLunInfo> portLunList) {
        ArrayList<SJmoPortLunInfo> confirmPortLunList = new ArrayList<SJmoPortLunInfo>();
        for (SJmoPortIndex portIndex : targetPortList) {
            int searchResult = Collections.binarySearch(portLunList, portIndex);
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getConfirmPortLunInfo", "SJmoPortLunInfo not found.");
                continue;
            }
            SJmoPortLunInfo portLun = portLunList.get(searchResult);
            confirmPortLunList.add(portLun);
        }
        return confirmPortLunList;
    }

    public static List<SJmoLdevDetail> getConfirmLdevDetail(List<SJmoLdevIndex> targetLdevList, List<SJmoLdevDetail> ldevDetailList) {
        ArrayList<SJmoLdevDetail> confirmLdevDetailList = new ArrayList<SJmoLdevDetail>(targetLdevList.size());
        for (SJmoLdevIndex portIndex : targetLdevList) {
            int searchResult = Collections.binarySearch(ldevDetailList, portIndex);
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getConfirmLdevDetail", "SJmoLdevDetail not found.");
                continue;
            }
            SJmoLdevDetail ldevDetail = ldevDetailList.get(searchResult);
            confirmLdevDetailList.add(ldevDetail);
        }
        return confirmLdevDetailList;
    }

    public static List<SJmoLdevLuseInfo> getConfirmLdevLuseInfo(List<SJmoLdevIndex> targetLdevList, List<SJmoLdevLuseInfo> ldevLuseList) {
        ArrayList<SJmoLdevLuseInfo> confirmLdevLuseList = new ArrayList<SJmoLdevLuseInfo>(targetLdevList.size());
        for (SJmoLdevIndex portIndex : targetLdevList) {
            int searchResult = Collections.binarySearch(ldevLuseList, portIndex);
            if (searchResult < 0) continue;
            SJmoLdevLuseInfo luseInfo = ldevLuseList.get(searchResult);
            confirmLdevLuseList.add(luseInfo);
        }
        return confirmLdevLuseList;
    }

    public static List<SJctrPortHostGroupTableKey> replaceConfirmTargetList(List<SJctrPortHostGroupTableKey> targetList, List<SJmoPortHostGroupInfo> confirmPortHgList) {
        ArrayList<SJctrPortHostGroupTableKey> retList = new ArrayList<SJctrPortHostGroupTableKey>();
        for (SJctrPortHostGroupTableKey oldKey : targetList) {
            int searchResult = Collections.binarySearch(confirmPortHgList, oldKey.getPortHostGroupInfo());
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "replaceConfirmTargetList", "SJmoHostGroupInfo(For CONFIRM) not found.");
                retList.add(oldKey);
                continue;
            }
            SJmoPortHostGroupInfo newPtHg = confirmPortHgList.get(searchResult);
            boolean findHgFlg = false;
            for (Object hgObj : newPtHg.getAlPortHostGroup()) {
                SJmoHostGroupInfo newHg = (SJmoHostGroupInfo)hgObj;
                if (oldKey.getHostGroupInfo().getSHostGroup() != newHg.getSHostGroup()) continue;
                retList.add(new SJctrPortHostGroupTableKey(newPtHg, newHg));
                findHgFlg = true;
                break;
            }
            if (findHgFlg) continue;
            retList.add(new SJctrPortHostGroupTableKey(newPtHg, oldKey.getHostGroupInfo()));
            SJctrLogUty.warn(THIS_CLASS_NAME, "replaceConfirmTargetList", "HG# miss. Port#=" + oldKey.getPortHostGroupInfo().getSPort() + " HG# =" + oldKey.getHostGroupInfo().getSHostGroup());
        }
        return retList;
    }

    public static List<SJmoLdevNicknameInfo> getConfirmLdevNickname(List<SJmoLdevIndex> targetLdevList, List<SJmoLdevNicknameInfo> ldevNickList) {
        ArrayList<SJmoLdevNicknameInfo> confirmLdevNickList = new ArrayList<SJmoLdevNicknameInfo>(targetLdevList.size());
        for (SJmoLdevIndex portIndex : targetLdevList) {
            int searchResult = Collections.binarySearch(ldevNickList, portIndex);
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getConfirmLdevNickname", "SJmoLdevNicknameInfo not found.");
                continue;
            }
            SJmoLdevNicknameInfo ldevNickname = ldevNickList.get(searchResult);
            confirmLdevNickList.add(ldevNickname);
        }
        return confirmLdevNickList;
    }

    public static List<SJmoPortIscsiTargetInfo> getConfirmPortIscsiTargetInfo(List<SJmoPortIndex> targetPortList, List<SJmoPortIscsiTargetInfo> portItList) {
        ArrayList<SJmoPortIscsiTargetInfo> confirmPortItList = new ArrayList<SJmoPortIscsiTargetInfo>();
        for (SJmoPortIndex portIndex : targetPortList) {
            int searchResult = Collections.binarySearch(portItList, portIndex);
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "getConfirmPortIscsiTargetInfo", "SJmoPortIscsiTargetInfo not found.");
                continue;
            }
            SJmoPortIscsiTargetInfo portHg = portItList.get(searchResult);
            confirmPortItList.add(portHg);
        }
        return confirmPortItList;
    }

    public static List<SJctrPortHostGroupTableKey> replaceConfirmIscsiTargetList(List<SJctrPortHostGroupTableKey> targetList, List<SJmoPortIscsiTargetInfo> confirmPortItList) {
        ArrayList<SJctrPortHostGroupTableKey> retList = new ArrayList<SJctrPortHostGroupTableKey>();
        for (SJctrPortHostGroupTableKey oldKey : targetList) {
            int searchResult = Collections.binarySearch(confirmPortItList, oldKey.getPortIscsiTargetInfo());
            if (searchResult < 0) {
                SJctrLogUty.warn(THIS_CLASS_NAME, "replaceConfirmTargetList", "SJmoIscsiTargetInfo(For CONFIRM) not found.");
                retList.add(oldKey);
                continue;
            }
            SJmoPortIscsiTargetInfo newPtIt = confirmPortItList.get(searchResult);
            boolean findHgFlg = false;
            Iterator<SJmoIscsiTargetInfo> i$ = newPtIt.getAlPortIscsiTarget().iterator();
            while (i$.hasNext()) {
                SJmoIscsiTargetInfo itObj;
                SJmoIscsiTargetInfo newIt = itObj = i$.next();
                if (oldKey.getIscsiTargetInfo().getSIscsiTarget() != newIt.getSIscsiTarget()) continue;
                retList.add(new SJctrPortHostGroupTableKey(newPtIt, newIt));
                findHgFlg = true;
                break;
            }
            if (findHgFlg) continue;
            retList.add(new SJctrPortHostGroupTableKey(newPtIt, oldKey.getIscsiTargetInfo()));
            SJctrLogUty.warn(THIS_CLASS_NAME, "replaceConfirmTargetList", "IT# miss. Port#=" + oldKey.getPortIscsiTargetInfo().getSPort() + " IT# =" + oldKey.getIscsiTargetInfo().getSIscsiTarget());
        }
        return retList;
    }
}

