/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.createaltpaths;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import sanproject.serverux.dataimpl.AddLUPath;
import sanproject.serverux.dataimpl.SanRmiInputInterface;
import sanproject.serverux.dataimpl.SetHostMode;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJctrCreateAltPathsIscsiAC
extends SJctrApplyController
implements SJmoKeyValueDefine_IF {
    private static final int LUNM_BASE_TIME = 30;
    private static final int CHECK_TIME = 5;
    private static final double COEFFICIENT = 0.003;
    List<SJctrError> resultData = null;
    List<SJmoPortIscsiTargetInfo> portIscsiTargetList = new ArrayList<SJmoPortIscsiTargetInfo>();
    List<SJmoPortLunInfo> portLunList = new ArrayList<SJmoPortLunInfo>();
    private Map<String, SJctrIscsiOperationError> errorMap = new TreeMap<String, SJctrIscsiOperationError>();
    private SJctrError representativeError = null;

    public void setApplyList(List<SJmoPortIscsiTargetInfo> portIscsiTargetList, List<SJmoPortLunInfo> portLunList) {
        this.portIscsiTargetList = portIscsiTargetList;
        this.portLunList = portLunList;
    }

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        double leadtime = 30.0 + (double)applylist.size() * 0.003 + 5.0;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(2);
        return applyList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        boolean bIscsiNameExist = false;
        try {
            SJctrLogUty.info(this.title, "applyStart", "make Apply Data.");
            SanRequest requestIscsiTargetData = supplier.newRequest("LUNMcreateiScsiTarget");
            SanRequest requestIscsiNameData = supplier.newRequest("LUNMcreateiScsiName");
            SanList reqPortIscsiTargetList = requestIscsiTargetData.newList("iScsiPorts");
            SanList reqPortIscsiNameList = requestIscsiNameData.newList("iScsiPorts");
            if (this.portIscsiTargetList == null) {
                SJctrLogUty.error("SJctrCreateEditIscsiPortIsnsAC", "applyStart", "Parameter is invalid.");
            }
            ArrayList<SetHostMode> setHostModeList = new ArrayList<SetHostMode>(this.portIscsiTargetList.size() * SJctrPortUtility.PORT_ISCSITARGET_MAX);
            ArrayList<AddLUPath> addLUPathList = new ArrayList<AddLUPath>(this.portIscsiTargetList.size() * SJctrPortUtility.PORT_ISCSITARGET_MAX * this.portLunList.size());
            for (SJmoPortIscsiTargetInfo portIscsiTarget : this.portIscsiTargetList) {
                ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = portIscsiTarget.getAlPortIscsiTarget();
                SJmoIscsiTargetInfo iscsiTarget = (SJmoIscsiTargetInfo)iscsiTargetList.get(0);
                SanObject portTargetParam = reqPortIscsiTargetList.addObj();
                portTargetParam.putInt("Id", (int)portIscsiTarget.getSPort());
                SanList iScsiTargetsTarget = portTargetParam.newList("iScsiTargets");
                SanObject iscsiTargetsTargetParam = iScsiTargetsTarget.addObj();
                iscsiTargetsTargetParam.putInt("Id", (int)iscsiTarget.getSIscsiTarget());
                iscsiTargetsTargetParam.putString("Name", iscsiTarget.getStrIscsiTargetName());
                iscsiTargetsTargetParam.putString("Alias", iscsiTarget.getStrIscsiTargetAlias());
                iscsiTargetsTargetParam.putInt("UserAuthSwitch", iscsiTarget.getiUserAuthentSwitch());
                iscsiTargetsTargetParam.putInt("AuthMode", iscsiTarget.getiAuthentMode());
                SetHostMode setHostMode = this.createSetHostMode(portIscsiTarget, iscsiTarget);
                setHostModeList.add(setHostMode);
                if (this.portLunList.size() != 0) {
                    SJmoPortLunInfo portLunInfo = this.portLunList.get(0);
                    ArrayList portLunDetailList = portLunInfo.getAlPortLun();
                    for (Object lunDetailObj : portLunDetailList) {
                        SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)lunDetailObj;
                        AddLUPath addLUPath = this.createAddLUPath(portIscsiTarget, iscsiTarget, lunDetail);
                        addLUPathList.add(addLUPath);
                    }
                }
                if (iscsiTarget.getAlIscsiName().size() == 0) continue;
                bIscsiNameExist = true;
                SanObject portNameParam = reqPortIscsiNameList.addObj();
                portNameParam.putInt("Id", (int)portIscsiTarget.getSPort());
                SanList iScsiTargetsName = portNameParam.newList("iScsiTargets");
                SanObject iscsiTargetsNameParam = iScsiTargetsName.addObj();
                iscsiTargetsNameParam.putInt("Id", (int)iscsiTarget.getSIscsiTarget());
                SanList iScsiNames = iscsiTargetsNameParam.newList("RemoteiScsiNames");
                for (SJmoIscsiName addHostsData : iscsiTarget.getAlIscsiName()) {
                    SanObject iScsiNamesParam = iScsiNames.addObj();
                    iScsiNamesParam.putString("Name", addHostsData.getStrIscsiName());
                    iScsiNamesParam.putString("NickName", addHostsData.getStrIscsiNickName());
                }
            }
            ArrayList<SanRequest> applyITList = new ArrayList<SanRequest>(1);
            applyITList.add(requestIscsiTargetData);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMcreateiScsiTarget)");
            Object resultITObject = supplier.applyStart(this.getLockId(), applyITList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMcreateiScsiTarget)");
            this.getMapIscsiError(resultITObject);
            SJctrLogUty.info(this.title, "applyStart", "set request(LUNMcreateiScsiTarget)");
            if (bIscsiNameExist) {
                ArrayList<SanRequest> applyINList = new ArrayList<SanRequest>(1);
                applyINList.add(requestIscsiNameData);
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMcreateiScsiName)");
                Object resultINObject = supplier.applyStart(this.getLockId(), applyINList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMcreateiScsiName)");
                this.getMapIscsiNameError(resultINObject);
                SJctrLogUty.info(this.title, "applyStart", "set request(LUNMcreateiScsiName)");
            }
            int applySize = setHostModeList.size() + addLUPathList.size();
            ArrayList<SanRmiInputInterface> applyList = new ArrayList<SanRmiInputInterface>(applySize);
            applyList.addAll(setHostModeList);
            if (addLUPathList.size() != 0) {
                applyList.addAll(addLUPathList);
            }
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (HostMode,LUPath)");
            Object resultObject = supplier.applyStart(this.getLockId(), applyList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (HostMode,LUPath)");
            this.setApplyResult(resultObject);
        }
        catch (SJcException se) {
            SJctrLogUty.error(this.title, "applyStart", "SJcException occurred. " + se.getMessage());
            SJctrError error = SJctrError.parseError(se);
            this.setError(error);
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "applyStart", "The Key-Value interfaced error occurred. " + sdEx.getMessage());
            SJctrError error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    private SetHostMode createSetHostMode(SJmoPortIscsiTargetInfo portIscsiTarget, SJmoIscsiTargetInfo iscsiTarget) {
        SetHostMode setHostMode = new SetHostMode();
        setHostMode.setSPort(portIscsiTarget.getSPort());
        setHostMode.setSHostgroupID(iscsiTarget.getSIscsiTarget());
        setHostMode.setByHostMode((byte)iscsiTarget.getIHostMode());
        setHostMode.setBtOption(iscsiTarget.getBtOption());
        return setHostMode;
    }

    private AddLUPath createAddLUPath(SJmoPortIscsiTargetInfo portIscsiTarget, SJmoIscsiTargetInfo iscsiTarget, SJmoPortLunDetail lunDetail) {
        AddLUPath addLUPath = new AddLUPath();
        addLUPath.setSPort(portIscsiTarget.getSPort());
        addLUPath.setSHostGroup(iscsiTarget.getSIscsiTarget());
        addLUPath.setSLUN(lunDetail.getSLUN());
        addLUPath.setSLDKC(lunDetail.getSLDKC());
        addLUPath.setSCU(lunDetail.getSCU());
        addLUPath.setSLDEV(lunDetail.getSLDEV());
        return addLUPath;
    }

    private void getMapIscsiError(Object resultObject) throws SanDataException {
        SanList iScsiPortList;
        SanObject repErrorInfo;
        int[] errMsgId;
        if (!(resultObject instanceof SanResponse)) {
            SJcException error = SJctrIscsiUtility.makeException(107001);
            throw error;
        }
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null && 0 != (errMsgId = (repErrorInfo = responseData.getObj("ErrorInfo")).getIntArray("MessageId"))[1]) {
            this.representativeError = new SJctrIscsiOperationError(errMsgId);
        }
        if ((iScsiPortList = responseData.getList("iScsiPorts")) == null || iScsiPortList.size() == 0) {
            return;
        }
        for (SanObject iScsiPort : iScsiPortList) {
            SanList iScsiTargetList = iScsiPort.getList("iScsiTargets");
            for (SanObject iScsiTarget : iScsiTargetList) {
                SanObject errInfo = iScsiTarget.getObj("ErrorInfo");
                int[] errMsgId2 = errInfo.getIntArray("MessageId");
                if (0 == errMsgId2[1]) continue;
                SJmoIscsiTargetIndex index = new SJmoIscsiTargetIndex();
                index.setSPort((short)iScsiPort.getInt("Id"));
                index.setSIscsiTarget((short)iScsiPort.getInt("Id"));
                String errorTg = index.toString();
                SJctrLogUty.info(this.title, "getMapPortError", index.toString());
                if (this.errorMap.containsKey(errorTg)) continue;
                SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId2, index);
                this.errorMap.put(errorTg, iscsiError);
            }
        }
    }

    private void getMapIscsiNameError(Object resultObject) throws SanDataException {
        SanList iScsiPortList;
        SanObject repErrorInfo;
        int[] errMsgId;
        if (!(resultObject instanceof SanResponse)) {
            SJcException error = SJctrIscsiUtility.makeException(107001);
            throw error;
        }
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null && 0 != (errMsgId = (repErrorInfo = responseData.getObj("ErrorInfo")).getIntArray("MessageId"))[1]) {
            this.representativeError = new SJctrIscsiOperationError(errMsgId);
        }
        if ((iScsiPortList = responseData.getList("iScsiPorts")) == null || iScsiPortList.size() == 0) {
            return;
        }
        for (SanObject iScsiPort : iScsiPortList) {
            SanList iScsiTargetList = iScsiPort.getList("iScsiTargets");
            for (SanObject iScsiTarget : iScsiTargetList) {
                SanList iScsiNameList = iScsiTarget.getList("RemoteiScsiNames");
                for (SanObject iScsiNameErr : iScsiNameList) {
                    SanObject errInfo = iScsiNameErr.getObj("ErrorInfo");
                    int[] errMsgId2 = errInfo.getIntArray("MessageId");
                    if (0 == errMsgId2[1]) continue;
                    SJmoIscsiTargetIndex index = new SJmoIscsiTargetIndex();
                    index.setSPort((short)iScsiPort.getInt("Id"));
                    index.setSIscsiTarget((short)iScsiPort.getInt("Id"));
                    String errorTg = index.toString();
                    SJctrLogUty.info(this.title, "getMapPortError", index.toString());
                    if (this.errorMap.containsKey(errorTg)) continue;
                    SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId2, index);
                    this.errorMap.put(errorTg, iscsiError);
                }
            }
        }
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        SJctrLogUty.info(this.title, "setApplyResult", "start.");
        super.setApplyResult(resultObject);
        if (this.representativeError != null) {
            this.setError(this.representativeError);
        } else {
            this.setError(SJctrIscsiUtility.makeError(0));
        }
        if (this.errorMap.size() > 0) {
            this.resultData = new ArrayList<SJctrIscsiOperationError>(this.errorMap.values());
        }
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }
}

