/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.createhgs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrAddHostsTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrModelDataCheck;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupWwnTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrReplaceDataForConfirm;
import sanproject.sn2.controller.wizard.lunm.comdialog.SJctrAddNewHostsDialogDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertyDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrAddPortWwnErrorTableModel;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrAvailableHostTableModel;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrAvailablePortTableModel;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrCreateHGAddErrMgr;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrCreateHostGroupData;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrHostModeOptTableModel;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrPortHostGroupWwnData;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrRsgDataModel;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrSelectedHGTableModel;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrHostModeComboModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortWwnInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilHostGrp;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortWwnInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.modelrc.util.SJmoRscUtilHostGrp;

public class SJctrCreateHostGroupDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1001201;
    public static final String KEY_HG_NAME = "COM_HOSTGROUPNAME";
    public static final String KEY_PORT = "COM_PORT";
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_TABLE_PORT = "COM_TABLE_PORT";
    public static final String KEY_HOSTMODE = "COM_HOSTMODE";
    public static final String KEY_TABLE_OPTION = "COM_TABLE_OPTION";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final String KEY_CONBOBOX = "COM_RSGNAME";
    public static final Class KEY_CLASS_MPORTHG = SJmoGetPortHostGroupInfo.class;
    public static final Class KEY_CLASS_MPORTATTR = SJmoGetPortAttributeInfo.class;
    public static final Class KEY_CLASS_MPORTWWN = SJmoGetPortWwnInfo.class;
    public static final Class KEY_CLASS_MPORTDETL = SJmoGetPortDetail.class;
    public static final Class KEY_CLASS_CREATEPORTHG = SJctrPortHostGroupTableKey.class;
    public static final Class KEY_CLASS_HG_UTIL = SJmoGetRscUtilHostGrp.class;
    public static final Class KEY_CLASS_SYS_OPT = SJctrGetSystemOption.class;
    public static final Class KEY_CLASS_RSG = SJmoGetRSGgetAllRsgs.class;
    public static final Class KEY_CLASS_VSS = SJmoGetHUVMVirtualLdev.class;
    public static final Class KEY_CLASS_DKC = SJmoGetHUVMVirtualDkc.class;
    public static final String KEY_SELECT_PORT_INDEX = "KEY_SELECT_PORT_INDEX";
    public static final String KEY_CLASS_CONFIRM_DATA = "SJctrCreateHostGroupData";
    public static final String TITLE = "DISP_HG1_TITLE";
    public static final String DISP_HOST_GROUP_NAME_MAX_CHAR = "DISP_HOST_GROUP_NAME_MAX_CHAR";
    public static final int EC_START_CACHE_NOT_FOUND = 107001;
    public static final int EC_CONSTRUCT_MODEL_NOT_FOUND = 107002;
    public static final int EC_MODEL_PORT_NOT_FOUND = 106503;
    public static final int EC_PORT_ATTRIBUTE = 105029;
    public static final int EC_TOO_MANY_HOSTGROUP = 105030;
    public static final int EC_TOO_MANY_WWN = 106504;
    public static final int EC_NOT_SELECT_AVAILABLE_HOST_DATA = 105031;
    public static final int EC_CANNOT_ADD_WWNMAX = 105033;
    public static final int EC_CANNOT_ADD_USED_WWNINFO = 105208;
    public static final int EC_CANNOT_ADD_HOSTGROUP_NAME = 105037;
    public static final int EC_CANNOT_ADD_DFFALUT_HGNAME = 105038;
    public static final int EC_CANNOT_ADD_USED_HOSTGROUP = 105013;
    public static final int EC_CANNOT_ADD_MORE_HOSTGROUP = 106505;
    public static final int EC_NOT_SELECT_DETAIL_DATA = 105040;
    public static final int EC_TOO_MANY_SELECT_DETAIL_DATA = 105041;
    public static final int EC_DETAIL_MODEL_NOT_FOUND = 107004;
    public static final int EC_NOT_SELECT_DELETE_DATA = 105042;
    public static final int EC_NOT_SET_DATA = 105043;
    public static final int EC_NOT_SELECT_AVAILABLE_PORT_DATA = 105031;
    public static final int EC_NOT_RSG_SELECT_DELETE_DATA = 105297;
    public static final int EC_NOTHING_AVAILABLE_PORT = 205058;
    public static final int EC_COEXISTENCE_OF_HG1 = 205146;
    public static final int EC_CONSTRUCT_MODEL_NO_FIBRE = 206288;
    public static int CREATEHG_ERR_vPort = 205166;
    public static final String FILE_NAME_DIR = "controller\\lunm";
    public static final String FILE_NAME_FILE = "SJctrPortHostGroupWwnData.dbg";
    private static final Pattern patternHgName = Pattern.compile("[^\\\\/:,;*?\"<>|]{1,64}");
    private List<SJctrAddHostsTableKey> availableKeyList;
    private List<SJmoPortHostGroupInfo> originPortHg;
    private Map<Short, SJctrPortHostGroupWwnData> definedData;
    SJctrRsgDataModel rsgDataModel = null;
    private List<SJmoPortDetail> portDetail = null;
    private List<SJmoPortHostGroupInfo> targetPortHg = null;
    private SJctrResourceGroupUtility rsgUtil = null;
    private ArrayList<SJctrError> errList = null;

    public SJctrCreateHostGroupDC() throws SJcException {
        super(0x1001201);
        this.initDataModel();
        this.initListener();
        this.definedData = new HashMap<Short, SJctrPortHostGroupWwnData>(SJctrPortUtility.PORT_MAX * 4 / 3 + 1);
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_HG_NAME, new SJctrTextBoxDataModel(){

            @Override
            public void initGuidance(SJctrComUtility util) {
                this.setLabel(util.getGuidance("LUNM", SJctrCreateHostGroupDC.DISP_HOST_GROUP_NAME_MAX_CHAR));
            }
        });
        this.addDataObjectModel(KEY_CONBOBOX, new SJctrRsgDataModel());
        this.addDataObjectModel(KEY_HOSTMODE, new SJctrHostModeComboModel());
        this.addDataObjectModel(KEY_TABLE_OPTION, new SJctrHostModeOptTableModel());
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrAvailableHostTableModel());
        this.addDataObjectModel(KEY_TABLE_PORT, new SJctrAvailablePortTableModel());
        SJctrSelectedHGTableModel selectHGTable = new SJctrSelectedHGTableModel();
        selectHGTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SELECTED, selectHGTable);
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.setRollBackCheck(true);
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrCreateHostGroupDC.this.addAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_ADD, add);
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean bRet = true;
        SJctrWizardWindowDC wizard = this.getWizardWindow();
        List<?> targetList = wizard.getCache(KEY_SELECT_PORT_INDEX);
        if (targetList != null && targetList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return bRet;
    }

    @Override
    public boolean checkConstructData() throws SJcException {
        int errSize;
        List<?> rsgDetailList;
        List<SJmoPortWwnInfo> portWwn;
        boolean ret = true;
        List<SJmoPortIndex> portIndex = this.getCache(KEY_SELECT_PORT_INDEX);
        List<SJmoPortHostGroupInfo> portHg = this.getCache(KEY_CLASS_MPORTHG);
        if (portHg == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoPortHostGroupInfo not found.");
            ret = false;
        } else if (portHg.size() == 0) {
            SJctrError err = new SJctrError(10, 22, 206288);
            throw err.createException();
        }
        List<SJmoPortAttributeInfo> portAttr = this.getCache(KEY_CLASS_MPORTATTR);
        if (portAttr == null || portAttr.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoPortAttributeInfo not found.");
            ret = false;
        }
        this.portDetail = this.getCache(KEY_CLASS_MPORTDETL);
        if (this.portDetail == null || this.portDetail.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoPortDetail not found.");
            ret = false;
        }
        if ((portWwn = this.getCache(KEY_CLASS_MPORTWWN)) == null || portWwn.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoPortWwnInfo not found.");
            ret = false;
        }
        List<?> hgUtilList = this.getCache(KEY_CLASS_HG_UTIL);
        Object rscHG = null;
        if (hgUtilList == null || hgUtilList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoRscUtilHostGrp not found.");
            ret = false;
        }
        if ((rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class)) == null || rsgDetailList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoGetRSGgetAllRsgs not found.");
            ret = false;
        }
        if (!ret) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        this.rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        boolean portIndexFlg = false;
        if (portIndex == null) {
            errSize = portHg.size();
            portIndex = portHg;
        } else {
            portIndexFlg = true;
            errSize = portIndex.size();
        }
        this.errList = new ArrayList(errSize);
        for (int i = 0; i < errSize; ++i) {
            SJctrError oneError = new SJctrError(0, 0, -1);
            this.errList.add(oneError);
        }
        this.targetPortHg = this.getAvailablePortHG(portIndex, portHg, this.errList, portIndexFlg);
        this.checkPortAttribute(this.targetPortHg, portAttr, this.errList);
        this.checkHostGroupNum(this.targetPortHg, this.errList);
        ret = this.checkPortNum(this.errList);
        List<SJmoPortHostGroupInfo> targetPortHgRsg = this.getPtHgRsg(this.targetPortHg, this.rsgUtil);
        if (ret && portIndexFlg) {
            this.checkPortHostGroupRSG(portIndex, this.rsgUtil);
        }
        List<SJmoPortDetail> portList = this.getPortDetail(targetPortHgRsg, this.portDetail, this.errList);
        if (!portIndexFlg && portList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, 205058);
            SJcException exp = err.createException();
            throw exp;
        }
        if (!ret) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Can't find port to create host groups!!");
            SJctrRelatedDispDataObject errDisp = this.createDialog(SJctrErrorDataController.class, null);
            SJctrUserController uc = this.getWizardWindow().getOwner();
            SJctrErrorDataController errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
            ArrayList<SJmoPortDetail> errBasicList = new ArrayList<SJmoPortDetail>(this.errList.size());
            ArrayList<SJctrErrorColumnData> newErrList = new ArrayList<SJctrErrorColumnData>(this.errList.size());
            for (int errpos = 0; errpos < this.errList.size(); ++errpos) {
                SJctrError errElement = this.errList.get(errpos);
                int index = Collections.binarySearch(this.portDetail, portIndex.get(errpos));
                if (index < 0) continue;
                SJmoPortDetail onePortDetail = this.portDetail.get(index);
                errBasicList.add(onePortDetail);
                SJctrErrorColumnData errData = new SJctrErrorColumnData(onePortDetail, errElement);
                newErrList.add(errData);
            }
            SJctrAvailablePortTableModel errTbl = new SJctrAvailablePortTableModel();
            errTbl.setDataController(this);
            errTbl.setPaging(false);
            errTbl.setBasicDataList(errBasicList);
            errTbl.initGuidance(this.getComUtility());
            errTbl.createModelDirect();
            errTbl.divideModelData(this.getProxy().getModelDataMap());
            errTbl.makeDataModel();
            errDC.setParameter(errTbl, newErrList);
            SJctrError err = errDC.getRepresentativeError(newErrList, 4);
            SJcException exp = err.createException();
            exp.setErrDisp(errDisp);
            throw exp;
        }
        this.makeDefinedData(portHg, this.errList);
        this.availableKeyList = this.makeAvailableTableKey(portHg, portWwn);
        SJctrAvailableHostTableModel hostTable = (SJctrAvailableHostTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        hostTable.setBasicDataList(this.availableKeyList);
        SJctrAvailablePortTableModel portTable = (SJctrAvailablePortTableModel)this.getDataObjectModel(KEY_TABLE_PORT);
        portTable.setBasicDataList(portList);
        SJctrHostModeComboModel hostModeCombo = (SJctrHostModeComboModel)this.getDataObjectModel(KEY_HOSTMODE);
        hostModeCombo.initItemList(this.getComUtility().getPortUtility());
        this.rsgDataModel = (SJctrRsgDataModel)this.getDataObjectModel(KEY_CONBOBOX);
        Map<String, Integer> rsgConboMap = this.getConboData(this.rsgUtil);
        this.createRsgConboBox(rsgConboMap);
        return ret;
    }

    private Map<String, Integer> getConboData(SJctrResourceGroupUtility rsgUtil) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        List<SJmoRSGgetRsg> rsgList = rsgUtil.extractRsg();
        SJctrComUtility comUtil = this.getComUtility();
        for (SJmoRSGgetRsg rsg : rsgList) {
            SJmoRSGInfo rsgInfo = rsg.getRsgInfo();
            if (SJctrRsgUtility.isSysRsg(rsgInfo)) continue;
            int rsgId = rsgInfo.getRsgId();
            String conboStr = SJctrRsgUtility.toRsgIdDisplay(comUtil, rsgInfo);
            resultMap.put(conboStr, rsgId);
        }
        return resultMap;
    }

    private void createRsgConboBox(Map<String, Integer> rsgConboMap) {
        ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(rsgConboMap.entrySet());
        Collections.sort(entries, new Comparator(){

            public int compare(Object rsgMap1, Object rsgMap2) {
                Map.Entry rsg1 = (Map.Entry)rsgMap1;
                Map.Entry rsg2 = (Map.Entry)rsgMap2;
                return ((Integer)rsg1.getValue()).compareTo((Integer)rsg2.getValue());
            }
        });
        this.rsgDataModel.addItem("Any");
        for (Map.Entry entry : entries) {
            this.rsgDataModel.addItem((String)entry.getKey());
        }
        this.rsgDataModel.setRsgMap(rsgConboMap);
        this.rsgDataModel.setSelection("Any");
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(KEY_CLASS_MPORTHG));
        set.add(this.createModelDirect(KEY_CLASS_MPORTATTR));
        set.add(this.createModelDirect(KEY_CLASS_MPORTWWN));
        set.add(this.createModelDirect(KEY_CLASS_MPORTDETL));
        set.add(this.createModelDirect(KEY_CLASS_HG_UTIL));
        set.add(this.createModelDirect(KEY_CLASS_SYS_OPT));
        set.add(this.createModelDirect(KEY_CLASS_RSG));
        return set;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper retValue = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList filterList = new ArrayList();
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            retValue = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<?> targetPortHgList = this.getCache(KEY_CLASS_CREATEPORTHG);
        if (selectedTable.getRowCount() <= 0 || targetPortHgList == null || targetPortHgList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "No Data Selected. (Selected Table Rows = " + selectedTable.getRowCount() + ")");
            SJctrError err = new SJctrError(10, 22, 105043);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        List<SJctrPortHostGroupTableKey> targetPortHgList = this.getCache(KEY_CLASS_CREATEPORTHG);
        List<?> portDetail = this.getCache(KEY_CLASS_MPORTDETL);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        portUtil.checkPortSecurityMsg(portDetail, targetPortHgList, this);
        return false;
    }

    private void initListener() {
        this.addMessageEventListener(CREATE_HG_MSG.ADD_NEW_HOST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHostGroupDC.this.enterAddNewHostAction();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object notifyObj = event.getNofifyObject();
                if (notifyObj instanceof Map) {
                    Map map = (Map)notifyObj;
                    SJctrCreateHostGroupDC.this.exitAddNewHostAction(map);
                }
            }
        });
        this.addMessageEventListener(CREATE_HG_MSG.DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHostGroupDC.this.detailAction();
            }
        });
        this.addMessageEventListener(CREATE_HG_MSG.DELETE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHostGroupDC.this.deleteAction();
            }
        });
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    private List<SJmoPortHostGroupInfo> getAvailablePortHG(List<SJmoPortIndex> portIndex, List<SJmoPortHostGroupInfo> portHg, List<SJctrError> errList, boolean portIndexFlg) {
        ArrayList<SJmoPortHostGroupInfo> retList = new ArrayList<SJmoPortHostGroupInfo>(portIndex.size());
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        for (int index = 0; index < portIndex.size(); ++index) {
            SJctrError errElement = errList.get(index);
            if (errElement.getError() != -1) continue;
            SJmoPortIndex onePortIndex = portIndex.get(index);
            int searchRet = Collections.binarySearch(portHg, onePortIndex);
            if (searchRet >= 0) {
                int searchIndex = Collections.binarySearch(portDetailList, onePortIndex);
                if (searchIndex < 0) continue;
                SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(searchIndex);
                boolean vPort = SJctrPortUtility.isHnasPort(portDetail);
                if (!vPort) {
                    retList.add(portHg.get(searchRet));
                    continue;
                }
                if (!portIndexFlg) continue;
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(CREATEHG_ERR_vPort);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAvailablePortHG", "Not Found port#=" + onePortIndex.getSPort());
            retList.add(new SJmoPortHostGroupInfo());
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(106503);
        }
        return retList;
    }

    private boolean checkHostGroupNum(List<SJmoPortHostGroupInfo> portHg, List<SJctrError> errList) {
        boolean ret = true;
        for (int index = 0; index < portHg.size(); ++index) {
            SJmoPortHostGroupInfo onePtHg;
            SJctrError errElement = errList.get(index);
            if (errElement.getError() != -1 || (onePtHg = portHg.get(index)).getAlPortHostGroup().size() < SJctrPortUtility.PORT_HOSTGROUP_MAX) continue;
            ret = false;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHostGroupNum", "No more host groups can be registered in the port. Port#=" + onePtHg.getSPort());
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(105030);
        }
        return ret;
    }

    private boolean checkWwnNum(List<SJmoPortHostGroupInfo> portHg, List<SJctrError> errList) {
        boolean ret = true;
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrError errElement = errList.get(index);
            if (errElement.getError() != -1) continue;
            SJmoPortHostGroupInfo onePtHg = portHg.get(index);
            int portWwnSum = 0;
            for (SJmoHostGroupInfo oneHostGrp : onePtHg.getAlPortHostGroup()) {
                portWwnSum += oneHostGrp.getAlHostGroupWwn().size();
            }
            if (portWwnSum < SJctrPortUtility.PORT_WWN_MAX) continue;
            ret = false;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkWwnNum", "No more wwns can be registered in the port. Port#=" + onePtHg.getSPort());
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(106504);
        }
        return ret;
    }

    private boolean checkPortAttribute(List<SJmoPortHostGroupInfo> portHg, List<SJmoPortAttributeInfo> portAttr, List<SJctrError> errList) {
        boolean ret = true;
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrError errElement = errList.get(index);
            if (errElement.getError() != -1) continue;
            SJmoPortHostGroupInfo onePtHg = portHg.get(index);
            int searchRet = Collections.binarySearch(portAttr, onePtHg);
            if (searchRet < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPortAttribute", "Not Found Port-AttributeInfo. Skipped Port#= " + onePtHg.getSPort());
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(106503);
                ret = false;
                continue;
            }
            SJmoPortAttributeInfo onePortAttr = portAttr.get(searchRet);
            byte portKind = onePortAttr.getByPortKind();
            if (portKind == 3 || portKind == 4 || portKind == 9) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPortAttribute", "Port# = " + onePortAttr.getSPort() + ", Attribute = " + portKind);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(105029);
            ret = false;
        }
        return ret;
    }

    private List<SJmoPortDetail> getPortDetail(List<SJmoPortHostGroupInfo> portHg, List<SJmoPortDetail> portDetail, List<SJctrError> errList) {
        ArrayList<SJmoPortDetail> portList = new ArrayList<SJmoPortDetail>(portHg.size());
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrError errElement;
            SJmoPortHostGroupInfo onePtHg = portHg.get(index);
            if (onePtHg == null || (errElement = errList.get(index)).getError() != -1) continue;
            int searchRet = Collections.binarySearch(portDetail, onePtHg);
            if (searchRet < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPortDetail", "Not Found Port-Detail. Port#= " + onePtHg.getSPort());
                SJctrError err = new SJctrError(10, 22, 106503);
                SJcException exp = err.createException();
                throw exp;
            }
            portList.add(portDetail.get(searchRet));
        }
        return portList;
    }

    private List<SJmoPortHostGroupInfo> getPtHgRsg(List<SJmoPortHostGroupInfo> portHg, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoPortHostGroupInfo> resultList = new ArrayList<SJmoPortHostGroupInfo>(SJctrPortUtility.PORT_MAX);
        BitSet hgIdSet = new BitSet(SJctrPortUtility.PORT_HOSTGROUP_MAX);
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        boolean rsgConboFlg = true;
        if (this.rsgDataModel != null) {
            rsgConboFlg = this.rsgDataModel.getSelectionRsgId() != -1;
        }
        for (SJmoPortHostGroupInfo ptHgInfo : portHg) {
            hgIdSet.clear();
            for (SJmoHostGroupInfo hgInfo : ptHgInfo.getAlPortHostGroup()) {
                hgIdSet.set(hgInfo.getSHostGroup());
            }
            short sHostgr = 0;
            short sPort = ptHgInfo.getSPort();
            boolean loopFlg = false;
            while (sHostgr < SJctrPortUtility.PORT_HOSTGROUP_MAX) {
                if ((sHostgr = (short)((short)hgIdSet.nextClearBit(sHostgr))) >= SJctrPortUtility.PORT_HOSTGROUP_MAX) continue;
                hgIndex.setSHostGroup(sHostgr);
                hgIndex.setSPort(sPort);
                int rsgId = rsgUtil.getRsgId(hgIndex);
                loopFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
                if (this.rsgDataModel != null && rsgConboFlg) {
                    loopFlg &= this.rsgDataModel.getSelectionRsgId() == rsgId;
                }
                if (loopFlg) {
                    resultList.add(ptHgInfo);
                    break;
                }
                sHostgr = (short)(sHostgr + 1);
            }
            if (loopFlg) continue;
            resultList.add(null);
        }
        return resultList;
    }

    private boolean checkPortNum(List<SJctrError> errList) {
        for (SJctrError errElement : errList) {
            if (errElement.getError() != -1) continue;
            return true;
        }
        return false;
    }

    private void checkPortHostGroupRSG(List<SJmoPortIndex> portIndexList, SJctrResourceGroupUtility rsgUtil) {
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        block0: for (SJmoPortIndex ptIndex : portIndexList) {
            hgIndex.setSPort(ptIndex.getSPort());
            short maxHostGroupIdx = SJctrPortUtility.PORT_HOSTGROUP_MAX - 1;
            for (short index = 0; index <= maxHostGroupIdx; index = (short)(index + 1)) {
                hgIndex.setSHostGroup(index);
                boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                if (rsgFlg) continue block0;
                if (index != maxHostGroupIdx) continue;
                SJctrError err = new SJctrError(10, 22, 105297);
                SJcException exp = err.createException();
                throw exp;
            }
        }
    }

    private void makeDefinedData(List<SJmoPortHostGroupInfo> allPtHg, List<SJctrError> errList) {
        for (int index = 0; index < allPtHg.size(); ++index) {
            SJmoPortHostGroupInfo ptHg = allPtHg.get(index);
            SJctrPortHostGroupWwnData ctrData = new SJctrPortHostGroupWwnData();
            for (SJmoHostGroupInfo mdlHg : ptHg.getAlPortHostGroup()) {
                ctrData.addHostGroup(mdlHg);
            }
            this.definedData.put(ptHg.getSPort(), ctrData);
        }
    }

    private List<SJctrAddHostsTableKey> makeAvailableTableKey(List<SJmoPortHostGroupInfo> mdlAllPtHg, List<SJmoPortWwnInfo> mdlAllPtWwn) {
        ArrayList<SJctrAddHostsTableKey> retList = new ArrayList<SJctrAddHostsTableKey>();
        for (SJmoPortHostGroupInfo mdlPtHg : mdlAllPtHg) {
            for (SJmoHostGroupInfo mdlHg : mdlPtHg.getAlPortHostGroup()) {
                for (SJmoWwn mdlPtHgWwn : mdlHg.getAlHostGroupWwn()) {
                    SJctrAddHostsTableKey hostKey = new SJctrAddHostsTableKey(mdlPtHg, mdlHg, mdlPtHgWwn, false);
                    retList.add(hostKey);
                }
            }
        }
        for (SJmoPortWwnInfo mdlPtWwn : mdlAllPtWwn) {
            SJctrPortHostGroupWwnData ctrData = this.definedData.get(mdlPtWwn.getSPort());
            for (SJmoWwn mdlLoginWwn : mdlPtWwn.getAlPortWwn()) {
                if (ctrData != null && ctrData.containsWwn(mdlLoginWwn)) continue;
                short port = mdlPtWwn.getSPort();
                SJmoPortHostGroupInfo newPtHgInfo = new SJmoPortHostGroupInfo();
                newPtHgInfo.setSPort(port);
                SJmoHostGroupInfo newHgInfo = new SJmoHostGroupInfo();
                SJctrAddHostsTableKey hostKey = new SJctrAddHostsTableKey(newPtHgInfo, newHgInfo, mdlLoginWwn, false);
                retList.add(hostKey);
            }
        }
        return retList;
    }

    private void enterAddNewHostAction() {
        SJctrAvailableHostTableModel availableTable = (SJctrAvailableHostTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        HashMap map = new HashMap();
        List<Object> addList = availableTable.getSelectedRowData();
        ArrayList<SJmoWwn> selectWwnList = new ArrayList<SJmoWwn>(addList.size());
        for (Object rowObj : addList) {
            SJctrAddHostsTableKey rowKey = (SJctrAddHostsTableKey)rowObj;
            selectWwnList.add(rowKey.getWwnInfo());
        }
        map.put("KEY_WWN_DIALOG_IN", selectWwnList);
        List<Object> availableList = availableTable.getAllRowData();
        ArrayList<SJmoWwn> availableWwnList = new ArrayList<SJmoWwn>(availableList.size());
        for (Object rowObj : availableList) {
            SJctrAddHostsTableKey rowKey = (SJctrAddHostsTableKey)rowObj;
            availableWwnList.add(rowKey.getWwnInfo());
        }
        map.put("KEY_AVAILABLE_WWN", availableWwnList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrAddNewHostsDialogDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void exitAddNewHostAction(Map<String, List<?>> carryMap) {
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<?> carryWwnList = carryMap.get("KEY_WWN_DIALOG_OUT");
        if (carryWwnList == null || carryWwnList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "exitAddNewHostAction", "KEY_WWN_DIALOG_OUT Not Found!!");
            return;
        }
        SJmoWwn newWwn = (SJmoWwn)carryWwnList.get(0);
        SJmoPortHostGroupInfo newPtHgInfo = new SJmoPortHostGroupInfo();
        SJmoHostGroupInfo newHgInfo = new SJmoHostGroupInfo();
        SJctrAddHostsTableKey hostKey = new SJctrAddHostsTableKey(newPtHgInfo, newHgInfo, newWwn, true);
        this.availableKeyList.add(hostKey);
        ArrayList<SJctrAddHostsTableKey> addList = new ArrayList<SJctrAddHostsTableKey>(1);
        addList.add(hostKey);
        avaliableTable.addRowDataTop(addList);
        avaliableTable.setDirty();
    }

    private void addAction() {
        ArrayList<SJctrErrorColumnData> newErrList;
        SJctrErrorDataController errDC;
        SJctrUserController uc;
        SJctrRelatedDispDataObject errDisp;
        List<Object> hostSelectRow;
        boolean canAddFlg = true;
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJctrAvailableHostTableModel hostTable = (SJctrAvailableHostTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<Object> addHostsList = hostSelectRow = hostTable.getSelectedRowDataOrder();
        SJctrSelectedHGTableModel selectedTable = (SJctrSelectedHGTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        SJctrAvailablePortTableModel portTable = (SJctrAvailablePortTableModel)this.getDataObjectModel(KEY_TABLE_PORT);
        List<Object> portSelectRow = portTable.getSelectedRowData();
        List<Object> portKeyList = portSelectRow;
        if (portKeyList.size() <= 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Available Ports Table Data Not Selected!!");
            SJctrError err = new SJctrError(10, 22, 105031);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrCreateHGAddErrMgr errMgr = new SJctrCreateHGAddErrMgr(portKeyList.size(), addHostsList.size());
        this.resetRscUtil();
        canAddFlg = this.canAddNewHg(portKeyList, addHostsList, errMgr);
        List<SJctrError> wwnErrAnyPortList = null;
        if (canAddFlg) {
            wwnErrAnyPortList = errMgr.getWwnErrAnyPortList();
            ArrayList<SJctrAddHostsTableKey> setList = new ArrayList<SJctrAddHostsTableKey>(addHostsList.size());
            for (int errpos = 0; errpos < addHostsList.size(); ++errpos) {
                SJctrError errElement = wwnErrAnyPortList.get(errpos);
                if (errElement.getError() != -1) continue;
                SJctrAddHostsTableKey addHostsData = (SJctrAddHostsTableKey)addHostsList.get(errpos);
                setList.add(addHostsData);
            }
            ArrayList<SJctrPortHostGroupTableKey> newList = new ArrayList<SJctrPortHostGroupTableKey>();
            List<?> utilList = this.getCache(KEY_CLASS_HG_UTIL);
            SJmoRscUtilHostGrp rscHG = (SJmoRscUtilHostGrp)utilList.get(0);
            ArrayList<SJmoHostGroupInfo> newHgList = new ArrayList<SJmoHostGroupInfo>(portKeyList.size());
            for (SJmoPortDetail sJmoPortDetail : portKeyList) {
                short sPort = sJmoPortDetail.getSPort();
                SJmoPortHostGroupInfo newPortHgData = new SJmoPortHostGroupInfo();
                newPortHgData.setSPort(sPort);
                SJctrPortHostGroupWwnData ctrData = this.definedData.get(sPort);
                SJmoHostGroupInfo newHgData = new SJmoHostGroupInfo();
                newHgData.setSPort(sPort);
                newHgData.setSHostGroup(ctrData.acquireHgId(rscHG, sPort, rsgUtil, this.rsgDataModel));
                newHgData.setStrHostgroupNickName(this.getHostGroupName());
                newHgData.setByHostMode(this.getSelectHostMode());
                BitSet hostModeOptionBitSet = (BitSet)this.getHostModeOption().clone();
                newHgData.setBtOption(hostModeOptionBitSet);
                ArrayList<SJmoWwn> newWwnList = new ArrayList<SJmoWwn>();
                for (SJctrAddHostsTableKey setOneData : setList) {
                    newWwnList.add(setOneData.getWwnInfo());
                }
                newHgData.setAlHostGroupWwn(newWwnList);
                newHgData.setIDataMode(2);
                ctrData.addHostGroup(newHgData);
                newHgList.add(newHgData);
                SJctrPortHostGroupTableKey newKey = new SJctrPortHostGroupTableKey(newPortHgData, newHgData);
                newList.add(newKey);
            }
            selectedTable.addRowDataTop(newList);
            List<Object> addPortHgList = selectedTable.getAllRowData();
            ArrayList<Object> arrayList = new ArrayList<Object>(addPortHgList.size());
            arrayList.addAll(addPortHgList);
            Collections.sort(arrayList);
            this.putCache(KEY_CLASS_CREATEPORTHG, arrayList);
            ArrayList<ArrayList<SJmoHostGroupInfo>> storeRscList = new ArrayList<ArrayList<SJmoHostGroupInfo>>();
            storeRscList.add(newHgList);
            rscHG.setRsvData(storeRscList);
            utilList = new ArrayList();
            utilList.add(rscHG);
            this.putCache(KEY_CLASS_HG_UTIL, utilList);
            this.updateFooter();
        }
        if (errMgr.isPortErrExist()) {
            errDisp = this.createDialog(SJctrErrorDataController.class, null);
            uc = this.getWizardWindow().getOwner();
            errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
            newErrList = new ArrayList<SJctrErrorColumnData>();
            List<SJctrError> portErrList = errMgr.getPortErrList();
            for (int errpos = 0; errpos < portErrList.size(); ++errpos) {
                SJctrError sJctrError = portErrList.get(errpos);
                if (sJctrError.getError() == -1) continue;
                SJctrErrorColumnData errData = new SJctrErrorColumnData((Comparable)portKeyList.get(errpos), sJctrError);
                newErrList.add(errData);
            }
            errDC.setParameter(this.getDataObjectModel(KEY_TABLE_PORT), newErrList);
            SJctrError err = errDC.getRepresentativeError(newErrList);
            SJcException sJcException = err.createException();
            sJcException.setErrDisp(errDisp);
            throw sJcException;
        }
        if (errMgr.isWwnErrExist(wwnErrAnyPortList)) {
            errDisp = this.createDialog(SJctrErrorDataController.class, null);
            uc = this.getWizardWindow().getOwner();
            errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
            newErrList = new ArrayList();
            SJctrAddPortWwnErrorTableModel errTbl = new SJctrAddPortWwnErrorTableModel();
            errTbl.setDataController(this);
            errTbl.setPaging(false);
            for (int portIndex = 0; portIndex < portKeyList.size(); ++portIndex) {
                List<SJctrError> list = errMgr.getWwnErrListAll(portIndex);
                for (int wwnIndex = 0; wwnIndex < addHostsList.size(); ++wwnIndex) {
                    SJctrError err = list.get(wwnIndex);
                    if (err.getError() == -1) continue;
                    SJmoPortDetail portDetail = (SJmoPortDetail)portKeyList.get(portIndex);
                    SJctrAddHostsTableKey addHost = (SJctrAddHostsTableKey)addHostsList.get(wwnIndex);
                    short sPort = portDetail.getSPort();
                    SJctrPortHostGroupWwnTableKey errTblBasicData = errTbl.addBasicData(sPort, addHost);
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(errTblBasicData, err);
                    newErrList.add(errData);
                }
            }
            errTbl.initGuidance(this.getComUtility());
            errTbl.setBasicData(KEY_CLASS_MPORTDETL, this.getCache(KEY_CLASS_MPORTDETL));
            errTbl.setBasicData(KEY_CLASS_MPORTHG, this.getCache(KEY_CLASS_MPORTHG));
            errTbl.makeDataModel();
            errDC.setParameter(errTbl, newErrList);
            hostTable.setDirty();
            selectedTable.setDirty();
            SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel(KEY_FOOTER);
            footer.setDirty();
            SJctrError sJctrError = errDC.getRepresentativeError(newErrList);
            SJcException exp = sJctrError.createException();
            exp.setErrDisp(errDisp);
            throw exp;
        }
    }

    private boolean canAddNewHg(List<SJmoPortDetail> portKeyList, List<SJctrAddHostsTableKey> addHostsKey, SJctrCreateHGAddErrMgr errMgr) {
        boolean ret = true;
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        for (int setNum = 0; setNum < portKeyList.size(); ++setNum) {
            SJctrError errElement;
            List<?> utilList;
            SJmoRscUtilHostGrp rscHG;
            short HgId;
            List<SJctrError> errList = errMgr.getWwnErrListAll(setNum);
            SJmoPortDetail portDetail = portKeyList.get(setNum);
            short sPort = portDetail.getSPort();
            SJctrPortHostGroupWwnData ctrData = this.definedData.get(sPort);
            String hgName = this.getHostGroupName();
            if (!this.isUseHgName(sPort, hgName, errMgr.getPortErr(setNum))) {
                ret = false;
            }
            if (ctrData.containsHgName(hgName)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddHost", "Host group name is already used. :" + hgName + ", Port# = " + sPort);
                SJctrError portErr = errMgr.getPortErr(setNum);
                portErr.setFunc(10);
                portErr.setModule(22);
                portErr.setError(105013);
                ret = false;
            }
            if ((HgId = ctrData.acquireHgId(rscHG = (SJmoRscUtilHostGrp)(utilList = this.getCache(KEY_CLASS_HG_UTIL)).get(0), sPort, rsgUtil, this.rsgDataModel)) >= SJctrPortUtility.PORT_HOSTGROUP_MAX) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddHost", "Host group in this port is assigned out!!" + hgName + ", Port# = " + sPort);
                SJctrError portErr = errMgr.getPortErr(setNum);
                portErr.setFunc(10);
                portErr.setModule(22);
                portErr.setError(106505);
                ret = false;
            }
            if (SJctrModelDataCheck.isSameHBAWWN(addHostsKey, errList)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddHost", "Try to add WWN(wwn-byte) is overlapped in this operation!!, Port# = " + sPort);
            }
            if (SJctrModelDataCheck.isSameNickname(addHostsKey, errList)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddHost", "Try to add WWN(nickname) is overlapped in this operation!!, Port# = " + sPort);
            }
            for (int index = 0; index < addHostsKey.size(); ++index) {
                SJctrAddHostsTableKey availableTblKey = addHostsKey.get(index);
                if (!ctrData.containsWwn(availableTblKey.getWwnInfo())) continue;
                errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(105208);
                SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddHost", "Try to add WWN is already used!!, Port# = " + sPort);
                ret = false;
            }
            int setCounter = 0;
            for (int errpos = 0; errpos < addHostsKey.size(); ++errpos) {
                errElement = errList.get(errpos);
                if (errElement.getError() != -1) continue;
                ++setCounter;
            }
            int afterWwnConnt = ctrData.getWwnStringList().size() + setCounter;
            if (afterWwnConnt <= SJctrPortUtility.PORT_WWN_MAX) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "canAddHost", "No more wwns can be registered in the port., Port# = " + sPort);
            SJctrError portErr = errMgr.getPortErr(setNum);
            portErr.setFunc(10);
            portErr.setModule(22);
            portErr.setError(105033);
            ret = false;
        }
        return ret;
    }

    private boolean isUseHgName(short portId, String chkStr, SJctrError err) {
        boolean ret = true;
        Matcher matcherHgName = patternHgName.matcher(chkStr);
        if (matcherHgName.matches()) {
            List<?> portDetail = this.getCache(KEY_CLASS_MPORTDETL);
            for (SJmoPortDetail onePortDetail : portDetail) {
                if (onePortDetail.getSPort() != portId) continue;
                SJctrPortUtility portUtil = this.getComUtility().getPortUtility();
                String defaultHgName = portUtil.toDefaultHGName(onePortDetail);
                if (chkStr.equals(defaultHgName)) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "isUseHgName", "Use default HostGroup Name.");
                    err.setFunc(10);
                    err.setModule(22);
                    err.setError(105038);
                    ret = false;
                }
                break;
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "isUseHgName", "not match pattern.");
            err.setFunc(10);
            err.setModule(22);
            err.setError(105037);
            ret = false;
        }
        return ret;
    }

    private SJctrRelatedDispDataObject makeDetailErrorDialog(List<SJctrAddHostsTableKey> addHostsKey, List<SJctrAddHostsTableKey> setList, List<SJctrError> errList) {
        if (setList.size() == addHostsKey.size()) {
            return null;
        }
        ArrayList<SJctrErrorColumnData> newErrList = new ArrayList<SJctrErrorColumnData>();
        for (int errpos = 0; errpos < errList.size(); ++errpos) {
            SJctrError errElement = errList.get(errpos);
            if (errElement.getError() == -1) continue;
            SJctrErrorColumnData errData = new SJctrErrorColumnData(addHostsKey.get(errpos), errElement);
            newErrList.add(errData);
        }
        SJctrRelatedDispDataObject errDisp = this.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController uc = this.getWizardWindow().getOwner();
        SJctrErrorDataController errDC = (SJctrErrorDataController)uc.getDataController(errDisp);
        errDC.setParameter(this.getDataObjectModel(KEY_TABLE_AVAILABLE), newErrList);
        return errDisp;
    }

    private void deleteAction() {
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> delList = selectedTable.removeSelectedRowData();
        if (delList.size() <= 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "deleteAction", "Deleting Data isn't selected.");
            SJctrError err = new SJctrError(10, 22, 105042);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> utilList = this.getCache(KEY_CLASS_HG_UTIL);
        SJmoRscUtilHostGrp rscHG = (SJmoRscUtilHostGrp)utilList.get(0);
        this.resetRscUtil();
        ArrayList<SJmoHostGroupInfo> delHgList = new ArrayList<SJmoHostGroupInfo>(delList.size());
        for (SJctrPortHostGroupTableKey sJctrPortHostGroupTableKey : delList) {
            delHgList.add(sJctrPortHostGroupTableKey.getHostGroupInfo());
            short sPort = sJctrPortHostGroupTableKey.getPortHostGroupInfo().getSPort();
            SJctrPortHostGroupWwnData ctrData = this.definedData.get(sPort);
            ctrData.removeHostGroup(sJctrPortHostGroupTableKey.getHostGroupInfo());
        }
        List<Object> newList = selectedTable.getAllRowData();
        ArrayList<Object> arrayList = new ArrayList<Object>(newList.size());
        arrayList.addAll(newList);
        Collections.sort(arrayList);
        this.putCache(KEY_CLASS_CREATEPORTHG, arrayList);
        ArrayList<ArrayList<SJmoHostGroupInfo>> storeRscList = new ArrayList<ArrayList<SJmoHostGroupInfo>>();
        storeRscList.add(delHgList);
        rscHG.delRsvData(storeRscList);
        utilList = new ArrayList();
        utilList.add(rscHG);
        this.putCache(KEY_CLASS_HG_UTIL, utilList);
        selectedTable.setSortColumn(null, Boolean.FALSE);
        this.updateFooter();
    }

    private void detailAction() {
        SJctrPortHostGroupTableKey selectPtHg;
        SJctrTableDataModel targetTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectedRows = targetTable.getSelectedRowData();
        if (selectedRows.size() == 0) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "detailAction", "Port isn't selected.");
            SJctrError err = new SJctrError(10, 22, 105040);
            SJcException exp = err.createException();
            throw exp;
        }
        if (selectedRows.size() > 1) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "detailAction", "too many Port is selected. Num = " + selectedRows.size());
            SJctrError err = new SJctrError(10, 22, 105041);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> ptDtList = this.getCache(KEY_CLASS_MPORTDETL);
        int index = Collections.binarySearch(ptDtList, (selectPtHg = (SJctrPortHostGroupTableKey)selectedRows.get(0)).getPortHostGroupInfo());
        if (index < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "detailAction", "Port# Not Found in SJmoPortDetail Class.");
            SJctrError err = new SJctrError(10, 22, 107004);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrHGPropertySelectData dialogData = new SJctrHGPropertySelectData();
        dialogData.setData((SJmoPortDetail)ptDtList.get(index), selectPtHg.getHostGroupInfo());
        ArrayList<SJctrHGPropertySelectData> dialogList = new ArrayList<SJctrHGPropertySelectData>();
        dialogList.add(dialogData);
        HashMap map = new HashMap();
        map.put("HG_PROPERTY_SELECT_DATA", dialogList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrHGPropertyDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    SJctrCreateHostGroupData createConfirmData(List<SJctrPortHostGroupTableKey> targetPortHgList) {
        TreeSet<SJmoPortHostGroupInfo> portSet = new TreeSet<SJmoPortHostGroupInfo>();
        for (SJctrPortHostGroupTableKey key : targetPortHgList) {
            portSet.add(key.getPortHostGroupInfo());
        }
        ArrayList<SJmoPortIndex> targetPortList = new ArrayList<SJmoPortIndex>(portSet);
        List<SJmoPortAttributeInfo> portAttributeList = this.getCache(KEY_CLASS_MPORTATTR);
        List<SJmoPortAttributeInfo> confirmPortAttrList = SJctrReplaceDataForConfirm.getConfirmPortAttrInfo(targetPortList, portAttributeList);
        List<SJmoPortDetail> portDetailList = this.getCache(KEY_CLASS_MPORTDETL);
        List<SJmoPortDetail> confirmPortDetailList = SJctrReplaceDataForConfirm.getConfirmPortDetail(targetPortList, portDetailList);
        List<SJmoHUVMVirtualDkc> confirmVDKCList = this.getCache(SJmoGetHUVMVirtualDkc.class);
        List<SJmoRSGgetAllRsgs> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        SJctrCreateHostGroupData confirmData = new SJctrCreateHostGroupData();
        confirmData.setPortAttributeInfo(confirmPortAttrList);
        confirmData.setPortDetail(confirmPortDetailList);
        confirmData.setCreateHostGroup(targetPortHgList);
        confirmData.setAllRsgList(rsgDetailList);
        confirmData.setVDKCList(confirmVDKCList);
        ArrayList<SJctrCreateHostGroupData> confirmDataList = new ArrayList<SJctrCreateHostGroupData>();
        confirmDataList.add(confirmData);
        this.putCache(KEY_CLASS_CONFIRM_DATA, confirmDataList);
        return confirmData;
    }

    public SJmoPortHostGroupInfo createNewPortHgInfo(SJmoPortHostGroupInfo portHg) throws CloneNotSupportedException {
        SJmoPortHostGroupInfo createPortHg = null;
        if (portHg == null) {
            portHg = new SJmoPortHostGroupInfo();
        }
        createPortHg = new SJmoPortHostGroupInfo();
        createPortHg.setSPort(portHg.getSPort());
        ArrayList<SJmoHostGroupInfo> alPortHostGroup = new ArrayList<SJmoHostGroupInfo>();
        for (Object hgObj : portHg.getAlPortHostGroup()) {
            SJmoHostGroupInfo hg = (SJmoHostGroupInfo)hgObj;
            SJmoHostGroupInfo newHg = this.createHostGroupInfo(hg);
            alPortHostGroup.add(newHg);
        }
        createPortHg.setAlPortHostGroup(alPortHostGroup);
        return createPortHg;
    }

    public SJmoHostGroupInfo createHostGroupInfo(SJmoHostGroupInfo hostGroupInfo) throws CloneNotSupportedException {
        SJmoHostGroupInfo result = (SJmoHostGroupInfo)hostGroupInfo.clone();
        ArrayList wwnList = hostGroupInfo.getAlHostGroupWwn();
        ArrayList<SJmoWwn> resultWwnList = new ArrayList<SJmoWwn>(wwnList.size());
        for (SJmoWwn wwn : wwnList) {
            SJmoWwn resultWwn = (SJmoWwn)wwn.clone();
            resultWwnList.add(resultWwn);
        }
        result.setAlHostGroupWwn(resultWwnList);
        return result;
    }

    @Override
    public void selectNextTask(SJctrActionDefine action) {
        switch (action) {
            case ACT_MAPLUN: {
                this.logUty.putlog("selectNextTask", "Create Host Groups -> Map LUNs");
                List<SJctrPortHostGroupTableKey> targetPortHgList = this.getCache(KEY_CLASS_CREATEPORTHG);
                ArrayList<SJctrPortHGIndex> toNextIndexList = new ArrayList<SJctrPortHGIndex>(targetPortHgList.size());
                int refVboxId = -1;
                TreeSet<SJmoPortHostGroupInfo> newPortIndexSet = new TreeSet<SJmoPortHostGroupInfo>();
                for (SJctrPortHostGroupTableKey targetPortHg : targetPortHgList) {
                    SJmoPortHostGroupInfo newPortIndex;
                    SJmoHostGroupInfo hgInfo = targetPortHg.getHostGroupInfo();
                    SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
                    hgIndex.setSPort(hgInfo.getSPort());
                    hgIndex.setSHostGroup(hgInfo.getSHostGroup());
                    SJmoRSGgetRsg rsg = this.rsgUtil.getRsgFromHg(hgIndex);
                    SJmoRSGInfo rsgInfo = rsg.getRsgInfo();
                    SJmoHUVMvboxIndex vboxIndex = rsgInfo.getVboxIndex();
                    int vboxId = vboxIndex.getIVboxId();
                    if (refVboxId != vboxId) {
                        if (refVboxId == -1) {
                            refVboxId = vboxId;
                        } else if (refVboxId != vboxId) {
                            this.logUty.putlog("checkEndData", "Selected any VDKCs at HostGroup", 40000);
                            SJctrError err = new SJctrError(10, 22, 205146);
                            SJcException exp = err.createException();
                            throw exp;
                        }
                    }
                    if (!newPortIndexSet.contains(newPortIndex = targetPortHg.getPortHostGroupInfo())) {
                        newPortIndexSet.add(newPortIndex);
                    }
                    SJctrPortHGIndex toNextIndex = new SJctrPortHGIndex();
                    toNextIndex.setIndex(targetPortHg.getPortHostGroupInfo().getSPort(), targetPortHg.getHostGroupInfo().getSHostGroup());
                    toNextIndexList.add(toNextIndex);
                }
                ArrayList<SJmoPortIndex> newPortIndexList = new ArrayList<SJmoPortIndex>(newPortIndexSet.size());
                newPortIndexList.addAll(newPortIndexSet);
                this.putCache("KEY_SELECT_HG_INDEX", toNextIndexList);
                this.updatePortHgInfo(targetPortHgList, newPortIndexList);
            }
        }
    }

    private void updatePortHgInfo(List<SJctrPortHostGroupTableKey> targetPortHgList, List<SJmoPortIndex> newPortIndexList) {
        if (this.originPortHg == null) {
            this.originPortHg = this.getCache(KEY_CLASS_MPORTHG);
        }
        ArrayList<SJmoPortHostGroupInfo> newPortHgList = new ArrayList<SJmoPortHostGroupInfo>(this.originPortHg.size());
        for (SJmoPortHostGroupInfo portHg : this.originPortHg) {
            SJmoPortHostGroupInfo newPortHg;
            int searchResult = Collections.binarySearch(newPortIndexList, portHg);
            if (searchResult < 0) {
                newPortHg = portHg;
            } else {
                try {
                    newPortHg = this.createNewPortHgInfo(portHg);
                }
                catch (CloneNotSupportedException e) {
                    this.getLogUty().putlog("mergePortHgInfo", "SJmoPortHostGroupInfo clone fail", e, 30000);
                    continue;
                }
            }
            newPortHgList.add(newPortHg);
        }
        List<SJmoPortHostGroupInfo> confirmPortHgList = this.mergePortHgInfo(targetPortHgList, newPortHgList);
        this.putCache(KEY_CLASS_MPORTHG, confirmPortHgList);
    }

    private List<SJmoPortHostGroupInfo> mergePortHgInfo(List<SJctrPortHostGroupTableKey> targetPortHgList, List<SJmoPortHostGroupInfo> newMdlPortHgList) {
        ArrayList<SJctrPortHostGroupTableKey> newPortHgList = new ArrayList<SJctrPortHostGroupTableKey>();
        newPortHgList.addAll(targetPortHgList);
        Collections.sort(newPortHgList);
        HashMap<String, SJmoPortHostGroupInfo> portHgMap = new HashMap<String, SJmoPortHostGroupInfo>(newPortHgList.size() * 4 / 3 + 1);
        for (SJctrPortHostGroupTableKey ptHgKey : newPortHgList) {
            SJmoPortHostGroupInfo createPortHg = null;
            if (portHgMap.containsKey(ptHgKey.getPortHostGroupInfo().toString())) {
                createPortHg = (SJmoPortHostGroupInfo)portHgMap.get(ptHgKey.getPortHostGroupInfo().toString());
            } else {
                block7: {
                    int searchResult = Collections.binarySearch(newMdlPortHgList, ptHgKey.getPortHostGroupInfo());
                    if (searchResult < 0) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "mergePortHgInfo", "SJmoPortHostGroupInfo not found!! create SJmoPortHostGroupInfo Port# = " + ptHgKey.getPortHostGroupInfo().getSPort());
                        try {
                            createPortHg = this.createNewPortHgInfo(ptHgKey.getPortHostGroupInfo());
                            newMdlPortHgList.add(createPortHg);
                            break block7;
                        }
                        catch (CloneNotSupportedException e) {
                            this.getLogUty().putlog("updatePortHgInfo", "SJmoPortHostGroupInfo clone fail", e, 30000);
                            continue;
                        }
                    }
                    createPortHg = newMdlPortHgList.get(searchResult);
                }
                portHgMap.put(ptHgKey.getPortHostGroupInfo().toString(), createPortHg);
            }
            ArrayList modelHgList = createPortHg.getAlPortHostGroup();
            modelHgList.add(ptHgKey.getHostGroupInfo());
        }
        for (SJmoPortHostGroupInfo newMdlPortHg : newMdlPortHgList) {
            Collections.sort(newMdlPortHg.getAlPortHostGroup());
        }
        return newMdlPortHgList;
    }

    String getHostGroupName() {
        SJctrTextBoxDataModel hgNameText = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HG_NAME);
        return hgNameText.getValue();
    }

    byte getSelectHostMode() {
        SJctrHostModeComboModel hostModeCombo = (SJctrHostModeComboModel)this.getDataObjectModel(KEY_HOSTMODE);
        return hostModeCombo.getSelectedHostModeValue();
    }

    BitSet getHostModeOption() {
        SJctrHostModeOptTableModel optTbl = (SJctrHostModeOptTableModel)this.getDataObjectModel(KEY_TABLE_OPTION);
        return optTbl.getBtOption();
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel(KEY_FOOTER);
        List<?> targetList = this.getCache(KEY_CLASS_CREATEPORTHG);
        if (targetList == null || targetList.size() <= 0) {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, false);
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.FINISH, true);
            SJctrAuthorizeContainer authorizeContainer = this.getOwner().getAuthorizeContainer();
            SJcRoleResourceContainer rolecontainer = authorizeContainer.getRoleResourceContainer();
            if (rolecontainer.checkAuthority(85)) {
                footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
            }
        }
    }

    void saveDefinedDataDump() {
        try {
            SJcFileUty.saveClass2File(FILE_NAME_DIR, FILE_NAME_FILE, (Serializable)((Object)this.definedData));
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "saveDefinedDataDump", "Dump data can't saved.");
        }
    }

    public void renewAvailablePortData() {
        List<SJmoPortHostGroupInfo> targetPortHgRsg = this.getPtHgRsg(this.targetPortHg, this.rsgUtil);
        List<SJmoPortDetail> portList = this.getPortDetail(targetPortHgRsg, this.portDetail, this.errList);
        SJctrAvailablePortTableModel portTable = (SJctrAvailablePortTableModel)this.getDataObjectModel(KEY_TABLE_PORT);
        portTable.setBasicDataList(portList);
    }

    public static enum CREATE_HG_MSG implements SJctrNotifyState
    {
        ADD_NEW_HOST,
        ADD,
        DETAIL,
        DELETE;

    }
}

