/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.deluuid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.SJctrEmulationTypeFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrLdevCapacityLUSEColumnFromLdevDetailLUSEInfo;
import sanproject.sn2.controller.com.column.SJctrLdevIdFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrLdevNameFromLdevDetailColumn;
import sanproject.sn2.controller.com.column.SJctrUuidColumnFromLdevDetail;
import sanproject.sn2.controller.com.data.SJctrTblDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.deluuid.SJctrDelUuidConfirmData;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevUuidInfo;

public class SJctrDelUuidConfirmTableModel
extends SJctrTableDataModel {
    public static final String KEY_LDEVID = "COM_COL_LDEVID";
    public static final String KEY_LDEVNAME = "COM_COL_LDEVNAME";
    public static final String KEY_UUID = "COM_COL_UUID";
    public static final String KEY_EMUTYPE = "COM_COL_EMUTYPE";
    public static final String KEY_LDEVCAP = "COM_COL_LDEVCAP";
    public static final String KEY_TOTAL_CAPACITY = "COM_TOTAL_CAPACITY";

    public SJctrDelUuidConfirmTableModel() {
        super(false);
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrDelUuidConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            return new ArrayList();
        }
        SJctrDelUuidConfirmData delUuidConfirmData = (SJctrDelUuidConfirmData)confirmDataList.get(0);
        List<SJctrLdevDetailLUSEInfo> ldevDetailList = delUuidConfirmData.getLdevDetailList();
        if (ldevDetailList == null || ldevDetailList.size() == 0) {
            return new ArrayList();
        }
        ArrayList<SJctrLdevDetailLUSEInfo> retList = new ArrayList<SJctrLdevDetailLUSEInfo>();
        retList.addAll(ldevDetailList);
        return retList;
    }

    @Override
    public void makeDataObject() {
        String totalCap = this.makeTotalCapacity();
        ((SJctrTblDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY, totalCap);
        super.makeDataObject();
    }

    private String makeTotalCapacity() {
        long totalCap = 0L;
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrDelUuidConfirmData.class);
        SJctrDelUuidConfirmData delUuidConfirmData = (SJctrDelUuidConfirmData)confirmDataList.get(0);
        List<SJctrLdevDetailLUSEInfo> ldevDetailList = delUuidConfirmData.getLdevDetailList();
        for (SJctrLdevDetailLUSEInfo ldevDetail : ldevDetailList) {
            totalCap += ldevDetail.getLTotalLBASize();
        }
        SJctrCapacityUtility capUtil = this.getComUtility().getCapacityUtility();
        String result = capUtil.toUnitString(totalCap);
        return result;
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        SJmoGetRange_IF ret = null;
        return ret;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrLdevIdFromLdevDetailColumn(KEY_LDEVID));
        this.addColumn(new SJctrLdevNameFromLdevDetailColumn(KEY_LDEVNAME));
        this.addColumn(new SJctrUuidColumnFromLdevDetail(KEY_UUID));
        SJctrEmulationTypeFromLdevDetailColumn emuType = new SJctrEmulationTypeFromLdevDetailColumn(KEY_EMUTYPE);
        if (SJctrDataController.isHM()) {
            emuType.setSupportColumn(false);
        }
        this.addColumn(emuType);
        this.addColumn(new SJctrLdevCapacityLUSEColumnFromLdevDetailLUSEInfo(KEY_LDEVCAP));
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        HashMap map = new HashMap();
        super.setModelData(map);
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrDelUuidConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            this.getLogUty().putlog("setModelData", "confirmData not found");
            return;
        }
        SJctrDelUuidConfirmData confirmData = (SJctrDelUuidConfirmData)confirmDataList.get(0);
        this.setBasicData(SJctrLdevDetailLUSEInfo.class, confirmData.getLdevDetailList());
        this.setBasicData(SJmoLdevUuidInfo.class, confirmData.getLdevUuidInfoList());
        this.setBasicData(SJmoGetLdevNicknameInfo.class, confirmData.getLdevNickInfoList());
    }
}

